<div class="bg-gray-900 border border-gray-800 rounded-2xl p-6">
    <div class="flex items-center justify-between mb-4">
        <h3 class="text-lg font-semibold text-white">System Updates</h3>
        <span class="text-sm text-gray-400">v{{ $currentVersion }}</span>
    </div>

    {{-- Error/Success Messages --}}
    @if($error)
        <div class="mb-4 p-3 bg-red-500/10 border border-red-500/30 rounded-xl text-sm text-red-400">
            {{ $error }}
        </div>
    @endif

    @if($success)
        <div class="mb-4 p-3 bg-green-500/10 border border-green-500/30 rounded-xl text-sm text-green-400">
            {{ $success }}
        </div>
    @endif

    {{-- Update Available --}}
    @if($updateInfo && $updateInfo['update_available'])
        <div class="p-4 bg-primary-500/10 border border-primary-500/30 rounded-xl mb-4">
            <div class="flex items-start gap-3">
                <div class="w-10 h-10 bg-primary-500/20 rounded-xl flex items-center justify-center shrink-0">
                    <i class="ph-duotone ph-arrow-circle-up text-xl text-primary-400"></i>
                </div>
                <div class="flex-1 min-w-0">
                    <p class="font-medium text-white">Version {{ $updateInfo['latest_version'] }} Available</p>
                    <p class="text-sm text-gray-400 mt-1">A new version of Salieno Core is available for download.</p>

                    @if(!empty($updateInfo['changelog']))
                        <div class="mt-3 text-sm text-gray-400">
                            <p class="font-medium text-gray-300 mb-1">What's New:</p>
                            <ul class="list-disc list-inside space-y-1">
                                @foreach(array_slice($updateInfo['changelog'], 0, 3) as $section => $items)
                                    @if(is_array($items))
                                        @foreach(array_slice($items, 0, 2) as $item)
                                            <li class="truncate">{{ $item }}</li>
                                        @endforeach
                                    @else
                                        <li class="truncate">{{ $items }}</li>
                                    @endif
                                @endforeach
                            </ul>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        {{-- Download Progress --}}
        @if($isDownloading)
            <div class="mb-4">
                <div class="flex items-center justify-between text-sm mb-2">
                    <span class="text-gray-400">Downloading & Installing...</span>
                    <span class="text-white font-medium">{{ $downloadProgress }}%</span>
                </div>
                <div class="h-2 bg-gray-800 rounded-full overflow-hidden">
                    <div class="h-full bg-primary-500 transition-all duration-300" style="width: {{ $downloadProgress }}%"></div>
                </div>
            </div>
        @endif

        <div class="flex gap-3">
            <button wire:click="downloadUpdate" wire:loading.attr="disabled" :disabled="$isDownloading" class="flex-1 py-2.5 px-4 bg-primary-600 hover:bg-primary-700 disabled:opacity-50 text-white font-medium rounded-xl transition-colors flex items-center justify-center gap-2">
                @if($isDownloading)
                    <i class="ph-duotone ph-spinner text-lg animate-spin"></i>
                    Installing...
                @else
                    <i class="ph-duotone ph-download-simple text-lg"></i>
                    Update Now
                @endif
            </button>
            <a href="{{ route('admin.system.update') }}" wire:navigate class="py-2.5 px-4 bg-gray-800 hover:bg-gray-700 text-gray-300 font-medium rounded-xl transition-colors">
                Details
            </a>
        </div>
    @else
        {{-- No Update / Check Button --}}
        <div class="text-center py-4">
            @if($updateInfo && !$updateInfo['update_available'])
                <div class="w-12 h-12 mx-auto mb-3 bg-green-500/20 rounded-full flex items-center justify-center">
                    <i class="ph-duotone ph-check-circle text-2xl text-green-400"></i>
                </div>
                <p class="text-gray-300 font-medium">You're up to date!</p>
                <p class="text-sm text-gray-500 mt-1">Running the latest version</p>
            @else
                <p class="text-gray-400 mb-4">Check for available updates</p>
            @endif

            <button wire:click="checkForUpdates" wire:loading.attr="disabled" class="py-2.5 px-6 bg-gray-800 hover:bg-gray-700 disabled:opacity-50 text-gray-300 font-medium rounded-xl transition-colors inline-flex items-center gap-2">
                @if($isChecking)
                    <i class="ph-duotone ph-spinner text-lg animate-spin"></i>
                    Checking...
                @else
                    <i class="ph-duotone ph-arrows-clockwise text-lg"></i>
                    Check for Updates
                @endif
            </button>
        </div>
    @endif
</div>

