<div class="space-y-4 md:space-y-6 lg:space-y-8">
    {{-- Page Header --}}
    <div class="flex flex-col gap-3 md:gap-4 sm:flex-row sm:items-center sm:justify-between animate-fade-in">
        <div>
            <h1 class="text-xl md:text-2xl lg:text-3xl font-semibold tracking-tight" style="color: var(--text-primary);">@lang('Affiliate Program')</h1>
            <p class="mt-0.5 md:mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Earn commissions by referring new customers.')</p>
        </div>
    </div>

    {{-- Referral Link Card --}}
    <x-client.card class="animate-slide-up">
        <div class="flex items-center gap-2.5 md:gap-3 mb-3 md:mb-4">
            <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--primary);">
                <i class="ph ph-link text-base md:text-lg" style="color: white;"></i>
            </div>
            <div>
                <h3 class="text-sm md:text-base font-medium" style="color: var(--text-primary);">@lang('Your Referral Link')</h3>
                <p class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Share this link to earn commissions')</p>
            </div>
        </div>
        <div class="flex flex-col gap-2 md:gap-3 sm:flex-row" x-data="{ copied: false }">
            <x-client.input type="text" value="{{ $referralUrl }}" readonly class="flex-1" />
            <x-client.button
                type="button"
                @click="navigator.clipboard.writeText('{{ $referralUrl }}'); copied = true; setTimeout(() => copied = false, 2000)"
            >
                <i class="ph" :class="copied ? 'ph-check' : 'ph-copy'"></i>
                <span x-text="copied ? '@lang('Copied!')' : '@lang('Copy Link')'"></span>
            </x-client.button>
        </div>
    </x-client.card>

    {{-- Stats Cards --}}
    <div class="grid gap-3 md:gap-4 grid-cols-2 lg:grid-cols-4 animate-slide-up stagger-1">
        {{-- Total Referrals --}}
        <x-client.card padding="sm" class="md:p-5">
            <div class="flex items-center gap-2.5 md:gap-3 mb-2 md:mb-3">
                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--primary-light);">
                    <i class="ph ph-users text-base md:text-lg" style="color: var(--primary);"></i>
                </div>
            </div>
            <p class="text-xs md:text-sm font-medium" style="color: var(--text-secondary);">@lang('Total Referrals')</p>
            <p class="mt-0.5 md:mt-1 text-xl md:text-2xl font-semibold tracking-tight" style="color: var(--text-primary);">{{ $totalReferrals }}</p>
        </x-client.card>

        {{-- Total Earnings --}}
        <x-client.card padding="sm" class="md:p-5">
            <div class="flex items-center gap-2.5 md:gap-3 mb-2 md:mb-3">
                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--success-light);">
                    <i class="ph ph-currency-dollar text-base md:text-lg" style="color: var(--success);"></i>
                </div>
            </div>
            <p class="text-xs md:text-sm font-medium" style="color: var(--text-secondary);">@lang('Total Earnings')</p>
            <p class="mt-0.5 md:mt-1 text-xl md:text-2xl font-semibold tracking-tight" style="color: var(--text-primary);">{{ showAmount($totalEarnings) }}</p>
        </x-client.card>

        {{-- Pending Earnings --}}
        <x-client.card padding="sm" class="md:p-5">
            <div class="flex items-center gap-2.5 md:gap-3 mb-2 md:mb-3">
                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--warning-light);">
                    <i class="ph ph-clock text-base md:text-lg" style="color: var(--warning);"></i>
                </div>
            </div>
            <p class="text-xs md:text-sm font-medium" style="color: var(--text-secondary);">@lang('Pending')</p>
            <p class="mt-0.5 md:mt-1 text-xl md:text-2xl font-semibold tracking-tight" style="color: var(--text-primary);">{{ showAmount($pendingEarnings) }}</p>
        </x-client.card>

        {{-- Paid Earnings --}}
        <x-client.card padding="sm" class="md:p-5">
            <div class="flex items-center gap-2.5 md:gap-3 mb-2 md:mb-3">
                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--primary-light);">
                    <i class="ph ph-check-circle text-base md:text-lg" style="color: var(--primary);"></i>
                </div>
            </div>
            <p class="text-xs md:text-sm font-medium" style="color: var(--text-secondary);">@lang('Paid')</p>
            <p class="mt-0.5 md:mt-1 text-xl md:text-2xl font-semibold tracking-tight" style="color: var(--text-primary);">{{ showAmount($paidEarnings) }}</p>
        </x-client.card>
    </div>

    {{-- Mobile: Card View --}}
    <div class="md:hidden space-y-2 animate-slide-up stagger-2">
        <div class="flex items-center gap-2.5 mb-3">
            <div class="flex h-8 w-8 items-center justify-center rounded-lg shrink-0" style="background: var(--primary-light);">
                <i class="ph ph-users-three text-sm" style="color: var(--primary);"></i>
            </div>
            <h3 class="text-sm font-medium" style="color: var(--text-primary);">@lang('Your Referrals')</h3>
        </div>

        @forelse($referrals as $referral)
            <x-client.card padding="sm">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-2.5">
                        <div class="flex h-9 w-9 items-center justify-center rounded-full font-medium text-xs shrink-0" style="background: var(--primary-light); color: var(--text-secondary);">
                            {{ strtoupper(substr($referral->firstname, 0, 1)) }}{{ strtoupper(substr($referral->lastname, 0, 1)) }}
                        </div>
                        <div>
                            <p class="text-sm font-medium" style="color: var(--text-primary);">{{ $referral->firstname }} {{ $referral->lastname }}</p>
                            <p class="text-xs" style="color: var(--text-muted);">{{ $referral->created_at->format('M d, Y') }}</p>
                        </div>
                    </div>
                    <x-client.badge type="{{ $referral->status ? 'success' : 'secondary' }}" size="xs">{{ $referral->status ? __('Active') : __('Inactive') }}</x-client.badge>
                </div>
            </x-client.card>
        @empty
            <x-client.empty-state icon="ph-users" title="{{ __('No referrals yet') }}" description="{{ __('Share your referral link to start earning commissions.') }}" />
        @endforelse

        @if($referrals->hasPages())
            <div class="mt-4">
                {{ $referrals->links('vendor.livewire.novahost') }}
            </div>
        @endif
    </div>

    {{-- Desktop: Table View --}}
    <div class="hidden md:block animate-slide-up stagger-2">
        <x-client.card padding="none">
            <div class="flex items-center justify-between px-4 md:px-5 py-3 md:py-4" style="border-bottom: 1px solid var(--card-border);">
                <div class="flex items-center gap-2.5 md:gap-3">
                    <div class="flex h-8 w-8 items-center justify-center rounded-lg shrink-0" style="background: var(--primary-light);">
                        <i class="ph ph-users-three text-sm md:text-base" style="color: var(--primary);"></i>
                    </div>
                    <h3 class="text-sm md:text-base font-medium" style="color: var(--text-primary);">@lang('Your Referrals')</h3>
                </div>
            </div>

            @if($referrals->count() > 0)
                <div class="overflow-x-auto">
                    <table class="w-full text-xs md:text-sm">
                        <thead style="background: var(--primary-light);">
                            <tr>
                                <th class="px-4 md:px-5 py-2.5 md:py-3 text-left font-medium" style="color: var(--text-secondary);">@lang('User')</th>
                                <th class="px-4 md:px-5 py-2.5 md:py-3 text-left font-medium" style="color: var(--text-secondary);">@lang('Joined')</th>
                                <th class="px-4 md:px-5 py-2.5 md:py-3 text-left font-medium" style="color: var(--text-secondary);">@lang('Status')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($referrals as $referral)
                                <tr class="transition-colors" style="border-bottom: 1px solid var(--card-border);">
                                    <td class="px-4 md:px-5 py-3 md:py-4">
                                        <div class="flex items-center gap-2.5 md:gap-3">
                                            <div class="flex h-8 w-8 md:h-9 md:w-9 items-center justify-center rounded-full font-medium text-xs md:text-sm shrink-0" style="background: var(--primary-light); color: var(--text-secondary);">
                                                {{ strtoupper(substr($referral->firstname, 0, 1)) }}{{ strtoupper(substr($referral->lastname, 0, 1)) }}
                                            </div>
                                            <div>
                                                <p class="text-sm md:text-base font-medium" style="color: var(--text-primary);">{{ $referral->firstname }} {{ $referral->lastname }}</p>
                                                <p class="text-xs" style="color: var(--text-secondary);">{{ Str::mask($referral->email, '*', 3, 5) }}</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="px-4 md:px-5 py-3 md:py-4" style="color: var(--text-secondary);">{{ $referral->created_at->format('M d, Y') }}</td>
                                    <td class="px-4 md:px-5 py-3 md:py-4">
                                        <x-client.badge type="{{ $referral->status ? 'success' : 'secondary' }}" size="sm">{{ $referral->status ? __('Active') : __('Inactive') }}</x-client.badge>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                @if($referrals->hasPages())
                    <div class="px-4 md:px-5 py-3 md:py-4" style="border-top: 1px solid var(--card-border);">
                        {{ $referrals->links('vendor.livewire.novahost') }}
                    </div>
                @endif
            @else
                <div class="p-8 md:p-12">
                    <x-client.empty-state icon="ph-users" title="{{ __('No referrals yet') }}" description="{{ __('Share your referral link to start earning commissions.') }}" />
                </div>
            @endif
        </x-client.card>
    </div>

    {{-- Commission History --}}
    <x-client.card padding="none" class="animate-slide-up stagger-3">
        <div class="flex items-center justify-between px-4 md:px-5 py-3 md:py-4" style="border-bottom: 1px solid var(--card-border);">
            <div class="flex items-center gap-2.5 md:gap-3">
                <div class="flex h-8 w-8 items-center justify-center rounded-lg shrink-0" style="background: var(--success-light);">
                    <i class="ph ph-currency-dollar text-sm md:text-base" style="color: var(--success);"></i>
                </div>
                <h3 class="text-sm md:text-base font-medium" style="color: var(--text-primary);">@lang('Commission History')</h3>
            </div>
        </div>

        @if($commissions->count() > 0)
            <div class="overflow-x-auto">
                <table class="w-full text-xs md:text-sm">
                    <thead style="background: var(--primary-light);">
                        <tr>
                            <th class="px-4 md:px-5 py-2.5 md:py-3 text-left font-medium" style="color: var(--text-secondary);">@lang('Date')</th>
                            <th class="px-4 md:px-5 py-2.5 md:py-3 text-left font-medium" style="color: var(--text-secondary);">@lang('Referral')</th>
                            <th class="px-4 md:px-5 py-2.5 md:py-3 text-left font-medium" style="color: var(--text-secondary);">@lang('Amount')</th>
                            <th class="px-4 md:px-5 py-2.5 md:py-3 text-left font-medium" style="color: var(--text-secondary);">@lang('Status')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($commissions as $commission)
                            <tr class="transition-colors" style="border-bottom: 1px solid var(--card-border);">
                                <td class="px-4 md:px-5 py-3 md:py-4" style="color: var(--text-secondary);">{{ $commission->created_at->format('M d, Y') }}</td>
                                <td class="px-4 md:px-5 py-3 md:py-4" style="color: var(--text-primary);">{{ $commission->referral?->firstname ?? 'N/A' }} {{ $commission->referral?->lastname ?? '' }}</td>
                                <td class="px-4 md:px-5 py-3 md:py-4 font-semibold" style="color: var(--success);">{{ showAmount($commission->amount) }}</td>
                                <td class="px-4 md:px-5 py-3 md:py-4">
                                    <x-client.badge type="{{ $commission->status === 'paid' ? 'success' : ($commission->status === 'approved' ? 'info' : ($commission->status === 'rejected' ? 'danger' : 'warning')) }}" size="sm">
                                        {{ ucfirst($commission->status) }}
                                    </x-client.badge>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if($commissions->hasPages())
                <div class="px-4 md:px-5 py-3 md:py-4" style="border-top: 1px solid var(--card-border);">
                    {{ $commissions->links('vendor.livewire.novahost') }}
                </div>
            @endif
        @else
            <div class="p-8 md:p-12">
                <x-client.empty-state icon="ph-currency-dollar" title="{{ __('No commissions yet') }}" description="{{ __('Commissions will appear here when your referrals make purchases.') }}" />
            </div>
        @endif
    </x-client.card>

    {{-- Request Payout Button --}}
    @if($approvedEarnings >= $minPayout)
        <div class="flex justify-center animate-slide-up stagger-4">
            <x-client.button wire:click="openPayoutModal" size="lg">
                <i class="ph ph-wallet"></i>
                @lang('Request Payout') ({{ showAmount($approvedEarnings) }})
            </x-client.button>
        </div>
    @endif

    {{-- Payout History --}}
    @if($payouts->count() > 0)
        <x-client.card padding="none" class="animate-slide-up stagger-5">
            <div class="flex items-center justify-between px-4 md:px-5 py-3 md:py-4" style="border-bottom: 1px solid var(--card-border);">
                <div class="flex items-center gap-2.5 md:gap-3">
                    <div class="flex h-8 w-8 items-center justify-center rounded-lg shrink-0" style="background: var(--primary-light);">
                        <i class="ph ph-wallet text-sm md:text-base" style="color: var(--primary);"></i>
                    </div>
                    <h3 class="text-sm md:text-base font-medium" style="color: var(--text-primary);">@lang('Payout History')</h3>
                </div>
            </div>

            <div class="overflow-x-auto">
                <table class="w-full text-xs md:text-sm">
                    <thead style="background: var(--primary-light);">
                        <tr>
                            <th class="px-4 md:px-5 py-2.5 md:py-3 text-left font-medium" style="color: var(--text-secondary);">@lang('Date')</th>
                            <th class="px-4 md:px-5 py-2.5 md:py-3 text-left font-medium" style="color: var(--text-secondary);">@lang('Amount')</th>
                            <th class="px-4 md:px-5 py-2.5 md:py-3 text-left font-medium" style="color: var(--text-secondary);">@lang('Method')</th>
                            <th class="px-4 md:px-5 py-2.5 md:py-3 text-left font-medium" style="color: var(--text-secondary);">@lang('Status')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($payouts as $payout)
                            <tr class="transition-colors" style="border-bottom: 1px solid var(--card-border);">
                                <td class="px-4 md:px-5 py-3 md:py-4" style="color: var(--text-secondary);">{{ $payout->created_at->format('M d, Y') }}</td>
                                <td class="px-4 md:px-5 py-3 md:py-4 font-semibold" style="color: var(--text-primary);">{{ showAmount($payout->amount) }}</td>
                                <td class="px-4 md:px-5 py-3 md:py-4" style="color: var(--text-secondary);">{{ ucfirst(str_replace('_', ' ', $payout->payment_method)) }}</td>
                                <td class="px-4 md:px-5 py-3 md:py-4">
                                    <x-client.badge type="{{ $payout->status === 'completed' ? 'success' : ($payout->status === 'rejected' ? 'danger' : 'warning') }}" size="sm">
                                        {{ ucfirst($payout->status) }}
                                    </x-client.badge>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @if($payouts->hasPages())
                <div class="px-4 md:px-5 py-3 md:py-4" style="border-top: 1px solid var(--card-border);">
                    {{ $payouts->links('vendor.livewire.novahost') }}
                </div>
            @endif
        </x-client.card>
    @endif

    {{-- Payout Request Modal --}}
    <x-client.modal :show="$showPayoutModal" title="{{ __('Request Payout') }}" maxWidth="md" closeAction="closePayoutModal">
        <form wire:submit="requestPayout" class="space-y-4">
            <div class="text-center mb-4">
                <p class="text-sm" style="color: var(--text-secondary);">@lang('Available Balance')</p>
                <p class="text-2xl font-bold" style="color: var(--success);">{{ showAmount($approvedEarnings) }}</p>
                <p class="text-xs mt-1" style="color: var(--text-muted);">@lang('Minimum payout: :amount', ['amount' => showAmount($minPayout)])</p>
            </div>

            <x-client.input type="select" wire:model.live="payoutMethod" label="{{ __('Payment Method') }}">
                @foreach($paymentMethods as $key => $label)
                    <option value="{{ $key }}">{{ $label }}</option>
                @endforeach
            </x-client.input>

            @if($payoutMethod === 'paypal')
                <x-client.input type="email" wire:model="paypalEmail" label="{{ __('PayPal Email') }}" placeholder="your@email.com" required />
            @elseif($payoutMethod === 'bank_transfer')
                <x-client.input type="text" wire:model="bankName" label="{{ __('Bank Name') }}" placeholder="{{ __('Enter bank name') }}" required />
                <x-client.input type="text" wire:model="bankAccountName" label="{{ __('Account Holder Name') }}" placeholder="{{ __('Enter account holder name') }}" required />
                <x-client.input type="text" wire:model="bankAccountNumber" label="{{ __('Account Number') }}" placeholder="{{ __('Enter account number') }}" required />
                <x-client.input type="text" wire:model="bankRoutingNumber" label="{{ __('Routing Number') }}" placeholder="{{ __('Enter routing number (optional)') }}" />
            @endif

            <div class="flex gap-3 pt-4">
                <x-client.button type="button" wire:click="closePayoutModal" variant="secondary" class="flex-1">
                    @lang('Cancel')
                </x-client.button>
                <x-client.button type="submit" class="flex-1">
                    <i class="ph ph-paper-plane-tilt"></i>
                    @lang('Submit Request')
                </x-client.button>
            </div>
        </form>
    </x-client.modal>
</div>

