<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex items-center gap-3 md:gap-4 animate-fade-in">
        <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--primary-light);">
            <i class="ph ph-megaphone text-lg md:text-xl" style="color: var(--primary);"></i>
        </div>
        <div>
            <h1 class="text-lg md:text-xl font-semibold" style="color: var(--text-primary);">@lang('Announcements')</h1>
            <p class="mt-0.5 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Stay updated with the latest news and updates')</p>
        </div>
    </div>

    {{-- Search --}}
    <div class="max-w-md animate-slide-up">
        <x-client.input type="text" wire:model.live.debounce.300ms="search" placeholder="{{ __('Search announcements...') }}" prefixIcon="ph-magnifying-glass" />
    </div>

    {{-- Announcements List --}}
    <div class="space-y-2 md:space-y-3 animate-slide-up stagger-1">
        @forelse($announcements as $announcement)
            @php
                $data = $announcement->data_values;
            @endphp
            <a href="{{ route('client.announcements.show', $announcement->id) }}" wire:navigate class="group block hover-lift">
                <x-client.card padding="sm" class="md:p-5">
                    <div class="flex items-start gap-3 md:gap-4">
                        <div class="flex h-10 w-10 md:h-12 md:w-12 shrink-0 items-center justify-center rounded-lg md:rounded-xl" style="background: var(--primary-light);">
                            <i class="ph ph-megaphone text-lg md:text-xl" style="color: var(--primary);"></i>
                        </div>
                        <div class="min-w-0 flex-1">
                            <div class="mb-0.5 md:mb-1 flex flex-wrap items-center gap-1.5 md:gap-2">
                                <h3 class="text-sm md:text-base font-medium" style="color: var(--text-primary);">
                                    {{ $data->title ?? 'Untitled' }}
                                </h3>
                                @if($announcement->created_at->isToday())
                                    <x-client.badge type="success" size="xs">@lang('New')</x-client.badge>
                                @endif
                            </div>
                            <p class="mb-1.5 md:mb-2 line-clamp-2 text-xs md:text-sm" style="color: var(--text-secondary);">
                                {{ Str::limit(strip_tags($data->description ?? ''), 120) }}
                            </p>
                            <div class="flex flex-wrap items-center gap-2 md:gap-3 text-xs" style="color: var(--text-muted);">
                                <span class="flex items-center gap-1">
                                    <i class="ph ph-calendar"></i>
                                    {{ $announcement->created_at->format('M d, Y') }}
                                </span>
                                <span class="hidden sm:flex items-center gap-1">
                                    <i class="ph ph-clock"></i>
                                    {{ $announcement->created_at->diffForHumans() }}
                                </span>
                            </div>
                        </div>
                        <i class="ph ph-arrow-right text-base md:text-lg opacity-0 group-hover:opacity-100 transition-opacity shrink-0" style="color: var(--text-muted);"></i>
                    </div>
                </x-client.card>
            </a>
        @empty
            <x-client.empty-state icon="ph-megaphone" title="{{ __('No Announcements') }}" description="{{ __('There are no announcements at this time.') }}" />
        @endforelse
    </div>

    {{-- Pagination --}}
    @if($announcements->hasPages())
        <div class="mt-4 md:mt-6">
            {{ $announcements->links('vendor.livewire.novahost') }}
        </div>
    @endif
</div>
