@php
    $data = $announcement->data_values;
@endphp

<div class="space-y-4 md:space-y-6">
    {{-- Breadcrumb --}}
    <nav class="flex items-center gap-1.5 md:gap-2 text-xs md:text-sm animate-fade-in">
        <a href="{{ route('client.announcements') }}" wire:navigate class="font-medium transition-colors touch-target" style="color: var(--primary);">@lang('Announcements')</a>
        <i class="ph ph-caret-right" style="color: var(--text-muted);"></i>
        <span class="font-medium truncate" style="color: var(--text-primary);">{{ Str::limit($data->title ?? 'Untitled', 25) }}</span>
    </nav>

    {{-- Announcement Card --}}
    <x-client.card padding="none" class="overflow-hidden animate-slide-up">
        {{-- Header --}}
        <div class="p-4 md:p-6" style="border-bottom: 1px solid var(--card-border); background: var(--primary-light);">
            <div class="flex items-start gap-3 md:gap-4">
                <div class="flex h-10 w-10 md:h-12 md:w-12 shrink-0 items-center justify-center rounded-lg md:rounded-xl" style="background: var(--primary); opacity: 0.2;">
                    <i class="ph ph-megaphone text-lg md:text-xl" style="color: var(--primary);"></i>
                </div>
                <div class="flex-1 min-w-0">
                    <h1 class="mb-1.5 md:mb-2 text-lg md:text-xl font-semibold" style="color: var(--text-primary);">
                        {{ $data->title ?? 'Untitled' }}
                    </h1>
                    <div class="flex flex-wrap items-center gap-2 md:gap-4 text-xs md:text-sm" style="color: var(--text-secondary);">
                        <span class="flex items-center gap-1 md:gap-1.5">
                            <i class="ph ph-calendar"></i>
                            {{ $announcement->created_at->format('M d, Y') }}
                        </span>
                        <span class="flex items-center gap-1 md:gap-1.5">
                            <i class="ph ph-clock"></i>
                            {{ $announcement->created_at->format('h:i A') }}
                        </span>
                    </div>
                </div>
            </div>
        </div>

        {{-- Content --}}
        <div class="p-4 md:p-6">
            <div class="prose prose-sm md:prose max-w-none text-sm md:text-base" style="color: var(--text-secondary);">
                {!! $data->description ?? '' !!}
            </div>
        </div>
    </x-client.card>

    {{-- Share Section --}}
    <x-client.card padding="sm" class="animate-slide-up stagger-1">
        <div class="flex items-center justify-between">
            <span class="text-xs md:text-sm font-medium" style="color: var(--text-secondary);">@lang('Share this announcement')</span>
            <div class="flex items-center gap-2">
                <button onclick="navigator.clipboard.writeText(window.location.href); this.querySelector('i').classList.replace('ph-link', 'ph-check'); setTimeout(() => this.querySelector('i').classList.replace('ph-check', 'ph-link'), 2000);" class="p-2 rounded-lg transition-colors touch-target" style="color: var(--text-secondary);" title="@lang('Copy Link')">
                    <i class="ph ph-link text-base md:text-lg"></i>
                </button>
            </div>
        </div>
    </x-client.card>

    {{-- Back Button --}}
    <a href="{{ route('client.announcements') }}" wire:navigate class="inline-flex items-center gap-1.5 md:gap-2 text-xs md:text-sm font-medium transition-colors touch-target animate-slide-up stagger-2" style="color: var(--primary);">
        <i class="ph ph-arrow-left"></i>
        @lang('Back to Announcements')
    </a>
</div>
