<div class="space-y-4 md:space-y-6">
    {{-- Flash Messages --}}
    @if(session('success'))
        <x-client.alert type="success" class="animate-slide-up">{{ session('success') }}</x-client.alert>
    @endif
    @if(session('error'))
        <x-client.alert type="danger" class="animate-slide-up">{{ session('error') }}</x-client.alert>
    @endif

    {{-- Page Header --}}
    <div class="flex flex-col gap-3 md:gap-4 sm:flex-row sm:items-center sm:justify-between animate-fade-in">
        <div class="flex items-center gap-3 md:gap-4">
            <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--primary-light);">
                <i class="ph ph-shopping-cart text-lg md:text-xl" style="color: var(--primary);"></i>
            </div>
            <div>
                <h1 class="text-lg md:text-xl font-semibold" style="color: var(--text-primary);">@lang('Shopping Cart')</h1>
                <p class="mt-0.5 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Review your order before checkout')</p>
            </div>
        </div>
        @if($cartItems->count() > 0)
            <x-client.button wire:click="clearCart" wire:confirm="@lang('Are you sure you want to clear your cart?')" variant="ghost" icon="ph-trash" class="text-[var(--danger)]">@lang('Clear Cart')</x-client.button>
        @endif
    </div>

    @if($cartItems->count() > 0)
        <div class="grid gap-4 md:gap-6 lg:gap-8 lg:grid-cols-3">
            {{-- Cart Items --}}
            <div class="lg:col-span-2 space-y-3 md:space-y-4">
                @foreach($cartItems as $index => $item)
                    <x-client.card class="animate-slide-up hover-lift" style="animation-delay: {{ $index * 50 }}ms;">
                        <div class="flex items-start gap-3 md:gap-4">
                            {{-- Item Icon --}}
                            <div class="flex h-10 w-10 md:h-12 md:w-12 shrink-0 items-center justify-center rounded-lg md:rounded-xl" style="background: {{ $item->isHosting() ? 'var(--primary-light)' : 'var(--success-light, rgba(34, 197, 94, 0.1))' }};">
                                @if($item->type == \App\Models\ShoppingCart::TYPE_ONLY_HOSTING)
                                    <i class="ph ph-hard-drives text-lg md:text-xl" style="color: var(--primary);"></i>
                                @elseif($item->type == \App\Models\ShoppingCart::TYPE_HOSTING_AND_DOMAIN)
                                    <i class="ph ph-hard-drives text-lg md:text-xl" style="color: var(--primary);"></i>
                                @elseif($item->type == \App\Models\ShoppingCart::TYPE_ONLY_DOMAIN)
                                    <i class="ph ph-globe text-lg md:text-xl" style="color: var(--success);"></i>
                                @else
                                    <i class="ph ph-arrows-clockwise text-lg md:text-xl" style="color: var(--warning);"></i>
                                @endif
                            </div>

                            {{-- Item Details --}}
                            <div class="min-w-0 flex-1">
                                <div class="flex flex-col sm:flex-row sm:items-start sm:justify-between gap-1 sm:gap-4">
                                    <div class="min-w-0">
                                        <h3 class="font-semibold text-sm md:text-base truncate" style="color: var(--text-primary);">
                                            @if($item->product_id && $item->product)
                                                {{ $item->product->name }}
                                            @elseif($item->isDomain())
                                                {{ $item->domain }}
                                            @else
                                                @lang('Product')
                                            @endif
                                        </h3>
                                        <p class="text-xs md:text-sm mt-0.5" style="color: var(--text-secondary);">
                                            {{ $item->getTypeLabel() }}
                                        </p>
                                    </div>
                                    <div class="text-left sm:text-right shrink-0">
                                        <p class="font-semibold text-sm md:text-base" style="color: var(--text-primary);">{{ showAmount($item->total) }}</p>
                                        @if($item->discount > 0)
                                            <p class="text-xs line-through" style="color: var(--text-muted);">{{ showAmount($item->total + $item->discount) }}</p>
                                        @endif
                                    </div>
                                </div>

                                {{-- Item Meta --}}
                                <div class="mt-2 md:mt-3 flex flex-wrap items-center gap-1.5 md:gap-2">
                                    @if($item->domain)
                                        <x-client.badge type="info" size="xs" icon="ph-globe">{{ $item->domain }}</x-client.badge>
                                    @endif
                                    @if($item->billing_cycle)
                                        <x-client.badge type="secondary" size="xs" icon="ph-calendar">{{ billingCycleLabel($item->billing_cycle) }}</x-client.badge>
                                    @endif
                                    @if($item->reg_period && $item->isDomain())
                                        <x-client.badge type="success" size="xs" icon="ph-timer">{{ $item->reg_period }} @lang('Year(s)')</x-client.badge>
                                    @endif
                                    @if($item->id_protection)
                                        <x-client.badge type="warning" size="xs" icon="ph-shield-check">@lang('ID Protection')</x-client.badge>
                                    @endif
                                </div>

                                {{-- Price Breakdown --}}
                                @if($item->setup_fee > 0 || $item->discount > 0)
                                    <div class="mt-2 md:mt-3 pt-2 md:pt-3 space-y-1" style="border-top: 1px dashed var(--card-border);">
                                        <div class="flex justify-between text-xs">
                                            <span style="color: var(--text-secondary);">@lang('Price')</span>
                                            <span style="color: var(--text-primary);">{{ showAmount($item->price) }}</span>
                                        </div>
                                        @if($item->setup_fee > 0)
                                            <div class="flex justify-between text-xs">
                                                <span style="color: var(--text-secondary);">@lang('Setup Fee')</span>
                                                <span style="color: var(--text-primary);">{{ showAmount($item->setup_fee) }}</span>
                                            </div>
                                        @endif
                                        @if($item->discount > 0)
                                            <div class="flex justify-between text-xs">
                                                <span style="color: var(--text-secondary);">@lang('Discount')</span>
                                                <span style="color: var(--success);">-{{ showAmount($item->discount) }}</span>
                                            </div>
                                        @endif
                                    </div>
                                @endif

                                {{-- Actions --}}
                                <div class="mt-2 md:mt-3 flex flex-wrap items-center gap-2 md:gap-4">
                                    @if($item->isHosting() && $item->product_id)
                                        <a href="{{ route('client.cart.config.service', $item->id) }}" wire:navigate class="inline-flex items-center gap-1 text-xs font-medium transition-colors touch-target" style="color: var(--primary);">
                                            <i class="ph ph-gear"></i>
                                            @lang('Configure')
                                        </a>
                                    @endif
                                    @if($item->isDomain() && $item->domain_setup_id)
                                        <a href="{{ route('client.cart.config.domain', $item->id) }}" wire:navigate class="inline-flex items-center gap-1 text-xs font-medium transition-colors touch-target" style="color: var(--primary);">
                                            <i class="ph ph-gear"></i>
                                            @lang('Configure')
                                        </a>
                                    @endif
                                    <button wire:click="removeItem({{ $item->id }})" class="inline-flex items-center gap-1 text-xs font-medium transition-colors touch-target" style="color: var(--danger);">
                                        <i class="ph ph-trash"></i>
                                        @lang('Remove')
                                    </button>
                                </div>
                            </div>
                        </div>
                    </x-client.card>
                @endforeach
            </div>

            {{-- Order Summary --}}
            <div class="animate-slide-up stagger-2">
                <x-client.card class="sticky top-4 md:top-6">
                    <h3 class="mb-3 md:mb-4 font-semibold text-base md:text-lg" style="color: var(--text-primary);">@lang('Order Summary')</h3>

                    {{-- Coupon Section --}}
                    <div class="mb-3 md:mb-4 pb-3 md:pb-4" style="border-bottom: 1px solid var(--card-border);">
                        @if($appliedCoupon)
                            <div class="flex items-center justify-between rounded-lg md:rounded-xl p-2.5 md:p-3" style="background: var(--success-light, rgba(34, 197, 94, 0.1));">
                                <div class="flex items-center gap-2">
                                    <i class="ph ph-ticket text-base md:text-lg" style="color: var(--success);"></i>
                                    <span class="text-xs md:text-sm font-medium" style="color: var(--success);">{{ $appliedCoupon->coupon->code ?? 'Coupon' }}</span>
                                </div>
                                <button wire:click="removeCoupon" class="text-xs font-medium touch-target" style="color: var(--danger);">
                                    @lang('Remove')
                                </button>
                            </div>
                        @else
                            @if($showCouponForm)
                                <form wire:submit="applyCoupon" class="space-y-2">
                                    <div class="flex gap-2">
                                        <x-client.input type="text" wire:model="couponCode" placeholder="@lang('Enter coupon code')" class="flex-1" />
                                        <x-client.button type="submit" wireLoading="applyCoupon">@lang('Apply')</x-client.button>
                                    </div>
                                    <button type="button" wire:click="toggleCouponForm" class="text-xs touch-target" style="color: var(--text-secondary);">
                                        @lang('Cancel')
                                    </button>
                                </form>
                            @else
                                <button wire:click="toggleCouponForm" class="flex items-center gap-2 text-xs md:text-sm font-medium transition-colors touch-target" style="color: var(--primary);">
                                    <i class="ph ph-ticket"></i>
                                    @lang('Have a coupon code?')
                                </button>
                            @endif
                        @endif
                    </div>

                    {{-- Totals --}}
                    <dl class="space-y-2 md:space-y-3 text-sm md:text-base">
                        <div class="flex justify-between">
                            <dt style="color: var(--text-secondary);">@lang('Subtotal')</dt>
                            <dd class="font-medium" style="color: var(--text-primary);">{{ showAmount($totals['subtotal']) }}</dd>
                        </div>
                        @if($totals['discount'] > 0)
                            <div class="flex justify-between">
                                <dt style="color: var(--text-secondary);">@lang('Discount')</dt>
                                <dd class="font-medium" style="color: var(--success);">-{{ showAmount($totals['discount']) }}</dd>
                            </div>
                        @endif
                        <div class="flex justify-between pt-2 md:pt-3" style="border-top: 1px solid var(--card-border);">
                            <dt class="text-base md:text-lg font-semibold" style="color: var(--text-primary);">@lang('Total')</dt>
                            <dd class="text-base md:text-lg font-bold" style="color: var(--primary);">{{ showAmount($totals['total']) }}</dd>
                        </div>
                    </dl>

                    {{-- Checkout Button --}}
                    <div class="mt-4 md:mt-6">
                        <x-client.button href="{{ route('client.cart.checkout') }}" icon="ph-arrow-right" fullWidth class="justify-center py-2.5 md:py-3">
                            @lang('Proceed to Checkout')
                        </x-client.button>
                    </div>

                    {{-- Item Count --}}
                    <p class="mt-3 md:mt-4 text-center text-xs md:text-sm" style="color: var(--text-muted);">
                        {{ $totals['item_count'] }} {{ $totals['item_count'] == 1 ? __('item') : __('items') }} @lang('in cart')
                    </p>
                </x-client.card>
            </div>
        </div>
    @else
        {{-- Empty Cart --}}
        <x-client.card class="text-center animate-fade-in" padding="lg">
            <div class="mx-auto mb-4 md:mb-6 flex h-16 w-16 md:h-20 md:w-20 items-center justify-center rounded-xl md:rounded-2xl" style="background: var(--primary-light);">
                <i class="ph ph-shopping-cart text-3xl md:text-4xl" style="color: var(--text-muted);"></i>
            </div>
            <h3 class="mb-1.5 md:mb-2 text-base md:text-lg font-semibold" style="color: var(--text-primary);">@lang('Your cart is empty')</h3>
            <p class="mb-4 md:mb-6 max-w-md mx-auto text-sm md:text-base" style="color: var(--text-secondary);">@lang('Browse our products and services to find what you need.')</p>
            <x-client.button href="/" icon="ph-storefront">@lang('Browse Products')</x-client.button>
        </x-client.card>
    @endif
</div>
