<div class="space-y-4 md:space-y-6">
    {{-- Flash Messages --}}
    @if(session('success'))
        <x-client.alert type="success" class="animate-slide-up">{{ session('success') }}</x-client.alert>
    @endif
    @if(session('error'))
        <x-client.alert type="danger" class="animate-slide-up">{{ session('error') }}</x-client.alert>
    @endif

    {{-- Page Header --}}
    <div class="flex flex-col gap-3 md:gap-4 sm:flex-row sm:items-center sm:justify-between animate-fade-in">
        <div class="flex items-center gap-3 md:gap-4">
            <a href="{{ route('client.cart') }}" wire:navigate class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-lg md:rounded-xl transition-colors touch-target shrink-0" style="background: var(--primary-light);">
                <i class="ph ph-arrow-left text-base md:text-lg" style="color: var(--primary);"></i>
            </a>
            <div>
                <h1 class="text-lg md:text-xl font-semibold" style="color: var(--text-primary);">@lang('Checkout')</h1>
                <p class="mt-0.5 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Complete your order')</p>
            </div>
        </div>
    </div>

    <div class="grid gap-4 md:gap-6 lg:gap-8 lg:grid-cols-3">
        {{-- Payment Methods --}}
        <div class="lg:col-span-2 space-y-4 md:space-y-6">
            {{-- Order Items --}}
            <x-client.card class="animate-slide-up stagger-1">
                <h3 class="mb-3 md:mb-4 font-semibold text-sm md:text-base" style="color: var(--text-primary);">@lang('Order Items')</h3>
                <div class="space-y-2 md:space-y-3">
                    @foreach($cartItems as $item)
                        <div class="flex items-center justify-between p-2.5 md:p-3 rounded-lg md:rounded-xl" style="background: var(--card-bg); border: 1px solid var(--card-border);">
                            <div class="flex items-center gap-2.5 md:gap-3 min-w-0">
                                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-lg shrink-0" style="background: {{ $item->isHosting() ? 'var(--primary-light)' : 'var(--success-light, rgba(34, 197, 94, 0.1))' }};">
                                    @if($item->isHosting())
                                        <i class="ph ph-hard-drives text-sm md:text-base" style="color: var(--primary);"></i>
                                    @else
                                        <i class="ph ph-globe text-sm md:text-base" style="color: var(--success);"></i>
                                    @endif
                                </div>
                                <div class="min-w-0">
                                    <p class="font-medium text-xs md:text-sm truncate" style="color: var(--text-primary);">
                                        @if($item->product)
                                            {{ $item->product->name }}
                                        @elseif($item->domain)
                                            {{ $item->domain }}
                                        @else
                                            @lang('Product')
                                        @endif
                                    </p>
                                    <p class="text-xs truncate" style="color: var(--text-secondary);">
                                        {{ $item->getTypeLabel() }}
                                        @if($item->billing_cycle !== null)
                                            • {{ billingCycleLabel($item->billing_cycle) }}
                                        @endif
                                        @if($item->reg_period && $item->isDomain())
                                            • {{ $item->reg_period }} @lang('Year(s)')
                                        @endif
                                    </p>
                                </div>
                            </div>
                            <p class="font-semibold text-xs md:text-sm shrink-0 ml-2" style="color: var(--text-primary);">{{ showAmount($item->total) }}</p>
                        </div>
                    @endforeach
                </div>
            </x-client.card>

            {{-- Payment Methods --}}
            <x-client.card class="animate-slide-up stagger-2">
                <h3 class="mb-3 md:mb-4 font-semibold text-sm md:text-base" style="color: var(--text-primary);">@lang('Payment Method')</h3>
                <div class="space-y-2 md:space-y-3">
                    {{-- Wallet - Only show if credit is enabled in billing settings --}}
                    @if($creditEnabled)
                    <button wire:click="selectPaymentMethod('wallet')" class="flex w-full items-center justify-between p-3 md:p-4 rounded-lg md:rounded-xl border-2 transition-all touch-target hover-lift" style="border-color: {{ $paymentMethod === 'wallet' ? 'var(--primary)' : 'var(--card-border)' }}; background: {{ $paymentMethod === 'wallet' ? 'var(--primary-light)' : 'var(--card-bg)' }};">
                        <div class="flex items-center gap-3 md:gap-4">
                            <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--success-light, rgba(34, 197, 94, 0.1));">
                                <i class="ph ph-wallet text-lg md:text-xl" style="color: var(--success);"></i>
                            </div>
                            <div class="text-left min-w-0">
                                <p class="font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Pay with Wallet')</p>
                                <p class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Balance'): {{ showAmount($balance) }}</p>
                            </div>
                        </div>
                        @if($paymentMethod === 'wallet')
                            <i class="ph-fill ph-check-circle text-lg md:text-xl shrink-0" style="color: var(--primary);"></i>
                        @else
                            <i class="ph ph-circle text-lg md:text-xl shrink-0" style="color: var(--card-border);"></i>
                        @endif
                    </button>
                    @endif

                    {{-- Gateways --}}
                    @foreach($gateways as $gateway)
                        <button wire:click="selectPaymentMethod('gateway', {{ $gateway->id }})" class="flex w-full items-center justify-between p-3 md:p-4 rounded-lg md:rounded-xl border-2 transition-all touch-target hover-lift" style="border-color: {{ $paymentMethod === 'gateway' && $gateway_id == $gateway->id ? 'var(--primary)' : 'var(--card-border)' }}; background: {{ $paymentMethod === 'gateway' && $gateway_id == $gateway->id ? 'var(--primary-light)' : 'var(--card-bg)' }};">
                            <div class="flex items-center gap-3 md:gap-4 min-w-0">
                                <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl overflow-hidden shrink-0" style="background: var(--primary-light);">
                                    @if($gateway->image)
                                        <img src="{{ getImage(getFilePath('gateway') . '/' . $gateway->image) }}" alt="{{ $gateway->name }}" class="h-6 w-6 md:h-8 md:w-8 object-contain">
                                    @else
                                        <i class="ph ph-credit-card text-lg md:text-xl" style="color: var(--primary);"></i>
                                    @endif
                                </div>
                                <div class="text-left min-w-0">
                                    <p class="font-medium text-sm md:text-base truncate" style="color: var(--text-primary);">{{ $gateway->name }}</p>
                                    @if($gateway->percent_charge > 0 || $gateway->fixed_charge > 0)
                                        <p class="text-xs md:text-sm" style="color: var(--text-secondary);">
                                            @lang('Fee'): {{ $gateway->percent_charge }}% + {{ showAmount($gateway->fixed_charge) }}
                                        </p>
                                    @endif
                                </div>
                            </div>
                            @if($paymentMethod === 'gateway' && $gateway_id == $gateway->id)
                                <i class="ph-fill ph-check-circle text-lg md:text-xl shrink-0" style="color: var(--primary);"></i>
                            @else
                                <i class="ph ph-circle text-lg md:text-xl shrink-0" style="color: var(--card-border);"></i>
                            @endif
                        </button>
                    @endforeach
                </div>
            </x-client.card>
        </div>

        {{-- Order Summary --}}
        <div class="animate-slide-up stagger-3">
            <x-client.card class="sticky top-4 md:top-6">
                <h3 class="mb-3 md:mb-4 font-semibold text-base md:text-lg" style="color: var(--text-primary);">@lang('Order Summary')</h3>

                {{-- Promo Code Section --}}
                <div class="mb-3 md:mb-4 pb-3 md:pb-4" style="border-bottom: 1px solid var(--card-border);">
                    @if($appliedCoupon && $appliedCoupon->coupon)
                        <div class="flex items-center justify-between p-2.5 md:p-3 rounded-lg md:rounded-xl" style="background: var(--success-light, rgba(34, 197, 94, 0.1));">
                            <div class="flex items-center gap-2">
                                <i class="ph ph-ticket text-base md:text-lg" style="color: var(--success);"></i>
                                <div>
                                    <p class="text-xs md:text-sm font-medium" style="color: var(--success);">{{ $appliedCoupon->coupon->code }}</p>
                                    <p class="text-xs" style="color: var(--text-secondary);">
                                        @if($appliedCoupon->coupon->type == 1)
                                            {{ showAmount($appliedCoupon->coupon->amount) }} @lang('off')
                                        @else
                                            {{ $appliedCoupon->coupon->amount }}% @lang('off')
                                        @endif
                                    </p>
                                </div>
                            </div>
                            <button wire:click="removePromoCode" class="text-xs md:text-sm font-medium touch-target" style="color: var(--danger);">
                                <i class="ph ph-x"></i>
                            </button>
                        </div>
                    @else
                        <div class="flex gap-2">
                            <x-client.input wire:model="promoCode" type="text" placeholder="@lang('Promo code')" class="flex-1" />
                            <x-client.button wire:click="applyPromoCode" wireLoading="applyPromoCode">@lang('Apply')</x-client.button>
                        </div>
                        @error('promoCode')
                            <p class="mt-1.5 md:mt-2 text-xs md:text-sm" style="color: var(--danger);">{{ $message }}</p>
                        @enderror
                    @endif
                </div>

                {{-- Totals --}}
                <dl class="space-y-2 md:space-y-3 text-sm md:text-base">
                    <div class="flex justify-between">
                        <dt style="color: var(--text-secondary);">@lang('Subtotal')</dt>
                        <dd class="font-medium" style="color: var(--text-primary);">{{ showAmount($totals['subtotal']) }}</dd>
                    </div>
                    @if($totals['discount'] > 0)
                        <div class="flex justify-between">
                            <dt style="color: var(--text-secondary);">@lang('Discount')</dt>
                            <dd class="font-medium" style="color: var(--success);">-{{ showAmount($totals['discount']) }}</dd>
                        </div>
                    @endif
                    <div class="flex justify-between pt-2 md:pt-3" style="border-top: 1px solid var(--card-border);">
                        <dt class="text-base md:text-lg font-semibold" style="color: var(--text-primary);">@lang('Total')</dt>
                        <dd class="text-base md:text-lg font-bold" style="color: var(--primary);">{{ showAmount($totals['total']) }}</dd>
                    </div>
                </dl>

                @if($paymentMethod === 'wallet' && $balance < $totals['total'])
                    <x-client.alert type="warning" class="mt-3 md:mt-4">
                        @lang('Insufficient balance.')
                        <a href="{{ route('client.deposits.add') }}" wire:navigate class="font-medium underline" style="color: var(--primary);">@lang('Add funds')</a>
                    </x-client.alert>
                @endif

                <div class="mt-4 md:mt-6">
                    <x-client.button wire:click="placeOrder" icon="ph-check-circle" wireLoading="placeOrder" fullWidth class="justify-center py-2.5 md:py-3" :disabled="$paymentMethod === 'wallet' && $balance < $totals['total']">
                        @lang('Place Order')
                    </x-client.button>
                </div>

                <p class="mt-3 md:mt-4 text-center text-xs" style="color: var(--text-muted);">
                    {{ $totals['item_count'] }} {{ $totals['item_count'] == 1 ? __('item') : __('items') }} • @lang('By placing this order, you agree to our Terms of Service.')
                </p>
            </x-client.card>
        </div>
    </div>
</div>
