<div class="space-y-6">
    {{-- Flash Messages --}}
    @if(session('error'))
        <div class="rounded-xl p-4" style="background: color-mix(in srgb, var(--danger) 12%, transparent); border: 1px solid color-mix(in srgb, var(--danger) 30%, transparent);">
            <div class="flex items-center gap-3">
                <i class="ph ph-warning-circle text-lg" style="color: var(--danger);"></i>
                <p class="text-sm font-medium" style="color: var(--danger);">{{ session('error') }}</p>
            </div>
        </div>
    @endif

    {{-- Page Header --}}
    <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
        <div class="flex items-center gap-4">
            <a href="{{ route('client.cart') }}" wire:navigate class="flex h-10 w-10 items-center justify-center rounded-xl transition-smooth hover:opacity-80" style="background: var(--primary-light);">
                <i class="ph ph-arrow-left text-lg" style="color: var(--primary);"></i>
            </a>
            <div>
                <h1 class="text-xl font-semibold" style="color: var(--text-primary);">@lang('Domain Configuration')</h1>
                <p class="mt-0.5" style="color: var(--text-secondary);">{{ $cart->domain }}</p>
            </div>
        </div>
    </div>

    <div class="grid gap-8 lg:grid-cols-3">
        {{-- Configuration Form --}}
        <div class="lg:col-span-2">
            <form wire:submit="updateConfig" class="card-dynamic rounded-2xl p-6 space-y-6">
                {{-- Registration Period --}}
                <div>
                    <label class="block text-sm font-medium mb-3" style="color: var(--text-primary);">@lang('Registration Period')</label>
                    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-5 gap-3">
                        @for($year = 1; $year <= 10; $year++)
                            @php
                                $priceField = "year_{$year}";
                                $price = $domainSetup?->pricing?->$priceField ?? null;
                            @endphp
                            @if($price !== null && $price >= 0)
                                <label class="relative cursor-pointer">
                                    <input type="radio" wire:model.live="regPeriod" value="{{ $year }}" class="peer sr-only">
                                    <div class="rounded-xl border-2 p-3 text-center transition-smooth peer-checked:border-[var(--primary)] peer-checked:bg-[var(--primary-light)]" style="border-color: var(--border);">
                                        <p class="font-semibold" style="color: var(--text-primary);">{{ $year }} @lang('Year')</p>
                                        <p class="text-sm mt-1" style="color: var(--text-secondary);">{{ showAmount($price) }}</p>
                                    </div>
                                </label>
                            @endif
                        @endfor
                    </div>
                </div>

                {{-- ID Protection --}}
                @if($domainSetup?->id_protection)
                    <div class="rounded-xl p-4" style="background: color-mix(in srgb, var(--warning) 8%, transparent); border: 1px solid color-mix(in srgb, var(--warning) 20%, transparent);">
                        <label class="flex items-start gap-4 cursor-pointer">
                            <div class="mt-0.5">
                                <input type="checkbox" wire:model.live="idProtection" class="h-5 w-5 rounded border-gray-300 text-[var(--primary)] focus:ring-[var(--primary)]">
                            </div>
                            <div class="flex-1">
                                <div class="flex items-center gap-2">
                                    <i class="ph ph-shield-check text-lg" style="color: var(--warning);"></i>
                                    <span class="font-medium" style="color: var(--text-primary);">@lang('ID Protection')</span>
                                    @php
                                        $idField = "id_protection_{$regPeriod}";
                                        $idPrice = $domainSetup?->pricing?->$idField ?? 0;
                                    @endphp
                                    <span class="text-sm font-medium" style="color: var(--primary);">+{{ showAmount($idPrice) }}/@lang('year')</span>
                                </div>
                                <p class="mt-1 text-sm" style="color: var(--text-secondary);">
                                    @lang('Protect your personal information from being publicly displayed in WHOIS records.')
                                </p>
                            </div>
                        </label>
                    </div>
                @endif

                {{-- Nameservers --}}
                @if(!$cart->product_id)
                    <div>
                        <label class="block text-sm font-medium mb-3" style="color: var(--text-primary);">@lang('Nameservers')</label>
                        <p class="text-sm mb-4" style="color: var(--text-secondary);">@lang('Configure custom nameservers for your domain (optional).')</p>
                        <div class="grid sm:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-xs font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Nameserver 1')</label>
                                <input type="text" wire:model="ns1" placeholder="ns1.example.com" class="input-dynamic w-full rounded-xl px-4 py-2.5" style="border: 1px solid var(--border);">
                            </div>
                            <div>
                                <label class="block text-xs font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Nameserver 2')</label>
                                <input type="text" wire:model="ns2" placeholder="ns2.example.com" class="input-dynamic w-full rounded-xl px-4 py-2.5" style="border: 1px solid var(--border);">
                            </div>
                            <div>
                                <label class="block text-xs font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Nameserver 3') <span class="opacity-50">(@lang('optional'))</span></label>
                                <input type="text" wire:model="ns3" placeholder="ns3.example.com" class="input-dynamic w-full rounded-xl px-4 py-2.5" style="border: 1px solid var(--border);">
                            </div>
                            <div>
                                <label class="block text-xs font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Nameserver 4') <span class="opacity-50">(@lang('optional'))</span></label>
                                <input type="text" wire:model="ns4" placeholder="ns4.example.com" class="input-dynamic w-full rounded-xl px-4 py-2.5" style="border: 1px solid var(--border);">
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Submit --}}
                <div class="pt-4" style="border-top: 1px solid var(--border);">
                    <button type="submit" class="btn-primary flex w-full items-center justify-center gap-2 rounded-xl py-3 font-semibold transition-smooth">
                        <i class="ph ph-check-circle"></i>
                        @lang('Update Configuration')
                    </button>
                </div>
            </form>
        </div>

        {{-- Price Summary --}}
        <div>
            <div class="card-dynamic rounded-2xl p-6 sticky top-6">
                <h3 class="font-semibold text-lg mb-4" style="color: var(--text-primary);">@lang('Price Summary')</h3>

                <div class="space-y-4">
                    {{-- Domain Info --}}
                    <div class="flex items-center gap-3 pb-4" style="border-bottom: 1px solid var(--border);">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl" style="background: color-mix(in srgb, var(--success) 12%, transparent);">
                            <i class="ph ph-globe text-lg" style="color: var(--success);"></i>
                        </div>
                        <div>
                            <p class="font-medium" style="color: var(--text-primary);">{{ $cart->domain }}</p>
                            <p class="text-sm" style="color: var(--text-secondary);">{{ $domainSetup?->extension }}</p>
                        </div>
                    </div>

                    {{-- Price Breakdown --}}
                    <dl class="space-y-3">
                        <div class="flex justify-between">
                            <dt style="color: var(--text-secondary);">@lang('Registration') ({{ $regPeriod }} @lang('year(s)'))</dt>
                            <dd class="font-medium" style="color: var(--text-primary);">{{ showAmount($this->domainPrice) }}</dd>
                        </div>
                        @if($idProtection && $this->idProtectionPrice > 0)
                            <div class="flex justify-between">
                                <dt style="color: var(--text-secondary);">@lang('ID Protection')</dt>
                                <dd class="font-medium" style="color: var(--text-primary);">{{ showAmount($this->idProtectionPrice) }}</dd>
                            </div>
                        @endif
                        <div class="flex justify-between pt-3" style="border-top: 1px solid var(--border);">
                            <dt class="text-lg font-semibold" style="color: var(--text-primary);">@lang('Total')</dt>
                            <dd class="text-lg font-bold" style="color: var(--primary);">{{ showAmount($this->totalPrice) }}</dd>
                        </div>
                    </dl>
                </div>
            </div>
        </div>
    </div>
</div>

