<div class="min-h-screen py-12" style="background: var(--bg-color);">
    <div class="mx-auto max-w-5xl px-4 sm:px-6 lg:px-8">
        {{-- Flash Messages --}}
        @if(session('error'))
            <div class="mb-6 rounded-xl p-4" style="background: color-mix(in srgb, var(--danger) 12%, transparent); border: 1px solid color-mix(in srgb, var(--danger) 30%, transparent);">
                <div class="flex items-center gap-3">
                    <i class="ph ph-warning-circle text-lg" style="color: var(--danger);"></i>
                    <p class="text-sm font-medium" style="color: var(--danger);">{{ session('error') }}</p>
                </div>
            </div>
        @endif

        {{-- Header --}}
        <div class="mb-8 text-center">
            <a href="/" class="inline-flex items-center gap-2 mb-4 text-sm font-medium" style="color: var(--primary);">
                <i class="ph ph-arrow-left"></i>
                @lang('Continue Shopping')
            </a>
            <h1 class="text-2xl font-bold" style="color: var(--text-primary);">@lang('Checkout')</h1>
            <p class="mt-1" style="color: var(--text-secondary);">@lang('Complete your order in a few simple steps')</p>
        </div>

        {{-- Progress Steps --}}
        <div class="mb-8">
            <div class="flex items-center justify-center gap-2 sm:gap-4">
                @foreach([1 => 'Account', 2 => 'Billing', 3 => 'Payment', 4 => 'Review'] as $stepNum => $stepName)
                    <div class="flex items-center gap-2">
                        <button wire:click="goToStep({{ $stepNum }})"
                                class="flex h-8 w-8 items-center justify-center rounded-full text-sm font-semibold transition-smooth {{ $step >= $stepNum ? 'cursor-pointer' : 'cursor-not-allowed' }}"
                                style="background: {{ $step >= $stepNum ? 'var(--primary)' : 'var(--border)' }}; color: {{ $step >= $stepNum ? 'white' : 'var(--text-muted)' }};"
                                @if($step < $stepNum) disabled @endif>
                            @if($step > $stepNum)
                                <i class="ph ph-check"></i>
                            @else
                                {{ $stepNum }}
                            @endif
                        </button>
                        <span class="hidden sm:block text-sm font-medium {{ $step >= $stepNum ? '' : 'opacity-50' }}" style="color: var(--text-primary);">
                            @lang($stepName)
                        </span>
                    </div>
                    @if($stepNum < 4)
                        <div class="h-0.5 w-8 sm:w-12" style="background: {{ $step > $stepNum ? 'var(--primary)' : 'var(--border)' }};"></div>
                    @endif
                @endforeach
            </div>
        </div>

        <div class="grid gap-8 lg:grid-cols-3">
            {{-- Main Content --}}
            <div class="lg:col-span-2">
                <div class="card-dynamic rounded-2xl p-6">
                    {{-- Step 1: Account --}}
                    @if($step === 1)
                        <h2 class="mb-6 text-lg font-semibold" style="color: var(--text-primary);">@lang('Account Information')</h2>

                        {{-- Email Check --}}
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Email Address')</label>
                                <div class="flex gap-2">
                                    <input wire:model="email" wire:blur="checkEmail" type="email" class="input-dynamic flex-1 px-4 py-3 rounded-xl" style="border: 1px solid var(--border);" placeholder="you@example.com">
                                </div>
                                @error('email') <p class="mt-1 text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
                            </div>

                            @if($existingUser)
                                {{-- Login Form --}}
                                <div class="p-4 rounded-xl" style="background: var(--primary-light); border: 1px solid var(--primary);">
                                    <p class="text-sm mb-3" style="color: var(--text-primary);">
                                        <i class="ph ph-info mr-1"></i>
                                        @lang('An account with this email already exists. Please log in.')
                                    </p>
                                    <div class="space-y-3">
                                        <input wire:model="password" type="password" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);" placeholder="@lang('Password')">
                                        @error('password') <p class="text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
                                        <button wire:click="login" class="btn-primary w-full py-3 rounded-xl font-medium">
                                            <span wire:loading.remove wire:target="login">@lang('Log In & Continue')</span>
                                            <span wire:loading wire:target="login"><i class="ph ph-spinner animate-spin"></i></span>
                                        </button>
                                    </div>
                                </div>
                            @else
                                {{-- Name Fields --}}
                                <div class="grid gap-4 sm:grid-cols-2">
                                    <div>
                                        <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('First Name')</label>
                                        <input wire:model="firstname" type="text" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);">
                                        @error('firstname') <p class="mt-1 text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
                                    </div>
                                    <div>
                                        <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Last Name')</label>
                                        <input wire:model="lastname" type="text" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);">
                                        @error('lastname') <p class="mt-1 text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
                                    </div>
                                </div>

                                {{-- Create Account Toggle --}}
                                <div class="flex items-center gap-3 p-4 rounded-xl" style="background: var(--bg-color);">
                                    <input wire:model.live="createAccount" type="checkbox" id="createAccount" class="h-5 w-5 rounded" style="accent-color: var(--primary);">
                                    <label for="createAccount" class="text-sm" style="color: var(--text-primary);">
                                        @lang('Create an account for faster checkout next time')
                                    </label>
                                </div>

                                @if($createAccount)
                                    <div class="grid gap-4 sm:grid-cols-2">
                                        <div>
                                            <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Password')</label>
                                            <input wire:model="password" type="password" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);">
                                            @error('password') <p class="mt-1 text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
                                        </div>
                                        <div>
                                            <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Confirm Password')</label>
                                            <input wire:model="password_confirmation" type="password" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);">
                                        </div>
                                    </div>
                                @endif
                            @endif
                        </div>

                        @if(!$existingUser)
                            <div class="mt-6 flex justify-end">
                                <button wire:click="nextStep" class="btn-primary px-6 py-3 rounded-xl font-medium">
                                    @lang('Continue to Billing')
                                    <i class="ph ph-arrow-right ml-2"></i>
                                </button>
                            </div>
                        @endif
                    @endif

                    {{-- Step 2: Billing --}}
                    @if($step === 2)
                        <h2 class="mb-6 text-lg font-semibold" style="color: var(--text-primary);">@lang('Billing Information')</h2>
                        @include('livewire.client.cart.partials.billing-form')
                        <div class="mt-6 flex justify-between">
                            <button wire:click="previousStep" class="px-6 py-3 rounded-xl font-medium" style="background: var(--bg-color); color: var(--text-primary); border: 1px solid var(--border);">
                                <i class="ph ph-arrow-left mr-2"></i> @lang('Back')
                            </button>
                            <button wire:click="nextStep" class="btn-primary px-6 py-3 rounded-xl font-medium">
                                @lang('Continue to Payment') <i class="ph ph-arrow-right ml-2"></i>
                            </button>
                        </div>
                    @endif

                    {{-- Step 3: Payment --}}
                    @if($step === 3)
                        <h2 class="mb-6 text-lg font-semibold" style="color: var(--text-primary);">@lang('Payment Method')</h2>
                        @include('livewire.client.cart.partials.payment-methods')
                        <div class="mt-6 flex justify-between">
                            <button wire:click="previousStep" class="px-6 py-3 rounded-xl font-medium" style="background: var(--bg-color); color: var(--text-primary); border: 1px solid var(--border);">
                                <i class="ph ph-arrow-left mr-2"></i> @lang('Back')
                            </button>
                            <button wire:click="nextStep" class="btn-primary px-6 py-3 rounded-xl font-medium" @if(!$gateway_id) disabled @endif>
                                @lang('Review Order') <i class="ph ph-arrow-right ml-2"></i>
                            </button>
                        </div>
                    @endif

                    {{-- Step 4: Review --}}
                    @if($step === 4)
                        <h2 class="mb-6 text-lg font-semibold" style="color: var(--text-primary);">@lang('Review Your Order')</h2>
                        @include('livewire.client.cart.partials.order-review')
                        <div class="mt-6 flex justify-between">
                            <button wire:click="previousStep" class="px-6 py-3 rounded-xl font-medium" style="background: var(--bg-color); color: var(--text-primary); border: 1px solid var(--border);">
                                <i class="ph ph-arrow-left mr-2"></i> @lang('Back')
                            </button>
                            <button wire:click="placeOrder" class="btn-primary px-8 py-3 rounded-xl font-semibold">
                                <span wire:loading.remove wire:target="placeOrder" class="flex items-center gap-2">
                                    <i class="ph ph-check-circle"></i> @lang('Place Order')
                                </span>
                                <span wire:loading wire:target="placeOrder"><i class="ph ph-spinner animate-spin"></i> @lang('Processing...')</span>
                            </button>
                        </div>
                    @endif
                </div>
            </div>

            {{-- Order Summary Sidebar --}}
            @include('livewire.client.cart.partials.order-summary-sidebar', ['totals' => $totals, 'cartItems' => $cartItems, 'appliedCoupon' => $appliedCoupon])
        </div>
    </div>
</div>

