<div class="relative" x-data="{ open: @entangle('isOpen') }" @click.away="open = false">
    {{-- Cart Icon with Badge --}}
    <button
        @click="open = !open"
        class="relative p-2.5 rounded-xl transition-smooth"
        style="color: var(--text-muted);"
        @mouseenter="$el.style.backgroundColor='var(--primary-light)'; $el.style.color='var(--text-secondary)'"
        @mouseleave="$el.style.backgroundColor='transparent'; $el.style.color='var(--text-muted)'"
    >
        <i class="ph ph-shopping-cart text-xl"></i>
        @if($itemCount > 0)
            <span class="absolute -top-0.5 -right-0.5 flex h-5 w-5 items-center justify-center rounded-full text-xs font-bold text-white"
                  style="background: var(--primary); font-size: 10px;">
                {{ $itemCount > 9 ? '9+' : $itemCount }}
            </span>
        @endif
    </button>

    {{-- Dropdown Panel --}}
    <div
        x-show="open"
        x-transition:enter="transition ease-out duration-200"
        x-transition:enter-start="opacity-0 translate-y-2"
        x-transition:enter-end="opacity-100 translate-y-0"
        x-transition:leave="transition ease-in duration-150"
        x-transition:leave-start="opacity-100 translate-y-0"
        x-transition:leave-end="opacity-0 translate-y-2"
        class="absolute right-0 mt-2 w-80 rounded-2xl shadow-xl z-50"
        style="background: var(--card-bg); border: 1px solid var(--border);"
        x-cloak
    >
        {{-- Header --}}
        <div class="flex items-center justify-between px-4 py-3" style="border-bottom: 1px solid var(--border);">
            <h4 class="font-semibold" style="color: var(--text-primary);">@lang('Shopping Cart')</h4>
            <span class="text-xs px-2 py-0.5 rounded-full" style="background: var(--primary-light); color: var(--primary);">
                {{ $itemCount }} {{ $itemCount === 1 ? __('item') : __('items') }}
            </span>
        </div>

        @if($itemCount > 0)
            {{-- Items List --}}
            <div class="max-h-64 overflow-y-auto p-2 space-y-2">
                @foreach($items as $item)
                    <div class="flex items-start gap-3 p-2 rounded-xl transition-smooth hover:bg-opacity-50" style="background: var(--primary-light); background: color-mix(in srgb, var(--primary) 5%, transparent);">
                        {{-- Icon --}}
                        <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-lg" style="background: var(--primary-light);">
                            <i class="ph {{ $this->getItemIcon($item) }} text-lg" style="color: var(--primary);"></i>
                        </div>

                        {{-- Details --}}
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium truncate" style="color: var(--text-primary);">
                                {{ $this->getItemName($item) }}
                            </p>
                            @if($item->domain)
                                <p class="text-xs truncate" style="color: var(--text-muted);">{{ $item->domain }}</p>
                            @endif
                            <p class="text-sm font-semibold mt-0.5" style="color: var(--primary);">
                                {{ showAmount($item->after_discount ?? $item->total) }}
                            </p>
                        </div>

                        {{-- Remove Button --}}
                        <button
                            wire:click="removeItem({{ $item->id }})"
                            wire:loading.attr="disabled"
                            class="p-1.5 rounded-lg transition-smooth hover:bg-opacity-80"
                            style="color: var(--text-muted);"
                            @mouseenter="$el.style.color='var(--danger)'; $el.style.background='color-mix(in srgb, var(--danger) 10%, transparent)'"
                            @mouseleave="$el.style.color='var(--text-muted)'; $el.style.background='transparent'"
                        >
                            <i class="ph ph-x text-sm"></i>
                        </button>
                    </div>
                @endforeach

                @if($hasMore)
                    <p class="text-center text-xs py-2" style="color: var(--text-muted);">
                        @lang('+ :count more items', ['count' => $itemCount - 3])
                    </p>
                @endif
            </div>

            {{-- Totals --}}
            <div class="px-4 py-3" style="border-top: 1px solid var(--border);">
                @if($totals['discount'] > 0)
                    <div class="flex justify-between text-sm mb-1">
                        <span style="color: var(--text-muted);">@lang('Subtotal')</span>
                        <span style="color: var(--text-secondary);">{{ showAmount($totals['subtotal']) }}</span>
                    </div>
                    <div class="flex justify-between text-sm mb-2">
                        <span style="color: var(--success);">@lang('Discount')</span>
                        <span style="color: var(--success);">-{{ showAmount($totals['discount']) }}</span>
                    </div>
                @endif
                <div class="flex justify-between font-semibold">
                    <span style="color: var(--text-primary);">@lang('Total')</span>
                    <span style="color: var(--primary);">{{ showAmount($totals['total']) }}</span>
                </div>
            </div>

            {{-- Actions --}}
            <div class="p-3 grid grid-cols-2 gap-2" style="border-top: 1px solid var(--border);">
                <a href="{{ route('client.cart') }}" wire:navigate
                   class="flex items-center justify-center gap-2 px-4 py-2.5 text-sm font-medium rounded-xl transition-smooth"
                   style="background: var(--primary-light); color: var(--primary);"
                   @mouseenter="$el.style.background='color-mix(in srgb, var(--primary) 20%, transparent)'"
                   @mouseleave="$el.style.background='var(--primary-light)'">
                    <i class="ph ph-shopping-cart"></i>
                    @lang('View Cart')
                </a>
                <a href="{{ route('client.checkout') }}" wire:navigate
                   class="flex items-center justify-center gap-2 px-4 py-2.5 text-sm font-medium rounded-xl transition-smooth text-white"
                   style="background: var(--primary);"
                   @mouseenter="$el.style.opacity='0.9'"
                   @mouseleave="$el.style.opacity='1'">
                    <i class="ph ph-credit-card"></i>
                    @lang('Checkout')
                </a>
            </div>
        @else
            {{-- Empty State --}}
            <div class="p-6 text-center">
                <div class="mx-auto mb-3 flex h-14 w-14 items-center justify-center rounded-2xl" style="background: var(--primary-light);">
                    <i class="ph ph-shopping-cart text-2xl" style="color: var(--text-muted);"></i>
                </div>
                <p class="text-sm font-medium mb-1" style="color: var(--text-primary);">@lang('Your cart is empty')</p>
                <p class="text-xs mb-4" style="color: var(--text-muted);">@lang('Browse our products to get started')</p>
                <a href="/" wire:navigate
                   class="inline-flex items-center gap-2 px-4 py-2 text-sm font-medium rounded-xl transition-smooth text-white"
                   style="background: var(--primary);">
                    <i class="ph ph-storefront"></i>
                    @lang('Browse Products')
                </a>
            </div>
        @endif
    </div>
</div>

