<div class="space-y-4">
    {{-- Company (Optional) --}}
    <div>
        <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Company') <span class="text-xs" style="color: var(--text-muted);">(@lang('Optional'))</span></label>
        <input wire:model="company" type="text" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);">
    </div>

    {{-- Address --}}
    <div>
        <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Address') <span style="color: var(--danger);">*</span></label>
        <input wire:model="address" type="text" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);" placeholder="@lang('Street address')">
        @error('address') <p class="mt-1 text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
    </div>

    {{-- City & State --}}
    <div class="grid gap-4 sm:grid-cols-2">
        <div>
            <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('City') <span style="color: var(--danger);">*</span></label>
            <input wire:model="city" type="text" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);">
            @error('city') <p class="mt-1 text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
        </div>
        <div>
            <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('State / Province')</label>
            <input wire:model="state" type="text" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);">
            @error('state') <p class="mt-1 text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
        </div>
    </div>

    {{-- Zip & Country --}}
    <div class="grid gap-4 sm:grid-cols-2">
        <div>
            <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('ZIP / Postal Code') <span style="color: var(--danger);">*</span></label>
            <input wire:model="zip" type="text" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);">
            @error('zip') <p class="mt-1 text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
        </div>
        <div>
            <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Country') <span style="color: var(--danger);">*</span></label>
            <select wire:model="country" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);">
                <option value="">@lang('Select Country')</option>
                @foreach($countries as $code => $name)
                    <option value="{{ $code }}">{{ $name }}</option>
                @endforeach
            </select>
            @error('country') <p class="mt-1 text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
        </div>
    </div>

    {{-- Phone --}}
    <div>
        <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Phone Number')</label>
        <input wire:model="phone" type="tel" class="input-dynamic w-full px-4 py-3 rounded-xl" style="border: 1px solid var(--border);" placeholder="+1 (555) 000-0000">
        @error('phone') <p class="mt-1 text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
    </div>
</div>

