<div class="space-y-6">
    {{-- Account Summary --}}
    <div class="p-4 rounded-xl" style="background: var(--bg-color); border: 1px solid var(--border);">
        <div class="flex items-center justify-between mb-2">
            <h4 class="font-medium" style="color: var(--text-primary);">@lang('Account')</h4>
            <button wire:click="goToStep(1)" class="text-sm font-medium" style="color: var(--primary);">@lang('Edit')</button>
        </div>
        <p class="text-sm" style="color: var(--text-secondary);">{{ $firstname }} {{ $lastname }}</p>
        <p class="text-sm" style="color: var(--text-secondary);">{{ $email }}</p>
    </div>

    {{-- Billing Summary --}}
    <div class="p-4 rounded-xl" style="background: var(--bg-color); border: 1px solid var(--border);">
        <div class="flex items-center justify-between mb-2">
            <h4 class="font-medium" style="color: var(--text-primary);">@lang('Billing Address')</h4>
            <button wire:click="goToStep(2)" class="text-sm font-medium" style="color: var(--primary);">@lang('Edit')</button>
        </div>
        <p class="text-sm" style="color: var(--text-secondary);">{{ $address }}</p>
        <p class="text-sm" style="color: var(--text-secondary);">{{ $city }}, {{ $state }} {{ $zip }}</p>
        <p class="text-sm" style="color: var(--text-secondary);">{{ $countries[$country] ?? $country }}</p>
    </div>

    {{-- Payment Summary --}}
    <div class="p-4 rounded-xl" style="background: var(--bg-color); border: 1px solid var(--border);">
        <div class="flex items-center justify-between mb-2">
            <h4 class="font-medium" style="color: var(--text-primary);">@lang('Payment Method')</h4>
            <button wire:click="goToStep(3)" class="text-sm font-medium" style="color: var(--primary);">@lang('Edit')</button>
        </div>
        @php
            $selectedGateway = $gateways->firstWhere('id', $gateway_id);
        @endphp
        @if($selectedGateway)
            <div class="flex items-center gap-3">
                <div class="flex h-10 w-10 items-center justify-center rounded-lg" style="background: var(--primary-light);">
                    @if($selectedGateway->image)
                        <img src="{{ getImage(getFilePath('gateway') . '/' . $selectedGateway->image) }}" alt="{{ $selectedGateway->name }}" class="h-6 w-6 object-contain">
                    @else
                        <i class="ph ph-credit-card" style="color: var(--primary);"></i>
                    @endif
                </div>
                <span class="text-sm" style="color: var(--text-secondary);">{{ $selectedGateway->name }}</span>
            </div>
        @endif
    </div>

    {{-- Order Items --}}
    <div>
        <h4 class="font-medium mb-3" style="color: var(--text-primary);">@lang('Order Items')</h4>
        <div class="space-y-2">
            @foreach($cartItems as $item)
                <div class="flex items-center justify-between p-3 rounded-xl" style="background: var(--bg-color); border: 1px solid var(--border);">
                    <div class="flex items-center gap-3">
                        <div class="flex h-10 w-10 items-center justify-center rounded-lg" style="background: var(--primary-light);">
                            @if($item->isHosting())
                                <i class="ph ph-hard-drives" style="color: var(--primary);"></i>
                            @else
                                <i class="ph ph-globe" style="color: var(--success);"></i>
                            @endif
                        </div>
                        <div>
                            <p class="text-sm font-medium" style="color: var(--text-primary);">
                                {{ $item->product?->name ?? $item->domain ?? __('Product') }}
                            </p>
                            <p class="text-xs" style="color: var(--text-muted);">
                                {{ $item->getTypeLabel() }}
                                @if($item->billing_cycle !== null) • {{ billingCycleLabel($item->billing_cycle) }} @endif
                            </p>
                        </div>
                    </div>
                    <p class="font-semibold text-sm" style="color: var(--text-primary);">{{ showAmount($item->after_discount ?? $item->total) }}</p>
                </div>
            @endforeach
        </div>
    </div>

    {{-- Terms --}}
    <div class="p-4 rounded-xl" style="background: color-mix(in srgb, var(--primary) 8%, transparent); border: 1px solid color-mix(in srgb, var(--primary) 20%, transparent);">
        <p class="text-sm" style="color: var(--text-secondary);">
            <i class="ph ph-info mr-1" style="color: var(--primary);"></i>
            @lang('By placing this order, you agree to our')
            <a href="{{ route('page.terms') }}" target="_blank" class="font-medium underline" style="color: var(--primary);">@lang('Terms of Service')</a>
            @lang('and')
            <a href="{{ route('page.privacy') }}" target="_blank" class="font-medium underline" style="color: var(--primary);">@lang('Privacy Policy')</a>.
        </p>
    </div>
</div>

