<div class="lg:col-span-1">
    <div class="card-dynamic rounded-2xl p-6 sticky top-6">
        <h3 class="mb-4 font-semibold text-lg" style="color: var(--text-primary);">@lang('Order Summary')</h3>

        {{-- Items Preview --}}
        <div class="space-y-2 mb-4 pb-4" style="border-bottom: 1px solid var(--border);">
            @foreach($cartItems->take(3) as $item)
                <div class="flex items-center justify-between text-sm">
                    <span class="truncate max-w-[180px]" style="color: var(--text-secondary);">
                        {{ $item->product?->name ?? $item->domain ?? __('Item') }}
                    </span>
                    <span class="font-medium" style="color: var(--text-primary);">{{ showAmount($item->after_discount ?? $item->total) }}</span>
                </div>
            @endforeach
            @if($cartItems->count() > 3)
                <p class="text-xs text-center" style="color: var(--text-muted);">
                    @lang('+ :count more items', ['count' => $cartItems->count() - 3])
                </p>
            @endif
        </div>

        {{-- Promo Code --}}
        @if(!$appliedCoupon)
            <div class="mb-4 pb-4" style="border-bottom: 1px solid var(--border);">
                <div class="flex gap-2">
                    <input wire:model="promoCode" type="text" placeholder="@lang('Promo code')" class="input-dynamic flex-1 px-3 py-2 text-sm rounded-lg" style="border: 1px solid var(--border);">
                    <button wire:click="applyPromoCode" class="px-3 py-2 text-sm font-medium rounded-lg" style="background: var(--primary-light); color: var(--primary);">
                        <span wire:loading.remove wire:target="applyPromoCode">@lang('Apply')</span>
                        <span wire:loading wire:target="applyPromoCode"><i class="ph ph-spinner animate-spin"></i></span>
                    </button>
                </div>
                @error('promoCode') <p class="mt-1 text-xs" style="color: var(--danger);">{{ $message }}</p> @enderror
            </div>
        @else
            <div class="mb-4 pb-4" style="border-bottom: 1px solid var(--border);">
                <div class="flex items-center justify-between p-2 rounded-lg" style="background: color-mix(in srgb, var(--success) 12%, transparent);">
                    <div class="flex items-center gap-2">
                        <i class="ph ph-ticket" style="color: var(--success);"></i>
                        <span class="text-sm font-medium" style="color: var(--success);">{{ $appliedCoupon->coupon?->code ?? 'Coupon' }}</span>
                    </div>
                    <button wire:click="removePromoCode" class="text-xs" style="color: var(--danger);">
                        <i class="ph ph-x"></i>
                    </button>
                </div>
            </div>
        @endif

        {{-- Totals --}}
        <dl class="space-y-2">
            <div class="flex justify-between text-sm">
                <dt style="color: var(--text-secondary);">@lang('Subtotal')</dt>
                <dd class="font-medium" style="color: var(--text-primary);">{{ showAmount($totals['subtotal']) }}</dd>
            </div>
            @if($totals['discount'] > 0)
                <div class="flex justify-between text-sm">
                    <dt style="color: var(--success);">@lang('Discount')</dt>
                    <dd class="font-medium" style="color: var(--success);">-{{ showAmount($totals['discount']) }}</dd>
                </div>
            @endif
            @if(isset($taxSummary) && $taxSummary['enabled'] && $taxSummary['amount'] > 0)
                <div class="flex justify-between text-sm">
                    <dt style="color: var(--text-secondary);">{{ $taxSummary['label'] }}</dt>
                    <dd class="font-medium" style="color: var(--text-primary);">{{ showAmount($taxSummary['amount']) }}</dd>
                </div>
            @endif
            <div class="flex justify-between pt-3" style="border-top: 1px solid var(--border);">
                <dt class="text-lg font-semibold" style="color: var(--text-primary);">@lang('Total')</dt>
                <dd class="text-lg font-bold" style="color: var(--primary);">{{ showAmount($totals['total']) }}</dd>
            </div>
        </dl>

        {{-- Security Badge --}}
        <div class="mt-6 flex items-center justify-center gap-2 text-xs" style="color: var(--text-muted);">
            <i class="ph ph-lock-simple"></i>
            @lang('Secure checkout powered by SSL')
        </div>
    </div>
</div>

