<div class="space-y-3">
    @forelse($gateways as $gateway)
        <button wire:click="selectPaymentMethod('gateway', {{ $gateway->id }})"
                class="flex w-full items-center justify-between p-4 rounded-xl border-2 transition-smooth hover:shadow-md"
                style="border-color: {{ $gateway_id == $gateway->id ? 'var(--primary)' : 'var(--border)' }}; background: {{ $gateway_id == $gateway->id ? 'var(--primary-light)' : 'var(--card-bg)' }};">
            <div class="flex items-center gap-4">
                <div class="flex h-12 w-12 items-center justify-center rounded-xl overflow-hidden" style="background: var(--primary-light);">
                    @if($gateway->image)
                        <img src="{{ getImage(getFilePath('gateway') . '/' . $gateway->image) }}" alt="{{ $gateway->name }}" class="h-8 w-8 object-contain">
                    @else
                        <i class="ph ph-credit-card text-xl" style="color: var(--primary);"></i>
                    @endif
                </div>
                <div class="text-left">
                    <p class="font-medium" style="color: var(--text-primary);">{{ $gateway->name }}</p>
                    @if($gateway->percent_charge > 0 || $gateway->fixed_charge > 0)
                        <p class="text-sm" style="color: var(--text-secondary);">
                            @lang('Fee'): {{ $gateway->percent_charge }}% + {{ showAmount($gateway->fixed_charge) }}
                        </p>
                    @else
                        <p class="text-sm" style="color: var(--success);">@lang('No additional fees')</p>
                    @endif
                </div>
            </div>
            @if($gateway_id == $gateway->id)
                <i class="ph-fill ph-check-circle text-xl" style="color: var(--primary);"></i>
            @else
                <i class="ph ph-circle text-xl" style="color: var(--border);"></i>
            @endif
        </button>
    @empty
        <div class="text-center py-8">
            <i class="ph ph-credit-card text-4xl mb-3" style="color: var(--text-muted);"></i>
            <p style="color: var(--text-secondary);">@lang('No payment methods available.')</p>
        </div>
    @endforelse

    @error('gateway_id')
        <p class="text-sm" style="color: var(--danger);">{{ $message }}</p>
    @enderror
</div>

