<div class="space-y-6">
    {{-- Flash Messages --}}
    @if(session('error'))
        <div class="rounded-xl p-4" style="background: color-mix(in srgb, var(--danger) 12%, transparent); border: 1px solid color-mix(in srgb, var(--danger) 30%, transparent);">
            <div class="flex items-center gap-3">
                <i class="ph ph-warning-circle text-lg" style="color: var(--danger);"></i>
                <p class="text-sm font-medium" style="color: var(--danger);">{{ session('error') }}</p>
            </div>
        </div>
    @endif

    {{-- Page Header --}}
    <div class="flex flex-col gap-4 sm:flex-row sm:items-center sm:justify-between">
        <div class="flex items-center gap-4">
            <a href="{{ route('client.cart') }}" wire:navigate class="flex h-10 w-10 items-center justify-center rounded-xl transition-smooth hover:opacity-80" style="background: var(--primary-light);">
                <i class="ph ph-arrow-left text-lg" style="color: var(--primary);"></i>
            </a>
            <div>
                <h1 class="text-xl font-semibold" style="color: var(--text-primary);">@lang('Service Configuration')</h1>
                <p class="mt-0.5" style="color: var(--text-secondary);">{{ $product?->name }}</p>
            </div>
        </div>
    </div>

    <div class="grid gap-8 lg:grid-cols-3">
        {{-- Configuration Form --}}
        <div class="lg:col-span-2">
            <form wire:submit="updateConfig" class="card-dynamic rounded-2xl p-6 space-y-6">
                {{-- Billing Cycle --}}
                <div>
                    <label class="block text-sm font-medium mb-3" style="color: var(--text-primary);">@lang('Billing Cycle')</label>
                    <div class="grid grid-cols-2 sm:grid-cols-3 gap-3">
                        @foreach($this->availableCycles as $index => $cycle)
                            <label class="relative cursor-pointer">
                                <input type="radio" wire:model.live="billingCycle" value="{{ $index }}" class="peer sr-only">
                                <div class="rounded-xl border-2 p-3 text-center transition-smooth peer-checked:border-[var(--primary)] peer-checked:bg-[var(--primary-light)]" style="border-color: var(--border);">
                                    <p class="font-semibold" style="color: var(--text-primary);">{{ $cycle['name'] }}</p>
                                    <p class="text-sm mt-1" style="color: var(--text-secondary);">{{ showAmount($cycle['price']) }}</p>
                                </div>
                            </label>
                        @endforeach
                    </div>
                </div>

                {{-- Hostname --}}
                @if($product?->require_hostname)
                    <div>
                        <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Hostname')</label>
                        <input type="text" wire:model="hostname" placeholder="server.example.com" class="input-dynamic w-full rounded-xl px-4 py-2.5" style="border: 1px solid var(--border);">
                        <p class="mt-1.5 text-xs" style="color: var(--text-muted);">@lang('Enter a hostname for your server (e.g., server.yourdomain.com)')</p>
                    </div>
                @endif

                {{-- Password --}}
                @if($product?->require_password)
                    <div>
                        <label class="block text-sm font-medium mb-2" style="color: var(--text-primary);">@lang('Password')</label>
                        <div class="flex gap-2">
                            <input type="text" wire:model="password" placeholder="@lang('Enter a secure password')" class="input-dynamic flex-1 rounded-xl px-4 py-2.5" style="border: 1px solid var(--border);">
                            <button type="button" wire:click="generatePassword" class="btn-secondary rounded-xl px-4 py-2.5 text-sm font-medium">
                                <i class="ph ph-arrows-clockwise"></i>
                                @lang('Generate')
                            </button>
                        </div>
                        <p class="mt-1.5 text-xs" style="color: var(--text-muted);">@lang('Minimum 8 characters. This will be your service password.')</p>
                    </div>
                @endif

                {{-- Nameservers --}}
                @if($product?->require_nameservers)
                    <div>
                        <label class="block text-sm font-medium mb-3" style="color: var(--text-primary);">@lang('Nameservers')</label>
                        <div class="grid sm:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-xs font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Nameserver 1')</label>
                                <input type="text" wire:model="ns1" placeholder="ns1.example.com" class="input-dynamic w-full rounded-xl px-4 py-2.5" style="border: 1px solid var(--border);">
                            </div>
                            <div>
                                <label class="block text-xs font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Nameserver 2')</label>
                                <input type="text" wire:model="ns2" placeholder="ns2.example.com" class="input-dynamic w-full rounded-xl px-4 py-2.5" style="border: 1px solid var(--border);">
                            </div>
                            <div>
                                <label class="block text-xs font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Nameserver 3') <span class="opacity-50">(@lang('optional'))</span></label>
                                <input type="text" wire:model="ns3" placeholder="ns3.example.com" class="input-dynamic w-full rounded-xl px-4 py-2.5" style="border: 1px solid var(--border);">
                            </div>
                            <div>
                                <label class="block text-xs font-medium mb-1.5" style="color: var(--text-secondary);">@lang('Nameserver 4') <span class="opacity-50">(@lang('optional'))</span></label>
                                <input type="text" wire:model="ns4" placeholder="ns4.example.com" class="input-dynamic w-full rounded-xl px-4 py-2.5" style="border: 1px solid var(--border);">
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Domain (if hosting with domain) --}}
                @if($cart->domain)
                    <div class="rounded-xl p-4" style="background: color-mix(in srgb, var(--success) 8%, transparent); border: 1px solid color-mix(in srgb, var(--success) 20%, transparent);">
                        <div class="flex items-center gap-3">
                            <i class="ph ph-globe text-lg" style="color: var(--success);"></i>
                            <div>
                                <p class="font-medium" style="color: var(--text-primary);">@lang('Domain'): {{ $cart->domain }}</p>
                                <p class="text-sm" style="color: var(--text-secondary);">@lang('This service will be configured with this domain.')</p>
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Submit --}}
                <div class="pt-4" style="border-top: 1px solid var(--border);">
                    <button type="submit" class="btn-primary flex w-full items-center justify-center gap-2 rounded-xl py-3 font-semibold transition-smooth">
                        <i class="ph ph-check-circle"></i>
                        @lang('Update Configuration')
                    </button>
                </div>
            </form>
        </div>

        {{-- Price Summary --}}
        <div>
            <div class="card-dynamic rounded-2xl p-6 sticky top-6">
                <h3 class="font-semibold text-lg mb-4" style="color: var(--text-primary);">@lang('Price Summary')</h3>

                <div class="space-y-4">
                    {{-- Product Info --}}
                    <div class="flex items-center gap-3 pb-4" style="border-bottom: 1px solid var(--border);">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl" style="background: var(--primary-light);">
                            <i class="ph ph-hard-drives text-lg" style="color: var(--primary);"></i>
                        </div>
                        <div>
                            <p class="font-medium" style="color: var(--text-primary);">{{ $product?->name }}</p>
                            <p class="text-sm" style="color: var(--text-secondary);">{{ billingCycleLabel($billingCycle) }}</p>
                        </div>
                    </div>

                    {{-- Price Breakdown --}}
                    <dl class="space-y-3">
                        <div class="flex justify-between">
                            <dt style="color: var(--text-secondary);">@lang('Price')</dt>
                            <dd class="font-medium" style="color: var(--text-primary);">{{ showAmount($this->productPrice) }}</dd>
                        </div>
                        @if($this->setupFee > 0)
                            <div class="flex justify-between">
                                <dt style="color: var(--text-secondary);">@lang('Setup Fee')</dt>
                                <dd class="font-medium" style="color: var(--text-primary);">{{ showAmount($this->setupFee) }}</dd>
                            </div>
                        @endif
                        <div class="flex justify-between pt-3" style="border-top: 1px solid var(--border);">
                            <dt class="text-lg font-semibold" style="color: var(--text-primary);">@lang('Total')</dt>
                            <dd class="text-lg font-bold" style="color: var(--primary);">{{ showAmount($this->totalPrice) }}</dd>
                        </div>
                    </dl>
                </div>
            </div>
        </div>
    </div>
</div>

