@php
    $welcome = getWelcomeMessages($user);
    $layout = getLayoutConfig();
    $showQuickActions = $layout['show_quick_actions'];
    $depositEnabled = isFeatureEnabled('deposits');
    $supportEnabled = isFeatureEnabled('support') && isMenuVisible('support');
    $kycEnabled = isFeatureEnabled('kyc');
@endphp
<div class="space-y-5 md:space-y-6 lg:space-y-8">
    {{-- Welcome Section --}}
    <div class="flex flex-col gap-4 md:gap-6 lg:flex-row lg:items-center lg:justify-between animate-in">
        <div class="space-y-1">
            <div class="flex items-center gap-2">
                <span class="inline-flex items-center gap-1.5 px-2.5 py-1 rounded-full text-[10px] font-bold uppercase tracking-widest bg-primary-light text-primary-color border border-primary/10">
                    <i class="ph-duotone ph-calendar-blank text-[12px]"></i>
                    {{ $welcome['time'] }}
                </span>
            </div>
            <h1 class="text-xl md:text-2xl font-bold tracking-tight lg:text-3xl text-dynamic">{{ $welcome['title'] }}</h1>
            <p class="text-sm md:text-base text-dynamic-secondary">{{ $welcome['subtitle'] }}</p>
        </div>
    </div>

    {{-- KYC Alert - Clean Design (only show if KYC feature is enabled) --}}
    @if($kycEnabled)
        @if($user->kv == 0)
            <x-client.alert type="warning" title="{{ __('Complete Your Profile') }}" class="animate-slide-up stagger-1">
                @lang('Verify your identity to unlock all features and secure your account.')
                <x-slot name="actions">
                    <x-client.button href="{{ route('client.kyc') }}" variant="warning" size="sm" icon="ph-arrow-right" iconPosition="right">
                        @lang('Verify Now')
                    </x-client.button>
                </x-slot>
            </x-client.alert>
        @elseif($user->kv == 2)
            <x-client.alert type="info" title="{{ __('Verification In Progress') }}" icon="ph-hourglass-medium" class="animate-slide-up stagger-1">
                @lang("Your documents are being reviewed. We'll notify you once complete.")
            </x-client.alert>
        @endif
    @endif

    {{-- Stats Grid - Bento Grid Style --}}
    <div class="grid grid-cols-2 gap-3 md:gap-4 lg:grid-cols-4">
        {{-- Balance Card (Primary) --}}
        <a href="{{ route('client.transactions') }}" wire:navigate class="group col-span-2 lg:col-span-1 border border-subtle p-4 md:p-5 bg-primary relative overflow-hidden" style="color: var(--sidebar-active-text, white); border-radius: var(--radius-card);">
            <div class="relative">
                <div class="flex items-center gap-2 mb-2 md:mb-3">
                    <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-white/10 border border-white/20">
                        <i class="ph-duotone ph-wallet text-base"></i>
                    </div>
                    <span class="text-xs md:text-sm font-semibold uppercase tracking-widest">@lang('Available Balance')</span>
                </div>
                <p class="text-2xl md:text-3xl font-extrabold tracking-tight text-white">{{ showAmount($stats['balance']) }}</p>
                <div class="mt-4 flex items-center gap-1.5 text-xs font-semibold bg-white/10 w-fit px-3 py-1.5 rounded-xl transition-all group-hover:bg-white/20 border border-white/5">
                    <span>@lang('Billing History')</span>
                    <i class="ph-bold ph-arrow-right text-[10px] transition-transform group-hover:translate-x-1"></i>
                </div>
            </div>
        </a>

        {{-- Services Card --}}
        <a href="{{ route('client.services') }}" wire:navigate class="group card-dynamic card-hover p-4 md:p-5">
            <div class="flex items-center justify-between mb-2 md:mb-3">
                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-xl bg-primary-light transition-transform group-hover:scale-110">
                    <i class="ph-duotone ph-cube text-base md:text-lg text-primary-color"></i>
                </div>
                @if($stats['activeServices'] > 0)
                    <x-client.badge type="success" size="sm">{{ $stats['activeServices'] }} @lang('active')</x-client.badge>
                @endif
            </div>
            <p class="text-xs md:text-sm font-medium text-dynamic-muted">@lang('Services')</p>
            <p class="mt-0.5 text-xl md:text-2xl font-semibold tracking-tight text-dynamic">{{ $stats['services'] }}</p>
        </a>

        {{-- Domains Card --}}
        <a href="{{ route('client.domains') }}" wire:navigate class="group card-dynamic card-hover p-4 md:p-5">
            <div class="flex items-center justify-between mb-2 md:mb-3">
                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-xl bg-info-light transition-transform group-hover:scale-110">
                    <i class="ph-duotone ph-globe text-base md:text-lg text-info-color"></i>
                </div>
            </div>
            <p class="text-xs md:text-sm font-medium text-dynamic-muted">@lang('Domains')</p>
            <p class="mt-0.5 text-xl md:text-2xl font-semibold tracking-tight text-dynamic">{{ $stats['domains'] }}</p>
        </a>

        {{-- Tickets Card --}}
        <a href="{{ route('client.tickets') }}" wire:navigate class="group card-dynamic card-hover p-4 md:p-5">
            <div class="flex items-center justify-between mb-2 md:mb-3">
                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-xl bg-warning-light transition-transform group-hover:scale-110">
                    <i class="ph-duotone ph-chat-circle-dots text-base md:text-lg text-warning-color"></i>
                </div>
                @if($stats['openTickets'] > 0)
                    <x-client.badge type="warning" size="sm" dot pulse>{{ $stats['openTickets'] }} @lang('open')</x-client.badge>
                @endif
            </div>
            <p class="text-xs md:text-sm font-medium text-dynamic-muted">@lang('Support')</p>
            <p class="mt-0.5 text-xl md:text-2xl font-semibold tracking-tight text-dynamic">{{ $stats['tickets'] }}</p>
        </a>
    </div>

    {{-- Overdue Invoices Alert --}}
    @if($overdueCount > 0)
        <x-client.alert type="danger" title="{{ __('Payment Required') }}" class="animate-slide-up">
            @lang('You have :count overdue invoice(s) totaling :amount', ['count' => $overdueCount, 'amount' => showAmount($overdueTotal)])
            <x-slot name="actions">
                <x-client.button href="{{ route('client.invoices') }}" variant="danger" size="sm" icon="ph-credit-card">
                    @lang('Pay Now')
                </x-client.button>
            </x-slot>
        </x-client.alert>
    @endif

    {{-- Main Content - Services & Tickets --}}
    <div class="grid gap-4 md:gap-6 lg:grid-cols-2">
        {{-- Recent Services --}}
        <x-client.card class="animate-in">
            <x-slot name="header">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-primary-light">
                            <i class="ph-duotone ph-cube text-base text-primary-color"></i>
                        </div>
                        <h3 class="font-bold text-sm md:text-base text-dynamic">@lang('My Services')</h3>
                    </div>
                    <a href="{{ route('client.services') }}" wire:navigate class="flex items-center gap-1 text-xs md:text-sm font-bold text-primary-color transition-all hover:gap-1.5">
                        @lang('View all') <i class="ph ph-arrow-right text-[10px]"></i>
                    </a>
                </div>
            </x-slot>

            <div class="-mx-5 md:-mx-6 -my-5 md:-my-6">
                @forelse($recentServices as $service)
                    <a href="{{ route('client.services.show', $service->id) }}" wire:navigate class="group/item flex items-center gap-3 md:gap-4 px-4 md:px-5 py-3 md:py-4 transition-all hover:bg-subtle/50">
                        <div class="flex h-9 w-9 md:h-10 md:w-10 shrink-0 items-center justify-center rounded-xl bg-primary-light transition-transform group-hover/item:scale-110">
                            <i class="ph-duotone ph-cube text-base md:text-lg text-primary-color"></i>
                        </div>
                        <div class="min-w-0 flex-1">
                            <p class="truncate text-sm font-semibold text-dynamic">{{ $service->product->name ?? 'N/A' }}</p>
                            <p class="mt-0.5 truncate text-xs text-dynamic-muted">@lang('Due'): {{ $service->next_due_date ? $service->next_due_date->format('M d, Y') : __('N/A') }}</p>
                        </div>
                        @php
                            $statusConfig = [1 => ['Active', 'success'], 2 => ['Pending', 'warning'], 3 => ['Suspended', 'warning'], 4 => ['Terminated', 'danger'], 5 => ['Cancelled', 'secondary']];
                            $status = $statusConfig[$service->status] ?? ['Unknown', 'secondary'];
                        @endphp
                        <x-client.badge :type="$status[1]" size="sm" outline>{{ __($status[0]) }}</x-client.badge>
                    </a>
                @empty
                    <x-client.empty-state icon="ph-cube" title="No services yet" description="Your active services will appear here" size="sm" class="py-8 md:py-12" />
                @endforelse
            </div>
        </x-client.card>

        {{-- Recent Tickets --}}
        <x-client.card class="animate-in">
            <x-slot name="header">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-warning-light">
                            <i class="ph-duotone ph-chat-circle-dots text-base text-warning-color"></i>
                        </div>
                        <h3 class="font-bold text-sm md:text-base text-dynamic">@lang('Support Tickets')</h3>
                    </div>
                    <a href="{{ route('client.tickets.create') }}" wire:navigate class="flex items-center gap-1.5 text-xs md:text-sm font-bold text-primary-color transition-all hover:gap-2">
                        <i class="ph ph-plus text-[10px]"></i>
                        @lang('New Ticket')
                    </a>
                </div>
            </x-slot>

            <div class="-mx-5 md:-mx-6 -my-5 md:-my-6">
                @forelse($recentTickets as $ticket)
                    <a href="{{ route('client.tickets.show', $ticket->ticket) }}" wire:navigate class="group/item flex items-center gap-3 md:gap-4 px-4 md:px-5 py-3 md:py-4 transition-all hover:bg-subtle/50">
                        <div class="flex h-9 w-9 md:h-10 md:w-10 shrink-0 items-center justify-center rounded-xl bg-warning-light transition-transform group-hover/item:scale-110">
                            <i class="ph-duotone ph-chat-circle-dots text-base md:text-lg text-warning-color"></i>
                        </div>
                        <div class="min-w-0 flex-1">
                            <p class="truncate text-sm font-semibold text-dynamic">{{ $ticket->subject }}</p>
                            <p class="mt-0.5 text-xs text-dynamic-muted">
                                <span class="font-mono opacity-60">#{{ $ticket->ticket }}</span> · <span class="opacity-80">{{ $ticket->last_reply?->diffForHumans() ?? $ticket->created_at->diffForHumans() }}</span>
                            </p>
                        </div>
                        @php
                            $ticketStatus = [0 => ['Open', 'danger'], 1 => ['Answered', 'success'], 2 => ['Replied', 'warning'], 3 => ['Closed', 'secondary']];
                            $tStatus = $ticketStatus[$ticket->status] ?? ['Unknown', 'secondary'];
                        @endphp
                        <x-client.badge :type="$tStatus[1]" size="sm" outline>{{ __($tStatus[0]) }}</x-client.badge>
                    </a>
                @empty
                    <x-client.empty-state icon="ph-chat-circle-dots" title="No tickets yet" description="Need help? We're here for you!" actionText="Open Ticket" actionHref="{{ route('client.tickets.create') }}" size="sm" class="py-8 md:py-12" />
                @endforelse
            </div>
        </x-client.card>
    </div>

    {{-- Account Completion & Announcements Row --}}
    <div class="grid gap-4 md:gap-6 lg:grid-cols-2">
        {{-- Account Completion Widget --}}
        @if(!$accountCompletion['isComplete'])
            <x-client.card class="animate-in">
                <x-slot name="header">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-3">
                            <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-primary">
                                <i class="ph-duotone ph-user-circle-check text-base text-white"></i>
                            </div>
                            <h3 class="font-bold text-sm md:text-base text-dynamic">@lang('Complete Your Profile')</h3>
                        </div>
                        <span class="text-sm font-black text-primary-color">{{ $accountCompletion['percentage'] }}%</span>
                    </div>
                </x-slot>

                {{-- Progress Bar --}}
                <div class="mb-4 md:mb-5">
                    <div class="h-2 w-full overflow-hidden rounded-full" style="background: var(--border);">
                        <div class="h-full rounded-full bg-primary-500 transition-all duration-500" style="width: {{ $accountCompletion['percentage'] }}%;"></div>
                    </div>
                    <p class="mt-2 text-xs text-dynamic-muted">{{ $accountCompletion['completed'] }} @lang('of') {{ $accountCompletion['total'] }} @lang('steps completed')</p>
                </div>

                {{-- Pending Items --}}
                <div class="space-y-3">
                    @foreach($accountCompletion['pending'] as $item)
                        <a href="{{ route($item['route']) }}" wire:navigate class="group/item flex items-center gap-4 p-3.5 rounded-2xl bg-dynamic border border-subtle hover-lift transition-all hover:bg-primary-light">
                            <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-xl bg-primary-light transition-transform group-hover/item:scale-110">
                                <i class="ph-duotone {{ $item['icon'] }} text-lg text-primary-color"></i>
                            </div>
                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-semibold text-dynamic">{{ __($item['label']) }}</p>
                                <p class="text-[11px] text-dynamic-muted">@lang('Required to fully unlock your account')</p>
                            </div>
                            <i class="ph-bold ph-caret-right text-xs text-dynamic-muted transition-transform group-hover/item:translate-x-1"></i>
                        </a>
                    @endforeach
                </div>
            </x-client.card>
        @endif

        {{-- Announcements Widget --}}
        <x-client.card class="animate-in {{ $accountCompletion['isComplete'] ? 'lg:col-span-2' : '' }}">
            <x-slot name="header">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="flex h-8 w-8 items-center justify-center rounded-lg bg-info-light">
                            <i class="ph-duotone ph-megaphone-simple text-base text-info-color"></i>
                        </div>
                        <h3 class="font-bold text-sm md:text-base text-dynamic">@lang('Announcements')</h3>
                    </div>
                    <a href="{{ route('client.announcements') }}" wire:navigate class="flex items-center gap-1 text-xs md:text-sm font-bold text-primary-color transition-all hover:gap-2">
                        @lang('View all') <i class="ph-bold ph-arrow-right text-[10px]"></i>
                    </a>
                </div>
            </x-slot>

            <div class="-mx-5 md:-mx-6 -my-5 md:-my-6">
                @forelse($announcements as $announcement)
                    @php $data = $announcement->data_values; @endphp
                    <a href="{{ route('client.announcements.show', $announcement->id) }}" wire:navigate class="group/item flex items-start gap-3 md:gap-4 px-4 md:px-5 py-3 md:py-4 transition-all hover:bg-subtle/50">
                        <div class="flex h-9 w-9 md:h-10 md:w-10 shrink-0 items-center justify-center rounded-xl bg-info-light transition-transform group-hover/item:scale-110">
                            <i class="ph-duotone ph-megaphone-simple text-base md:text-lg text-info-color"></i>
                        </div>
                        <div class="min-w-0 flex-1">
                            <div class="mb-1 flex items-center gap-2">
                                <p class="truncate text-sm font-semibold text-dynamic">{{ $data->title ?? 'Untitled' }}</p>
                                @if($announcement->created_at->isToday())
                                    <x-client.badge type="primary" size="xs">@lang('New')</x-client.badge>
                                @endif
                            </div>
                            <p class="line-clamp-1 text-xs text-dynamic-muted opacity-80">{{ Str::limit(strip_tags($data->description ?? ''), 80) }}</p>
                            <p class="mt-1.5 text-[11px] font-medium text-dynamic-muted opacity-60 uppercase">{{ $announcement->created_at->diffForHumans() }}</p>
                        </div>
                    </a>
                @empty
                    <x-client.empty-state icon="ph-duotone ph-megaphone-simple" title="No announcements" description="Check back later for updates" size="sm" class="py-8 md:py-10" />
                @endforelse
            </div>
        </x-client.card>
    </div>

    {{-- Quick Actions Grid --}}
    <div class="hidden md:block animate-in">
        <h3 class="mb-5 text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Quick Actions')</h3>
        <div class="grid grid-cols-2 gap-3 lg:grid-cols-4">
            @php
                $actions = [
                    ['route' => 'client.tickets.create', 'icon' => 'ph-chat-circle-dots', 'title' => 'Get Support', 'color' => 'warning'],
                    ['route' => 'client.deposits.add', 'icon' => 'ph-plus-circle', 'title' => 'Add Funds', 'color' => 'success'],
                    ['route' => 'client.invoices', 'icon' => 'ph-receipt', 'title' => 'Invoices', 'color' => 'primary'],
                    ['route' => 'client.profile', 'icon' => 'ph-user-circle', 'title' => 'My Profile', 'color' => 'info'],
                ];
            @endphp

            @foreach($actions as $action)
                <a href="{{ route($action['route']) }}" wire:navigate class="group card-dynamic card-hover flex flex-col items-center p-4 md:p-5 text-center">
                    <div class="mb-3 flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl bg-{{ $action['color'] }}-light transition-all group-hover:scale-110 shadow-sm border border-{{ $action['color'] }}-color/10">
                        <i class="ph-duotone {{ $action['icon'] }} text-lg md:text-xl text-{{ $action['color'] }}-color"></i>
                    </div>
                    <p class="text-xs md:text-sm font-bold text-dynamic">@lang($action['title'])</p>
                </a>
            @endforeach
        </div>
    </div>
</div>
