<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex items-center gap-3 md:gap-4 animate-fade-in">
        <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl bg-primary-light">
            <i class="ph-duotone ph-wallet text-lg md:text-xl text-primary-color"></i>
        </div>
        <div>
            <h1 class="text-lg md:text-xl font-bold tracking-tight text-dynamic">@lang('Add Funds')</h1>
            <p class="mt-0.5 text-sm text-dynamic-secondary">@lang('Deposit money to your wallet')</p>
        </div>
    </div>

    {{-- Current Balance --}}
    <div class="card-dynamic bg-gradient-primary rounded-xl md:rounded-2xl p-5 md:p-8 text-white relative overflow-hidden animate-slide-up border-none shadow-premium">
        <div class="absolute -right-10 -top-10 h-32 w-32 rounded-full bg-white/10 blur-3xl opacity-50"></div>
        <div class="relative flex items-center justify-between">
            <div>
                <p class="text-xs md:text-sm font-bold uppercase tracking-widest opacity-80">@lang('Current Balance')</p>
                <p class="mt-1 md:mt-2 text-3xl md:text-4xl font-black tracking-tight drop-shadow-sm">{{ showAmount($balance) }}</p>
            </div>
            <div class="flex h-12 w-12 md:h-14 md:w-14 items-center justify-center rounded-xl bg-white/20 backdrop-blur-md border border-white/20 shrink-0">
                <i class="ph-duotone ph-wallet text-2xl md:text-3xl font-bold"></i>
            </div>
        </div>
    </div>

    <div class="grid gap-4 md:gap-6 lg:grid-cols-2">
        {{-- Amount Input --}}
        <x-client.card class="animate-slide-up stagger-1">
            <h3 class="mb-5 md:mb-6 text-sm font-bold uppercase tracking-widest text-dynamic-muted">@lang('Enter Amount')</h3>
            <div class="space-y-3 md:space-y-4">
                <div class="space-y-1.5 md:space-y-2">
                    <label for="amount" class="block text-xs md:text-sm font-bold text-dynamic">@lang('Amount') <span class="text-danger-color">*</span></label>
                    <div class="relative">
                        <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-4 text-dynamic-muted">
                            <span class="text-base md:text-lg font-bold">{{ gs('cur_sym') ?? '$' }}</span>
                        </div>
                        <x-client.input wire:model.live="amount" type="number" id="amount" step="0.01" min="1" placeholder="0.00" class="pl-10 text-lg md:text-xl font-bold text-dynamic" />
                    </div>
                    @error('amount') <p class="text-xs md:text-sm text-danger-color font-medium">{{ $message }}</p> @enderror
                </div>

                {{-- Quick Amount Buttons --}}
                <div class="flex flex-wrap gap-1.5 md:gap-2">
                    @foreach([10, 25, 50, 100, 250, 500] as $quickAmount)
                        <button type="button" wire:click="$set('amount', {{ $quickAmount }})" class="filter-pill {{ $amount == $quickAmount ? 'filter-pill-active' : '' }}">
                            {{ gs('cur_sym') ?? '$' }}{{ $quickAmount }}
                        </button>
                    @endforeach
                </div>
            </div>
        </x-client.card>

        {{-- Payment Methods --}}
        <x-client.card class="animate-slide-up stagger-2">
            <h3 class="mb-5 md:mb-6 text-sm font-bold uppercase tracking-widest text-dynamic-muted">@lang('Select Payment Method')</h3>
            <div class="space-y-2 md:space-y-3">
                @forelse($gatewayCurrencies as $gc)
                    <button type="button" wire:click="selectGateway({{ $gc->id }})" class="flex w-full items-center justify-between p-3 md:p-4 rounded-xl border-2 transition-all hover-lift {{ $gateway_currency_id == $gc->id ? 'border-primary-color bg-primary-light/40' : 'border-subtle bg-dynamic/50' }}">
                        <div class="flex items-center gap-3 md:gap-4">
                            <div class="flex h-11 w-11 md:h-12 md:w-12 items-center justify-center rounded-xl shrink-0 bg-white dark:bg-white/10 p-1.5 overflow-hidden shadow-sm">
                                @if($gc->gateway?->imageUrl())
                                    <img src="{{ $gc->gateway->imageUrl() }}" alt="{{ $gc->gateway->name }}" class="h-full w-full object-contain" />
                                @else
                                    <i class="ph-duotone ph-credit-card text-xl text-primary-color"></i>
                                @endif
                            </div>
                            <div class="text-left">
                                <p class="text-sm md:text-base font-bold text-dynamic">{{ $gc->gateway?->name ?? $gc->name }}</p>
                                <div class="flex flex-wrap items-center gap-1.5 md:gap-2 text-[11px] text-dynamic-secondary mt-0.5">
                                    @if($gc->percent_charge > 0 || $gc->fixed_charge > 0)
                                        <span class="px-1.5 py-0.5 rounded-md bg-warning-light text-warning-color font-bold">@lang('Fee'): {{ $gc->percent_charge }}% + {{ $gc->symbol }}{{ showAmount($gc->fixed_charge, false) }}</span>
                                    @endif
                                    <span class="hidden sm:inline opacity-70">@lang('Limit'): {{ $gc->symbol }}{{ showAmount($gc->min_amount, false) }} - {{ $gc->symbol }}{{ showAmount($gc->max_amount, false) }}</span>
                                </div>
                            </div>
                        </div>
                        @if($gateway_currency_id == $gc->id)
                            <i class="ph-duotone ph-check-circle text-xl shrink-0 text-primary-color"></i>
                        @endif
                    </button>
                @empty
                    <x-client.empty-state icon="ph-credit-card" title="{{ __('No payment methods') }}" description="{{ __('No payment methods available') }}" />
                @endforelse
            </div>
            @error('gateway_currency_id') <p class="mt-2 text-xs md:text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
        </x-client.card>
    </div>

    {{-- Summary & Submit --}}
    @if($amount > 0 && $gateway_currency_id)
        @php
            $gc = $gatewayCurrencies->find($gateway_currency_id);
            $totalCharge = $gc ? $gc->calculateCharge($amount) : 0;
            $payable = $amount + $totalCharge;
            $finalAmount = $gc ? $payable * $gc->rate : $payable;
        @endphp
        <x-client.card class="animate-slide-up stagger-3">
            <div class="flex flex-col gap-4 md:gap-6 sm:flex-row sm:items-center sm:justify-between">
                <div class="min-w-[180px] md:min-w-[200px] space-y-2 md:space-y-3">
                    <div class="flex items-center justify-between gap-4 md:gap-8 text-xs md:text-sm">
                        <span class="text-dynamic-secondary">@lang('Amount')</span>
                        <span class="font-bold text-dynamic">{{ showAmount($amount) }}</span>
                    </div>
                    <div class="flex items-center justify-between gap-4 md:gap-8 text-xs md:text-sm">
                        <span class="text-dynamic-secondary">@lang('Processing Fee')</span>
                        <span class="font-bold text-dynamic">{{ showAmount($totalCharge) }}</span>
                    </div>
                    <div class="flex items-center justify-between gap-4 md:gap-8 pt-3 text-base md:text-lg border-t border-subtle">
                        <span class="font-bold text-dynamic">@lang('Total')</span>
                        <span class="font-black text-primary-color">{{ showAmount($payable) }}</span>
                    </div>
                    @if($gc && $gc->rate != 1)
                        <div class="flex items-center justify-between gap-4 md:gap-8 text-[11px] text-dynamic-muted">
                            <span>@lang('In :currency', ['currency' => $gc->currency])</span>
                            <span class="font-bold">{{ $gc->symbol }}{{ showAmount($finalAmount, false) }}</span>
                        </div>
                    @endif
                </div>
                <x-client.button wire:click="submit" icon="ph-arrow-right" wireLoading="submit">@lang('Continue to Payment')</x-client.button>
            </div>
        </x-client.card>
    @endif
</div>
