<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex flex-col gap-3 md:gap-4 lg:flex-row lg:items-center lg:justify-between animate-fade-in">
        <div class="flex items-center gap-3 md:gap-4">
            <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl bg-primary-light">
                <i class="ph-duotone ph-money text-lg md:text-xl text-primary-color"></i>
            </div>
            <div>
                <h1 class="text-lg md:text-xl font-bold tracking-tight text-dynamic">@lang('Deposits')</h1>
                <p class="mt-0.5 text-sm text-dynamic-secondary">@lang('View your deposit history')</p>
            </div>
        </div>
        <x-client.button href="{{ route('client.deposits.add') }}" icon="ph-plus" class="hover-lift">@lang('Add Funds')</x-client.button>
    </div>

    {{-- Stats --}}
    <div class="grid gap-3 md:gap-4 sm:grid-cols-2 animate-slide-up">
        <div class="card-dynamic bg-gradient-primary rounded-xl md:rounded-2xl p-5 md:p-8 text-white relative overflow-hidden border-none shadow-premium">
            <div class="absolute -right-10 -top-10 h-32 w-32 rounded-full bg-white/10 blur-3xl opacity-50"></div>
            <p class="text-xs md:text-sm font-bold uppercase tracking-widest opacity-80">@lang('Total Deposited')</p>
            <p class="mt-1 md:mt-2 text-2xl md:text-3xl font-black drop-shadow-sm">{{ showAmount($totals['total']) }}</p>
        </div>
        <x-client.card class="bg-primary-light border-subtle">
            <p class="text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Pending Deposits')</p>
            <p class="mt-1 md:mt-2 text-2xl md:text-3xl font-black text-primary-color">{{ showAmount($totals['pending']) }}</p>
        </x-client.card>
    </div>

    {{-- Filters --}}
    <div class="flex flex-col gap-3 md:gap-4 sm:flex-row sm:items-center sm:justify-between animate-slide-up stagger-1">
        {{-- Search --}}
        <div class="relative w-full sm:max-w-xs">
            <x-client.input wire:model.live.debounce.300ms="search" type="text" placeholder="{{ __('Search by transaction ID...') }}" prefixIcon="ph-magnifying-glass" />
        </div>

        {{-- Status Filter --}}
        <div class="flex flex-wrap gap-2 md:gap-3">
            @foreach($filters as $value => $filter)
                <button wire:click="$set('status', '{{ $value }}')" class="filter-pill {{ $status === $value ? 'filter-pill-active' : '' }}">
                    @lang($filter['label'])
                    <span class="text-2xs px-1.5 py-0.5 rounded-full {{ $status === $value ? 'bg-primary-light/30' : 'bg-primary-light/20' }}">{{ $filter['count'] }}</span>
                </button>
            @endforeach
        </div>
    </div>

    {{-- Mobile: Card View --}}
    <div class="md:hidden space-y-2 animate-slide-up stagger-2">
        @forelse($deposits as $deposit)
            @php
                $statusConfig = [
                    0 => ['label' => 'Pending', 'type' => 'warning', 'icon' => 'ph-clock'],
                    1 => ['label' => 'Completed', 'type' => 'success', 'icon' => 'ph-check-circle'],
                    2 => ['label' => 'Rejected', 'type' => 'danger', 'icon' => 'ph-x-circle'],
                ];
                $config = $statusConfig[$deposit->status] ?? $statusConfig[0];
            @endphp
            <x-client.card padding="sm">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-3">
                        <div class="flex h-10 w-10 items-center justify-center rounded-xl shrink-0 bg-{{ $config['type'] }}-light">
                            <i class="ph-duotone {{ $config['icon'] }} text-base text-{{ $config['type'] }}-color"></i>
                        </div>
                        <div>
                            <p class="text-sm font-bold text-dynamic">{{ $deposit->gateway->name ?? 'N/A' }}</p>
                            <p class="text-[11px] text-dynamic-muted mt-0.5">{{ $deposit->created_at->format('M d, Y') }}</p>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-sm font-medium" style="color: var(--text-primary);">{{ showAmount($deposit->amount) }}</p>
                        <x-client.badge type="{{ $config['type'] }}" size="xs">{{ __($config['label']) }}</x-client.badge>
                    </div>
                </div>
            </x-client.card>
        @empty
            <x-client.empty-state icon="ph-money" title="{{ __('No deposits found') }}" description="{{ __('Your deposit history will appear here.') }}" actionUrl="{{ route('client.deposits.add') }}" actionLabel="{{ __('Add Funds') }}" />
        @endforelse
    </div>

    {{-- Desktop: List View --}}
    <div class="hidden md:block animate-slide-up stagger-2">
        <x-client.card padding="none">
            <div class="divide-y divide-subtle">
                @forelse($deposits as $deposit)
                    @php
                        $statusConfig = [
                            0 => ['label' => 'Pending', 'type' => 'warning', 'icon' => 'ph-clock'],
                            1 => ['label' => 'Completed', 'type' => 'success', 'icon' => 'ph-check-circle'],
                            2 => ['label' => 'Rejected', 'type' => 'danger', 'icon' => 'ph-x-circle'],
                        ];
                        $config = $statusConfig[$deposit->status] ?? $statusConfig[0];
                    @endphp
                    <div class="flex items-center justify-between px-5 md:px-8 py-4 md:py-5 transition-all hover:bg-primary-light group">
                        <div class="flex items-center gap-3 md:gap-4">
                            <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl shrink-0 bg-{{ $config['type'] }}-light transition-transform group-hover:scale-110">
                                <i class="ph-duotone {{ $config['icon'] }} text-lg md:text-xl text-{{ $config['type'] }}-color"></i>
                            </div>
                            <div>
                                <p class="text-sm md:text-base font-bold text-dynamic group-hover:text-primary-color transition-colors">{{ $deposit->gateway->name ?? 'N/A' }}</p>
                                <p class="text-xs md:text-sm text-dynamic-muted mt-0.5">
                                    <span class="font-mono text-[10px] uppercase opacity-70 tracking-widest">{{ $deposit->trx }}</span> 
                                    <span class="mx-1.5 opacity-30">|</span> 
                                    {{ $deposit->created_at->format('M d, Y H:i') }}
                                </p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="text-sm md:text-base font-black text-dynamic">{{ showAmount($deposit->amount) }}</p>
                            <x-client.badge type="{{ $config['type'] }}" size="sm">{{ __($config['label']) }}</x-client.badge>
                        </div>
                    </div>
                @empty
                    <div class="p-8 md:p-12">
                        <x-client.empty-state icon="ph-money" title="{{ __('No deposits found') }}" description="{{ __('Your deposit history will appear here.') }}" actionUrl="{{ route('client.deposits.add') }}" actionLabel="{{ __('Add Funds') }}" />
                    </div>
                @endforelse
            </div>
        </x-client.card>
    </div>

    {{-- Pagination --}}
    @if($deposits->hasPages())
        <div class="mt-4 md:mt-6">
            {{ $deposits->links('vendor.livewire.novahost') }}
        </div>
    @endif
</div>
