@extends('layouts.client')

@section('title', $pageTitle)

@section('content')
<div class="max-w-2xl mx-auto space-y-4 md:space-y-6">
    <!-- Header -->
    <div class="animate-fade-in">
        <h1 class="text-lg md:text-xl font-semibold" style="color: var(--text-primary);">{{ __('Confirm Payment') }}</h1>
        <p class="mt-0.5 text-xs md:text-sm" style="color: var(--text-secondary);">{{ __('Complete your payment via') }} {{ $deposit->gateway->name ?? 'Gateway' }}</p>
    </div>

    <!-- Payment Card -->
    <x-client.card padding="none" class="overflow-hidden animate-slide-up">
        <!-- Amount Summary -->
        <div class="p-4 md:p-6" style="background: var(--primary); color: white;">
            <div class="text-center">
                <p class="text-xs md:text-sm mb-0.5 md:mb-1" style="opacity: 0.7;">{{ __('Amount to Pay') }}</p>
                <p class="text-2xl md:text-3xl font-semibold">{{ showAmount($deposit->final_amount, currencyFormat: false) }} {{ $deposit->method_currency }}</p>
                <p class="text-xs md:text-sm mt-1.5 md:mt-2" style="opacity: 0.7;">
                    {{ __('Deposit Amount') }}: {{ showAmount($deposit->amount) }}
                </p>
            </div>
        </div>

        <!-- Gateway Content -->
        <div class="p-4 md:p-6">
            @php
                $gatewayView = isset($data->view) ? str_replace('user.payment.', '', $data->view) : null;
            @endphp

            @if($gatewayView && view()->exists('partials.client.gateways.' . $gatewayView))
                {{-- Gateway-specific view --}}
                @include('partials.client.gateways.' . $gatewayView, ['data' => $data, 'deposit' => $deposit])
            @elseif(isset($data->view) && $data->view === 'user.payment.redirect')
                <!-- Auto-redirect Form -->
                <div class="text-center py-6 md:py-8">
                    <div class="animate-spin w-10 h-10 md:w-12 md:h-12 border-4 rounded-full mx-auto mb-3 md:mb-4" style="border-color: var(--primary); border-top-color: transparent;"></div>
                    <p class="text-xs md:text-sm" style="color: var(--text-secondary);">{{ __('Redirecting to payment gateway...') }}</p>
                </div>
                <form action="{{ $data->url }}" method="{{ $data->method }}" id="auto_submit" class="hidden">
                    @foreach($data->val as $k => $v)
                        <input type="hidden" name="{{ $k }}" value="{{ $v }}">
                    @endforeach
                </form>
                <script>
                    document.getElementById("auto_submit").submit();
                </script>
            @elseif(isset($data->view) && $data->view === 'user.payment.crypto')
                <!-- Crypto Payment -->
                <div class="text-center">
                    <div class="mb-3 md:mb-4">
                        <img src="{{ $data->img }}" alt="QR Code" class="mx-auto w-40 h-40 md:w-48 md:h-48 rounded-lg md:rounded-xl" style="border: 1px solid var(--card-border);">
                    </div>
                    <div class="rounded-lg md:rounded-xl p-3 md:p-4 mb-3 md:mb-4" style="background: var(--primary-light);">
                        <p class="text-xs md:text-sm mb-0.5 md:mb-1" style="color: var(--text-secondary);">{{ __('Send exactly') }}</p>
                        <p class="text-lg md:text-xl font-semibold" style="color: var(--text-primary);">{{ $data->amount }} {{ $data->currency }}</p>
                    </div>
                    <div class="rounded-lg md:rounded-xl p-3 md:p-4" style="background: var(--primary-light);">
                        <p class="text-xs md:text-sm mb-0.5 md:mb-1" style="color: var(--text-secondary);">{{ __('To this address') }}</p>
                        <div class="flex items-center gap-2 justify-center">
                            <code class="text-xs md:text-sm break-all" style="color: var(--text-primary);">{{ $data->address }}</code>
                            <button type="button" onclick="navigator.clipboard.writeText('{{ $data->address }}')" class="transition-colors touch-target shrink-0" style="color: var(--text-secondary);">
                                <i class="ph ph-copy"></i>
                            </button>
                        </div>
                    </div>
                </div>
            @else
                <!-- Generic Gateway Form -->
                @if(isset($data->form_action))
                    <form action="{{ $data->form_action }}" method="{{ $data->form_method ?? 'POST' }}" class="space-y-3 md:space-y-4">
                        @csrf
                        @if(isset($data->fields))
                            @foreach($data->fields as $field)
                                <div class="space-y-1 md:space-y-1.5">
                                    <label class="block text-xs md:text-sm font-medium" style="color: var(--text-primary);">{{ $field->label }}</label>
                                    <x-client.input type="{{ $field->type ?? 'text' }}" name="{{ $field->name }}" :required="$field->required ?? false" />
                                </div>
                            @endforeach
                        @endif
                        <x-client.button type="submit" fullWidth class="justify-center">{{ __('Pay Now') }}</x-client.button>
                    </form>
                @else
                    <div class="text-center py-6 md:py-8">
                        <i class="ph ph-check-circle text-4xl md:text-5xl mb-3 md:mb-4" style="color: var(--success);"></i>
                        <p class="text-xs md:text-sm" style="color: var(--text-secondary);">{{ __('Payment is being processed...') }}</p>
                    </div>
                @endif
            @endif
        </div>
    </x-client.card>

    <!-- Back Link -->
    <div class="text-center animate-slide-up stagger-1">
        <a href="{{ route('client.deposits') }}" wire:navigate class="text-xs md:text-sm font-medium inline-flex items-center gap-1 transition-colors touch-target" style="color: var(--primary);">
            <i class="ph ph-arrow-left"></i>
            {{ __('Back to Deposits') }}
        </a>
    </div>
</div>
@endsection

