@extends('layouts.client')

@section('title', $pageTitle)

@section('content')
<div class="max-w-2xl mx-auto space-y-4 md:space-y-6">
    <!-- Header -->
    <div class="animate-fade-in">
        <h1 class="text-lg md:text-xl font-semibold" style="color: var(--text-primary);">{{ __('Confirm Payment') }}</h1>
        <p class="mt-0.5 text-xs md:text-sm" style="color: var(--text-secondary);">{{ __('Complete your manual payment') }}</p>
    </div>

    <!-- Payment Card -->
    <x-client.card padding="none" class="overflow-hidden animate-slide-up">
        <!-- Amount Summary -->
        <div class="p-4 md:p-6" style="background: var(--primary); color: white;">
            <div class="text-center">
                <p class="text-xs md:text-sm mb-0.5 md:mb-1" style="opacity: 0.7;">{{ __('Amount to Pay') }}</p>
                <p class="text-2xl md:text-3xl font-semibold">{{ showAmount($data['final_amount'], currencyFormat: false) }} {{ $data['method_currency'] }}</p>
                <p class="text-xs md:text-sm mt-1.5 md:mt-2" style="opacity: 0.7;">
                    {{ __('Deposit Amount') }}: {{ showAmount($data['amount']) }}
                </p>
            </div>
        </div>

        <!-- Instructions -->
        <div class="p-4 md:p-6" style="border-bottom: 1px solid var(--card-border);">
            <h3 class="text-sm md:text-base font-medium mb-2 md:mb-3 flex items-center gap-2" style="color: var(--text-primary);">
                <i class="ph ph-info" style="color: var(--text-muted);"></i>
                {{ __('Payment Instructions') }}
            </h3>
            <div class="prose prose-sm max-w-none text-xs md:text-sm" style="color: var(--text-secondary);">
                {!! $gateway->description !!}
            </div>
        </div>

        <!-- Form -->
        <form action="{{ route('client.deposit.manual.update') }}" method="POST" enctype="multipart/form-data" class="p-4 md:p-6">
            @csrf

            @if($gateway->form && $gateway->form->form_data)
                @php
                    $formData = is_string($gateway->form->form_data)
                        ? json_decode($gateway->form->form_data, true)
                        : (array) $gateway->form->form_data;
                @endphp

                <div class="space-y-3 md:space-y-4">
                    @foreach($formData as $key => $field)
                        @php
                            $fieldName = is_object($field) ? $field->label : ($field['label'] ?? $key);
                            $fieldType = is_object($field) ? $field->type : ($field['type'] ?? 'text');
                            $isRequired = is_object($field) ? ($field->is_required ?? 'optional') : ($field['is_required'] ?? 'optional');
                            $options = is_object($field) ? ($field->options ?? []) : ($field['options'] ?? []);
                            $instruction = is_object($field) ? ($field->instruction ?? '') : ($field['instruction'] ?? '');
                        @endphp

                        <div class="space-y-1 md:space-y-1.5">
                            <label class="block text-xs md:text-sm font-medium" style="color: var(--text-primary);">
                                {{ __(ucfirst(str_replace('_', ' ', is_object($field) ? $field->name : ($field['name'] ?? $key)))) }}
                                @if($isRequired === 'required')
                                    <span style="color: var(--danger);">*</span>
                                @endif
                            </label>

                            @if($instruction)
                                <p class="text-xs" style="color: var(--text-secondary);">{{ $instruction }}</p>
                            @endif

                            @if($fieldType === 'textarea')
                                <x-client.input type="textarea" name="{{ $fieldName }}" rows="3" :required="$isRequired === 'required'" />
                            @elseif($fieldType === 'select')
                                <x-client.input type="select" name="{{ $fieldName }}" :required="$isRequired === 'required'">
                                    <option value="">{{ __('Select One') }}</option>
                                    @foreach($options as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </x-client.input>
                            @elseif($fieldType === 'file')
                                <x-client.input type="file" name="{{ $fieldName }}" :required="$isRequired === 'required'" />
                            @else
                                <x-client.input type="{{ $fieldType }}" name="{{ $fieldName }}" :required="$isRequired === 'required'" />
                            @endif

                            @error($fieldName)
                                <p class="text-xs" style="color: var(--danger);">{{ $message }}</p>
                            @enderror
                        </div>
                    @endforeach
                </div>
            @endif

            <!-- Submit Button -->
            <div class="mt-4 md:mt-6">
                <x-client.button type="submit" icon="ph-paper-plane-tilt" fullWidth class="justify-center">{{ __('Submit Payment') }}</x-client.button>
            </div>
        </form>
    </x-client.card>

    <!-- Back Link -->
    <div class="text-center animate-slide-up stagger-1">
        <a href="{{ route('client.deposits') }}" wire:navigate class="text-xs md:text-sm font-medium inline-flex items-center gap-1 transition-colors touch-target" style="color: var(--primary);">
            <i class="ph ph-arrow-left"></i>
            {{ __('Back to Deposits') }}
        </a>
    </div>
</div>
@endsection

