<div>
    @if(!$eppRetrievalManual)
    <button @click="$wire.openModal()" class="flex w-full items-center gap-2 md:gap-3 p-2.5 md:p-3 rounded-lg md:rounded-xl text-left transition-colors touch-target group" style="color: var(--text-primary); cursor: pointer;">
        <i class="ph ph-key text-lg md:text-xl group-hover:text-primary transition-colors" style="color: var(--primary);"></i>
        <span class="text-xs md:text-sm">@lang('Get EPP/Auth Code')</span>
        <i class="ph ph-spinner animate-spin ml-auto text-xs" wire:loading wire:target="openModal"></i>
    </button>
    @endif

    {{-- EPP Code Modal --}}
    <x-client.modal :show="$showModal" :title="__('EPP/Auth Code')" :icon="'ph-key'" :closeAction="'closeModal'" maxWidth="md">
        <div class="space-y-3 md:space-y-4">
            <div wire:loading wire:target="openModal, loadEppCode">
                <div class="space-y-3 md:space-y-4">
                    <x-client.skeleton type="line" class="h-4 w-24 mb-2" />
                    <x-client.skeleton type="line" class="h-10" />
                </div>
            </div>

            <div wire:loading.remove wire:target="openModal, loadEppCode">
                @if($eppCode)
                    <div class="p-3 md:p-4 rounded-lg md:rounded-xl" style="background: var(--success-light, rgba(34, 197, 94, 0.1));">
                        <p class="text-xs md:text-sm mb-1.5 md:mb-2" style="color: var(--text-secondary);">@lang('Your EPP/Auth Code')</p>
                        <div class="flex items-center gap-2 md:gap-3">
                            <code class="flex-1 font-mono text-sm md:text-lg font-medium truncate" style="color: var(--text-primary);">{{ $eppCode }}</code>
                            <button
                                onclick="navigator.clipboard.writeText('{{ $eppCode }}'); this.innerHTML = '<i class=\'ph ph-check\'></i>'; setTimeout(() => this.innerHTML = '<i class=\'ph ph-copy\'></i>', 2000);"
                                class="p-1.5 md:p-2 rounded-lg transition-colors touch-target shrink-0"
                                style="color: var(--primary);"
                                title="@lang('Copy')"
                            >
                                <i class="ph ph-copy"></i>
                            </button>
                        </div>
                    </div>
                    <x-client.alert type="warning">
                        <p class="text-xs md:text-sm">@lang('Keep this code secure. It is required to transfer your domain to another registrar.')</p>
                    </x-client.alert>
                @else
                    <div class="p-3 md:p-4 rounded-lg md:rounded-xl text-center" style="background: var(--danger-light, rgba(239, 68, 68, 0.1));">
                        <i class="ph ph-warning text-xl md:text-2xl" style="color: var(--danger);"></i>
                        <p class="mt-1.5 md:mt-2 text-xs md:text-sm" style="color: var(--text-primary);">@lang('Unable to retrieve EPP code. Please try again or contact support.')</p>
                    </div>
                @endif
            </div>

            <div class="flex justify-end pt-3 md:pt-4">
                <x-client.button type="button" wire:click="closeModal" variant="secondary">@lang('Close')</x-client.button>
            </div>
        </div>
    </x-client.modal>
</div>
