<div>
    <x-client.card class="animate-slide-up stagger-3">
        <div class="mb-3 md:mb-4 flex items-center justify-between">
            <h3 class="font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Nameservers')</h3>
            @if($domain->status == 1)
                <button @click="$wire.set('showModal', true)" class="flex items-center gap-1 text-xs md:text-sm font-medium transition-colors touch-target" style="color: var(--primary); cursor: pointer;">
                    <i class="ph ph-pencil-simple"></i>
                    @lang('Edit')
                    <i class="ph ph-spinner animate-spin ml-1 text-xs" wire:loading wire:target="openModal"></i>
                </button>
            @endif
        </div>
        <div class="space-y-2 md:space-y-3">
            @if($domain->ns1 || $domain->ns2)
                @foreach(['ns1', 'ns2', 'ns3', 'ns4'] as $ns)
                    @if($domain->$ns)
                        <div class="flex items-center gap-2 md:gap-3 p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light border border-subtle">
                            <i class="ph ph-server text-lg md:text-xl" style="color: var(--primary);"></i>
                            <span class="font-mono text-xs md:text-sm truncate" style="color: var(--text-primary);">{{ $domain->$ns }}</span>
                        </div>
                    @endif
                @endforeach
            @else
                <div class="p-6 md:p-8 text-center">
                    <i class="ph ph-server text-2xl md:text-3xl" style="color: var(--text-muted);"></i>
                    <p class="mt-2 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('No nameservers configured')</p>
                    @if($domain->status == 1)
                        <x-client.button @click="$wire.set('showModal', true)" class="mt-3">@lang('Add Nameservers')</x-client.button>
                    @endif
                </div>
            @endif
        </div>
    </x-client.card>

    {{-- Nameserver Modal --}}
    <x-client.modal :show="$showModal" :title="__('Manage Nameservers')" :icon="'ph-server'" :closeAction="'closeModal'" maxWidth="lg">
        <form wire:submit="updateNameservers" class="space-y-3 md:space-y-4">
            <div wire:loading wire:target="updateNameservers" class="space-y-3 md:space-y-4">
                @for($i = 0; $i < 4; $i++)
                    <x-client.skeleton type="line" class="h-4 w-24 mb-2" />
                    <x-client.skeleton type="line" class="h-10" />
                @endfor
            </div>
            <div wire:loading.remove wire:target="updateNameservers">
                @foreach(['ns1' => 'Nameserver 1', 'ns2' => 'Nameserver 2', 'ns3' => 'Nameserver 3', 'ns4' => 'Nameserver 4'] as $field => $label)
                    <div>
                        <label class="mb-1.5 md:mb-2 block text-xs md:text-sm font-medium" style="color: var(--text-primary);">
                            {{ __($label) }}
                            @if(in_array($field, ['ns1', 'ns2']))
                                <span style="color: var(--danger);">*</span>
                            @endif
                        </label>
                        <x-client.input type="text" wire:model="{{ $field }}" placeholder="ns{{ substr($field, 2) }}.example.com" />
                        @error($field) <p class="mt-1 text-xs md:text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
                    </div>
                @endforeach
            </div>
            <div class="flex flex-col-reverse sm:flex-row justify-end gap-2 md:gap-3 pt-3 md:pt-4">
                <x-client.button type="button" wire:click="closeModal" variant="secondary">@lang('Cancel')</x-client.button>
                <x-client.button type="submit" wireLoading="updateNameservers">@lang('Save Changes')</x-client.button>
            </div>
        </form>
    </x-client.modal>
</div>
