<div>
    @if($domain->status == 1)
        <x-client.button @click="$wire.set('showModal', true)" icon="ph-arrows-clockwise" class="w-full sm:w-auto">@lang('Renew Domain')</x-client.button>
    @endif

    {{-- Expiry Warnings --}}
    <div class="mt-4 space-y-4">
        @if($daysUntilExpiry !== null && $daysUntilExpiry <= 30 && $daysUntilExpiry > 0)
            <x-client.alert type="warning" class="animate-slide-up stagger-8">
                <p class="font-medium text-sm md:text-base">@lang('Expiring Soon')</p>
                <p class="mt-0.5 md:mt-1 text-xs md:text-sm">@lang('This domain expires in :days days. Renew now to avoid losing it.', ['days' => $daysUntilExpiry])</p>
            </x-client.alert>
        @elseif($daysUntilExpiry !== null && $daysUntilExpiry <= 0)
            <x-client.alert type="danger" class="animate-slide-up stagger-8">
                <p class="font-medium text-sm md:text-base">@lang('Domain Expired')</p>
                <p class="mt-0.5 md:mt-1 text-xs md:text-sm">@lang('This domain has expired. Renew immediately to restore it.')</p>
            </x-client.alert>
        @endif
    </div>

    {{-- Renew Modal --}}
    <x-client.modal :show="$showModal" :title="__('Renew Domain')" :icon="'ph-arrows-clockwise'" :closeAction="'closeModal'" maxWidth="md">
        <div class="space-y-3 md:space-y-4">
            <div class="p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light border border-subtle">
                <p class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Domain')</p>
                <p class="font-medium text-sm md:text-base truncate" style="color: var(--text-primary);">{{ $domain->domain }}</p>
            </div>
            <div>
                <label class="mb-1.5 md:mb-2 block text-xs md:text-sm font-medium" style="color: var(--text-primary);">@lang('Renewal Period')</label>
                <x-client.input wire:model="renewYears" type="select">
                    @for($i = 1; $i <= 10; $i++)
                        <option value="{{ $i }}">{{ $i }} @lang('Year(s)')</option>
                    @endfor
                </x-client.input>
            </div>
            <div class="flex flex-col-reverse sm:flex-row justify-end gap-2 md:gap-3 pt-3 md:pt-4">
                <x-client.button type="button" wire:click="closeModal" variant="secondary">@lang('Cancel')</x-client.button>
                <x-client.button wire:click="renewDomain" icon="ph-arrows-clockwise" wireLoading="renewDomain">@lang('Renew Now')</x-client.button>
            </div>
        </div>
    </x-client.modal>
</div>
