<div>
    <button @click="$wire.openModal()" class="flex w-full items-center gap-2 md:gap-3 p-2.5 md:p-3 rounded-lg md:rounded-xl text-left transition-colors touch-target hover:bg-subtle/50 group" style="color: var(--text-primary); cursor: pointer;">
        <i class="ph ph-user text-lg md:text-xl" style="color: var(--primary);"></i>
        <span class="text-xs md:text-sm">@lang('Contact Information')</span>
        <i class="ph ph-spinner animate-spin ml-auto text-xs" wire:loading wire:target="openModal"></i>
    </button>

    {{-- Contact Information Modal --}}
    <x-client.modal :show="$showModal" :title="__('Contact Information')" :icon="'ph-user'" :closeAction="'closeModal'" maxWidth="2xl">

        <div wire:loading wire:target="loadContactInfo, updateContact">
            <div class="space-y-3 md:space-y-4">
                @for($i = 0; $i < 4; $i++)
                    <x-client.skeleton type="line" class="h-4 w-24 mb-2" />
                    <x-client.skeleton type="line" class="h-10" />
                @endfor
            </div>
        </div>

        <div wire:loading.remove wire:target="loadContactInfo, updateContact">
            @if(count($contactInfo) > 0)
            <form wire:submit.prevent="updateContact" class="space-y-3 md:space-y-4">
                @php
                    $registrarAlias = $domain->domainRegister?->alias ?? 'default';
                @endphp

                <div class="grid grid-cols-1 md:grid-cols-2 gap-3 md:gap-4">
                    <div>
                        <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">@lang('First Name')</label>
                        <x-client.input type="text" wire:model="contactInfo.first_name" placeholder="John" />
                    </div>
                    <div>
                        <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">@lang('Last Name')</label>
                        <x-client.input type="text" wire:model="contactInfo.last_name" placeholder="Doe" />
                    </div>
                </div>

                <div>
                    <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">@lang('Organization')</label>
                    <x-client.input type="text" wire:model="contactInfo.organization" placeholder="Company Name (optional)" />
                </div>

                <div>
                    <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">@lang('Email')</label>
                    <x-client.input type="email" wire:model="contactInfo.email" placeholder="email@example.com" />
                </div>

                <div>
                    <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">@lang('Phone')</label>
                    <x-client.input type="text" wire:model="contactInfo.phone" placeholder="+1.1234567890" />
                </div>

                <div>
                    <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">@lang('Address Line 1')</label>
                    <x-client.input type="text" wire:model="contactInfo.address1" placeholder="123 Main Street" />
                </div>

                <div>
                    <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">@lang('Address Line 2')</label>
                    <x-client.input type="text" wire:model="contactInfo.address2" placeholder="Suite 100 (optional)" />
                </div>

                <div class="grid grid-cols-1 md:grid-cols-3 gap-3 md:gap-4">
                    <div>
                        <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">@lang('City')</label>
                        <x-client.input type="text" wire:model="contactInfo.city" placeholder="New York" />
                    </div>
                    <div>
                        <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">@lang('State/Province')</label>
                        <x-client.input type="text" wire:model="contactInfo.state" placeholder="NY" />
                    </div>
                    <div>
                        <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">@lang('Postal Code')</label>
                        <x-client.input type="text" wire:model="contactInfo.postcode" placeholder="10001" />
                    </div>
                </div>

                <div>
                    <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">@lang('Country')</label>
                    <x-client.input wire:model="contactInfo.country" type="select">
                        <option value="">@lang('Select Country')</option>
                        @foreach($countries as $code => $name)
                            <option value="{{ $code }}">{{ $name }}</option>
                        @endforeach
                    </x-client.input>
                </div>

                {{-- Registrar-specific fields --}}
                @if($registrarAlias === 'enom')
                    <div class="p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light border border-subtle">
                        <p class="text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--primary);">@lang('eNom Specific Options')</p>
                        <label class="flex items-center gap-2 touch-target">
                            <input type="checkbox" wire:model="contactInfo.whois_privacy" class="rounded" style="accent-color: var(--primary);">
                            <span class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Enable WHOIS Privacy Protection')</span>
                        </label>
                    </div>
                @elseif($registrarAlias === 'resellerclub' || $registrarAlias === 'logicboxes')
                    <div class="p-3 md:p-4 rounded-lg md:rounded-xl" style="background: var(--primary-light);">
                        <p class="text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--primary);">@lang('ResellerClub Options')</p>
                        <label class="flex items-center gap-2 touch-target">
                            <input type="checkbox" wire:model="contactInfo.privacy_protect" class="rounded" style="accent-color: var(--primary);">
                            <span class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Privacy Protection')</span>
                        </label>
                    </div>
                @elseif($registrarAlias === 'namesilo')
                    <div class="p-3 md:p-4 rounded-lg md:rounded-xl" style="background: var(--primary-light);">
                        <p class="text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--primary);">@lang('NameSilo Options')</p>
                        <label class="flex items-center gap-2 touch-target">
                            <input type="checkbox" wire:model="contactInfo.private" class="rounded" style="accent-color: var(--primary);">
                            <span class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Enable WHOIS Privacy')</span>
                        </label>
                    </div>
                @endif

                <div class="flex flex-col-reverse sm:flex-row justify-end gap-2 md:gap-3 pt-3 md:pt-4 border-t" style="border-color: var(--card-border);">
                    <x-client.button type="button" wire:click="closeModal" variant="secondary">@lang('Cancel')</x-client.button>
                    <x-client.button type="submit" icon="ph-check" wireLoading="updateContact">@lang('Save Changes')</x-client.button>
                </div>
            </form>
        @else
            <div class="text-center py-6 md:py-8">
                <div class="mx-auto flex h-12 w-12 md:h-14 md:w-14 items-center justify-center rounded-lg md:rounded-xl mb-3 md:mb-4" style="background: var(--danger-light, rgba(239, 68, 68, 0.1));">
                    <i class="ph ph-warning text-xl md:text-2xl" style="color: var(--danger);"></i>
                </div>
                <p class="font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Unable to load contact information')</p>
                <p class="text-xs md:text-sm mt-0.5 md:mt-1" style="color: var(--text-secondary);">@lang('Please try again or contact support.')</p>
                <x-client.button type="button" wire:click="closeModal" variant="secondary" class="mt-3 md:mt-4">@lang('Close')</x-client.button>
            </div>
            @endif
        </div>
    </x-client.modal>
</div>
