<div class="space-y-4 md:space-y-6">
    {{-- Breadcrumb --}}
    <nav class="flex items-center gap-1.5 md:gap-2 text-xs md:text-sm animate-fade-in" style="color: var(--text-secondary);">
        <a href="{{ route('client.domains') }}" wire:navigate class="transition-colors hover:underline" style="color: var(--primary);">@lang('Domains')</a>
        <i class="ph ph-caret-right text-xs"></i>
        <span class="truncate" style="color: var(--text-primary);">{{ $domain->domain }}</span>
    </nav>

    @if(session('success'))
        <x-client.alert type="success" class="animate-slide-up">{{ session('success') }}</x-client.alert>
    @endif

    @if(session('error'))
        <x-client.alert type="danger" class="animate-slide-up">{{ session('error') }}</x-client.alert>
    @endif

    {{-- Header Card --}}
    @php
        $statusType = $statusConfig['color'] ?? 'secondary';
    @endphp
    <x-client.card class="animate-slide-up stagger-1">
        <div class="flex flex-col gap-3 md:gap-4 lg:flex-row lg:items-center lg:justify-between">
            <div class="flex items-start gap-3 md:gap-4">
                <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--primary-light);">
                    <i class="ph ph-globe text-lg md:text-xl" style="color: var(--primary);"></i>
                </div>
                <div class="min-w-0">
                    <div class="flex flex-wrap items-center gap-2 md:gap-3">
                        <h1 class="text-lg md:text-xl font-semibold truncate" style="color: var(--text-primary);">{{ $domain->domain }}</h1>
                        <x-client.badge :type="$statusType" size="sm">{{ __($statusConfig['label']) }}</x-client.badge>
                    </div>
                    <p class="mt-0.5 md:mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">
                        @lang('Registered') {{ $domain->reg_date ? $domain->reg_date->format('M d, Y') : 'N/A' }}
                        @if($domain->expiry_date)
                            <span class="mx-1 md:mx-2">•</span>
                            @if($daysUntilExpiry > 0)
                                <span x-data="liveCountdown('{{ $domain->expiry_date->toISOString() }}')"
                                      style="color: {{ $daysUntilExpiry < 30 ? 'var(--warning)' : 'var(--text-secondary)' }};">
                                    <span x-text="display"></span>
                                </span>
                            @else
                                <span style="color: var(--danger);">@lang('Expired')</span>
                            @endif
                        @endif
                    </p>
                </div>
            </div>
            @livewire('client.domains.details.renewal', ['domain' => $domain])
        </div>
    </x-client.card>

    <div class="grid gap-4 md:gap-6 lg:grid-cols-3">
        {{-- Main Info --}}
        <div class="space-y-4 md:space-y-6 lg:col-span-2">
            {{-- Domain Information --}}
            <x-client.card class="animate-slide-up stagger-2">
                <h3 class="mb-3 md:mb-4 font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Domain Information')</h3>
                <dl class="grid gap-3 md:gap-4 sm:grid-cols-2">
                    <div class="p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light border border-subtle">
                        <dt class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Domain Name')</dt>
                        <dd class="mt-0.5 md:mt-1 flex items-center gap-2 font-medium text-sm md:text-base" style="color: var(--text-primary);">
                            <span class="truncate">{{ $domain->domain }}</span>
                            <button onclick="navigator.clipboard.writeText('{{ $domain->domain }}')" class="p-1 rounded transition-colors shrink-0 touch-target" style="color: var(--text-muted); cursor: pointer;" title="@lang('Copy')">
                                <i class="ph ph-copy text-sm"></i>
                            </button>
                        </dd>
                    </div>
                    <div class="p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light border border-subtle">
                        <dt class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Registration Date')</dt>
                        <dd class="mt-0.5 md:mt-1 font-medium text-sm md:text-base" style="color: var(--text-primary);">{{ $domain->reg_date ? $domain->reg_date->format('M d, Y') : 'N/A' }}</dd>
                    </div>
                    <div class="p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light border border-subtle">
                        <dt class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Expiry Date')</dt>
                        <dd class="mt-0.5 md:mt-1 font-medium text-sm md:text-base" style="color: {{ $domain->expiry_date && $domain->expiry_date < now()->addDays(30) ? 'var(--danger)' : 'var(--text-primary)' }};">
                            {{ $domain->expiry_date ? $domain->expiry_date->format('M d, Y') : 'N/A' }}
                        </dd>
                    </div>
                </dl>
            </x-client.card>

            {{-- Nameservers --}}
            @livewire('client.domains.details.nameservers', ['domain' => $domain])

            {{-- Private Nameservers --}}
            @livewire('client.domains.private-nameserver-component', ['domain' => $domain])
        </div>

        {{-- Sidebar --}}
        <div class="space-y-4 md:space-y-6">
            {{-- Auto Renew Toggle --}}
            <x-client.card class="animate-slide-up stagger-4" padding="sm">
                <div class="flex items-center justify-between gap-3">
                    <div class="min-w-0">
                        <h4 class="font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Auto Renew')</h4>
                        <p class="mt-0.5 md:mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Automatically renew before expiry')</p>
                    </div>
                    <button wire:click="toggleAutoRenew" class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors shrink-0 touch-target" style="background: {{ $autoRenew ? 'var(--primary)' : 'var(--card-border)' }}; cursor: pointer;">
                        <span class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform {{ $autoRenew ? 'translate-x-6' : 'translate-x-1' }}"></span>
                    </button>
                </div>
            </x-client.card>

            {{-- Domain Lock Toggle --}}
            @if(!$eppRetrievalManual)
            <x-client.card class="animate-slide-up stagger-5" padding="sm">
                <div class="flex items-center justify-between gap-3">
                    <div class="min-w-0">
                        <h4 class="font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Transfer Lock')</h4>
                        <p class="mt-0.5 md:mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Prevent unauthorized transfers')</p>
                    </div>
                    <button
                        wire:click="toggleDomainLock"
                        wire:loading.attr="disabled"
                        wire:target="toggleDomainLock"
                        class="relative inline-flex h-6 w-11 items-center rounded-full transition-colors disabled:opacity-50 shrink-0 touch-target"
                        style="background: {{ $isLocked ? 'var(--primary)' : 'var(--card-border)' }}; cursor: pointer;"
                    >
                        <span wire:loading.remove wire:target="toggleDomainLock" class="inline-block h-4 w-4 transform rounded-full bg-white transition-transform {{ $isLocked ? 'translate-x-6' : 'translate-x-1' }}"></span>
                        <span wire:loading wire:target="toggleDomainLock" class="absolute inset-0 flex items-center justify-center">
                            <i class="ph ph-spinner animate-spin text-xs text-white"></i>
                        </span>
                    </button>
                </div>
            </x-client.card>
            @endif
 
            {{-- Quick Actions --}}
            <x-client.card class="animate-slide-up stagger-6" padding="sm">
                <h3 class="mb-3 md:mb-4 font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Quick Actions')</h3>
                <div class="space-y-1 md:space-y-2">
                    <button @click="$dispatch('open-nameserver-modal')" class="flex w-full items-center gap-2 md:gap-3 p-2.5 md:p-3 rounded-lg md:rounded-xl text-left transition-colors touch-target hover:bg-subtle/50 group" style="color: var(--text-primary); cursor: pointer;">
                        <i class="ph ph-globe text-lg md:text-xl" style="color: var(--primary);"></i>
                        <span class="text-xs md:text-sm">@lang('Manage Nameservers')</span>
                    </button>
                    
                    @livewire('client.domains.details.epp-code', ['domain' => $domain])
                    
                    @livewire('client.domains.details.whois', ['domain' => $domain])
                </div>
            </x-client.card>

            {{-- Domain Summary --}}
            <x-client.card class="animate-slide-up stagger-7" padding="sm">
                <h3 class="mb-3 md:mb-4 font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Summary')</h3>
                <div class="space-y-2 md:space-y-3">
                    <div class="flex justify-between items-center">
                        <span class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Status')</span>
                        <x-client.badge :type="$statusType" size="xs">{{ __($statusConfig['label']) }}</x-client.badge>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Auto Renew')</span>
                        <span class="text-xs md:text-sm font-medium" style="color: {{ $autoRenew ? 'var(--success)' : 'var(--text-muted)' }};">{{ $autoRenew ? __('Enabled') : __('Disabled') }}</span>
                    </div>
                    @if($domain->expiry_date)
                        <div class="flex justify-between items-center">
                            <span class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Expires')</span>
                            <span class="text-xs md:text-sm font-medium" style="color: var(--text-primary);">{{ $domain->expiry_date->format('M d, Y') }}</span>
                        </div>
                    @endif
                </div>
            </x-client.card>
        </div>
    </div>
</div>
</div>

@push('scripts')
<script>
    document.addEventListener('alpine:init', () => {
        Alpine.data('liveCountdown', (expiryDate) => ({
            display: '',
            expiryTime: new Date(expiryDate).getTime(),
            interval: null,

            init() {
                this.updateCountdown();
                this.interval = setInterval(() => this.updateCountdown(), 1000);
            },

            destroy() {
                if (this.interval) clearInterval(this.interval);
            },

            updateCountdown() {
                const now = Date.now();
                const diff = this.expiryTime - now;

                if (diff <= 0) {
                    this.display = '{{ __("Expired") }}';
                    if (this.interval) clearInterval(this.interval);
                    return;
                }

                const days = Math.floor(diff / (1000 * 60 * 60 * 24));
                const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((diff % (1000 * 60)) / 1000);

                if (days > 0) {
                    this.display = `${days}d ${hours}h ${minutes}m ${seconds}s {{ __('until expiry') }}`;
                } else if (hours > 0) {
                    this.display = `${hours}h ${minutes}m ${seconds}s {{ __('until expiry') }}`;
                } else {
                    this.display = `${minutes}m ${seconds}s {{ __('until expiry') }}`;
                }
            }
        }));
    });
</script>
@endpush
