<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex items-center gap-3 md:gap-4 animate-fade-in">
        <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl shrink-0 bg-primary-light">
            <i class="ph-duotone ph-globe-hemisphere-west text-lg md:text-xl text-primary-color"></i>
        </div>
        <div>
            <h1 class="text-lg md:text-xl font-bold text-dynamic">@lang('My Domains')</h1>
            <p class="mt-0.5 text-xs md:text-sm text-dynamic-secondary">@lang('Manage your registered domains')</p>
        </div>
    </div>

    {{-- Filters Card --}}
    <x-client.card class="animate-slide-up stagger-1" padding="sm">
        <div class="flex flex-col gap-3 md:gap-4 lg:flex-row lg:items-center">
            {{-- Search --}}
            <div class="max-w-sm flex-1">
                <x-client.input wire:model.live.debounce.300ms="search" type="text" placeholder="{{ __('Search domains...') }}" prefixIcon="ph-magnifying-glass" />
            </div>

            {{-- Status Filter Pills --}}
            <div class="flex gap-2 overflow-x-auto -mx-4 px-4 md:mx-0 md:px-0 scrollbar-hide">
                @php
                    $filters = [
                        '' => ['label' => 'All', 'count' => $counts['all']],
                        '1' => ['label' => 'Active', 'count' => $counts['active']],
                        '2' => ['label' => 'Pending', 'count' => $counts['pending']],
                        '3' => ['label' => 'Expired', 'count' => $counts['expired']],
                    ];
                @endphp
                @foreach($filters as $value => $filter)
                    <button
                        wire:click="$set('status', '{{ $value }}')"
                        class="filter-pill {{ $status === $value ? 'filter-pill-active' : '' }}"
                    >
                        @lang($filter['label'])
                        <span class="text-2xs px-1.5 py-0.5 rounded-full {{ $status === $value ? 'bg-primary-light/30' : 'bg-primary-light/20' }}">{{ $filter['count'] }}</span>
                    </button>
                @endforeach
            </div>
        </div>
    </x-client.card>

    {{-- Domains Grid --}}
    <div class="grid gap-3 md:gap-4 sm:grid-cols-2 lg:grid-cols-3">
        {{-- Loading Skeleton --}}
        <div wire:loading.delay wire:target="search, status" class="contents">
            @for($i = 0; $i < 6; $i++)
                <x-client.skeleton type="domain-card" :delay="$i * 75" />
            @endfor
        </div>

        {{-- Actual Content --}}
        <div wire:loading.remove wire:target="search, status" class="contents">
        @forelse($domains as $index => $domain)
            @php
                $statusConfig = [
                    1 => ['label' => 'Active', 'type' => 'success'],
                    2 => ['label' => 'Pending', 'type' => 'warning'],
                    3 => ['label' => 'Expired', 'type' => 'danger'],
                    4 => ['label' => 'Cancelled', 'type' => 'secondary'],
                ];
                $config = $statusConfig[$domain->status] ?? $statusConfig[2];
                $isExpiringSoon = $domain->expiry_date && $domain->expiry_date < now()->addDays(30);
                $staggerClass = 'stagger-' . min($index + 2, 11);
            @endphp
            <a href="{{ route('client.domains.show', $domain->id) }}" wire:navigate class="group animate-slide-up {{ $staggerClass }}">
                <x-client.card class="h-full hover-lift transition-all" padding="sm">
                    {{-- Header --}}
                    <div class="flex items-start justify-between mb-3 md:mb-4">
                        <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-lg md:rounded-xl shrink-0 bg-primary-light">
                            <i class="ph-duotone ph-globe-hemisphere-west text-base md:text-lg text-primary-color"></i>
                        </div>
                        <x-client.badge :type="$config['type']" size="sm">{{ __($config['label']) }}</x-client.badge>
                    </div>

                    {{-- Content --}}
                    <h3 class="font-medium text-sm md:text-base truncate text-dynamic">{{ $domain->domain }}</h3>

                    {{-- Details --}}
                    <div class="mt-3 md:mt-4 pt-3 md:pt-4 space-y-1.5 md:space-y-2 text-xs md:text-sm border-subtle" style="border-top-width: 1px;">
                        <div class="flex justify-between">
                            <span class="text-dynamic-secondary">@lang('Registered')</span>
                            <span class="font-medium text-dynamic">{{ $domain->reg_date ? $domain->reg_date->format('M d, Y') : 'N/A' }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-dynamic-secondary">@lang('Expires')</span>
                            <span class="font-medium" style="color: {{ $isExpiringSoon ? 'var(--warning)' : 'var(--text-primary)' }};">
                                {{ $domain->expiry_date ? $domain->expiry_date->format('M d, Y') : 'N/A' }}
                                @if($isExpiringSoon)
                                    <i class="ph-duotone ph-warning-circle ml-1 text-xs text-warning-color"></i>
                                @endif
                            </span>
                        </div>
                    </div>

                    <div class="mt-3 md:mt-4 flex items-center justify-end">
                        <i class="ph-bold ph-caret-right transition-transform group-hover:translate-x-1 text-dynamic-muted text-xs"></i>
                    </div>
                </x-client.card>
            </a>
        @empty
            <div class="col-span-full">
                <x-client.card class="animate-fade-in">
                    <x-client.empty-state
                        icon="ph-globe-hemisphere-west"
                        illustration="domains"
                        title="No domains found"
                        description="You don't have any registered domains yet."
                    />
                </x-client.card>
            </div>
        @endforelse
        </div>
    </div>

    {{-- Pagination --}}
    @if($domains->hasPages())
        <div class="mt-4 md:mt-6">
            {{ $domains->links('vendor.livewire.novahost') }}
        </div>
    @endif
</div>
