<div x-data="{ showAddModal: @entangle('showAddModal'), showEditModal: @entangle('showEditModal'), showDeleteModal: @entangle('showDeleteModal') }">
    <x-client.card class="animate-slide-up">
        @if(session()->has('success'))
            <x-client.alert type="success" autoDismiss="5" class="mb-4">
                {{ session('success') }}
            </x-client.alert>
        @endif

        @if(session()->has('error'))
            <x-client.alert type="danger" class="mb-4">
                {{ session('error') }}
            </x-client.alert>
        @endif

        @if(session()->has('info'))
            <x-client.alert type="info" class="mb-4">
                {{ session('info') }}
            </x-client.alert>
        @endif

        <div class="mb-4 flex items-center justify-between">
            <div>
                <h3 class="font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Private Nameservers')</h3>
                <p class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Manage your own child nameservers for this domain.')</p>
            </div>
            @if($domain->status == 1)
                <x-client.button @click="showAddModal = true; $wire.openAddModal()" size="sm" icon="ph-plus">@lang('Register Nameserver')</x-client.button>
            @endif
        </div>

        <div class="space-y-3">
            @if($isLoading)
                <div class="space-y-3">
                    <x-client.skeleton type="line" class="h-12 w-full" />
                    <x-client.skeleton type="line" class="h-12 w-full" />
                </div>
            @elseif(empty($nameservers))
                <div class="p-8 text-center border-2 border-dashed rounded-xl" style="border-color: var(--card-border);">
                    <div class="mx-auto flex h-12 w-12 items-center justify-center rounded-full bg-primary/5 mb-3">
                        <i class="ph ph-server text-2xl" style="color: var(--primary);"></i>
                    </div>
                    <p class="text-sm font-medium" style="color: var(--text-primary);">@lang('No private nameservers found')</p>
                    <p class="text-xs mt-1" style="color: var(--text-secondary);">@lang('You can register your own nameservers like ns1.yourdomain.com')</p>
                </div>
            @else
                <div class="overflow-x-auto">
                    <table class="w-full text-left text-sm">
                        <thead>
                            <tr class="border-b" style="border-color: var(--card-border);">
                                <th class="pb-3 font-medium" style="color: var(--text-secondary);">@lang('Hostname')</th>
                                <th class="pb-3 font-medium" style="color: var(--text-secondary);">@lang('IP Address')</th>
                                <th class="pb-3 font-medium text-right" style="color: var(--text-secondary);">@lang('Actions')</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y" style="border-color: var(--card-border);">
                            @foreach($nameservers as $ns)
                                <tr>
                                    <td class="py-3 font-mono" style="color: var(--text-primary);">{{ $ns['hostname'] }}</td>
                                    <td class="py-3 font-mono" style="color: var(--text-primary);">{{ $ns['ip'] }}</td>
                                    <td class="py-3 text-right">
                                        <div class="flex items-center justify-end gap-2">
                                            <button @click="$wire.openEditModal('{{ $ns['hostname'] }}', '{{ $ns['ip'] }}')" class="p-1.5 rounded-lg transition-colors hover:bg-primary/5 touch-target" style="color: var(--primary);" title="@lang('Edit IP')">
                                                <i class="ph ph-pencil-simple"></i>
                                            </button>
                                            <button @click="$wire.openDeleteModal('{{ $ns['hostname'] }}')" class="p-1.5 rounded-lg transition-colors hover:bg-danger/5 touch-target" style="color: var(--danger);" title="@lang('Delete')">
                                                <i class="ph ph-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </x-client.card>

    {{-- Register Nameserver Modal --}}
    <x-client.modal :show="$showAddModal" :title="__('Register Private Nameserver')" :icon="'ph-plus-circle'" :closeAction="'resetForm'" maxWidth="md">
        <form wire:submit.prevent="addNameserver" class="space-y-4">
            <div>
                <label class="mb-1.5 block text-xs md:text-sm font-medium" style="color: var(--text-primary);">@lang('Hostname')</label>
                <div class="flex items-center gap-2">
                    <x-client.input type="text" wire:model="hostname" placeholder="ns1" class="flex-1" />
                    <span class="text-sm" style="color: var(--text-secondary);">.{{ $domain->domain }}</span>
                </div>
                <p class="mt-1 text-xs" style="color: var(--text-muted);">@lang('Enter only the prefix (e.g., ns1)')</p>
                @error('hostname') <p class="mt-1 text-xs" style="color: var(--danger);">{{ $message }}</p> @enderror
            </div>
            <div>
                <label class="mb-1.5 block text-xs md:text-sm font-medium" style="color: var(--text-primary);">@lang('IP Address')</label>
                <x-client.input type="text" wire:model="ip" placeholder="12.34.56.78" />
                @error('ip') <p class="mt-1 text-xs" style="color: var(--danger);">{{ $message }}</p> @enderror
            </div>
            <div class="flex flex-col-reverse sm:flex-row justify-end gap-2 pt-4">
                <x-client.button type="button" wire:click="$set('showAddModal', false)" variant="secondary">@lang('Cancel')</x-client.button>
                <x-client.button type="submit" wireLoading="addNameserver">@lang('Register')</x-client.button>
            </div>
        </form>
    </x-client.modal>

    {{-- Edit Nameserver Modal --}}
    <x-client.modal :show="$showEditModal" :title="__('Edit Private Nameserver')" :icon="'ph-pencil-simple'" :closeAction="'resetForm'" maxWidth="md">
        <form wire:submit.prevent="updateNameserver" class="space-y-4">
            <div class="p-3 rounded-lg" style="background: var(--primary-light);">
                <p class="text-xs" style="color: var(--text-secondary);">@lang('Nameserver')</p>
                <p class="font-medium font-mono" style="color: var(--text-primary);">{{ $hostname }}</p>
            </div>
            <div>
                <label class="mb-1.5 block text-xs md:text-sm font-medium" style="color: var(--text-primary);">@lang('New IP Address')</label>
                <x-client.input type="text" wire:model="ip" placeholder="12.34.56.78" />
                @error('ip') <p class="mt-1 text-xs" style="color: var(--danger);">{{ $message }}</p> @enderror
            </div>
            <div class="flex flex-col-reverse sm:flex-row justify-end gap-2 pt-4">
                <x-client.button type="button" wire:click="$set('showEditModal', false)" variant="secondary">@lang('Cancel')</x-client.button>
                <x-client.button type="submit" wireLoading="updateNameserver">@lang('Save Changes')</x-client.button>
            </div>
        </form>
    </x-client.modal>

    {{-- Delete Nameserver Modal --}}
    <x-client.modal :show="$showDeleteModal" :title="__('Delete Private Nameserver')" :icon="'ph-warning'" :closeAction="'resetForm'" maxWidth="md">
        <div class="space-y-4">
            <p style="color: var(--text-secondary);">
                @lang('Are you sure you want to delete the private nameserver') <span class="font-bold font-mono">{{ $selectedHostname }}</span>?
                @lang('This action cannot be undone.')
            </p>
            <div class="flex flex-col-reverse sm:flex-row justify-end gap-2 pt-4">
                <x-client.button type="button" wire:click="$set('showDeleteModal', false)" variant="secondary">@lang('Cancel')</x-client.button>
                <x-client.button type="button" wire:click="deleteNameserver" variant="danger" wireLoading="deleteNameserver">@lang('Delete')</x-client.button>
            </div>
        </div>
    </x-client.modal>
</div>
