<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex items-center gap-3 md:gap-4 animate-fade-in">
        <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--primary-light);">
            <i class="ph ph-envelope text-lg md:text-xl" style="color: var(--primary);"></i>
        </div>
        <div>
            <h1 class="text-lg md:text-xl font-semibold" style="color: var(--text-primary);">@lang('Email History')</h1>
            <p class="mt-0.5 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('View emails sent to your account')</p>
        </div>
    </div>

    {{-- Mobile: Card View --}}
    <div class="md:hidden space-y-2 animate-slide-up">
        @forelse($emails as $email)
            <button wire:click="viewEmail({{ $email->id }})" class="w-full text-left touch-target">
                <x-client.card padding="sm" class="hover-lift">
                    <div class="flex items-center gap-2.5">
                        <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-lg" style="background: var(--primary-light);">
                            <i class="ph ph-envelope text-base" style="color: var(--primary);"></i>
                        </div>
                        <div class="min-w-0 flex-1">
                            <p class="truncate text-sm font-medium" style="color: var(--text-primary);">{{ $email->subject }}</p>
                            <p class="text-xs" style="color: var(--text-muted);">{{ $email->created_at->format('M d, Y') }}</p>
                        </div>
                        <i class="ph ph-caret-right text-sm shrink-0" style="color: var(--text-muted);"></i>
                    </div>
                </x-client.card>
            </button>
        @empty
            <x-client.empty-state icon="ph-envelope" title="{{ __('No emails found') }}" description="{{ __('Your email history will appear here.') }}" />
        @endforelse
    </div>

    {{-- Desktop: List View --}}
    <div class="hidden md:block animate-slide-up">
        <x-client.card padding="none">
            <div class="divide-y" style="border-color: var(--card-border);">
                @forelse($emails as $email)
                    <button wire:click="viewEmail({{ $email->id }})" class="flex w-full items-start gap-3 md:gap-4 px-4 md:px-6 py-3 md:py-4 text-left transition-colors touch-target" style="border-color: var(--card-border);">
                        <div class="flex h-10 w-10 shrink-0 items-center justify-center rounded-lg md:rounded-xl" style="background: var(--primary-light);">
                            <i class="ph ph-envelope text-lg" style="color: var(--primary);"></i>
                        </div>
                        <div class="min-w-0 flex-1">
                            <p class="truncate text-sm md:text-base font-medium" style="color: var(--text-primary);">{{ $email->subject }}</p>
                            <p class="mt-0.5 md:mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">{{ $email->created_at->format('M d, Y H:i') }}</p>
                        </div>
                        <i class="ph ph-caret-right shrink-0" style="color: var(--text-muted);"></i>
                    </button>
                @empty
                    <div class="p-8 md:p-12">
                        <x-client.empty-state icon="ph-envelope" title="{{ __('No emails found') }}" description="{{ __('Your email history will appear here.') }}" />
                    </div>
                @endforelse
            </div>
        </x-client.card>
    </div>

    {{-- Pagination --}}
    @if($emails->hasPages())
        <div class="mt-4 md:mt-6">
            {{ $emails->links('vendor.livewire.novahost') }}
        </div>
    @endif

    {{-- Email View Modal --}}
    @if($selectedEmailData)
        <x-client.modal :show="true" maxWidth="2xl">
            {{-- Modal Header --}}
            <div class="flex items-center justify-between p-4 md:p-6" style="border-bottom: 1px solid var(--card-border);">
                <div class="flex items-center gap-2.5 md:gap-3 min-w-0">
                    <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--primary-light);">
                        <i class="ph ph-envelope text-base md:text-lg" style="color: var(--primary);"></i>
                    </div>
                    <h3 class="text-sm md:text-base font-medium truncate" style="color: var(--text-primary);">{{ $selectedEmailData->subject }}</h3>
                </div>
                <button wire:click="closeEmail" class="p-2 rounded-lg transition-colors touch-target shrink-0" style="color: var(--text-muted);">
                    <i class="ph ph-x text-base md:text-lg"></i>
                </button>
            </div>

            {{-- Modal Body --}}
            <div class="p-4 md:p-6">
                <div class="mb-3 md:mb-4 flex flex-wrap items-center gap-3 md:gap-4 p-3 md:p-4 rounded-lg md:rounded-xl" style="background: var(--primary-light);">
                    <div class="flex-1 min-w-[100px] md:min-w-[120px]">
                        <p class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Sent to')</p>
                        <p class="text-sm md:text-base font-medium truncate" style="color: var(--text-primary);">{{ $selectedEmailData->sent_to }}</p>
                    </div>
                    <div class="flex-1 min-w-[100px] md:min-w-[120px]">
                        <p class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Sent via')</p>
                        <p class="text-sm md:text-base font-medium" style="color: var(--text-primary);">{{ ucfirst($selectedEmailData->sender ?? 'System') }}</p>
                    </div>
                    <div>
                        <p class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Date')</p>
                        <p class="text-sm md:text-base font-medium" style="color: var(--text-primary);">{{ $selectedEmailData->created_at->format('M d, Y') }}</p>
                    </div>
                </div>

                <div class="prose prose-sm md:prose max-w-none p-3 md:p-4 rounded-lg md:rounded-xl text-sm md:text-base" style="border: 1px solid var(--card-border); color: var(--text-secondary);">
                    {!! $selectedEmailData->message !!}
                </div>
            </div>

            {{-- Modal Footer --}}
            <div class="flex justify-end p-4 md:p-6" style="border-top: 1px solid var(--card-border);">
                <x-client.button wire:click="closeEmail" variant="secondary">@lang('Close')</x-client.button>
            </div>
        </x-client.modal>
    @endif
</div>
