@php
    $disabledFeature = session('disabled_feature');
    $supportEnabled = isFeatureEnabled('support') && isMenuVisible('support');

    // Feature display names
    $featureNames = [
        'deposits' => __('Add Funds'),
        'support' => __('Support Tickets'),
        'domains' => __('Domain Management'),
        'kyc' => __('Identity Verification'),
        'affiliates' => __('Affiliate Program'),
        'announcements' => __('Announcements'),
        'emails' => __('Email History'),
        'login_history' => __('Login History'),
        'security' => __('Security Settings'),
    ];
    $featureName = $featureNames[$disabledFeature] ?? __('This feature');
@endphp

<div class="flex min-h-[60vh] items-center justify-center px-4">
    <div class="max-w-md text-center">
        {{-- Icon --}}
        <div class="mx-auto mb-6 flex h-20 w-20 items-center justify-center rounded-2xl" style="background: color-mix(in srgb, var(--warning) 15%, transparent);">
            <i class="ph ph-prohibit text-4xl" style="color: var(--warning);"></i>
        </div>

        {{-- Title --}}
        <h1 class="text-2xl font-semibold" style="color: var(--text-primary);">@lang('Feature Unavailable')</h1>

        {{-- Description --}}
        <p class="mt-3" style="color: var(--text-secondary);">
            {{ $featureName }} @lang('is currently disabled by the administrator.')
        </p>
        <p class="mt-2 text-sm" style="color: var(--text-muted);">
            @lang('Please contact support if you believe this is an error.')
        </p>

        {{-- Actions --}}
        <div class="mt-8 flex flex-col gap-3 sm:flex-row sm:justify-center">
            <a href="{{ route('client.dashboard') }}" wire:navigate class="inline-flex items-center justify-center gap-2 px-5 py-2.5 text-sm font-medium rounded-xl transition-smooth btn-primary">
                <i class="ph ph-house"></i>
                @lang('Go to Dashboard')
            </a>
            @if($supportEnabled)
                <a href="{{ route('client.tickets.create') }}" wire:navigate class="inline-flex items-center justify-center gap-2 px-5 py-2.5 text-sm font-medium rounded-xl transition-smooth btn-secondary">
                    <i class="ph ph-headset"></i>
                    @lang('Contact Support')
                </a>
            @endif
        </div>
    </div>
</div>

