<div x-data="{ 
    open: @entangle('isOpen'),
    selectedIndex: -1,
    get results() {
        return Array.from(document.querySelectorAll('.search-result-item'));
    },
    navigate(direction) {
        const count = this.results.length;
        if (count === 0) return;
        
        if (direction === 'down') {
            this.selectedIndex = (this.selectedIndex + 1) % count;
        } else {
            this.selectedIndex = (this.selectedIndex - 1 + count) % count;
        }
        
        this.results[this.selectedIndex]?.scrollIntoView({ block: 'nearest' });
    },
    select() {
        if (this.selectedIndex >= 0) {
            this.results[this.selectedIndex]?.click();
        }
    }
}" 
     @keydown.window.prevent.cmd.k="open = true; $nextTick(() => $refs.searchInput.focus())" 
     @keydown.window.prevent.ctrl.k="open = true; $nextTick(() => $refs.searchInput.focus())"
     @open-global-search.window="open = true; $nextTick(() => $refs.searchInput.focus())"
     class="relative">
    
    {{-- Search Modal --}}
    <div x-show="open" 
         class="fixed inset-0 z-[1000] overflow-y-auto"
         role="dialog" aria-modal="true"
         x-cloak>
        
        {{-- Backdrop --}}
        <div x-show="open"
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition ease-in duration-200"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             class="fixed inset-0 bg-black/60 backdrop-blur-sm transition-opacity" 
             @click="open = false"
             aria-hidden="true"></div>

        {{-- Modal Content Wrapper --}}
        <div class="flex min-h-screen items-start justify-center p-4 sm:p-6 md:p-20">
            <div x-show="open"
                 x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 scale-95"
                 x-transition:enter-end="opacity-100 scale-100"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100 scale-100"
                 x-transition:leave-end="opacity-0 scale-95"
                 class="relative z-10 w-full max-w-2xl transform divide-y divide-subtle overflow-hidden rounded-2xl shadow-2xl ring-1 ring-black/5 transition-all"
                 style="background-color: var(--card-bg); border: 1px solid var(--card-border);"
                 @click.away="open = false">
                
                <div class="relative group">
                    <i class="ph ph-magnifying-glass absolute left-4 top-4 text-xl group-focus-within:text-primary transition-colors" style="color: var(--text-muted);"></i>
                    <input type="text" 
                           wire:model.live.debounce.300ms="search"
                           class="h-14 w-full border-0 bg-transparent pl-12 pr-4 text-dynamic placeholder-dynamic-muted focus:ring-0 sm:text-sm"
                           placeholder="Search services, domains, tickets..."
                           @keydown.escape="open = false"
                           @keydown.arrow-down.prevent="navigate('down')"
                           @keydown.arrow-up.prevent="navigate('up')"
                           @keydown.enter.prevent="select()"
                           x-ref="searchInput">
                    <div class="absolute right-4 top-4 flex gap-1 items-center">
                        <kbd class="px-2 py-1 text-[10px] font-semibold rounded-md border border-subtle bg-primary-light text-dynamic-secondary uppercase">ESC</kbd>
                    </div>
                </div>

                @if(strlen($search) >= 2)
                    <div class="max-h-[60vh] overflow-y-auto p-2 scrollbar-thin">
                        <div wire:loading wire:target="search" class="w-full py-10 text-center">
                            <div class="loading-spinner text-primary mx-auto"></div>
                            <p class="mt-2 text-xs text-dynamic-muted">Searching your account...</p>
                        </div>

                        <div wire:loading.remove wire:target="search">
                            @if(empty($results))
                                <div class="px-6 py-14 text-center sm:px-14">
                                    <i class="ph ph-mask-sad mx-auto h-12 w-12 text-dynamic-muted"></i>
                                    <p class="mt-4 text-sm text-dynamic">No results found for "<span class="font-semibold text-primary">{{ $search }}</span>".</p>
                                    <p class="mt-1 text-xs text-dynamic-muted">Try using different keywords or check for typos.</p>
                                </div>
                            @else
                                @php $globalIndex = 0; @endphp
                                @foreach($results as $group => $items)
                                    <div class="px-3 pb-2 pt-4 first:pt-2">
                                        <h3 class="px-3 text-[10px] font-bold uppercase tracking-wider" style="color: var(--text-muted);">
                                            {{ __($group) }}
                                        </h3>
                                        <div class="mt-2 space-y-1">
                                            @foreach($items as $item)
                                                <a href="{{ $item['url'] }}" 
                                                   wire:navigate
                                                   class="search-result-item group flex items-center gap-3 rounded-xl px-3 py-2.5 transition-smooth"
                                                   :class="{ 'bg-primary-light': selectedIndex === {{ $globalIndex }} }"
                                                   @mouseenter="selectedIndex = {{ $globalIndex }}"
                                                   style="background-color: selectedIndex === {{ $globalIndex }} ? 'var(--primary-light)' : 'transparent';">
                                                    <div class="flex h-10 w-10 flex-none items-center justify-center rounded-lg transition-colors" 
                                                         :style="selectedIndex === {{ $globalIndex }} ? 'background-color: var(--primary); color: white;' : 'background-color: var(--primary-light); color: var(--primary);'">
                                                        <i class="{{ $item['icon'] }} text-lg"></i>
                                                    </div>
                                                    <div class="flex-1 min-w-0">
                                                        <p class="text-sm font-semibold truncate text-dynamic transition-colors"
                                                           :class="{ 'text-primary': selectedIndex === {{ $globalIndex }} }">
                                                            {{ $item['title'] }}
                                                        </p>
                                                        <p class="text-xs truncate text-dynamic-muted">
                                                            {{ $item['subtitle'] }}
                                                        </p>
                                                    </div>
                                                    <i class="ph ph-caret-right text-xs text-dynamic-muted transition-all"
                                                       :class="{ 'opacity-100 translate-x-0': selectedIndex === {{ $globalIndex }}, 'opacity-0 -translate-x-1': selectedIndex !== {{ $globalIndex }} }"></i>
                                                </a>
                                                @php $globalIndex++; @endphp
                                            @endforeach
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                @else
                    <div class="px-6 py-14 text-center sm:px-14">
                        <div class="flex h-16 w-16 mx-auto items-center justify-center rounded-full bg-primary-light text-primary animate-pulse-soft">
                            <i class="ph ph-sparkle h-8 w-8"></i>
                        </div>
                        <p class="mt-4 text-sm font-medium text-dynamic">Type at least 2 characters to start searching...</p>
                        <p class="mt-1 text-xs text-dynamic-muted max-w-xs mx-auto text-center">Quickly find your services, domains, active tickets and historical invoices with our global search.</p>
                        
                        <div class="mt-8 flex flex-wrap justify-center gap-2">
                            <span class="px-3 py-1.5 rounded-lg text-[10px] font-bold border border-subtle transition-all cursor-pointer hover:border-primary hover:text-primary hover:bg-primary-light" @click="$wire.set('search', 'hosting'); $refs.searchInput.focus()">HOSTING</span>
                            <span class="px-3 py-1.5 rounded-lg text-[10px] font-bold border border-subtle transition-all cursor-pointer hover:border-primary hover:text-primary hover:bg-primary-light" @click="$wire.set('search', 'domain'); $refs.searchInput.focus()">DOMAIN</span>
                            <span class="px-3 py-1.5 rounded-lg text-[10px] font-bold border border-subtle transition-all cursor-pointer hover:border-primary hover:text-primary hover:bg-primary-light" @click="$wire.set('search', 'ticket'); $refs.searchInput.focus()">TICKET</span>
                        </div>
                    </div>
                @endif

                {{-- Footer --}}
                <div class="flex items-center justify-between px-6 py-4 text-[10px] font-bold uppercase tracking-widest text-dynamic-muted" style="background-color: var(--primary-light); opacity: 0.8;">
                    <div class="flex gap-6 items-center">
                        <span class="flex items-center gap-2">
                            <kbd class="px-1.5 py-1 rounded border border-subtle bg-card-bg shadow-sm text-[9px]">Enter</kbd> Select
                        </span>
                        <span class="flex items-center gap-2">
                            <kbd class="px-1.5 py-1 rounded border border-subtle bg-card-bg shadow-sm text-[9px]">↑↓</kbd> Navigate
                        </span>
                    </div>
                    <div class="flex items-center gap-2">
                        <i class="ph ph-command"></i>
                        <span>Control + K</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
