<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex items-center gap-3 md:gap-4 animate-in">
        <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl bg-primary-light">
            <i class="ph-duotone ph-receipt text-lg md:text-xl text-primary-color"></i>
        </div>
        <div>
            <h1 class="text-lg md:text-xl font-bold tracking-tight text-dynamic">@lang('Invoices')</h1>
            <p class="mt-0.5 text-sm text-dynamic-secondary">@lang('View and pay your invoices')</p>
        </div>
    </div>

    {{-- Summary Cards --}}
    <div class="grid gap-3 md:gap-4 sm:grid-cols-2">
        <x-client.card class="animate-in" padding="sm">
            <div class="flex items-center gap-3 md:gap-4">
                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-xl bg-warning-light">
                    <i class="ph-duotone ph-receipt text-base md:text-lg text-warning-color"></i>
                </div>
                <div>
                    <p class="text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Unpaid Invoices')</p>
                    <p class="text-lg md:text-xl font-black text-dynamic">{{ showAmount($totals['unpaid']) }}</p>
                </div>
            </div>
        </x-client.card>
        <x-client.card class="animate-in" padding="sm">
            <div class="flex items-center gap-3 md:gap-4">
                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-xl bg-danger-light">
                    <i class="ph-duotone ph-warning text-base md:text-lg text-danger-color"></i>
                </div>
                <div>
                    <p class="text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Overdue Amount')</p>
                    <p class="text-lg md:text-xl font-black text-dynamic">{{ showAmount($totals['overdue']) }}</p>
                </div>
            </div>
        </x-client.card>
    </div>

    {{-- Filters --}}
    <div class="flex flex-col gap-3 md:gap-4 sm:flex-row sm:items-center sm:justify-between animate-in">
        {{-- Search --}}
        <div class="w-full sm:max-w-xs">
            <x-client.input wire:model.live.debounce.300ms="search" type="text" placeholder="{{ __('Search invoices...') }}" prefixIcon="ph-magnifying-glass" />
        </div>

        {{-- Status Filter Pills --}}
        <div class="flex gap-2 overflow-x-auto -mx-4 px-4 md:mx-0 md:px-0 scrollbar-hide">
            @php
                $filters = ['' => ['label' => 'All', 'count' => $counts['all']], '1' => ['label' => 'Paid', 'count' => $counts['paid']], '2' => ['label' => 'Unpaid', 'count' => $counts['unpaid']], '3' => ['label' => 'Cancelled', 'count' => $counts['cancelled']]];
            @endphp
            @foreach($filters as $value => $filter)
                <button wire:click="$set('status', '{{ $value }}')" class="filter-pill {{ $status === $value ? 'filter-pill-active' : '' }}">
                    @lang($filter['label'])
                    <span class="text-2xs px-1.5 py-0.5 rounded-full {{ $status === $value ? 'bg-primary-light/30' : 'bg-primary-light/20' }}">{{ $filter['count'] }}</span>
                </button>
            @endforeach
        </div>
    </div>

    {{-- Mobile Card View --}}
    <div class="block lg:hidden space-y-3 md:space-y-4">
        {{-- Loading Skeleton --}}
        <div wire:loading.delay wire:target="search, status" class="space-y-3 md:space-y-4">
            @for($i = 0; $i < 3; $i++)
                <x-client.skeleton type="invoice-card" :delay="$i * 75" />
            @endfor
        </div>

        {{-- Actual Content --}}
        <div wire:loading.remove wire:target="search, status" class="space-y-3 md:space-y-4">
            @forelse($invoices as $index => $invoice)
                @php
                    $statusConfig = [1 => ['label' => 'Paid', 'type' => 'success'], 2 => ['label' => 'Unpaid', 'type' => 'warning'], 3 => ['label' => 'Cancelled', 'type' => 'secondary']];
                    $config = $statusConfig[$invoice->status] ?? $statusConfig[2];
                    $isOverdue = $invoice->status == 2 && $invoice->due_date && $invoice->due_date < now();
                @endphp
                <a href="{{ route('client.invoices.show', $invoice->id) }}" wire:navigate class="block animate-in" style="animation-delay: {{ $index * 50 }}ms;">
                    <x-client.card class="card-hover" padding="sm">
                        <div class="flex items-start justify-between mb-2 md:mb-3">
                            <div class="flex items-center gap-2 md:gap-3">
                                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-xl shrink-0 bg-primary-light">
                                    <i class="ph-duotone ph-receipt text-base md:text-lg text-primary-color"></i>
                                </div>
                                <div class="min-w-0">
                                    <p class="font-medium text-sm md:text-base truncate text-dynamic">#{{ $invoice->invoice_number }}</p>
                                    <p class="text-xs md:text-sm text-dynamic-secondary">{{ $invoice->created_at->format('M d, Y') }}</p>
                                </div>
                            </div>
                            <x-client.badge :type="$config['type']" size="sm">{{ __($config['label']) }}</x-client.badge>
                        </div>
                        <div class="flex items-center justify-between pt-2 md:pt-3 border-subtle" style="border-top-width: 1px;">
                            <div>
                                <p class="text-xs text-dynamic-muted">@lang('Due Date')</p>
                                <p class="text-xs md:text-sm font-medium {{ $isOverdue ? 'text-danger-color' : 'text-dynamic-secondary' }}">
                                    {{ $invoice->due_date ? $invoice->due_date->format('M d, Y') : 'N/A' }}
                                    @if($isOverdue) <span class="text-xs">({{ __('Overdue') }})</span> @endif
                                </p>
                            </div>
                            <div class="text-right">
                                <p class="text-[10px] font-bold uppercase tracking-widest text-dynamic-muted">@lang('Amount')</p>
                                <p class="text-base md:text-lg font-bold text-dynamic">{{ showAmount($invoice->total) }}</p>
                            </div>
                        </div>
                        @if($invoice->status == 2)
                            <div class="mt-2 md:mt-3 pt-2 md:pt-3 border-subtle" style="border-top-width: 1px;">
                                <span class="flex w-full items-center justify-center gap-2 px-4 py-2.5 rounded-xl text-xs md:text-sm font-medium bg-primary text-white">
                                    <i class="ph ph-credit-card"></i> @lang('Pay Now')
                                </span>
                            </div>
                        @endif
                    </x-client.card>
                </a>
            @empty
                <x-client.empty-state icon="ph-receipt" :title="__('No invoices found')" :description="__('You don\'t have any invoices yet.')" />
            @endforelse
        </div>
    </div>

    {{-- Desktop Table View --}}
    <x-client.card class="hidden lg:block animate-in overflow-hidden" padding="none">
        <div class="overflow-x-auto">
            <table class="min-w-full table-dynamic">
                <thead>
                    <tr class="bg-primary-light border-b border-subtle">
                        <th class="px-5 lg:px-8 py-4 text-left text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Invoice')</th>
                        <th class="px-5 lg:px-8 py-4 text-left text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Date')</th>
                        <th class="px-5 lg:px-8 py-4 text-left text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Due Date')</th>
                        <th class="px-5 lg:px-8 py-4 text-left text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Amount')</th>
                        <th class="px-5 lg:px-8 py-4 text-left text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Status')</th>
                        <th class="px-5 lg:px-8 py-4 text-right text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Actions')</th>
                    </tr>
                </thead>
                <tbody wire:loading.delay wire:target="search, status">
                    @for($i = 0; $i < 5; $i++)
                        <x-client.skeleton type="table-row" :delay="$i * 50" />
                    @endfor
                </tbody>
                <tbody wire:loading.remove wire:target="search, status">
                    @forelse($invoices as $invoice)
                        @php
                            $statusConfig = [1 => ['label' => 'Paid', 'type' => 'success'], 2 => ['label' => 'Unpaid', 'type' => 'warning'], 3 => ['label' => 'Cancelled', 'type' => 'secondary']];
                            $config = $statusConfig[$invoice->status] ?? $statusConfig[2];
                            $isOverdue = $invoice->status == 2 && $invoice->due_date && $invoice->due_date < now();
                        @endphp
                        <tr class="table-row-hover border-subtle group" style="border-bottom-width: 1px;">
                            <td class="whitespace-nowrap px-5 lg:px-8 py-4">
                                <a href="{{ route('client.invoices.show', $invoice->id) }}" wire:navigate class="font-bold text-primary-color transition-colors hover:opacity-80">#{{ $invoice->invoice_number }}</a>
                            </td>
                            <td class="whitespace-nowrap px-5 lg:px-8 py-4 text-sm text-dynamic-secondary">{{ $invoice->created_at->format('M d, Y') }}</td>
                            <td class="whitespace-nowrap px-5 lg:px-8 py-4 text-sm {{ $isOverdue ? 'font-bold text-danger-color' : 'text-dynamic-secondary' }}">
                                {{ $invoice->due_date ? $invoice->due_date->format('M d, Y') : 'N/A' }}
                                @if($isOverdue) <span class="ml-1 text-xs">({{ __('Overdue') }})</span> @endif
                            </td>
                            <td class="whitespace-nowrap px-5 lg:px-8 py-4 font-bold text-dynamic">{{ showAmount($invoice->total) }}</td>
                            <td class="whitespace-nowrap px-5 lg:px-8 py-4"><x-client.badge :type="$config['type']" size="sm">{{ __($config['label']) }}</x-client.badge></td>
                            <td class="whitespace-nowrap px-5 lg:px-8 py-4 text-right">
                                <div class="flex items-center justify-end gap-1">
                                    <x-client.button href="{{ route('client.invoices.show', $invoice->id) }}" variant="ghost" size="sm" iconOnly icon="ph-duotone ph-eye" title="{{ __('View') }}" />
                                    <x-client.button href="{{ route('client.invoices.download', $invoice->id) }}" variant="ghost" size="sm" iconOnly icon="ph-duotone ph-download-simple" title="{{ __('Download') }}" />
                                    @if($invoice->status == 2)
                                        <x-client.button href="{{ route('client.invoices.show', $invoice->id) }}" size="sm" iconOnly icon="ph-duotone ph-credit-card" title="{{ __('Pay Now') }}" />
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="px-6 py-12 text-center"><x-client.empty-state icon="ph-receipt" :title="__('No invoices found')" :description="__('You don\'t have any invoices yet.')" /></td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </x-client.card>

    {{-- Pagination --}}
    @if($invoices->hasPages())
        <div class="mt-4 md:mt-6 animate-in">{{ $invoices->links('vendor.livewire.novahost') }}</div>
    @endif
</div>
