@php
    $cs = clientAreaSettings();
    $invoiceDownloadEnabled = $cs['invoice_download'] ?? true;
@endphp

<div x-data="{ showPaymentModal: @entangle('showPaymentModal') }" class="space-y-4 md:space-y-6">
    @php
        $statusStyles = [
            1 => ['type' => 'success', 'icon' => 'ph-check-circle'],
            2 => ['type' => 'warning', 'icon' => 'ph-clock'],
            3 => ['type' => 'secondary', 'icon' => 'ph-x-circle'],
        ];
        $currentStatus = $statusStyles[$invoice->status] ?? $statusStyles[2];
    @endphp

    <nav class="flex items-center gap-2 text-xs md:text-sm animate-fade-in text-dynamic-secondary">
        <a href="{{ route('client.invoices') }}" wire:navigate class="transition-colors text-primary-color hover:opacity-80">@lang('Invoices')</a>
        <i class="ph-duotone ph-caret-right text-[10px] opacity-50"></i>
        <span class="text-dynamic font-medium">#{{ $invoice->invoice_number }}</span>
    </nav>

    @if(session('success'))
        <x-client.alert type="success" dismissible>
            <div class="flex items-center gap-2 md:gap-3">
                <i class="ph ph-check-circle text-lg md:text-xl shrink-0"></i>
                <p class="text-sm md:text-base">{{ session('success') }}</p>
            </div>
        </x-client.alert>
    @endif

    @if(session('error'))
        <x-client.alert type="danger" dismissible>
            <div class="flex items-center gap-2 md:gap-3">
                <i class="ph ph-warning text-lg md:text-xl shrink-0"></i>
                <p class="text-sm md:text-base">{{ session('error') }}</p>
            </div>
        </x-client.alert>
    @endif

    {{-- Header Card --}}
    <x-client.card class="animate-slide-up stagger-1">
        <div class="flex flex-col gap-3 md:gap-4 lg:flex-row lg:items-center lg:justify-between">
            <div class="flex items-start gap-3 md:gap-4">
                <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl shrink-0 bg-primary-light">
                    <i class="ph-duotone ph-receipt text-lg md:text-xl text-primary-color"></i>
                </div>
                <div class="min-w-0">
                    <div class="flex flex-wrap items-center gap-2 md:gap-3">
                        <h1 class="text-lg md:text-xl font-semibold text-dynamic">@lang('Invoice') #{{ $invoice->invoice_number }}</h1>
                        <x-client.badge :type="$currentStatus['type']" size="sm" :icon="$currentStatus['icon']">{{ __($statusConfig['label']) }}</x-client.badge>
                    </div>
                    <p class="mt-0.5 md:mt-1 text-xs md:text-sm text-dynamic-secondary">
                        @lang('Created') {{ $invoice->created_at->format('M d, Y') }}
                        @if($invoice->due_date)
                            <span class="mx-1 md:mx-2 opacity-50">•</span>
                            @lang('Due') {{ $invoice->due_date->format('M d, Y') }}
                        @endif
                    </p>
                </div>
            </div>
            <div class="flex flex-wrap gap-2 md:gap-3">
                @if($invoiceDownloadEnabled)
                    <x-client.button href="{{ route('client.invoices.view', $invoice->id) }}" target="_blank" variant="secondary" size="sm" icon="ph-eye">
                        <span class="hidden sm:inline">@lang('View PDF')</span>
                        <span class="sm:hidden">@lang('PDF')</span>
                    </x-client.button>
                    <x-client.button href="{{ route('client.invoices.download', $invoice->id) }}" variant="secondary" size="sm" icon="ph-download-simple">
                        @lang('Download')
                    </x-client.button>
                @endif
                @if($invoice->status == 2)
                    <x-client.button @click="showPaymentModal = true" size="sm" icon="ph-duotone ph-credit-card">
                        @lang('Pay Now')
                    </x-client.button>
                @endif
            </div>
        </div>
    </x-client.card>

    <div class="grid gap-4 md:gap-6 lg:grid-cols-3">
        {{-- Invoice Details --}}
        <div class="lg:col-span-2 space-y-4 md:space-y-6">
            <x-client.card class="animate-slide-up stagger-2 overflow-hidden" padding="none">
                {{-- Company & Client Info --}}
                <div class="grid gap-4 md:gap-6 p-5 md:p-8 sm:grid-cols-2 border-b border-subtle">
                    <div>
                        <h3 class="text-xs md:text-sm font-semibold uppercase tracking-wider text-dynamic-muted">@lang('From')</h3>
                        <p class="mt-2 text-base md:text-lg font-bold text-dynamic">{{ gs('site_name') ?? 'Salieno' }}</p>
                        <p class="text-sm text-dynamic-secondary">{{ gs('email') ?? 'support@example.com' }}</p>
                    </div>
                    <div class="sm:text-right">
                        <h3 class="text-xs md:text-sm font-semibold uppercase tracking-wider text-dynamic-muted">@lang('Bill To')</h3>
                        <p class="mt-2 text-base md:text-lg font-bold text-dynamic">{{ $invoice->user->fullname }}</p>
                        <p class="text-sm text-dynamic-secondary">{{ $invoice->user->email }}</p>
                        @if($invoice->user->address)
                            <p class="text-sm text-dynamic-muted">{{ $invoice->user->address }}</p>
                        @endif
                    </div>
                </div>

                {{-- Items Table --}}
                <div class="overflow-x-auto">
                    <table class="min-w-full">
                        <thead>
                            <tr class="bg-primary-light border-b border-subtle">
                                <th class="px-5 md:px-8 py-4 text-left text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Description')</th>
                                <th class="px-5 md:px-8 py-4 text-right text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Amount')</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y border-subtle">
                            {{-- Hosting Items (Grouped) --}}
                            @foreach($groupedItems['hosting'] as $hostingId => $items)
                                @php $hosting = $items->first()->hosting; @endphp
                                <tr class="bg-primary-light/5">
                                    <td colspan="2" class="px-5 md:px-8 py-3">
                                        <div class="flex items-center gap-2.5">
                                            <i class="ph-duotone ph-cube text-base text-primary-color"></i>
                                            <span class="text-xs font-bold uppercase tracking-wider text-dynamic">
                                                {{ $hosting?->product?->name ?? __('Hosting Service') }}
                                                @if($hosting?->domain)
                                                    <span class="mx-1 text-dynamic-muted">/</span> {{ $hosting->domain }}
                                                @endif
                                            </span>
                                        </div>
                                    </td>
                                </tr>
                                @foreach($items as $item)
                                    <tr>
                                        <td class="px-4 md:px-6 py-3 md:py-4 pl-8 md:pl-10">
                                            <p class="font-medium text-sm md:text-base" style="color: var(--text-primary);">{{ $item->description }}</p>
                                        </td>
                                        <td class="whitespace-nowrap px-4 md:px-6 py-3 md:py-4 text-right font-medium text-sm md:text-base" style="color: var(--text-primary);">
                                            {{ showAmount($item->amount) }}
                                        </td>
                                    </tr>
                                @endforeach
                            @endforeach

                            {{-- Domain Items (Grouped) --}}
                            @foreach($groupedItems['domain'] as $domainId => $items)
                                @php $domain = $items->first()->domain; @endphp
                                <tr class="bg-primary-light/5">
                                    <td colspan="2" class="px-5 md:px-8 py-3">
                                        <div class="flex items-center gap-2.5">
                                            <i class="ph-duotone ph-globe text-base text-primary-color"></i>
                                            <span class="text-xs font-bold uppercase tracking-wider text-dynamic">
                                                @lang('Domain') <span class="mx-1 text-dynamic-muted">/</span> {{ $domain?->domain ?? __('Domain') }}
                                            </span>
                                        </div>
                                    </td>
                                </tr>
                                @foreach($items as $item)
                                    <tr>
                                        <td class="px-4 md:px-6 py-3 md:py-4 pl-8 md:pl-10">
                                            <p class="font-medium text-sm md:text-base" style="color: var(--text-primary);">{{ $item->description }}</p>
                                        </td>
                                        <td class="whitespace-nowrap px-4 md:px-6 py-3 md:py-4 text-right font-medium text-sm md:text-base" style="color: var(--text-primary);">
                                            {{ showAmount($item->amount) }}
                                        </td>
                                    </tr>
                                @endforeach
                            @endforeach

                            {{-- Other Items --}}
                            @foreach($groupedItems['other'] as $item)
                                <tr>
                                    <td class="px-4 md:px-6 py-3 md:py-4">
                                        <p class="font-medium text-sm md:text-base" style="color: var(--text-primary);">{{ $item->description }}</p>
                                    </td>
                                    <td class="whitespace-nowrap px-4 md:px-6 py-3 md:py-4 text-right font-medium text-sm md:text-base" style="color: var(--text-primary);">
                                        {{ showAmount($item->amount) }}
                                    </td>
                                </tr>
                            @endforeach

                            @if($invoice->items->isEmpty())
                                <tr>
                                    <td colspan="2" class="px-4 md:px-6 py-6 md:py-8 text-center text-sm" style="color: var(--text-secondary);">
                                        @lang('No items found')
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>

                {{-- Totals Section --}}
                @php
                    // Recalculate Subtotal (Gross) = Paid Total + Discount - Tax - Late Fee
                    $displaySubtotal = $invoice->total + $invoice->discount - $invoice->tax - $invoice->late_fee;
                    
                    // Find coupon code
                    $viewCouponCode = null;
                    if($invoice->order && $invoice->order->coupon) {
                        $viewCouponCode = $invoice->order->coupon->code;
                    } else {
                        foreach($invoice->items as $it) {
                            if($it->hosting && $it->hosting->coupon) {
                                $viewCouponCode = $it->hosting->coupon->code;
                                break;
                            }
                        }
                    }
                @endphp
                <div class="bg-primary-light p-5 md:p-8 border-t border-subtle">
                    <div class="max-w-xs ml-auto space-y-3">
                        <div class="flex justify-between items-center text-sm">
                            <span class="text-dynamic-secondary">@lang('Subtotal')</span>
                            <span class="font-semibold text-dynamic">{{ showAmount($displaySubtotal) }}</span>
                        </div>
                        @if(($invoice->tax ?? 0) > 0)
                            <div class="flex justify-between items-center text-sm">
                                <span class="text-dynamic-secondary">@lang('Tax')</span>
                                <span class="font-semibold text-dynamic">{{ showAmount($invoice->tax) }}</span>
                            </div>
                        @endif
                        @if(($invoice->late_fee ?? 0) > 0)
                            <div class="flex justify-between items-center text-sm">
                                <span class="text-dynamic-secondary">@lang('Late Fee')</span>
                                <span class="font-semibold text-dynamic">{{ showAmount($invoice->late_fee) }}</span>
                            </div>
                        @endif
                        @if($invoice->discount > 0)
                            <div class="flex justify-between items-center text-sm">
                                <span class="text-dynamic-secondary">
                                    @lang('Discount')
                                    @if($viewCouponCode)
                                        <span class="ml-1 text-[10px] font-bold text-success-color uppercase tracking-wider">({{ $viewCouponCode }})</span>
                                    @endif
                                </span>
                                <span class="font-semibold text-success-color">-{{ showAmount($invoice->discount) }}</span>
                            </div>
                        @endif
                        <div class="pt-3 border-t border-subtle flex justify-between items-center">
                            <span class="text-lg font-bold text-dynamic">@lang('Total')</span>
                            <span class="text-xl font-black text-primary-color">{{ showAmount($invoice->total) }}</span>
                        </div>
                    </div>
                </div>
            </x-client.card>

            {{-- Payment History --}}
            @if($paymentHistory->count() > 0)
                <x-client.card class="animate-slide-up stagger-3">
                    <h3 class="mb-3 md:mb-4 font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Payment History')</h3>
                    <div class="space-y-2 md:space-y-3">
                        @foreach($paymentHistory as $payment)
                            <div class="flex items-center justify-between p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light/10 border border-success-color/10">
                                <div class="flex items-center gap-2 md:gap-3">
                                    <div class="flex h-8 w-8 md:h-10 md:w-10 items-center justify-center rounded-lg md:rounded-xl shrink-0 bg-success-light">
                                        <i class="ph-duotone ph-check-circle text-base md:text-lg text-success-color"></i>
                                    </div>
                                    <div class="min-w-0">
                                        <p class="font-bold text-sm md:text-base truncate text-dynamic">
                                            {{ $payment->gateway?->name ?? __('Wallet Payment') }}
                                        </p>
                                        <p class="text-xs text-dynamic-muted mt-0.5">
                                            {{ $payment->created_at->format('M d, Y H:i') }}
                                        </p>
                                    </div>
                                </div>
                                <div class="text-right shrink-0 ml-2">
                                    <p class="font-bold text-sm md:text-base text-success-color">{{ showAmount($payment->amount) }}</p>
                                    <p class="text-[10px] uppercase tracking-widest text-dynamic-muted">{{ $payment->trx }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </x-client.card>
            @endif
        </div>

        {{-- Sidebar --}}
        <div class="space-y-4 md:space-y-5">
            {{-- Payment Summary --}}
            <x-client.card class="animate-slide-up stagger-4" padding="sm">
                <h3 class="mb-3 md:mb-4 font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Payment Summary')</h3>
                <dl class="space-y-2 md:space-y-3 text-sm">
                    <div class="flex justify-between items-center">
                        <dt style="color: var(--text-secondary);">@lang('Status')</dt>
                        <dd><x-client.badge :type="$currentStatus['type']" size="sm">{{ __($statusConfig['label']) }}</x-client.badge></dd>
                    </div>
                    <div class="flex justify-between items-center">
                        <dt style="color: var(--text-secondary);">@lang('Amount Due')</dt>
                        <dd class="font-semibold" style="color: var(--text-primary);">{{ $invoice->status == 1 ? showAmount(0) : showAmount($invoice->total) }}</dd>
                    </div>
                    @if($invoice->date_paid)
                        <div class="flex justify-between items-center">
                            <dt style="color: var(--text-secondary);">@lang('Paid On')</dt>
                            <dd class="font-medium" style="color: var(--text-primary);">{{ $invoice->date_paid->format('M d, Y') }}</dd>
                        </div>
                    @endif
                </dl>

                @if($invoice->status == 2)
                    <div class="mt-3 md:mt-4 pt-3 md:pt-4" style="border-top: 1px solid var(--card-border);">
                        <x-client.button @click="showPaymentModal = true" fullWidth icon="ph-credit-card">@lang('Pay Now')</x-client.button>
                    </div>
                @endif
            </x-client.card>

            {{-- Your Balance --}}
            <x-client.card class="animate-slide-up stagger-5" padding="sm">
                <div class="mb-3 flex items-center gap-3">
                    <div class="flex h-10 w-10 items-center justify-center rounded-xl shrink-0 bg-success-light">
                        <i class="ph-duotone ph-wallet text-xl text-success-color"></i>
                    </div>
                    <div>
                        <p class="text-xs font-semibold uppercase tracking-wider text-dynamic-muted">@lang('Your Balance')</p>
                        <p class="font-bold text-lg text-dynamic">{{ showAmount(auth()->user()->balance) }}</p>
                    </div>
                </div>
                <a href="{{ route('client.deposits.add') }}" wire:navigate class="flex items-center gap-1.5 text-xs md:text-sm font-semibold text-primary-color transition-all hover:gap-2">
                    <i class="ph-bold ph-plus text-[10px]"></i>
                    @lang('Add Funds')
                </a>
            </x-client.card>

            @if($invoice->status == 2)
                <x-client.alert type="warning" class="animate-slide-up stagger-6">
                    <div class="flex items-start gap-2 md:gap-3">
                        <i class="ph ph-warning-circle text-lg md:text-xl shrink-0"></i>
                        <div>
                            <p class="font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Payment Required')</p>
                            <p class="mt-0.5 md:mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Please pay before the due date to avoid service interruption.')</p>
                        </div>
                    </div>
                </x-client.alert>
            @endif
        </div>
    </div>

    {{-- Payment Modal --}}
    <x-client.modal name="showPaymentModal" maxWidth="md">
        <div class="p-4 md:p-6">
            <div class="mb-4 md:mb-6 text-center">
                <div class="mx-auto mb-3 md:mb-4 flex h-12 w-12 md:h-14 md:w-14 items-center justify-center rounded-lg md:rounded-xl" style="background: var(--primary-light);">
                    <i class="ph ph-credit-card text-xl md:text-2xl" style="color: var(--primary);"></i>
                </div>
                <h3 class="text-base md:text-lg font-semibold" style="color: var(--text-primary);">@lang('Pay Invoice')</h3>
                <p class="mt-0.5 md:mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">#{{ $invoice->invoice_number }}</p>
            </div>

            <div class="mb-4 md:mb-6 p-3 md:p-4 rounded-lg md:rounded-xl text-center bg-primary-light border border-subtle">
                <p class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Amount to Pay')</p>
                <p class="text-xl md:text-2xl font-semibold" style="color: var(--text-primary);">{{ showAmount($invoice->total) }}</p>
            </div>

            <div class="space-y-2 md:space-y-3 max-h-60 md:max-h-80 overflow-y-auto pr-1 md:pr-2">
                {{-- Wallet Payment --}}
                @if($creditEnabled)
                <button wire:click="payWithWallet" wire:loading.attr="disabled" class="flex w-full items-center justify-between p-3 md:p-4 rounded-lg md:rounded-xl transition-colors touch-target" style="background: color-mix(in srgb, var(--success) 10%, transparent); border: 1px solid color-mix(in srgb, var(--success) 30%, transparent);">
                    <div class="flex items-center gap-2 md:gap-3">
                        <i class="ph ph-wallet text-lg md:text-xl" style="color: var(--success);"></i>
                        <div class="text-left">
                            <p class="font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Pay with Wallet')</p>
                            <p class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Balance'): {{ showAmount(auth()->user()->balance) }}</p>
                        </div>
                    </div>
                    <div class="flex items-center gap-2 shrink-0">
                        <span wire:loading wire:target="payWithWallet" class="animate-spin">
                            <i class="ph ph-spinner"></i>
                        </span>
                        <i wire:loading.remove wire:target="payWithWallet" class="ph ph-arrow-right" style="color: var(--success);"></i>
                    </div>
                </button>
                @endif

                {{-- Payment Gateways --}}
                @foreach($gateways as $gateway)
                    @foreach($gateway->currencies ?? [] as $currency)
                        <button wire:click="payWithGateway({{ $gateway->code }}, '{{ $currency->currency }}')" wire:loading.attr="disabled" class="flex w-full items-center justify-between p-3 md:p-4 rounded-lg md:rounded-xl transition-colors touch-target" style="background: var(--primary-light); border: 1px solid var(--card-border);">
                            <div class="flex items-center gap-2 md:gap-3">
                                @if($gateway->image)
                                    <img src="{{ getImage('assets/images/gateway/' . $gateway->image) }}" alt="{{ $gateway->name }}" class="h-7 w-7 md:h-8 md:w-8 object-contain rounded">
                                @else
                                    <div class="flex h-7 w-7 md:h-8 md:w-8 items-center justify-center rounded" style="background: var(--card-border);">
                                        <i class="ph ph-credit-card text-base md:text-lg" style="color: var(--text-muted);"></i>
                                    </div>
                                @endif
                                <div class="text-left">
                                    <p class="font-medium text-sm md:text-base" style="color: var(--text-primary);">{{ $gateway->name }}</p>
                                    <p class="text-xs" style="color: var(--text-secondary);">
                                        {{ $currency->currency }}
                                        @if($currency->fixed_charge > 0 || $currency->percent_charge > 0)
                                            <span class="ml-1">(+{{ showAmount($currency->fixed_charge) }} + {{ $currency->percent_charge }}%)</span>
                                        @endif
                                    </p>
                                </div>
                            </div>
                            <div class="flex items-center gap-2 shrink-0">
                                <span wire:loading wire:target="payWithGateway({{ $gateway->code }}, '{{ $currency->currency }}')" class="animate-spin">
                                    <i class="ph ph-spinner"></i>
                                </span>
                                <i wire:loading.remove wire:target="payWithGateway({{ $gateway->code }}, '{{ $currency->currency }}')" class="ph ph-arrow-right" style="color: var(--text-muted);"></i>
                            </div>
                        </button>
                    @endforeach
                @endforeach

                @if($gateways->isEmpty() && !gs('deposit_module'))
                    <div class="p-4 text-center rounded-lg md:rounded-xl" style="background: var(--primary-light);">
                        <i class="ph ph-warning-circle text-xl md:text-2xl mb-2" style="color: var(--text-muted);"></i>
                        <p class="text-sm" style="color: var(--text-secondary);">@lang('No payment methods available.')</p>
                    </div>
                @endif
            </div>

            <div class="mt-4 md:mt-6 flex justify-center">
                <x-client.button @click="showPaymentModal = false" variant="secondary">@lang('Cancel')</x-client.button>
            </div>
        </div>
    </x-client.modal>
</div>
