<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex items-center gap-3 md:gap-4 animate-fade-in">
        <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--primary-light);">
            <i class="ph ph-identification-card text-lg md:text-xl" style="color: var(--primary);"></i>
        </div>
        <div>
            <h1 class="text-lg md:text-xl font-semibold" style="color: var(--text-primary);">@lang('KYC Verification')</h1>
            <p class="mt-0.5 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Verify your identity to unlock all features')</p>
        </div>
    </div>

    {{-- Rejection Notice --}}
    @if($isRejected && $rejectionReason)
        <x-client.alert type="danger" class="animate-slide-up">
            <div class="flex items-start gap-2.5 md:gap-3">
                <i class="ph ph-warning-circle text-lg md:text-xl mt-0.5 shrink-0" style="color: var(--danger);"></i>
                <div>
                    <p class="text-sm md:text-base font-medium" style="color: var(--danger);">@lang('Your previous submission was rejected')</p>
                    <p class="mt-0.5 md:mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">{{ $rejectionReason }}</p>
                </div>
            </div>
        </x-client.alert>
    @endif

    <div class="grid gap-4 md:gap-6 lg:grid-cols-3 animate-slide-up">
        {{-- Form --}}
        <div class="lg:col-span-2">
            <x-client.card>
                <form wire:submit="submit" class="space-y-4 md:space-y-6">
                    {{-- Document Type --}}
                    @if(count($availableDocumentTypes) > 0)
                        <div class="space-y-1.5 md:space-y-2">
                            <label class="block text-xs md:text-sm font-medium" style="color: var(--text-primary);">@lang('Document Type') <span style="color: var(--danger);">*</span></label>
                            <div class="grid gap-2 md:gap-3 sm:grid-cols-{{ min(count($availableDocumentTypes), 3) }}">
                                @foreach($availableDocumentTypes as $type)
                                    @php
                                        $label = $this->documentTypeLabel[$type] ?? ucwords(str_replace('_', ' ', $type));
                                        $icons = [
                                            'passport' => 'ph-identification-badge',
                                            'id_card' => 'ph-identification-card',
                                            'drivers_license' => 'ph-car',
                                            'residence_permit' => 'ph-house',
                                            'utility_bill' => 'ph-file-text',
                                            'bank_statement' => 'ph-bank',
                                        ];
                                        $icon = $icons[$type] ?? 'ph-file';
                                    @endphp
                                    <label class="relative flex cursor-pointer items-center gap-2.5 md:gap-3 p-3 md:p-4 rounded-lg md:rounded-xl border-2 transition-colors touch-target" style="border-color: {{ $document_type === $type ? 'var(--primary)' : 'var(--card-border)' }}; background: {{ $document_type === $type ? 'var(--primary-light)' : 'var(--card-bg)' }};">
                                        <input type="radio" wire:model.live="document_type" value="{{ $type }}" class="sr-only" />
                                        <i class="ph {{ $icon }} text-lg md:text-xl" style="color: {{ $document_type === $type ? 'var(--primary)' : 'var(--text-muted)' }};"></i>
                                        <span class="text-sm md:text-base font-medium" style="color: {{ $document_type === $type ? 'var(--text-primary)' : 'var(--text-secondary)' }};">{{ $label }}</span>
                                    </label>
                                @endforeach
                            </div>
                            @error('document_type') <p class="text-xs md:text-sm" style="color: var(--danger);">{{ $message }}</p> @enderror
                        </div>
                    @endif

                    {{-- Dynamic Form Fields --}}
                    @if(count($formFields) > 0)
                        <div class="grid gap-3 md:gap-4" style="grid-template-columns: repeat(12, minmax(0, 1fr));">
                            @foreach($formFields as $index => $field)
                                @php
                                    $fieldName = $field['name'];
                                    $colSpan = 'grid-column: span ' . ($field['width'] ?? 12) . ' / span ' . ($field['width'] ?? 12);
                                @endphp
                                <div style="{{ $colSpan }};">
                                    <label class="block text-xs md:text-sm font-medium mb-1.5 md:mb-2" style="color: var(--text-primary);">
                                        {{ $field['label'] }}
                                        @if($field['is_required'] === 'required')
                                            <span style="color: var(--danger);">*</span>
                                        @endif
                                    </label>

                                    @if(!empty($field['instruction']))
                                        <p class="text-xs mb-1.5 md:mb-2" style="color: var(--text-muted);">{{ $field['instruction'] }}</p>
                                    @endif

                                    @switch($field['type'])
                                        @case('textarea')
                                            <x-client.input type="textarea" wire:model="formData.{{ $fieldName }}" rows="4" placeholder="{{ $field['label'] }}" />
                                            @break

                                        @case('select')
                                            <x-client.input type="select" wire:model="formData.{{ $fieldName }}">
                                                <option value="">@lang('Select') {{ $field['label'] }}</option>
                                                @foreach($field['options'] ?? [] as $option)
                                                    <option value="{{ $option }}">{{ $option }}</option>
                                                @endforeach
                                            </x-client.input>
                                            @break

                                        @case('checkbox')
                                            <div class="flex items-center gap-2">
                                                <input type="checkbox" wire:model="formData.{{ $fieldName }}" class="rounded" style="accent-color: var(--primary);" />
                                                <span class="text-xs md:text-sm" style="color: var(--text-secondary);">{{ $field['label'] }}</span>
                                            </div>
                                            @break

                                        @case('radio')
                                            <div class="flex flex-wrap gap-3 md:gap-4">
                                                @foreach($field['options'] ?? [] as $option)
                                                    <label class="flex items-center gap-2 cursor-pointer touch-target">
                                                        <input type="radio" wire:model="formData.{{ $fieldName }}" value="{{ $option }}" style="accent-color: var(--primary);" />
                                                        <span class="text-xs md:text-sm" style="color: var(--text-secondary);">{{ $option }}</span>
                                                    </label>
                                                @endforeach
                                            </div>
                                            @break

                                        @case('file')
                                            <div class="relative p-4 md:p-6 text-center border-2 border-dashed rounded-lg md:rounded-xl transition-colors" style="border-color: var(--card-border);">
                                                <input type="file" wire:model="fileUploads.{{ $fieldName }}" accept=".{{ str_replace(',', ',.', $field['extensions'] ?? 'jpg,jpeg,png,pdf') }}" class="absolute inset-0 cursor-pointer opacity-0" />
                                                @if(isset($fileUploads[$fieldName]) && $fileUploads[$fieldName])
                                                    @if(in_array($fileUploads[$fieldName]->getClientOriginalExtension(), ['jpg', 'jpeg', 'png', 'gif', 'webp']))
                                                        <img src="{{ $fileUploads[$fieldName]->temporaryUrl() }}" class="mx-auto h-24 md:h-32 rounded-lg object-cover" />
                                                    @else
                                                        <i class="ph ph-file text-2xl md:text-3xl" style="color: var(--success);"></i>
                                                        <p class="mt-1.5 md:mt-2 text-xs md:text-sm" style="color: var(--text-secondary);">{{ $fileUploads[$fieldName]->getClientOriginalName() }}</p>
                                                    @endif
                                                    <p class="mt-1.5 md:mt-2 text-xs md:text-sm" style="color: var(--success);">@lang('File selected')</p>
                                                @else
                                                    <i class="ph ph-upload-simple text-2xl md:text-3xl" style="color: var(--text-muted);"></i>
                                                    <p class="mt-1.5 md:mt-2 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Click or drag to upload')</p>
                                                    <p class="mt-0.5 md:mt-1 text-xs" style="color: var(--text-muted);">@lang('Allowed'): {{ strtoupper($field['extensions'] ?? 'JPG, PNG, PDF') }}</p>
                                                @endif
                                            </div>
                                            @error("fileUploads.{$fieldName}") <p class="text-xs md:text-sm mt-1" style="color: var(--danger);">{{ $message }}</p> @enderror
                                            @break

                                        @case('date')
                                            <x-client.input type="date" wire:model="formData.{{ $fieldName }}" />
                                            @break

                                        @case('datetime')
                                            <x-client.input type="datetime-local" wire:model="formData.{{ $fieldName }}" />
                                            @break

                                        @case('email')
                                            <x-client.input type="email" wire:model="formData.{{ $fieldName }}" placeholder="{{ $field['label'] }}" />
                                            @break

                                        @case('number')
                                            <x-client.input type="number" wire:model="formData.{{ $fieldName }}" placeholder="{{ $field['label'] }}" />
                                            @break

                                        @default
                                            <x-client.input type="text" wire:model="formData.{{ $fieldName }}" placeholder="{{ $field['label'] }}" />
                                    @endswitch

                                    @if($field['type'] !== 'file')
                                        @error("formData.{$fieldName}") <p class="text-xs md:text-sm mt-1" style="color: var(--danger);">{{ $message }}</p> @enderror
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-6 md:py-8" style="color: var(--text-muted);">
                            <i class="ph ph-info text-2xl md:text-3xl mb-2"></i>
                            <p class="text-xs md:text-sm">@lang('No additional fields required. Please select your document type and submit.')</p>
                        </div>
                    @endif

                    {{-- Submit --}}
                    <div class="flex justify-end pt-4 md:pt-6" style="border-top: 1px solid var(--card-border);">
                        <x-client.button type="submit" icon="ph-paper-plane-tilt" wireLoading="submit">@lang('Submit for Verification')</x-client.button>
                    </div>
                </form>
            </x-client.card>
        </div>

        {{-- Sidebar --}}
        <div class="space-y-3 md:space-y-4">
            <x-client.card class="sticky top-4 md:top-6">
                <h3 class="mb-3 md:mb-4 text-sm md:text-base font-medium" style="color: var(--text-primary);">@lang('Requirements')</h3>
                <ul class="space-y-2 md:space-y-3 text-xs md:text-sm" style="color: var(--text-secondary);">
                    <li class="flex items-start gap-2">
                        <i class="ph ph-check-circle mt-0.5 shrink-0" style="color: var(--success);"></i>
                        @lang('Document must be valid and not expired')
                    </li>
                    <li class="flex items-start gap-2">
                        <i class="ph ph-check-circle mt-0.5 shrink-0" style="color: var(--success);"></i>
                        @lang('All corners must be visible')
                    </li>
                    <li class="flex items-start gap-2">
                        <i class="ph ph-check-circle mt-0.5 shrink-0" style="color: var(--success);"></i>
                        @lang('Image must be clear and readable')
                    </li>
                    <li class="flex items-start gap-2">
                        <i class="ph ph-check-circle mt-0.5 shrink-0" style="color: var(--success);"></i>
                        @lang('Max file size: 10MB per file')
                    </li>
                </ul>
            </x-client.card>

            <div class="flex items-center gap-2.5 md:gap-3 p-3 md:p-4 rounded-lg md:rounded-xl" style="background: var(--primary-light); border: 1px solid var(--card-border);">
                <i class="ph ph-info text-lg md:text-xl shrink-0" style="color: var(--primary);"></i>
                <p class="text-xs md:text-sm font-medium" style="color: var(--text-secondary);">@lang('Verification usually takes 1-2 business days.')</p>
            </div>
        </div>
    </div>
</div>
