<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex items-center gap-3 md:gap-4 animate-fade-in">
        <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl shrink-0" style="background: var(--primary-light);">
            <i class="ph ph-shield-check text-lg md:text-xl" style="color: var(--primary);"></i>
        </div>
        <div>
            <h1 class="text-lg md:text-xl font-semibold" style="color: var(--text-primary);">@lang('KYC Status')</h1>
            <p class="mt-0.5 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('View your verification status')</p>
        </div>
    </div>

    <div class="mx-auto max-w-xl animate-slide-up">
        <x-client.card padding="lg" class="text-center">
            {{-- Status Icon --}}
            @php
                $colorMap = [
                    'gray' => ['bg' => 'var(--primary-light)', 'text' => 'var(--text-muted)'],
                    'amber' => ['bg' => 'var(--warning-light)', 'text' => 'var(--warning)'],
                    'emerald' => ['bg' => 'var(--success-light)', 'text' => 'var(--success)'],
                    'rose' => ['bg' => 'var(--danger-light)', 'text' => 'var(--danger)'],
                ];
                $colors = $colorMap[$statusConfig['color']] ?? $colorMap['gray'];
            @endphp
            <div class="mx-auto mb-4 md:mb-6 flex h-16 w-16 md:h-20 md:w-20 items-center justify-center rounded-xl md:rounded-2xl" style="background: {{ $colors['bg'] }};">
                <i class="ph {{ $statusConfig['icon'] }} text-3xl md:text-4xl" style="color: {{ $colors['text'] }};"></i>
            </div>

            {{-- Status Label --}}
            <h2 class="text-lg md:text-xl font-semibold" style="color: var(--text-primary);">{{ __($statusConfig['label']) }}</h2>
            <p class="mt-1.5 md:mt-2 text-sm md:text-base" style="color: var(--text-secondary);">{{ __($statusConfig['description']) }}</p>

            {{-- Rejection Reason --}}
            @if($kycStatus == 3 && $rejectionReason)
                <div class="mt-4 md:mt-6 rounded-lg md:rounded-xl p-3 md:p-4 text-left" style="background: var(--danger-light); border: 1px solid color-mix(in srgb, var(--danger) 20%, transparent);">
                    <div class="flex items-start gap-2.5 md:gap-3">
                        <i class="ph ph-warning-circle text-lg md:text-xl shrink-0" style="color: var(--danger);"></i>
                        <div>
                            <p class="text-sm md:text-base font-medium" style="color: var(--danger);">@lang('Rejection Reason')</p>
                            <p class="mt-0.5 md:mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">{{ $rejectionReason }}</p>
                        </div>
                    </div>
                </div>
            @endif

            {{-- Submission/Verification Dates --}}
            @if($submittedAt || $verifiedAt)
                <div class="mt-4 md:mt-6 flex flex-wrap justify-center gap-4 md:gap-6 text-xs md:text-sm" style="color: var(--text-muted);">
                    @if($submittedAt)
                        <div class="flex items-center gap-1.5 md:gap-2">
                            <i class="ph ph-calendar"></i>
                            <span>@lang('Submitted'): {{ $submittedAt->format('M d, Y') }}</span>
                        </div>
                    @endif
                    @if($verifiedAt)
                        <div class="flex items-center gap-1.5 md:gap-2">
                            <i class="ph ph-seal-check"></i>
                            <span>@lang('Verified'): {{ $verifiedAt->format('M d, Y') }}</span>
                        </div>
                    @endif
                </div>
            @endif

            {{-- Actions --}}
            <div class="mt-6 md:mt-8">
                @if($kycStatus == 0 || $kycStatus == 3)
                    <x-client.button href="{{ route('client.kyc') }}" icon="ph-identification-card">@lang('Submit KYC Documents')</x-client.button>
                @elseif($kycStatus == 2)
                    <x-client.alert type="warning">
                        <div class="flex items-center justify-center gap-2">
                            <i class="ph ph-spinner animate-spin"></i>
                            <span class="text-sm md:text-base font-medium">@lang('Review in progress...')</span>
                        </div>
                    </x-client.alert>
                @elseif($kycStatus == 1)
                    <x-client.alert type="success">
                        <p class="text-sm md:text-base font-medium">
                            <i class="ph ph-seal-check mr-1"></i>
                            @lang('Your account is fully verified')
                        </p>
                    </x-client.alert>
                @endif
            </div>
        </x-client.card>

        {{-- Timeline --}}
        <div class="mt-6 md:mt-8 animate-slide-up stagger-1">
            <h3 class="mb-3 md:mb-4 text-sm md:text-base font-medium" style="color: var(--text-primary);">@lang('Verification Steps')</h3>
            <div class="space-y-3 md:space-y-4">
                @php
                    $steps = [
                        ['label' => 'Submit Documents', 'completed' => $kycStatus >= 2],
                        ['label' => 'Under Review', 'completed' => $kycStatus == 1, 'active' => $kycStatus == 2],
                        ['label' => 'Verified', 'completed' => $kycStatus == 1],
                    ];
                @endphp
                @foreach($steps as $index => $step)
                    @php
                        $stepBg = $step['completed'] ? 'var(--success-light)' : (($step['active'] ?? false) ? 'var(--warning-light)' : 'var(--primary-light)');
                        $stepText = $step['completed'] ? 'var(--success)' : (($step['active'] ?? false) ? 'var(--warning)' : 'var(--text-muted)');
                    @endphp
                    <div class="flex items-center gap-3 md:gap-4">
                        <div class="flex h-9 w-9 md:h-10 md:w-10 shrink-0 items-center justify-center rounded-lg md:rounded-xl" style="background: {{ $stepBg }};">
                            @if($step['completed'])
                                <i class="ph ph-check text-base md:text-lg" style="color: var(--success);"></i>
                            @elseif($step['active'] ?? false)
                                <span class="text-xs md:text-sm font-semibold" style="color: var(--warning);">{{ $index + 1 }}</span>
                            @else
                                <span class="text-xs md:text-sm font-semibold" style="color: var(--text-muted);">{{ $index + 1 }}</span>
                            @endif
                        </div>
                        <div>
                            <p class="text-sm md:text-base font-medium" style="color: {{ $stepText }};">
                                {{ __($step['label']) }}
                            </p>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
