<div class="relative" x-data="{ open: @entangle('isOpen') }">
    {{-- Notification Bell Button --}}
    <button
        @click="open = !open"
        class="relative p-2.5 rounded-xl transition-smooth"
        style="color: var(--text-muted);"
        @mouseenter="$el.style.backgroundColor='var(--primary-light)'; $el.style.color='var(--text-secondary)'"
        @mouseleave="$el.style.backgroundColor='transparent'; $el.style.color='var(--text-muted)'"
    >
        <i class="ph ph-bell text-xl"></i>
        @if($this->unreadCount > 0)
            <span class="absolute top-1 right-1 flex h-2.5 w-2.5">
                <span class="absolute inline-flex h-full w-full animate-ping rounded-full opacity-75" style="background: var(--danger);"></span>
                <span class="relative inline-flex h-2.5 w-2.5 rounded-full" style="background: var(--danger);"></span>
            </span>
        @endif
    </button>

    {{-- Notifications Dropdown --}}
    <div
        x-show="open"
        x-transition:enter="transition ease-out duration-150"
        x-transition:enter-start="opacity-0 translate-y-2"
        x-transition:enter-end="opacity-100 translate-y-0"
        x-transition:leave="transition ease-in duration-100"
        x-transition:leave-start="opacity-100 translate-y-0"
        x-transition:leave-end="opacity-0 translate-y-2"
        @click.away="open = false"
        class="absolute right-0 top-full mt-2 w-80 sm:w-96 overflow-hidden rounded-2xl shadow-2xl z-50"
        style="background: var(--card-bg); border: 1px solid var(--card-border);"
        x-cloak
    >
        {{-- Header --}}
        <div class="flex items-center justify-between px-4 py-3" style="border-bottom: 1px solid var(--card-border);">
            <p class="text-sm font-semibold" style="color: var(--text-primary);">@lang('Notifications')</p>
            @if($this->unreadCount > 0)
                <span class="rounded-full px-2 py-0.5 text-[11px] font-semibold" style="background: var(--danger-light); color: var(--danger);">
                    {{ $this->unreadCount }} @lang('new')
                </span>
            @endif
        </div>

        {{-- Notifications List --}}
        <div class="max-h-[350px] overflow-y-auto">
            @forelse($this->notifications as $notification)
                <a
                    href="{{ $notification->action_url ?? '#' }}"
                    wire:click="markAsRead({{ $notification->id }})"
                    class="flex items-start gap-3 px-4 py-3 transition-all"
                    style="border-bottom: 1px solid var(--card-border); {{ !$notification->isRead() ? 'background: var(--primary-light);' : '' }}"
                    @mouseenter="$el.style.background='var(--primary-light)'"
                    @mouseleave="$el.style.background='{{ !$notification->isRead() ? 'var(--primary-light)' : 'transparent' }}'"
                >
                    <div class="flex h-9 w-9 shrink-0 items-center justify-center rounded-xl" style="background: var(--primary-light);">
                        <i class="ph {{ $this->getNotificationIcon($notification->type) }} text-base" style="color: {{ $this->getNotificationColor($notification->type) }};"></i>
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-medium truncate {{ !$notification->isRead() ? 'font-semibold' : '' }}" style="color: var(--text-primary);">
                            {{ $notification->title }}
                        </p>
                        <p class="text-xs truncate mt-0.5" style="color: var(--text-secondary);">{{ Str::limit($notification->message, 50) }}</p>
                        <p class="mt-1 text-[11px]" style="color: var(--text-muted);">{{ $notification->created_at->diffForHumans() }}</p>
                    </div>
                    @if(!$notification->isRead())
                        <span class="mt-2 h-2 w-2 shrink-0 rounded-full" style="background: var(--primary);"></span>
                    @endif
                </a>
            @empty
                <div class="px-4 py-10 text-center">
                    <div class="mx-auto mb-3 flex h-12 w-12 items-center justify-center rounded-xl" style="background: var(--primary-light);">
                        <i class="ph ph-bell-slash text-xl" style="color: var(--text-muted);"></i>
                    </div>
                    <p class="text-sm font-medium" style="color: var(--text-secondary);">@lang('No notifications')</p>
                    <p class="mt-1 text-xs" style="color: var(--text-muted);">@lang("You're all caught up!")</p>
                </div>
            @endforelse
        </div>

        {{-- Footer --}}
        @if($this->notifications->count() > 0)
            <div class="flex items-center justify-between px-4 py-3" style="border-top: 1px solid var(--card-border);">
                @if($this->unreadCount > 0)
                    <button
                        wire:click="markAllAsRead"
                        class="text-xs font-medium transition-colors"
                        style="color: var(--text-secondary);"
                        @mouseenter="$el.style.color='var(--primary)'"
                        @mouseleave="$el.style.color='var(--text-secondary)'"
                    >
                        @lang('Mark all as read')
                    </button>
                @else
                    <span></span>
                @endif
                <a
                    href="{{ route('client.notifications') }}"
                    wire:navigate
                    class="flex items-center gap-1.5 text-xs font-medium transition-colors"
                    style="color: var(--primary);"
                >
                    @lang('View all')
                    <i class="ph ph-arrow-right text-xs"></i>
                </a>
            </div>
        @endif
    </div>
</div>

