<div class="space-y-4 md:space-y-6 lg:space-y-8">
    {{-- Page Header --}}
    <div class="flex flex-col gap-3 md:gap-4 sm:flex-row sm:items-center sm:justify-between animate-fade-in">
        <div>
            <h1 class="text-xl md:text-2xl lg:text-3xl font-semibold tracking-tight" style="color: var(--text-primary);">@lang('Notifications')</h1>
            <p class="mt-0.5 md:mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">
                {{ $this->unreadCount }} @lang('unread notifications')
            </p>
        </div>
        <div class="flex items-center gap-2">
            @if($this->unreadCount > 0)
                <x-client.button wire:click="markAllAsRead" variant="secondary" size="sm">
                    <i class="ph ph-checks"></i>
                    @lang('Mark All Read')
                </x-client.button>
            @endif
            @if($notifications->count() > 0)
                <x-client.button wire:click="clearAll" wire:confirm="{{ __('Are you sure you want to clear all notifications?') }}" variant="ghost" size="sm">
                    <i class="ph ph-trash"></i>
                    @lang('Clear All')
                </x-client.button>
            @endif
        </div>
    </div>

    {{-- Filter Tabs --}}
    <div class="flex items-center gap-2 animate-slide-up">
        <button
            wire:click="$set('filter', 'all')"
            class="px-4 py-2 text-sm font-medium rounded-xl transition-all"
            style="{{ $filter === 'all' ? 'background: var(--primary); color: white;' : 'background: var(--primary-light); color: var(--text-secondary);' }}"
        >
            @lang('All')
        </button>
        <button
            wire:click="$set('filter', 'unread')"
            class="px-4 py-2 text-sm font-medium rounded-xl transition-all"
            style="{{ $filter === 'unread' ? 'background: var(--primary); color: white;' : 'background: var(--primary-light); color: var(--text-secondary);' }}"
        >
            @lang('Unread')
        </button>
        <button
            wire:click="$set('filter', 'read')"
            class="px-4 py-2 text-sm font-medium rounded-xl transition-all"
            style="{{ $filter === 'read' ? 'background: var(--primary); color: white;' : 'background: var(--primary-light); color: var(--text-secondary);' }}"
        >
            @lang('Read')
        </button>
    </div>

    {{-- Notifications List --}}
    <div class="space-y-2 animate-slide-up stagger-1">
        @forelse($notifications as $notification)
            <x-client.card padding="sm" class="{{ !$notification->isRead() ? 'ring-1' : '' }}" style="{{ !$notification->isRead() ? 'ring-color: var(--primary);' : '' }}">
                <div class="flex items-start gap-3 md:gap-4">
                    {{-- Icon --}}
                    <div class="flex h-10 w-10 md:h-12 md:w-12 shrink-0 items-center justify-center rounded-xl" style="background: var(--primary-light);">
                        <i class="ph {{ $this->getNotificationIcon($notification->type) }} text-lg md:text-xl" style="color: var(--primary);"></i>
                    </div>

                    {{-- Content --}}
                    <div class="flex-1 min-w-0">
                        <div class="flex items-start justify-between gap-2">
                            <div class="flex-1 min-w-0">
                                <h3 class="text-sm md:text-base font-medium truncate {{ !$notification->isRead() ? 'font-semibold' : '' }}" style="color: var(--text-primary);">
                                    {{ $notification->title }}
                                </h3>
                                <p class="text-xs md:text-sm mt-0.5" style="color: var(--text-secondary);">{{ $notification->message }}</p>
                                <p class="text-[11px] md:text-xs mt-1" style="color: var(--text-muted);">{{ $notification->created_at->diffForHumans() }}</p>
                            </div>

                            {{-- Actions --}}
                            <div class="flex items-center gap-1.5 shrink-0">
                                @if(!$notification->isRead())
                                    <button
                                        wire:click="markAsRead({{ $notification->id }})"
                                        class="p-1.5 rounded-lg transition-all"
                                        style="color: var(--text-muted);"
                                        title="@lang('Mark as read')"
                                    >
                                        <i class="ph ph-check text-base"></i>
                                    </button>
                                @endif
                                @if($notification->action_url)
                                    <a
                                        href="{{ $notification->action_url }}"
                                        wire:click="markAsRead({{ $notification->id }})"
                                        class="p-1.5 rounded-lg transition-all"
                                        style="color: var(--primary);"
                                        title="@lang('View')"
                                    >
                                        <i class="ph ph-arrow-right text-base"></i>
                                    </a>
                                @endif
                                <button
                                    wire:click="delete({{ $notification->id }})"
                                    class="p-1.5 rounded-lg transition-all"
                                    style="color: var(--text-muted);"
                                    title="@lang('Delete')"
                                >
                                    <i class="ph ph-x text-base"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </x-client.card>
        @empty
            <x-client.empty-state
                icon="ph-bell-slash"
                title="{{ __('No notifications') }}"
                description="{{ __('You\'re all caught up! No notifications to display.') }}"
            />
        @endforelse
    </div>

    {{-- Pagination --}}
    @if($notifications->hasPages())
        <div class="mt-4">
            {{ $notifications->links('vendor.livewire.novahost') }}
        </div>
    @endif
</div>

