<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex items-center gap-3 md:gap-4 animate-in">
        <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl shrink-0 bg-danger-light">
            <i class="ph ph-lock text-lg md:text-xl text-danger-color"></i>
        </div>
        <div>
            <h1 class="text-lg md:text-xl font-semibold text-dynamic">@lang('Change Password')</h1>
            <p class="mt-0.5 text-xs md:text-sm text-dynamic-secondary">@lang('Update your account password')</p>
        </div>
    </div>

    {{-- Navigation Tabs --}}
    <div class="flex overflow-x-auto gap-1.5 md:gap-2 pb-3 md:pb-4 -mx-4 px-4 md:mx-0 md:px-0 animate-in border-b border-subtle">
        <x-client.button href="{{ route('client.profile') }}" variant="soft" icon="ph-user" class="shrink-0">@lang('Profile')</x-client.button>
        <x-client.button href="{{ route('client.profile.password') }}" icon="ph-lock" class="shrink-0">@lang('Password')</x-client.button>
        <x-client.button href="{{ route('client.security') }}" variant="soft" icon="ph-shield-check" class="shrink-0">@lang('Security')</x-client.button>
    </div>

    @if(session('success'))
        <x-client.alert type="success" class="animate-in">{{ session('success') }}</x-client.alert>
    @endif

    <div class="max-w-xl animate-in">
        <x-client.card>
            <form wire:submit="save" class="space-y-4 md:space-y-6">
                {{-- Current Password --}}
                <div class="space-y-1.5 md:space-y-2">
                    <label for="current_password" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Current Password') <span class="text-danger-color">*</span></label>
                    <div class="relative" x-data="{ show: false }">
                        <x-client.input wire:model="current_password" x-bind:type="show ? 'text' : 'password'" id="current_password" />
                        <button type="button" @click="show = !show" class="absolute inset-y-0 right-0 flex items-center pr-3 md:pr-4 transition-colors text-dynamic-muted">
                            <i class="ph text-base md:text-lg" :class="show ? 'ph-eye-slash' : 'ph-eye'"></i>
                        </button>
                    </div>
                    @error('current_password') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                </div>

                {{-- New Password --}}
                <div class="space-y-1.5 md:space-y-2">
                    <label for="password" class="block text-xs md:text-sm font-medium text-dynamic">@lang('New Password') <span class="text-danger-color">*</span></label>
                    <div class="relative" x-data="{ show: false }">
                        <x-client.input wire:model="password" x-bind:type="show ? 'text' : 'password'" id="password" />
                        <button type="button" @click="show = !show" class="absolute inset-y-0 right-0 flex items-center pr-3 md:pr-4 transition-colors text-dynamic-muted">
                            <i class="ph text-base md:text-lg" :class="show ? 'ph-eye-slash' : 'ph-eye'"></i>
                        </button>
                    </div>
                    @error('password') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                </div>

                {{-- Confirm Password --}}
                <div class="space-y-1.5 md:space-y-2">
                    <label for="password_confirmation" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Confirm New Password') <span class="text-danger-color">*</span></label>
                    <div class="relative" x-data="{ show: false }">
                        <x-client.input wire:model="password_confirmation" x-bind:type="show ? 'text' : 'password'" id="password_confirmation" />
                        <button type="button" @click="show = !show" class="absolute inset-y-0 right-0 flex items-center pr-3 md:pr-4 transition-colors text-dynamic-muted">
                            <i class="ph text-base md:text-lg" :class="show ? 'ph-eye-slash' : 'ph-eye'"></i>
                        </button>
                    </div>
                </div>

                {{-- Password Requirements --}}
                <div class="p-3 md:p-4 rounded-xl bg-info-light border border-subtle">
                    <p class="text-xs md:text-sm font-medium text-dynamic">@lang('Password Requirements'):</p>
                    <ul class="mt-1.5 md:mt-2 space-y-1 text-xs md:text-sm text-dynamic-secondary">
                        <li class="flex items-center gap-1.5 md:gap-2"><i class="ph ph-check-circle text-success-color"></i> @lang('Minimum 6 characters')</li>
                        <li class="flex items-center gap-1.5 md:gap-2"><i class="ph ph-check-circle text-success-color"></i> @lang('Mix of letters and numbers recommended')</li>
                    </ul>
                </div>

                {{-- Submit --}}
                <div class="flex flex-col-reverse sm:flex-row sm:justify-end pt-4 md:pt-6 border-t border-subtle">
                    <x-client.button type="submit" icon="ph-lock" wireLoading="save">@lang('Update Password')</x-client.button>
                </div>
            </form>
        </x-client.card>
    </div>
</div>
