<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="animate-fade-in">
        <h1 class="text-lg md:text-2xl font-semibold tracking-tight" style="color: var(--text-primary);">@lang('Login History')</h1>
        <p class="mt-0.5 md:mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('View your recent login activity and session information')</p>
    </div>

    {{-- Mobile: Card View --}}
    <div class="md:hidden space-y-2 animate-slide-up">
        @forelse($loginHistory as $login)
            <x-client.card padding="sm" class="stagger-{{ $loop->index + 1 }}">
                <div class="flex items-start justify-between mb-2">
                    <div>
                        <p class="text-xs font-medium" style="color: var(--text-primary);">{{ $login->created_at->format('M d, Y') }}</p>
                        <p class="text-xs" style="color: var(--text-muted);">{{ $login->created_at->format('h:i A') }}</p>
                    </div>
                    <x-client.badge type="secondary" size="xs" icon="ph-globe">{{ $login->user_ip ?? 'N/A' }}</x-client.badge>
                </div>
                <div class="flex items-center justify-between text-xs" style="color: var(--text-secondary);">
                    <span class="flex items-center gap-1.5">
                        @if($login->city || $login->country)
                            @if($login->country_code)
                                <span>{{ country_flag($login->country_code) }}</span>
                            @endif
                            {{ $login->city ?? '' }}{{ $login->city && $login->country ? ', ' : '' }}{{ $login->country ?? '' }}
                        @else
                            <span style="color: var(--text-muted);">@lang('Unknown')</span>
                        @endif
                    </span>
                    <span>{{ $login->browser ?? 'Unknown' }}</span>
                </div>
            </x-client.card>
        @empty
            <x-client.empty-state icon="ph-clock-counter-clockwise" title="{{ __('No login history') }}" description="{{ __('Your login activity will appear here') }}" />
        @endforelse
    </div>

    {{-- Desktop: Table View --}}
    <div class="hidden md:block animate-slide-up">
        <x-client.card padding="none">
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead style="background: var(--primary-light);">
                        <tr>
                            <th class="px-4 md:px-6 py-3 md:py-4 text-left text-xs font-semibold uppercase tracking-wider" style="color: var(--text-secondary);">@lang('Date & Time')</th>
                            <th class="px-4 md:px-6 py-3 md:py-4 text-left text-xs font-semibold uppercase tracking-wider" style="color: var(--text-secondary);">@lang('IP Address')</th>
                            <th class="px-4 md:px-6 py-3 md:py-4 text-left text-xs font-semibold uppercase tracking-wider" style="color: var(--text-secondary);">@lang('Location')</th>
                            <th class="px-4 md:px-6 py-3 md:py-4 text-left text-xs font-semibold uppercase tracking-wider" style="color: var(--text-secondary);">@lang('Browser')</th>
                            <th class="px-4 md:px-6 py-3 md:py-4 text-left text-xs font-semibold uppercase tracking-wider" style="color: var(--text-secondary);">@lang('OS')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($loginHistory as $login)
                            <tr class="transition-colors" style="border-bottom: 1px solid var(--card-border);">
                                <td class="px-4 md:px-6 py-3 md:py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium" style="color: var(--text-primary);">{{ $login->created_at->format('M d, Y') }}</div>
                                    <div class="text-xs" style="color: var(--text-secondary);">{{ $login->created_at->format('h:i A') }}</div>
                                </td>
                                <td class="px-4 md:px-6 py-3 md:py-4 whitespace-nowrap">
                                    <x-client.badge type="secondary" size="sm" icon="ph-globe">{{ $login->user_ip ?? 'N/A' }}</x-client.badge>
                                </td>
                                <td class="px-4 md:px-6 py-3 md:py-4 whitespace-nowrap">
                                    @if($login->city || $login->country)
                                        <div class="flex items-center gap-2">
                                            @if($login->country_code)
                                                <span class="text-lg">{{ country_flag($login->country_code) }}</span>
                                            @endif
                                            <div>
                                                <div class="text-sm" style="color: var(--text-primary);">{{ $login->city ?? '' }}</div>
                                                <div class="text-xs" style="color: var(--text-secondary);">{{ $login->country ?? '' }}</div>
                                            </div>
                                        </div>
                                    @else
                                        <span class="text-sm" style="color: var(--text-muted);">@lang('Unknown')</span>
                                    @endif
                                </td>
                                <td class="px-4 md:px-6 py-3 md:py-4 whitespace-nowrap">
                                    <div class="flex items-center gap-2">
                                        <i class="ph ph-browser" style="color: var(--text-muted);"></i>
                                        <span class="text-sm" style="color: var(--text-secondary);">{{ $login->browser ?? 'Unknown' }}</span>
                                    </div>
                                </td>
                                <td class="px-4 md:px-6 py-3 md:py-4 whitespace-nowrap">
                                    <div class="flex items-center gap-2">
                                        <i class="ph ph-desktop" style="color: var(--text-muted);"></i>
                                        <span class="text-sm" style="color: var(--text-secondary);">{{ $login->os ?? 'Unknown' }}</span>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="px-6 py-12 text-center">
                                    <x-client.empty-state icon="ph-clock-counter-clockwise" title="{{ __('No login history') }}" description="{{ __('Your login activity will appear here') }}" />
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            @if($loginHistory->hasPages())
                <div class="px-4 md:px-6 py-3 md:py-4" style="border-top: 1px solid var(--card-border);">
                    {{ $loginHistory->links('vendor.livewire.novahost') }}
                </div>
            @endif
        </x-client.card>
    </div>

    {{-- Security Notice --}}
    <x-client.alert type="info" class="animate-slide-up stagger-2">
        <p class="font-medium">@lang('Security Notice')</p>
        <p class="mt-0.5 text-xs md:text-sm opacity-80">@lang('If you notice any suspicious login activity, please change your password immediately and enable two-factor authentication for added security.')</p>
    </x-client.alert>
</div>

