<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex items-center gap-3 md:gap-4 animate-in">
        <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl shrink-0 bg-info-light">
            <i class="ph ph-user-circle text-lg md:text-xl text-info-color"></i>
        </div>
        <div>
            <h1 class="text-lg md:text-xl font-semibold text-dynamic">@lang('Profile Settings')</h1>
            <p class="mt-0.5 text-xs md:text-sm text-dynamic-secondary">@lang('Manage your personal information')</p>
        </div>
    </div>

    {{-- Navigation Tabs --}}
    <div class="flex overflow-x-auto gap-1.5 md:gap-2 pb-3 md:pb-4 -mx-4 px-4 md:mx-0 md:px-0 animate-in border-b border-subtle">
        <x-client.button href="{{ route('client.profile') }}" icon="ph-user" class="shrink-0">@lang('Profile')</x-client.button>
        <x-client.button href="{{ route('client.profile.password') }}" variant="soft" icon="ph-lock" class="shrink-0">@lang('Password')</x-client.button>
        <x-client.button href="{{ route('client.security') }}" variant="soft" icon="ph-shield-check" class="shrink-0">@lang('Security')</x-client.button>
    </div>

    @if(session('success'))
        <x-client.alert type="success" class="animate-in">{{ session('success') }}</x-client.alert>
    @endif

    <div class="grid gap-4 md:gap-6 lg:grid-cols-3">
        {{-- Profile Photo Card --}}
        <div class="lg:col-span-1 animate-in">
            <x-client.card>
                <h3 class="mb-3 md:mb-4 font-medium text-sm md:text-base text-dynamic">@lang('Profile Photo')</h3>
                <div class="flex flex-col items-center">
                    {{-- Current Photo --}}
                    <div class="relative mb-3 md:mb-4">
                        @if($photo)
                            <img src="{{ $photo->temporaryUrl() }}" alt="Preview" class="h-24 w-24 md:h-28 md:w-28 rounded-full object-cover ring-4 ring-primary-light">
                        @elseif($currentPhoto)
                            <img src="{{ asset('storage/profile/' . $currentPhoto) }}" alt="{{ auth()->user()->fullname }}" class="h-24 w-24 md:h-28 md:w-28 rounded-full object-cover ring-4 ring-primary-light">
                        @else
                            <div class="flex h-24 w-24 md:h-28 md:w-28 items-center justify-center rounded-full text-2xl md:text-3xl font-bold bg-primary-light text-primary-color">
                                {{ strtoupper(substr(auth()->user()->firstname ?? 'U', 0, 1)) }}{{ strtoupper(substr(auth()->user()->lastname ?? '', 0, 1)) }}
                            </div>
                        @endif
                    </div>

                    {{-- Upload Input --}}
                    <div class="w-full space-y-2 md:space-y-3">
                        <label class="flex cursor-pointer items-center justify-center gap-2 rounded-xl px-3 md:px-4 py-2 md:py-2.5 text-xs md:text-sm font-medium transition-colors bg-primary-light text-primary-color hover:opacity-80">
                            <i class="ph ph-upload-simple"></i> @lang('Choose Photo')
                            <input type="file" wire:model="photo" accept="image/*" class="hidden">
                        </label>

                        @if($photo)
                            <x-client.button wire:click="uploadPhoto" icon="ph-check" wireLoading="uploadPhoto" fullWidth class="justify-center">@lang('Save Photo')</x-client.button>
                        @endif

                        @if($currentPhoto)
                            <x-client.button wire:click="removePhoto" wire:confirm="{{ __('Are you sure you want to remove your profile photo?') }}" variant="danger" icon="ph-trash" fullWidth class="justify-center">@lang('Remove Photo')</x-client.button>
                        @endif
                    </div>

                    @error('photo')
                        <p class="mt-1.5 md:mt-2 text-xs md:text-sm text-danger-color">{{ $message }}</p>
                    @enderror

                    <p class="mt-2 md:mt-3 text-center text-xs text-dynamic-muted">@lang('JPG, PNG or GIF. Max 2MB.')</p>
                </div>
            </x-client.card>
        </div>

        {{-- Profile Form --}}
        <div class="lg:col-span-2 animate-in">
            <x-client.card>
                <form wire:submit="save" class="space-y-4 md:space-y-6">
                    {{-- Name Fields --}}
                    <div class="grid gap-4 md:gap-6 sm:grid-cols-2">
                        <div class="space-y-1.5 md:space-y-2">
                            <label for="firstname" class="block text-xs md:text-sm font-medium text-dynamic">@lang('First Name') <span class="text-danger-color">*</span></label>
                            <x-client.input wire:model="firstname" type="text" id="firstname" />
                            @error('firstname') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                        </div>
                        <div class="space-y-1.5 md:space-y-2">
                            <label for="lastname" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Last Name') <span class="text-danger-color">*</span></label>
                            <x-client.input wire:model="lastname" type="text" id="lastname" />
                            @error('lastname') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                        </div>
                    </div>

                    {{-- Email (Read-only) --}}
                    <div class="space-y-1.5 md:space-y-2">
                        <label for="email" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Email Address')</label>
                        <x-client.input type="email" id="email" value="{{ auth()->user()->email }}" disabled suffixIcon="ph-lock-simple" />
                        <p class="text-xs md:text-sm text-dynamic-secondary">@lang('Email cannot be changed. Contact support if needed.')</p>
                    </div>

                    {{-- Phone --}}
                    <div class="grid gap-4 md:gap-6 sm:grid-cols-3">
                        <div class="space-y-1.5 md:space-y-2">
                            <label for="country_code" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Country Code')</label>
                            <x-client.input wire:model="country_code" type="text" id="country_code" placeholder="+1" />
                        </div>
                        <div class="space-y-1.5 md:space-y-2 sm:col-span-2">
                            <label for="mobile" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Phone Number')</label>
                            <x-client.input wire:model="mobile" type="text" id="mobile" placeholder="123-456-7890" />
                        </div>
                    </div>

                    {{-- Address --}}
                    <div class="space-y-1.5 md:space-y-2">
                        <label for="address" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Address')</label>
                        <x-client.input wire:model="address" type="text" id="address" placeholder="{{ __('Street address') }}" />
                    </div>

                    {{-- City, State, Zip --}}
                    <div class="grid gap-4 md:gap-6 sm:grid-cols-3">
                        <div class="space-y-1.5 md:space-y-2">
                            <label for="city" class="block text-xs md:text-sm font-medium text-dynamic">@lang('City')</label>
                            <x-client.input wire:model="city" type="text" id="city" />
                        </div>
                        <div class="space-y-1.5 md:space-y-2">
                            <label for="state" class="block text-xs md:text-sm font-medium text-dynamic">@lang('State/Province')</label>
                            <x-client.input wire:model="state" type="text" id="state" />
                        </div>
                        <div class="space-y-1.5 md:space-y-2">
                            <label for="zip" class="block text-xs md:text-sm font-medium text-dynamic">@lang('ZIP/Postal Code')</label>
                            <x-client.input wire:model="zip" type="text" id="zip" />
                        </div>
                    </div>

                    {{-- Country --}}
                    <div class="space-y-1.5 md:space-y-2">
                        <label for="country" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Country')</label>
                        <x-client.input wire:model="country" type="text" id="country" />
                    </div>

                    {{-- Company Details Section --}}
                    <div class="pt-4 md:pt-6 border-t border-subtle">
                        <h3 class="mb-3 md:mb-4 font-medium text-sm md:text-base text-dynamic">@lang('Company Details')</h3>
                        <p class="mb-3 md:mb-4 text-xs md:text-sm text-dynamic-secondary">@lang('Optional. Add your company information for invoices.')</p>

                        <div class="space-y-1.5 md:space-y-2">
                            <label for="company_name" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Company Name')</label>
                            <x-client.input wire:model="company_name" type="text" id="company_name" placeholder="{{ __('Your company name') }}" />
                            @error('company_name') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                        </div>
                    </div>

                    {{-- Submit --}}
                    <div class="flex flex-col-reverse sm:flex-row sm:justify-end pt-4 md:pt-6 border-t border-subtle">
                        <x-client.button type="submit" icon="ph-floppy-disk" wireLoading="save">@lang('Save Changes')</x-client.button>
                    </div>
                </form>
            </x-client.card>
        </div>
    </div>
</div>
