<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex items-center gap-3 md:gap-4 animate-in">
        <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl shrink-0 bg-success-light">
            <i class="ph-duotone ph-shield-check text-lg md:text-xl text-success-color"></i>
        </div>
        <div>
            <h1 class="text-lg md:text-xl font-semibold text-dynamic">@lang('Security Settings')</h1>
            <p class="mt-0.5 text-xs md:text-sm text-dynamic-secondary">@lang('Manage your account security')</p>
        </div>
    </div>

    {{-- Navigation Tabs --}}
    <div class="flex overflow-x-auto gap-1.5 md:gap-2 pb-3 md:pb-4 -mx-4 px-4 md:mx-0 md:px-0 animate-in border-subtle" style="border-bottom-width: 1px;">
        <x-client.button href="{{ route('client.profile') }}" variant="soft" icon="ph-user" class="shrink-0">@lang('Profile')</x-client.button>
        <x-client.button href="{{ route('client.profile.password') }}" variant="soft" icon="ph-lock" class="shrink-0">@lang('Password')</x-client.button>
        <x-client.button href="{{ route('client.security') }}" icon="ph-shield-check" class="shrink-0">@lang('Security')</x-client.button>
    </div>

    @if(session('success'))
        <x-client.alert type="success" class="animate-in">{{ session('success') }}</x-client.alert>
    @endif

    {{-- 2FA Section --}}
    <div class="max-w-2xl animate-in">
        <x-client.card>
            <div class="flex flex-col sm:flex-row sm:items-start gap-3 md:gap-4">
                <div class="flex h-10 w-10 md:h-12 md:w-12 shrink-0 items-center justify-center rounded-xl {{ $is2FAEnabled ? 'bg-success-light' : 'bg-primary-light' }}">
                    <i class="ph-duotone ph-shield-check text-lg md:text-xl {{ $is2FAEnabled ? 'text-success-color' : 'text-dynamic-muted' }}"></i>
                </div>
                <div class="flex-1">
                    <div class="flex flex-wrap items-center gap-2 md:gap-3">
                        <h3 class="font-medium text-sm md:text-base text-dynamic">@lang('Two-Factor Authentication')</h3>
                        @if($is2FAEnabled)
                            <x-client.badge type="success" size="sm">@lang('Enabled')</x-client.badge>
                        @else
                            <x-client.badge type="secondary" size="sm">@lang('Disabled')</x-client.badge>
                        @endif
                    </div>
                    <p class="mt-1.5 md:mt-2 text-xs md:text-sm text-dynamic-secondary">@lang('Add an extra layer of security to your account by requiring a verification code from your authenticator app.')</p>
                    <div class="mt-3 md:mt-4">
                        @if($is2FAEnabled)
                            <x-client.button wire:click="openDisableModal" variant="secondary">@lang('Disable 2FA')</x-client.button>
                        @else
                            <x-client.button wire:click="openSetupModal" icon="ph-shield-plus">@lang('Enable 2FA')</x-client.button>
                        @endif
                    </div>
                </div>
            </div>
        </x-client.card>
    </div>

    {{-- Active Sessions --}}
    <div class="max-w-2xl animate-in">
        <x-client.card>
            <div class="mb-3 md:mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between gap-2">
                <div class="flex items-center gap-2 md:gap-3">
                    <div class="flex h-8 w-8 md:h-10 md:w-10 items-center justify-center rounded-xl shrink-0 bg-info-light">
                        <i class="ph-duotone ph-devices text-base md:text-lg text-info-color"></i>
                    </div>
                    <div>
                        <h3 class="font-medium text-sm md:text-base text-dynamic">@lang('Active Sessions')</h3>
                        <p class="text-xs md:text-sm text-dynamic-secondary">@lang('Devices currently logged in')</p>
                    </div>
                </div>
                @if($activeSessions->count() > 1)
                    <x-client.button wire:click="logoutOtherSessions" wire:confirm="{{ __('Are you sure you want to log out all other sessions?') }}" wireLoading="logoutOtherSessions" variant="ghost" class="text-xs md:text-sm text-danger-color">@lang('Log out others')</x-client.button>
                @endif
            </div>
            <div class="space-y-2 md:space-y-3">
                @forelse($activeSessions as $session)
                    <div class="flex items-center justify-between p-3 md:p-4 rounded-xl {{ $session->is_current ? 'bg-success-light' : 'bg-primary-light' }} border-subtle" style="border-width: 1px;">
                        <div class="flex items-center gap-2 md:gap-3">
                            <div class="flex h-8 w-8 md:h-10 md:w-10 items-center justify-center rounded-lg shrink-0 {{ $session->is_current ? 'bg-success-light' : 'bg-primary-light' }}">
                                <i class="ph-duotone {{ str_contains(strtolower($session->user_agent ?? ''), 'mobile') ? 'ph-device-mobile' : 'ph-desktop' }} text-base md:text-lg {{ $session->is_current ? 'text-success-color' : 'text-dynamic-muted' }}"></i>
                            </div>
                            <div>
                                <p class="text-xs md:text-sm font-medium flex flex-wrap items-center gap-1.5 md:gap-2 text-dynamic">
                                    {{ $session->ip_address }}
                                    @if($session->is_current)
                                        <x-client.badge type="success" size="xs">@lang('Current')</x-client.badge>
                                    @endif
                                </p>
                                <p class="text-xs text-dynamic-secondary">@lang('Last active') {{ $session->last_activity->diffForHumans() }}</p>
                            </div>
                        </div>
                    </div>
                @empty
                    <p class="py-3 md:py-4 text-center text-xs md:text-sm text-dynamic-secondary">@lang('No active sessions found')</p>
                @endforelse
            </div>
        </x-client.card>
    </div>

    {{-- Login History --}}
    <div class="max-w-2xl animate-in">
        <x-client.card>
            <div class="mb-3 md:mb-4 flex items-center gap-2 md:gap-3">
                <div class="flex h-8 w-8 md:h-10 md:w-10 items-center justify-center rounded-xl shrink-0 bg-warning-light">
                    <i class="ph-duotone ph-clock-counter-clockwise text-base md:text-lg text-warning-color"></i>
                </div>
                <div>
                    <h3 class="font-medium text-sm md:text-base text-dynamic">@lang('Login History')</h3>
                    <p class="text-xs md:text-sm text-dynamic-secondary">@lang('Recent login activity')</p>
                </div>
            </div>
            {{-- Mobile: Card View --}}
            <div class="md:hidden space-y-2">
                @forelse($loginHistory as $login)
                    <div class="p-3 rounded-xl bg-primary-light border-subtle" style="border-width: 1px;">
                        <div class="flex items-center justify-between mb-2">
                            <span class="text-xs font-medium text-dynamic">{{ $login->created_at->format('M d, Y H:i') }}</span>
                            <span class="text-xs text-dynamic-secondary">{{ $login->user_ip }}</span>
                        </div>
                        <div class="flex items-center justify-between text-xs text-dynamic-muted">
                            <span>@if($login->city || $login->country){{ $login->city }}{{ $login->city && $login->country ? ', ' : '' }}{{ $login->country }}@else @lang('Unknown')@endif</span>
                            <span>{{ $login->browser ?? 'Unknown' }}</span>
                        </div>
                    </div>
                @empty
                    <p class="py-4 text-center text-xs text-dynamic-secondary">@lang('No login history found')</p>
                @endforelse
            </div>
            {{-- Desktop: Table View --}}
            <div class="hidden md:block overflow-x-auto">
                <table class="min-w-full table-dynamic">
                    <thead>
                        <tr class="border-subtle" style="border-bottom-width: 1px;">
                            <th class="py-3 text-left text-xs font-medium uppercase tracking-wider text-dynamic-secondary">@lang('Date')</th>
                            <th class="py-3 text-left text-xs font-medium uppercase tracking-wider text-dynamic-secondary">@lang('IP Address')</th>
                            <th class="py-3 text-left text-xs font-medium uppercase tracking-wider text-dynamic-secondary">@lang('Location')</th>
                            <th class="py-3 text-left text-xs font-medium uppercase tracking-wider text-dynamic-secondary">@lang('Device')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($loginHistory as $login)
                            <tr class="table-row-hover border-subtle" style="border-bottom-width: 1px;">
                                <td class="whitespace-nowrap py-3 text-sm text-dynamic">{{ $login->created_at->format('M d, Y H:i') }}</td>
                                <td class="whitespace-nowrap py-3 text-sm text-dynamic-secondary">{{ $login->user_ip }}</td>
                                <td class="whitespace-nowrap py-3 text-sm text-dynamic-secondary">@if($login->city || $login->country){{ $login->city }}{{ $login->city && $login->country ? ', ' : '' }}{{ $login->country }}@else<span class="text-dynamic-muted">@lang('Unknown')</span>@endif</td>
                                <td class="whitespace-nowrap py-3 text-sm text-dynamic-secondary">{{ $login->browser ?? 'Unknown' }} / {{ $login->os ?? 'Unknown' }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="4" class="py-8 text-center text-sm text-dynamic-secondary">@lang('No login history found')</td></tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </x-client.card>
    </div>

    {{-- Setup 2FA Modal --}}
    <x-client.modal :show="$showSetupModal" maxWidth="lg">
        @if(!$showRecoveryCodes)
            <h3 class="text-base md:text-lg font-medium text-dynamic">@lang('Enable Two-Factor Authentication')</h3>
            <div class="mt-4 md:mt-6 space-y-4 md:space-y-6">
                <div class="p-3 md:p-4 rounded-xl bg-primary-light border-subtle" style="border-width: 1px;">
                    <p class="text-xs md:text-sm text-dynamic-secondary">@lang('Scan this QR code with your authenticator app (Google Authenticator, Authy, etc.)')</p>
                    <div class="mt-3 md:mt-4 flex justify-center">
                        <div class="p-3 md:p-4 rounded-xl bg-white dark:bg-white border border-subtle dark:border-white/20">{!! $qrCodeSvg !!}</div>
                    </div>
                    <p class="mt-3 md:mt-4 text-center text-xs text-dynamic-muted">@lang('Or enter this code manually:')</p>
                    <div class="mt-2 flex items-center justify-center gap-2">
                        <code class="px-2 md:px-3 py-1.5 md:py-2 font-mono text-xs md:text-sm tracking-wider rounded-lg card-dynamic text-dynamic">{{ $secret }}</code>
                        <button type="button" onclick="navigator.clipboard.writeText('{{ $secret }}')" class="p-1.5 md:p-2 rounded-lg bg-primary-light hover:opacity-80 transition-colors">
                            <i class="ph ph-copy text-base md:text-lg text-primary-color"></i>
                        </button>
                    </div>
                </div>
                <div class="space-y-1.5 md:space-y-2">
                    <label for="code" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Verification Code')</label>
                    <x-client.input wire:model="code" type="text" id="code" maxlength="6" placeholder="000000" inputmode="numeric" pattern="[0-9]*" class="text-center text-lg md:text-xl font-semibold tracking-widest" />
                    @error('code') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                </div>
                <div class="flex flex-col-reverse sm:flex-row sm:justify-end gap-2 md:gap-3">
                    <x-client.button wire:click="closeSetupModal" variant="secondary">@lang('Cancel')</x-client.button>
                    <x-client.button wire:click="enable2FA" icon="ph-check" wireLoading="enable2FA">@lang('Verify & Enable')</x-client.button>
                </div>
            </div>
        @else
            <div class="flex items-center gap-2 md:gap-3 mb-4 md:mb-6">
                <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl shrink-0 bg-success-light">
                    <i class="ph ph-check-circle text-xl md:text-2xl text-success-color"></i>
                </div>
                <div>
                    <h3 class="text-base md:text-lg font-medium text-dynamic">@lang('2FA Enabled Successfully!')</h3>
                    <p class="text-xs md:text-sm text-dynamic-secondary">@lang('Save your recovery codes')</p>
                </div>
            </div>
            <x-client.alert type="warning" class="mb-4 md:mb-6">@lang('Store these recovery codes in a safe place. Each code can only be used once to sign in if you lose access to your authenticator app.')</x-client.alert>
            <div class="grid grid-cols-2 gap-1.5 md:gap-2 p-3 md:p-4 rounded-xl bg-primary-light border-subtle" style="border-width: 1px;">
                @foreach($recoveryCodes as $recoveryCode)
                    <code class="px-2 md:px-3 py-1.5 md:py-2 text-center font-mono text-xs md:text-sm rounded-lg card-dynamic text-dynamic">{{ $recoveryCode }}</code>
                @endforeach
            </div>
            <div class="flex flex-col-reverse sm:flex-row sm:justify-between gap-2 md:gap-3 mt-4 md:mt-6">
                <x-client.button type="button" onclick="navigator.clipboard.writeText('{{ implode('\n', $recoveryCodes) }}')" variant="secondary" icon="ph-copy">@lang('Copy Codes')</x-client.button>
                <x-client.button wire:click="finishSetup" icon="ph-check">@lang('Done')</x-client.button>
            </div>
        @endif
    </x-client.modal>

    {{-- Disable 2FA Modal --}}
    <x-client.modal :show="$showDisableModal" maxWidth="md">
        <h3 class="text-base md:text-lg font-medium text-dynamic">@lang('Disable Two-Factor Authentication')</h3>
        <div class="mt-4 md:mt-6 space-y-4 md:space-y-6">
            <x-client.alert type="warning">@lang('Disabling 2FA will make your account less secure.')</x-client.alert>
            <div class="space-y-1.5 md:space-y-2">
                <label for="disable-code" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Enter your 2FA code to confirm')</label>
                <x-client.input wire:model="code" type="text" id="disable-code" maxlength="6" placeholder="000000" class="text-center text-lg md:text-xl font-semibold tracking-widest" />
                @error('code') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
            </div>
            <div class="flex flex-col-reverse sm:flex-row sm:justify-end gap-2 md:gap-3">
                <x-client.button wire:click="closeDisableModal" variant="secondary">@lang('Cancel')</x-client.button>
                <x-client.button wire:click="disable2FA" wireLoading="disable2FA" variant="danger">@lang('Disable 2FA')</x-client.button>
            </div>
        </div>
    </x-client.modal>
</div>
