@php
    $cs = clientAreaSettings();
    $serviceCancellationEnabled = $cs['service_cancellation'] ?? true;
    $supportEnabled = isFeatureEnabled('support') && isMenuVisible('support');
@endphp

<div wire:init="loadData" x-data="{ showCancelModal: @entangle('showCancelModal'), showRenewModal: @entangle('showRenewModal'), showUpgradeModal: @entangle('showUpgradeModal'), showPasswordModal: @entangle('showPasswordModal') }" class="space-y-4 md:space-y-6">
    {{-- Breadcrumb --}}
    <nav class="flex items-center gap-2 text-xs md:text-sm animate-fade-in text-dynamic-muted">
        <a href="{{ route('client.services') }}" wire:navigate class="transition-all font-bold hover:text-primary-color">@lang('Services')</a>
        <i class="ph-bold ph-caret-right text-[10px] opacity-40"></i>
        <span class="text-dynamic font-bold tracking-tight">{{ $service->product->name ?? 'Service' }}</span>
    </nav>

    {{-- Success/Error Messages --}}
    @if(session('success'))
        <x-client.alert type="success" :autoDismiss="5000" class="animate-slide-up">
            {{ session('success') }}
        </x-client.alert>
    @endif

    @if(session('error'))
        <x-client.alert type="danger" :autoDismiss="5000" class="animate-slide-up">
            {{ session('error') }}
        </x-client.alert>
    @endif

    {{-- Header Card --}}
    @php
        $statusType = match($statusConfig['color']) {
            'success' => 'success',
            'warning' => 'warning',
            'danger' => 'danger',
            default => 'secondary',
        };
    @endphp
    <x-client.card class="animate-slide-up stagger-1">
        <div class="flex flex-col gap-4 lg:flex-row lg:items-center lg:justify-between">
            <div class="flex items-start gap-3 md:gap-4">
                @php
                    $icon = match($productType) {
                        1 => 'ph-duotone ph-globe',
                        2 => 'ph-duotone ph-stack',
                        3 => 'ph-duotone ph-monitor',
                        default => 'ph-duotone ph-cube',
                    };
                @endphp
                <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl bg-primary-light">
                    <i class="{{ $icon }} text-lg md:text-xl text-primary-color"></i>
                </div>
                <div>
                    <h1 class="text-lg md:text-xl font-bold tracking-tight text-dynamic">{{ $service->product->name ?? 'N/A' }}</h1>
                    @if($service->domain)
                        <p class="mt-0.5 md:mt-1 text-sm font-medium text-dynamic-secondary">{{ $service->domain }}</p>
                    @endif
                </div>
            </div>
            <div class="grid grid-cols-2 sm:flex sm:flex-wrap items-center gap-2 md:gap-3 items-stretch sm:items-center">
                <x-client.badge :type="$statusType" size="md" class="flex items-center justify-center col-span-2 sm:col-span-1">{{ __($statusConfig['label']) }}</x-client.badge>
                @if($service->status === 1)
                    <x-client.button @click="showRenewModal = true" variant="secondary" size="md" icon="ph-arrows-clockwise" class="sm:btn-sm">
                        @lang('Renew')
                    </x-client.button>
                @endif
                @if($service->status === 1 && $service->server)
                    <x-client.button wire:click="loginToControlPanel" wireLoading="loginToControlPanel" size="md" icon="{{ $loginButtonIcon }}" class="sm:btn-sm">
                        {{ $loginButtonLabel }}
                    </x-client.button>
                    <x-client.button @click="showPasswordModal = true" variant="secondary" size="md" icon="ph-key" class="sm:btn-sm">
                        @lang('Password')
                    </x-client.button>
                @endif
            </div>
        </div>
    </x-client.card>

    <div class="grid gap-4 md:gap-6 lg:grid-cols-3">
        {{-- Main Content --}}
        <div class="space-y-4 md:space-y-6 lg:col-span-2">
            {{-- Usage Stats --}}
            @if($service->status === 1 && $service->server)
                <div class="flex items-center justify-between mb-3">
                    <h3 class="text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Resource Usage')</h3>
                    <button wire:click="syncWithServer" wire:loading.attr="disabled" class="flex items-center gap-1.5 text-xs font-bold text-primary-color transition-all hover:opacity-80 disabled:opacity-50">
                        <i class="ph-duotone ph-arrows-clockwise {{ $isSyncing ? 'animate-spin' : '' }}"></i>
                        <span>{{ $isSyncing ? __('Syncing...') : __('Sync from Server') }}</span>
                    </button>
                </div>
                
                <div class="grid gap-3 md:gap-4 sm:grid-cols-2">
                    @if(!$isLoaded)
                        {{-- Disk Usage Skeleton --}}
                        <div class="animate-pulse flex flex-col gap-3 p-4 rounded-xl" style="background: var(--card-bg); border: 1px solid var(--card-border);">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center gap-3">
                                    <div class="h-10 w-10 rounded-xl" style="background: var(--border-subtle);"></div>
                                    <div class="h-4 w-24 rounded" style="background: var(--border-subtle);"></div>
                                </div>
                                <div class="h-4 w-8 rounded" style="background: var(--border-subtle);"></div>
                            </div>
                            <div class="h-2 w-full rounded-full" style="background: var(--border-subtle);"></div>
                        </div>
                        {{-- Bandwidth Skeleton --}}
                        <div class="animate-pulse flex flex-col gap-3 p-4 rounded-xl" style="background: var(--card-bg); border: 1px solid var(--card-border);">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center gap-3">
                                    <div class="h-10 w-10 rounded-xl" style="background: var(--border-subtle);"></div>
                                    <div class="h-4 w-24 rounded" style="background: var(--border-subtle);"></div>
                                </div>
                                <div class="h-4 w-8 rounded" style="background: var(--border-subtle);"></div>
                            </div>
                            <div class="h-2 w-full rounded-full" style="background: var(--border-subtle);"></div>
                        </div>
                    @else
                        @if($diskUsage !== null)
                            @php $diskWarning = $diskUsage >= 80; @endphp
                            <x-client.card class="animate-slide-up stagger-2" padding="sm">
                                <div class="flex items-center justify-between mb-3 md:mb-4">
                                    <div class="flex items-center gap-2 md:gap-3">
                                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-{{ $diskWarning ? 'warning' : 'primary' }}-light">
                                            <i class="ph-duotone ph-hard-drives text-base md:text-lg text-{{ $diskWarning ? 'warning' : 'primary' }}-color"></i>
                                        </div>
                                        <span class="font-bold text-sm md:text-base text-dynamic">@lang('Disk Usage')</span>
                                    </div>
                                    <span class="text-sm font-black text-{{ $diskWarning ? 'warning' : 'primary' }}-color">{{ $diskUsage }}%</span>
                                </div>
                                <div class="h-2.5 overflow-hidden rounded-full bg-primary-light/30">
                                    <div class="h-full rounded-full transition-all duration-700 ease-out" style="width: {{ min($diskUsage, 100) }}%; background: {{ $diskWarning ? 'var(--warning)' : 'var(--primary)' }};"></div>
                                </div>
                                @if(isset($accountSummary['disk_used']) && isset($accountSummary['disk_limit']))
                                    <p class="mt-2.5 text-xs font-medium text-dynamic-secondary">{{ $accountSummary['disk_used'] }} / {{ $accountSummary['disk_limit'] }}</p>
                                @endif
                            </x-client.card>
                        @endif

                        @if($bandwidthUsage !== null)
                            @php $bwWarning = $bandwidthUsage >= 80; @endphp
                            <x-client.card class="animate-slide-up stagger-3" padding="sm">
                                <div class="flex items-center justify-between mb-3 md:mb-4">
                                    <div class="flex items-center gap-2 md:gap-3">
                                        <div class="flex h-10 w-10 items-center justify-center rounded-xl bg-{{ $bwWarning ? 'warning' : 'primary' }}-light">
                                            <i class="ph-duotone ph-chart-line-up text-base md:text-lg text-{{ $bwWarning ? 'warning' : 'primary' }}-color"></i>
                                        </div>
                                        <span class="font-bold text-sm md:text-base text-dynamic">@lang('Bandwidth')</span>
                                    </div>
                                    <span class="text-sm font-black text-{{ $bwWarning ? 'warning' : 'primary' }}-color">{{ $bandwidthUsage }}%</span>
                                </div>
                                <div class="h-2.5 overflow-hidden rounded-full bg-primary-light/30">
                                    <div class="h-full rounded-full transition-all duration-700 ease-out" style="width: {{ min($bandwidthUsage, 100) }}%; background: {{ $bwWarning ? 'var(--warning)' : 'var(--primary)' }};"></div>
                                </div>
                                @if(isset($accountSummary['bandwidth_used']) && isset($accountSummary['bandwidth_limit']))
                                    <p class="mt-2.5 text-xs font-medium text-dynamic-secondary">{{ $accountSummary['bandwidth_used'] }} / {{ $accountSummary['bandwidth_limit'] }}</p>
                                @endif
                            </x-client.card>
                        @endif
                    @endif
                </div>
            @endif

            {{-- Service Details Card --}}
            <x-client.card class="animate-slide-up stagger-4">
                <h3 class="mb-4 text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Service Details')</h3>
                <dl class="grid gap-3 md:gap-4 sm:grid-cols-2">
                    <div class="p-3 md:p-4 rounded-xl bg-primary-light border border-subtle">
                        <dt class="text-[11px] font-bold uppercase tracking-wide text-dynamic-muted">@lang('Product')</dt>
                        <dd class="mt-1.5 font-bold text-sm md:text-base text-dynamic">{{ $service->product->name ?? 'N/A' }}</dd>
                    </div>
                    @if($productType == 1) {{-- Shared --}}
                        <div class="p-3 md:p-4 rounded-xl bg-primary-light border border-subtle">
                            <dt class="text-[11px] font-bold uppercase tracking-wide text-dynamic-muted">@lang('Domain')</dt>
                            <dd class="mt-1.5 font-bold text-sm md:text-base text-dynamic truncate">{{ $service->domain ?? 'N/A' }}</dd>
                        </div>
                    @elseif($productType == 2) {{-- Reseller --}}
                        <div class="p-3 md:p-4 rounded-xl bg-primary-light border border-subtle">
                            <dt class="text-[11px] font-bold uppercase tracking-wide text-dynamic-muted">@lang('Primary Domain')</dt>
                            <dd class="mt-1.5 font-bold text-sm md:text-base text-dynamic truncate">{{ $service->domain ?? 'N/A' }}</dd>
                        </div>
                    @elseif($productType == 3) {{-- VPS/Server --}}
                        <div class="p-3 md:p-4 rounded-xl bg-primary-light border border-subtle">
                            <dt class="text-[11px] font-bold uppercase tracking-wide text-dynamic-muted">@lang('Hostname')</dt>
                            <dd class="mt-1.5 font-bold text-sm md:text-base text-dynamic truncate">{{ $service->domain ?? 'N/A' }}</dd>
                        </div>
                    @elseif($service->domain) {{-- Other with domain --}}
                        <div class="p-3 md:p-4 rounded-xl bg-primary-light border border-subtle">
                            <dt class="text-[11px] font-bold uppercase tracking-wide text-dynamic-muted">@lang('Domain')</dt>
                            <dd class="mt-1.5 font-bold text-sm md:text-base text-dynamic truncate">{{ $service->domain }}</dd>
                        </div>
                    @endif
                    <div class="p-3 md:p-4 rounded-xl bg-primary-light border border-subtle">
                        <dt class="text-[11px] font-bold uppercase tracking-wide text-dynamic-muted">@lang('Registration Date')</dt>
                        <dd class="mt-1.5 font-bold text-sm md:text-base text-dynamic">{{ $service->reg_date ? $service->reg_date->format('M d, Y') : 'N/A' }}</dd>
                    </div>
                    <div class="p-3 md:p-4 rounded-xl bg-primary-light border border-subtle">
                        <dt class="text-[11px] font-bold uppercase tracking-wide text-dynamic-muted">@lang('Recurring Amount')</dt>
                        <dd class="mt-1.5 font-bold text-sm md:text-base text-primary-color">{{ $formattedPrice }}</dd>
                    </div>
                    <div class="p-3 md:p-4 rounded-xl bg-primary-light border border-subtle">
                        <dt class="text-[11px] font-bold uppercase tracking-wide text-dynamic-muted">@lang('Next Due Date')</dt>
                        <dd class="mt-1.5 font-bold text-sm md:text-base text-dynamic">{{ $service->next_due_date ? $service->next_due_date->format('M d, Y') : 'N/A' }}</dd>
                    </div>
                    <div class="p-3 md:p-4 rounded-xl bg-primary-light border border-subtle">
                        <dt class="text-[11px] font-bold uppercase tracking-wide text-dynamic-muted">@lang('Billing Cycle')</dt>
                        <dd class="mt-1.5 font-bold text-sm md:text-base text-dynamic">{{ ucfirst($service->billing_cycle ?? 'monthly') }}</dd>
                    </div>
                </dl>
            </x-client.card>

            {{-- Configurable Options --}}
            @if($service->configs && $service->configs->count() > 0)
                <x-client.card class="animate-slide-up stagger-5">
                    <h3 class="mb-4 text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Configuration Options')</h3>
                    <dl class="grid gap-3 md:gap-4 sm:grid-cols-2">
                        @foreach($service->configs as $config)
                            @if($config->select && $config->subOption)
                                <div class="p-3 md:p-4 rounded-xl bg-primary-light border border-subtle">
                                    <dt class="text-[11px] font-bold uppercase tracking-wide text-dynamic-muted">{{ $config->select->name }}</dt>
                                    <dd class="mt-1.5 font-bold text-sm md:text-base text-dynamic">{{ $config->subOption->name }}</dd>
                                    @if($config->price > 0)
                                        <dd class="mt-1 text-xs font-bold text-primary-color/70">+{{ showAmount($config->price) }}</dd>
                                    @endif
                                </div>
                            @endif
                        @endforeach
                    </dl>
                </x-client.card>
            @endif

            {{-- Server Details --}}
            @if($service->server)
                <x-client.card class="animate-slide-up stagger-6">
                    <h3 class="mb-3 md:mb-4 font-bold text-sm md:text-base text-dynamic">@lang('Server Information')</h3>
                    <dl class="grid gap-3 md:gap-4 sm:grid-cols-2">
                        <div class="p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light border border-subtle">
                            <dt class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Server')</dt>
                            <dd class="mt-1 font-medium text-sm md:text-base" style="color: var(--text-primary);">{{ $service->server->name ?? 'N/A' }}</dd>
                        </div>
                        @if($productType == 1 || $productType == 2)
                            <div class="p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light border border-subtle">
                                <dt class="text-xs md:text-sm" style="color: var(--text-secondary);">{{ $productType == 2 ? __('Reseller Username') : __('Username') }}</dt>
                                <dd class="mt-1 flex items-center justify-between gap-2 font-medium text-sm md:text-base" style="color: var(--text-primary);">
                                    <span class="font-mono break-all">{{ $service->username ?? 'N/A' }}</span>
                                    @if($service->username)
                                        <button onclick="navigator.clipboard.writeText('{{ $service->username }}'); this.querySelector('i').classList.replace('ph-copy', 'ph-check'); setTimeout(() => this.querySelector('i').classList.replace('ph-check', 'ph-copy'), 1500);" class="p-2 rounded-lg transition-colors touch-target shrink-0 flex items-center justify-center" style="color: var(--text-muted); background: var(--border-subtle);" title="@lang('Copy')">
                                            <i class="ph ph-copy text-sm md:text-base"></i>
                                        </button>
                                    @endif
                                </dd>
                            </div>
                        @elseif($productType == 4 && $service->username)
                            <div class="p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light border border-subtle">
                                <dt class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Username')</dt>
                                <dd class="mt-1 flex items-center gap-2 font-medium text-sm md:text-base" style="color: var(--text-primary);">
                                    <span class="font-mono">{{ $service->username }}</span>
                                    <button onclick="navigator.clipboard.writeText('{{ $service->username }}'); this.querySelector('i').classList.replace('ph-copy', 'ph-check'); setTimeout(() => this.querySelector('i').classList.replace('ph-check', 'ph-copy'), 1500);" class="p-1.5 rounded-lg transition-colors touch-target" style="color: var(--text-muted);" title="@lang('Copy')">
                                        <i class="ph ph-copy text-sm"></i>
                                    </button>
                                </dd>
                            </div>
                        @endif
                        @if($productType == 3 && $service->password)
                            <div class="p-3 md:p-4 rounded-lg md:rounded-xl" style="background: var(--primary-light);">
                                <dt class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Root Password')</dt>
                                <dd class="mt-1 flex items-center gap-2 font-medium text-sm md:text-base" style="color: var(--text-primary);">
                                    <span class="font-mono">••••••••</span>
                                    <button onclick="navigator.clipboard.writeText('{{ $service->password }}'); this.querySelector('i').classList.replace('ph-copy', 'ph-check'); setTimeout(() => this.querySelector('i').classList.replace('ph-check', 'ph-copy'), 1500);" class="p-1.5 rounded-lg transition-colors touch-target" style="color: var(--text-muted);" title="@lang('Copy')">
                                        <i class="ph ph-copy text-sm"></i>
                                    </button>
                                </dd>
                            </div>
                        @endif
                        @if($service->server->hostname)
                            <div class="p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light border border-subtle">
                                <dt class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Server Hostname')</dt>
                                <dd class="mt-1 flex items-center justify-between gap-2 font-medium text-sm md:text-base" style="color: var(--text-primary);">
                                    @php
                                        $displayHostname = $service->server->hostname;
                                        if (filter_var($displayHostname, FILTER_VALIDATE_URL)) {
                                            $displayHostname = parse_url($displayHostname, PHP_URL_HOST);
                                        }
                                    @endphp
                                    <span class="font-mono break-all">{{ $displayHostname }}</span>
                                    <button onclick="navigator.clipboard.writeText('{{ $service->server->hostname }}'); this.querySelector('i').classList.replace('ph-copy', 'ph-check'); setTimeout(() => this.querySelector('i').classList.replace('ph-check', 'ph-copy'), 1500);" class="p-2 rounded-lg transition-colors touch-target shrink-0 flex items-center justify-center" style="color: var(--text-muted); background: var(--border-subtle);" title="@lang('Copy')">
                                        <i class="ph ph-copy text-sm md:text-base"></i>
                                    </button>
                                </dd>
                            </div>
                        @endif
                        @if($service->effective_ip || $service->assigned_ips)
                            <div class="p-3 md:p-4 rounded-lg md:rounded-xl bg-primary-light border border-subtle">
                                <dt class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('IP Address')</dt>
                                <dd class="mt-1 flex items-center gap-2 font-medium text-sm md:text-base" style="color: var(--text-primary);">
                                    <span class="font-mono">{{ $service->effective_ip }}</span>
                                    <button onclick="navigator.clipboard.writeText('{{ $service->effective_ip }}'); this.querySelector('i').classList.replace('ph-copy', 'ph-check'); setTimeout(() => this.querySelector('i').classList.replace('ph-check', 'ph-copy'), 1500);" class="p-1.5 rounded-lg transition-colors touch-target shrink-0" style="color: var(--text-muted);" title="@lang('Copy')">
                                        <i class="ph ph-copy text-sm"></i>
                                    </button>
                                </dd>
                                @if($service->assigned_ips)
                                    <dd class="mt-1 text-xs" style="color: var(--text-secondary);">
                                        @lang('Additional IPs'): {{ $service->assigned_ips }}
                                    </dd>
                                @endif
                            </div>
                        @endif
                    </dl>
                </x-client.card>
            @endif

            {{-- Nameservers --}}
            @if($service->server && ($service->server->ns1 || $service->server->ns2 || $service->server->ns3 || $service->server->ns4))
                <x-client.card class="animate-slide-up stagger-7">
                    <h3 class="mb-4 text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Nameservers')</h3>
                    <dl class="grid gap-3 md:gap-4 sm:grid-cols-2">
                        @foreach(['ns1', 'ns2', 'ns3', 'ns4'] as $index => $nsKey)
                            @if($service->server->$nsKey)
                                <div class="p-3 md:p-4 rounded-xl bg-primary-light border border-subtle">
                                    <dt class="text-[11px] font-bold uppercase tracking-wide text-dynamic-muted">@lang('Nameserver') {{ $index + 1 }}</dt>
                                    <dd class="mt-1.5 flex items-center gap-2 font-bold text-sm md:text-base text-dynamic">
                                        <span class="font-mono truncate">{{ $service->server->$nsKey }}</span>
                                        <button onclick="navigator.clipboard.writeText('{{ $service->server->$nsKey }}'); this.querySelector('i').classList.replace('ph-copy', 'ph-check'); setTimeout(() => this.querySelector('i').classList.replace('ph-check', 'ph-copy'), 1500);" class="p-1.5 rounded-lg transition-colors hover:bg-primary-light text-dynamic-muted hover:text-primary-color" title="@lang('Copy')">
                                            <i class="ph ph-copy text-sm"></i>
                                        </button>
                                    </dd>
                                </div>
                            @endif
                        @endforeach
                    </dl>
                    {{-- Copy All Nameservers Button --}}
                    <div class="mt-4 pt-4 border-t border-subtle">
                        <button
                            onclick="navigator.clipboard.writeText('{{ implode('\n', array_filter([$service->server->ns1, $service->server->ns2, $service->server->ns3, $service->server->ns4])) }}'); this.querySelector('span').textContent = '{{ __('Copied!') }}'; setTimeout(() => this.querySelector('span').textContent = '{{ __('Copy All Nameservers') }}', 1500);"
                            class="flex items-center justify-center sm:justify-start gap-2 text-xs font-bold transition-all touch-target w-full sm:w-auto p-2.5 sm:p-0 rounded-xl sm:rounded-none bg-primary-light sm:bg-transparent text-primary-color hover:opacity-80"
                        >
                            <i class="ph-duotone ph-copy text-sm"></i>
                            <span class="uppercase tracking-widest">@lang('Copy All Nameservers')</span>
                        </button>
                    </div>
                </x-client.card>
            @endif

            {{-- Related Invoices --}}
            <x-client.card class="animate-slide-up stagger-8 !p-0 overflow-hidden border-subtle">
                <div class="px-5 md:px-6 py-4 border-b border-subtle bg-primary-light/10">
                    <h3 class="text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Related Invoices')</h3>
                </div>
                <div class="divide-y border-subtle">
                    @forelse($invoices as $invoice)
                        @php
                            $invType = match($invoice->status) { 1 => 'success', 2 => 'warning', 3 => 'secondary', default => 'secondary' };
                            $invLabel = match($invoice->status) { 1 => 'Paid', 2 => 'Unpaid', 3 => 'Cancelled', default => 'Unknown' };
                        @endphp
                        <a href="{{ route('client.invoices.show', $invoice->id) }}" wire:navigate class="group flex flex-col sm:flex-row sm:items-center justify-between p-4 md:p-5 transition-all hover:bg-primary-light/30 gap-2 sm:gap-4">
                            <div class="flex items-center justify-between sm:block">
                                <div>
                                    <p class="font-bold text-sm md:text-base text-dynamic group-hover:text-primary-color transition-colors">#{{ $invoice->invoice_number }}</p>
                                    <p class="text-[11px] font-medium text-dynamic-muted mt-0.5">{{ $invoice->created_at->format('M d, Y') }}</p>
                                </div>
                                <div class="text-right sm:hidden">
                                    <p class="font-black text-sm text-dynamic">{{ showAmount($invoice->total) }}</p>
                                    <x-client.badge :type="$invType" size="xs">{{ __($invLabel) }}</x-client.badge>
                                </div>
                            </div>
                            <div class="hidden sm:text-right sm:block">
                                <p class="font-black text-sm md:text-base text-dynamic">{{ showAmount($invoice->total) }}</p>
                                <x-client.badge :type="$invType" size="xs">{{ __($invLabel) }}</x-client.badge>
                            </div>
                        </a>
                    @empty
                        <div class="p-8">
                            <x-client.empty-state icon="ph-receipt" :title="__('No invoices found')" size="sm" />
                        </div>
                    @endforelse
                </div>
            </x-client.card>
        </div>

        {{-- Sidebar --}}
        <div class="space-y-4 md:space-y-6 lg:order-last">
            {{-- Quick Actions --}}
            <x-client.card class="animate-slide-up stagger-9" padding="sm">
                <h3 class="mb-4 text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Quick Actions')</h3>
                <div class="space-y-2 md:space-y-3">
                    @if($service->status === 1)
                        <x-client.button @click="showRenewModal = true" variant="soft" fullWidth icon="ph-duotone ph-arrow-clockwise">
                            @lang('Renew Service')
                        </x-client.button>
                        @if($canUpgrade)
                            <x-client.button wire:click="openUpgradeModal" variant="soft" fullWidth icon="ph-duotone ph-arrows-out-simple">
                                @lang('Upgrade/Downgrade')
                            </x-client.button>
                        @endif
                    @endif
                    @if($supportEnabled)
                    <x-client.button href="{{ route('client.tickets.create') }}" variant="soft" fullWidth icon="ph-duotone ph-chat-circle-dots">
                        @lang('Open Ticket')
                    </x-client.button>
                    @endif
                    @if($serviceCancellationEnabled && $service->status === 1 && !$hasCancelRequest)
                        <x-client.button @click="showCancelModal = true" variant="danger" fullWidth icon="ph-duotone ph-x-circle">
                            @lang('Request Cancellation')
                        </x-client.button>
                    @endif
                </div>
            </x-client.card>

            @if($service->status === 1 && $service->server)
                <x-client.card class="animate-slide-up stagger-10" padding="sm">
                    <h3 class="mb-3 md:mb-4 font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Quick Shortcuts')</h3>
                    <div class="grid grid-cols-2 gap-2">
                        @if(!$isLoaded)
                            @for($i = 0; $i < 4; $i++)
                                <div class="animate-pulse flex flex-col items-center justify-center gap-2 p-3 rounded-xl" style="background: var(--border-subtle); border: 1px solid var(--card-border);">
                                    <div class="h-8 w-8 rounded-full mb-1" style="background: var(--border);"></div>
                                    <div class="h-3 w-16 rounded" style="background: var(--border);"></div>
                                </div>
                            @endfor
                        @else
                            @foreach($quickActions as $action)
                                <a href="{{ $action['url'] }}" target="_blank" class="flex flex-col items-center justify-center gap-2 p-3 rounded-xl transition-all hover:scale-[1.02] active:scale-[0.98]" style="background: var(--primary-light); border: 1px solid var(--card-border);">
                                    <i class="ph {{ $action['icon'] }} text-xl md:text-2xl" style="color: var(--primary);"></i>
                                    <span class="text-[10px] md:text-xs font-medium text-center" style="color: var(--text-primary);">{{ $action['label'] }}</span>
                                </a>
                            @endforeach
                        @endif
                    </div>
                </x-client.card>
            @endif

            @if($hasCancelRequest)
                <x-client.alert type="warning" class="animate-slide-up stagger-10">
                    <div class="flex items-start gap-3">
                        <i class="ph ph-warning-circle text-xl shrink-0" style="color: var(--warning);"></i>
                        <div>
                            <p class="font-medium text-sm md:text-base" style="color: var(--text-primary);">@lang('Cancellation Pending')</p>
                            <p class="mt-1 text-xs md:text-sm" style="color: var(--text-secondary);">@lang('A cancellation request is pending for this service.')</p>
                        </div>
                    </div>
                </x-client.alert>
            @endif

            {{-- Service Summary --}}
            <x-client.card class="animate-slide-up stagger-11" padding="sm">
                <h3 class="mb-4 text-xs font-bold uppercase tracking-widest text-dynamic-muted">@lang('Summary')</h3>
                <div class="space-y-3">
                    <div class="flex justify-between items-center px-3 py-2 rounded-lg bg-primary-light/30">
                        <span class="text-xs font-bold text-dynamic-muted uppercase tracking-tight">@lang('Status')</span>
                        <x-client.badge :type="$statusType" size="sm">{{ __($statusConfig['label']) }}</x-client.badge>
                    </div>
                    <div class="flex justify-between items-center px-3 py-2 rounded-lg bg-primary-light/30">
                        <span class="text-xs font-bold text-dynamic-muted uppercase tracking-tight">@lang('Billing')</span>
                        <span class="text-xs font-black text-dynamic uppercase">{{ $service->billing_cycle ?? 'monthly' }}</span>
                    </div>
                    <div class="flex justify-between items-center px-3 py-2 rounded-lg bg-primary-light/30">
                        <span class="text-xs font-bold text-dynamic-muted uppercase tracking-tight">@lang('Price')</span>
                        <span class="text-xs font-black text-primary-color">{{ $formattedPrice }}</span>
                    </div>
                    @if($service->next_due_date)
                        <div class="flex justify-between items-center px-3 py-2 rounded-lg bg-primary-light/30">
                            <span class="text-xs font-bold text-dynamic-muted uppercase tracking-tight">@lang('Due')</span>
                            <span class="text-xs font-black text-dynamic">{{ $service->next_due_date->format('M d, Y') }}</span>
                        </div>
                    @endif
                </div>
            </x-client.card>
        </div>
    </div>

    {{-- Cancel Modal --}}
    <x-client.modal :show="$showCancelModal" maxWidth="lg" closeAction="closeCancelModal">
        <div class="p-4 md:p-6">
            <div class="mb-4 md:mb-6 flex items-center gap-3 md:gap-4">
                <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl" style="background: color-mix(in srgb, var(--danger) 15%, transparent);">
                    <i class="ph ph-warning text-xl md:text-2xl" style="color: var(--danger);"></i>
                </div>
                <div>
                    <h3 class="text-base md:text-lg font-semibold" style="color: var(--text-primary);">@lang('Request Cancellation')</h3>
                    <p class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('This action cannot be undone')</p>
                </div>
            </div>
            <form wire:submit="requestCancellation" class="space-y-3 md:space-y-4">
                <div>
                    <x-client.input type="select" wire:model="cancelType" label="{{ __('Cancellation Type') }}">
                        <option value="end_of_billing">@lang('End of Billing Period')</option>
                        <option value="immediate">@lang('Immediate')</option>
                    </x-client.input>
                </div>
                <div>
                    <x-client.input type="textarea" wire:model="cancelReason" rows="4" label="{{ __('Reason for Cancellation') }}" placeholder="{{ __('Please tell us why you want to cancel...') }}" :error="$errors->first('cancelReason')" />
                </div>
                <div class="flex flex-col-reverse sm:flex-row justify-end gap-2 md:gap-3 pt-3 md:pt-4">
                    <x-client.button type="button" wire:click="closeCancelModal" variant="secondary">@lang('Cancel')</x-client.button>
                    <x-client.button type="submit" variant="danger" wireLoading="requestCancellation">@lang('Submit Request')</x-client.button>
                </div>
            </form>
        </div>
    </x-client.modal>

    {{-- Renew Modal --}}
    <x-client.modal :show="$showRenewModal" maxWidth="md" closeAction="closeRenewModal">
        <div class="p-4 md:p-6">
            <div class="flex items-center gap-3 md:gap-4 mb-4 md:mb-6">
                <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl bg-primary-light">
                    <i class="ph ph-arrows-clockwise text-lg md:text-xl text-primary"></i>
                </div>
                <div>
                    <h3 class="text-base md:text-lg font-semibold text-dynamic">@lang('Renew Service')</h3>
                    <p class="text-xs md:text-sm text-dynamic-secondary">@lang('Extend your service subscription')</p>
                </div>
            </div>
            <form wire:submit="renewService" class="space-y-3 md:space-y-4">
                <div>
                    <x-client.input type="select" wire:model="renewBillingCycle" label="{{ __('Billing Cycle') }}">
                        <option value="monthly">@lang('Monthly')</option>
                        <option value="quarterly">@lang('Quarterly')</option>
                        <option value="semi_annually">@lang('Semi-Annually')</option>
                        <option value="annually">@lang('Annually')</option>
                        <option value="biennially">@lang('Biennially')</option>
                        <option value="triennially">@lang('Triennially')</option>
                    </x-client.input>
                </div>
                <div class="flex flex-col-reverse sm:flex-row justify-end gap-2 md:gap-3 pt-3 md:pt-4">
                    <x-client.button type="button" wire:click="closeRenewModal" variant="secondary">@lang('Cancel')</x-client.button>
                    <x-client.button type="submit" wireLoading="renewService" icon="ph-shopping-cart">@lang('Add to Cart')</x-client.button>
                </div>
            </form>
        </div>
    </x-client.modal>

    {{-- Upgrade/Downgrade Modal --}}
    <x-client.modal :show="$showUpgradeModal" maxWidth="lg" closeAction="closeUpgradeModal">
        <div class="p-4 md:p-6 max-h-[80vh] overflow-y-auto">
            <div class="flex items-center gap-3 md:gap-4 mb-4 md:mb-6">
                <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl bg-primary-light">
                    <i class="ph ph-arrows-out-simple text-lg md:text-xl text-primary"></i>
                </div>
                <div>
                    <h3 class="text-base md:text-lg font-semibold text-dynamic">@lang('Upgrade/Downgrade')</h3>
                    <p class="text-xs md:text-sm text-dynamic-secondary">@lang('Change your service plan')</p>
                </div>
            </div>

            @if(count($upgradeProducts) > 0)
                <div class="space-y-2 md:space-y-3 mb-4 md:mb-6">
                    @foreach($upgradeProducts as $item)
                        @php
                            $product = $item['product'];
                            $isUpgrade = $item['is_upgrade'];
                            $proratedAmount = $item['prorated_amount'];
                        @endphp
                        <label class="block cursor-pointer">
                            <input
                                type="radio"
                                wire:model.live="selectedUpgradeProductId"
                                value="{{ $product->id }}"
                                class="peer sr-only"
                            />
                            <div class="p-3 md:p-4 rounded-lg md:rounded-xl border transition-all peer-checked:border-primary-500 peer-checked:bg-primary-500/5 group border-subtle">
                                <style>
                                    .peer:checked + div {
                                        border-color: var(--primary) !important;
                                        background-color: color-mix(in srgb, var(--primary) 5%, transparent) !important;
                                    }
                                </style>
                                <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-2">
                                    <div>
                                        <p class="font-medium text-sm md:text-base text-dynamic">{{ $product->name }}</p>
                                        <p class="text-xs md:text-sm mt-0.5 md:mt-1 text-dynamic-secondary">
                                            {{ showAmount($item['price_difference'] > 0 ? '+' . $item['price_difference'] : $item['price_difference']) }}/{{ $service->billing_cycle }}
                                        </p>
                                    </div>
                                    <div class="sm:text-right flex sm:flex-col items-center sm:items-end gap-2">
                                        <x-client.badge :type="$isUpgrade ? 'success' : 'info'" size="xs">
                                            {{ $isUpgrade ? __('Upgrade') : __('Downgrade') }}
                                        </x-client.badge>
                                        @if($proratedAmount > 0)
                                            <p class="text-xs md:text-sm font-medium text-dynamic">
                                                @lang('Due Today'): {{ showAmount($proratedAmount) }}
                                            </p>
                                        @elseif($proratedAmount == 0)
                                            <p class="text-xs md:text-sm text-success">
                                                @lang('No charge')
                                            </p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </label>
                    @endforeach
                </div>

                <x-client.alert type="info" class="mb-4 md:mb-6">
                    <div class="flex items-start gap-2 md:gap-3">
                        <i class="ph ph-info text-base md:text-lg shrink-0 text-primary"></i>
                        <div class="text-xs md:text-sm text-dynamic-secondary">
                            <p>@lang('Upgrades are prorated based on remaining time in your billing cycle.')</p>
                            <p class="mt-1">@lang('Downgrades take effect at the end of your current billing period.')</p>
                        </div>
                    </div>
                </x-client.alert>

                <div class="flex flex-col-reverse sm:flex-row justify-end gap-2 md:gap-3">
                    <x-client.button type="button" wire:click="closeUpgradeModal" variant="secondary">@lang('Cancel')</x-client.button>
                    <x-client.button type="button" wire:click="processUpgrade" wireLoading="processUpgrade" :disabled="!$selectedUpgradeProductId" icon="ph-check">
                        @lang('Confirm Change')
                    </x-client.button>
                </div>
            @else
                <x-client.empty-state icon="ph-duotone ph-package" :title="__('No upgrade options available')" :description="__('There are no other plans available for upgrade or downgrade.')">
                    <x-client.button type="button" wire:click="closeUpgradeModal" variant="secondary" class="mt-4">@lang('Close')</x-client.button>
                </x-client.empty-state>
            @endif
        </div>
    </x-client.modal>

    {{-- Change Password Modal --}}
    <x-client.modal :show="$showPasswordModal" maxWidth="md" closeAction="closePasswordModal">
        <div class="p-4 md:p-6">
            <div class="flex items-center gap-3 mb-4 md:mb-6">
                <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-lg md:rounded-xl" style="background: var(--primary-light);">
                    <i class="ph-duotone ph-key text-base md:text-lg" style="color: var(--primary);"></i>
                </div>
                <div>
                    <h3 class="text-base md:text-lg font-semibold" style="color: var(--text-primary);">@lang('Change Password')</h3>
                    <p class="text-xs md:text-sm" style="color: var(--text-secondary);">@lang('Update your hosting account password')</p>
                </div>
            </div>

            <form wire:submit="changePassword" class="space-y-3 md:space-y-4">
                <x-client.input type="password" wire:model="newPassword" label="{{ __('New Password') }}" placeholder="{{ __('Enter new password') }}" :error="$errors->first('newPassword')" hint="{{ __('Minimum 8 characters') }}" />

                <x-client.input type="password" wire:model="confirmPassword" label="{{ __('Confirm Password') }}" placeholder="{{ __('Confirm new password') }}" :error="$errors->first('confirmPassword')" />

                <x-client.alert type="warning">
                    <div class="flex items-start gap-2 md:gap-3">
                        <i class="ph ph-warning text-base md:text-lg shrink-0" style="color: var(--warning);"></i>
                        <div class="text-xs md:text-sm" style="color: var(--text-secondary);">
                            <p>@lang('This will change your hosting account password on the server.')</p>
                            <p class="mt-1">@lang('Make sure to save your new password securely.')</p>
                        </div>
                    </div>
                </x-client.alert>

                <div class="flex flex-col-reverse sm:flex-row justify-end gap-2 md:gap-3 pt-2">
                    <x-client.button type="button" wire:click="closePasswordModal" variant="secondary">@lang('Cancel')</x-client.button>
                    <x-client.button type="submit" wireLoading="changePassword" icon="ph-check">@lang('Change Password')</x-client.button>
                </div>
            </form>
        </div>
    </x-client.modal>

    {{-- Script for opening login window --}}
    @script
    <script>
        $wire.on('openLoginWindow', ({ url }) => {
            window.open(url, '_blank', 'width=1200,height=800');
        });
    </script>
    @endscript
</div>

