<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex flex-col gap-3 md:gap-4 lg:flex-row lg:items-center lg:justify-between animate-in">
        <div>
            <h1 class="text-xl md:text-2xl font-bold tracking-tight lg:text-3xl text-dynamic">@lang('My Services')</h1>
            <p class="mt-1 text-sm md:text-base text-dynamic-secondary">@lang('Manage your hosting services and subscriptions')</p>
        </div>
    </div>

    {{-- Filters Card --}}
    <x-client.card class="animate-in" padding="sm">
        <div class="flex flex-col gap-3 md:gap-4 lg:flex-row lg:items-center">
            {{-- Search --}}
            <div class="relative flex-1 lg:max-w-sm">
                <x-client.input wire:model.live.debounce.300ms="search" type="text" placeholder="{{ __('Search services...') }}" prefix="ph-magnifying-glass" clearable />
            </div>

            {{-- Status Filter Pills --}}
            <div class="flex gap-2 overflow-x-auto pb-1 -mx-4 px-4 md:mx-0 md:px-0 md:flex-wrap scrollbar-hide">
                @php
                    $filters = ['' => ['label' => 'All', 'count' => $counts['all']], '1' => ['label' => 'Active', 'count' => $counts['active']], '2' => ['label' => 'Pending', 'count' => $counts['pending']], '3' => ['label' => 'Suspended', 'count' => $counts['suspended']]];
                @endphp
                @foreach($filters as $value => $filter)
                    <button wire:click="$set('status', '{{ $value }}')" class="filter-pill {{ $status === $value ? 'filter-pill-active' : '' }}">
                        @lang($filter['label'])
                        <span class="text-2xs px-1.5 py-0.5 rounded-full {{ $status === $value ? 'bg-primary-light/30' : 'bg-primary-light/20' }}">{{ $filter['count'] }}</span>
                    </button>
                @endforeach
            </div>
        </div>
    </x-client.card>

    {{-- Services Grid --}}
    <div class="grid gap-3 md:gap-4 sm:grid-cols-2 lg:grid-cols-3">
        {{-- Loading Skeleton --}}
        <div wire:loading.delay wire:target="search, status" class="contents">
            @for($i = 0; $i < 6; $i++)
                <x-client.skeleton type="service-card" :delay="$i * 75" />
            @endfor
        </div>

        {{-- Actual Content --}}
        <div wire:loading.remove wire:target="search, status" class="contents">
        @forelse($services as $index => $service)
            @php
                $statusConfig = [1 => ['label' => 'Active', 'type' => 'success'], 2 => ['label' => 'Pending', 'type' => 'warning'], 3 => ['label' => 'Suspended', 'type' => 'danger'], 4 => ['label' => 'Terminated', 'type' => 'secondary'], 5 => ['label' => 'Cancelled', 'type' => 'secondary']];
                $config = $statusConfig[$service->status] ?? $statusConfig[4];
                $isExpiringSoon = $service->next_due_date && $service->next_due_date->diffInDays(now()) <= 7 && $service->next_due_date->isFuture();
            @endphp
            <a href="{{ route('client.services.show', $service->id) }}" wire:navigate class="group card-dynamic card-hover relative p-4 md:p-5 animate-in" style="animation-delay: {{ $index * 50 }}ms;">
                {{-- Expiring Soon Indicator --}}
                @if($isExpiringSoon && $service->status == 1)
                    <div class="absolute -top-1 -right-1">
                        <span class="relative flex h-3 w-3">
                            <span class="animate-ping absolute inline-flex h-full w-full rounded-full opacity-75 bg-warning"></span>
                            <span class="relative inline-flex rounded-full h-3 w-3 bg-warning"></span>
                        </span>
                    </div>
                @endif

                {{-- Header --}}
                <div class="flex items-start justify-between mb-3 md:mb-4">
                    <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl bg-primary-light transition-transform group-hover:scale-110">
                        <i class="ph-duotone ph-cube text-base md:text-xl text-primary-color"></i>
                    </div>
                    <x-client.badge :type="$config['type']" size="sm">{{ __($config['label']) }}</x-client.badge>
                </div>

                {{-- Content --}}
                <h3 class="font-bold text-sm md:text-base text-dynamic">{{ $service->product->name ?? 'N/A' }}</h3>
                <p class="mt-1 truncate text-xs md:text-sm font-medium text-dynamic-secondary tracking-tight">{{ $service->domain ?? __('No domain') }}</p>

                {{-- Details --}}
                <div class="mt-3 md:mt-4 flex items-center justify-between pt-3 md:pt-4 border-subtle" style="border-top-width: 1px;">
                    <div class="text-xs md:text-sm">
                        <span class="text-dynamic-muted font-medium">@lang('Due'):</span>
                        <span class="ml-1 font-bold {{ $isExpiringSoon ? 'text-warning-color' : 'text-dynamic' }}">
                            {{ $service->next_due_date ? $service->next_due_date->format('M d, Y') : 'N/A' }}
                        </span>
                    </div>
                    <i class="ph ph-arrow-right text-[10px] text-dynamic-muted group-hover:translate-x-1 group-hover:text-primary-color transition-all"></i>
                </div>
            </a>
        @empty
            <div class="col-span-full animate-in">
                <x-client.empty-state icon="ph-cube" title="No services found" description="You don't have any services yet. Browse our products to get started." size="lg" />
            </div>
        @endforelse
        </div>
    </div>

    {{-- Pagination --}}
    @if($services->hasPages())
        <div class="mt-4 md:mt-6 animate-in">{{ $services->links('vendor.livewire.novahost') }}</div>
    @endif
</div>
