<div class="space-y-4 md:space-y-6">
    {{-- Breadcrumb --}}
    <nav class="flex items-center gap-2 text-xs md:text-sm animate-in text-dynamic-secondary">
        <a href="{{ route('client.tickets') }}" wire:navigate class="transition-colors text-primary-color hover:underline">@lang('Tickets')</a>
        <i class="ph ph-caret-right text-xs"></i>
        <span class="text-dynamic">@lang('Open Ticket')</span>
    </nav>

    {{-- Page Header --}}
    <div class="flex items-center gap-3 md:gap-4 animate-in">
        <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl shrink-0 bg-primary-light">
            <i class="ph ph-paper-plane-tilt text-lg md:text-xl text-primary-color"></i>
        </div>
        <div>
            <h1 class="text-lg md:text-xl font-semibold text-dynamic">@lang('Open New Ticket')</h1>
            <p class="mt-0.5 text-xs md:text-sm text-dynamic-secondary">@lang('Describe your issue and our team will get back to you soon')</p>
        </div>
    </div>

    <x-client.card class="max-w-3xl animate-in">
        <form wire:submit="submit" class="space-y-4 md:space-y-6">
            {{-- Subject --}}
            <div class="space-y-1.5 md:space-y-2">
                <label for="subject" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Subject') <span class="text-danger-color">*</span></label>
                <x-client.input wire:model="subject" type="text" id="subject" placeholder="{{ __('Brief description of your issue') }}" />
                @error('subject') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
            </div>

            {{-- Category --}}
            @if($categories->count() > 0)
                <div class="space-y-1.5 md:space-y-2">
                    <label for="category_id" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Category') @if($requireCategory)<span class="text-danger-color">*</span>@endif</label>
                    <x-client.input wire:model="category_id" type="select" id="category_id">
                        <option value="">@lang('Select a category...')</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                        @endforeach
                    </x-client.input>
                    @error('category_id') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                </div>
            @elseif($requireCategory)
                <div class="space-y-1.5 md:space-y-2">
                    <label class="block text-xs md:text-sm font-medium text-dynamic">@lang('Category') <span class="text-danger-color">*</span></label>
                    <div class="p-3 rounded-xl bg-danger-light border border-danger-color/20 text-danger-color text-xs md:text-sm">
                        <i class="ph ph-warning-circle mr-1"></i>
                        @lang('No support categories are currently available. This is required to open a ticket.')
                    </div>
                    @error('category_id') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                </div>
            @endif

            {{-- Priority --}}
            <div class="space-y-1.5 md:space-y-2">
                <label class="block text-xs md:text-sm font-medium text-dynamic">@lang('Priority') <span class="text-danger-color">*</span></label>
                <div class="flex flex-wrap gap-2 md:gap-3">
                    @php $priorities = [1 => ['label' => 'Low', 'icon' => 'ph-minus-circle', 'class' => 'text-dynamic-muted'], 2 => ['label' => 'Medium', 'icon' => 'ph-equals', 'class' => 'text-info-color'], 3 => ['label' => 'High', 'icon' => 'ph-warning', 'class' => 'text-danger-color']]; @endphp
                    @foreach($priorities as $value => $p)
                        <label class="relative cursor-pointer">
                            <input wire:model="priority" type="radio" value="{{ $value }}" class="peer sr-only" />
                            <div class="flex items-center gap-2 px-3 md:px-4 py-2.5 md:py-3 rounded-xl transition-all card-dynamic peer-checked:ring-2 peer-checked:ring-offset-1 ring-primary">
                                <i class="ph {{ $p['icon'] }} text-sm md:text-base {{ $p['class'] }}"></i>
                                <span class="font-medium text-sm md:text-base text-dynamic">@lang($p['label'])</span>
                            </div>
                        </label>
                    @endforeach
                </div>
            </div>

            {{-- Message --}}
            <div class="space-y-1.5 md:space-y-2">
                <label for="message" class="block text-xs md:text-sm font-medium text-dynamic">@lang('Message') <span class="text-danger-color">*</span></label>
                <x-client.input wire:model="message" type="textarea" id="message" rows="6" placeholder="{{ __('Describe your issue in detail...') }}" />
                @error('message') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
            </div>

            {{-- Attachments --}}
            @if($attachmentsEnabled)
                <div class="space-y-1.5 md:space-y-2">
                    <label class="block text-xs md:text-sm font-medium text-dynamic">@lang('Attachments')</label>
                    <div class="group p-4 md:p-6 text-center rounded-xl transition-all bg-primary-light border-2 border-dashed border-subtle">
                        <input wire:model="attachments" type="file" multiple class="hidden" id="attachments" />
                        <label for="attachments" class="cursor-pointer block">
                            <div class="mx-auto mb-2 md:mb-3 flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl transition-all card-dynamic">
                                <i class="ph ph-upload-simple text-lg md:text-xl text-dynamic-muted"></i>
                            </div>
                            <p class="text-xs md:text-sm text-dynamic-secondary">@lang('Click to upload or drag and drop')</p>
                            <p class="mt-1 text-xs text-dynamic-muted">@lang('Max :size MB per file. Up to :max files. Allowed: :types', ['size' => $maxAttachmentSize, 'max' => $maxAttachments, 'types' => $allowedExtensions])</p>
                        </label>
                    </div>
                    @if(count($attachments) > 0)
                        <div class="mt-2 md:mt-3 space-y-1.5 md:space-y-2">
                            @foreach($attachments as $index => $attachment)
                                <div class="flex items-center justify-between px-3 md:px-4 py-2.5 md:py-3 rounded-xl bg-primary-light border-subtle" style="border-width: 1px;">
                                    <div class="flex items-center gap-2 md:gap-3 min-w-0">
                                        <div class="flex h-7 w-7 md:h-8 md:w-8 items-center justify-center rounded-lg shrink-0 card-dynamic">
                                            <i class="ph ph-file text-sm md:text-base text-dynamic-muted"></i>
                                        </div>
                                        <span class="text-xs md:text-sm font-medium truncate text-dynamic">{{ $attachment->getClientOriginalName() }}</span>
                                    </div>
                                    <button type="button" wire:click="removeAttachment({{ $index }})" class="transition-colors shrink-0 p-1 text-dynamic-muted hover:text-danger-color"><i class="ph ph-x"></i></button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    @error('attachments') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                    @error('attachments.*') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                </div>
            @endif

            {{-- Submit --}}
            <div class="flex flex-col-reverse sm:flex-row items-center justify-end gap-2 md:gap-3 pt-4 md:pt-6 border-subtle" style="border-top-width: 1px;">
                <x-client.button href="{{ route('client.tickets') }}" variant="secondary" fullWidth class="sm:w-auto">@lang('Cancel')</x-client.button>
                <x-client.button type="submit" icon="ph-paper-plane-tilt" wireLoading="submit" fullWidth class="sm:w-auto">@lang('Submit Ticket')</x-client.button>
            </div>
        </form>
    </x-client.card>
</div>
