<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex flex-col gap-3 md:gap-4 lg:flex-row lg:items-center lg:justify-between animate-in">
        <div class="flex items-center gap-3 md:gap-4">
            <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl shrink-0 bg-warning-light">
                <i class="ph ph-chat-circle-dots text-lg md:text-xl text-warning-color"></i>
            </div>
            <div>
                <h1 class="text-lg md:text-xl font-semibold text-dynamic">@lang('Support Tickets')</h1>
                <p class="mt-0.5 text-sm text-dynamic-secondary">@lang('Get help from our support team')</p>
            </div>
        </div>
        @if($canCreateNew)
            <x-client.button href="{{ route('client.tickets.create') }}" icon="ph-plus">@lang('Open Ticket')</x-client.button>
        @else
            <x-client.alert type="warning" class="lg:max-w-xs">
                <div class="flex items-center gap-2">
                    <i class="ph ph-warning shrink-0"></i>
                    <span class="text-xs md:text-sm font-medium">@lang('Maximum open tickets reached')</span>
                </div>
            </x-client.alert>
        @endif
    </div>

    {{-- Filters Card --}}
    <x-client.card class="animate-in" padding="sm">
        <div class="flex flex-col gap-3 md:gap-4 lg:flex-row lg:items-center">
            {{-- Search --}}
            <div class="max-w-sm flex-1">
                <x-client.input wire:model.live.debounce.300ms="search" type="text" placeholder="{{ __('Search tickets...') }}" prefixIcon="ph-magnifying-glass" />
            </div>

            {{-- Status Filter Pills --}}
            <div class="flex gap-2 overflow-x-auto -mx-4 px-4 md:mx-0 md:px-0 scrollbar-hide">
                @php
                    $filters = ['' => ['label' => 'All', 'count' => $counts['all'] ?? 0], '0' => ['label' => 'Open', 'count' => $counts['open'] ?? 0], '1' => ['label' => 'Answered', 'count' => $counts['answered'] ?? 0], '2' => ['label' => 'Replied', 'count' => $counts['replied'] ?? 0], '4' => ['label' => 'On Hold', 'count' => $counts['on_hold'] ?? 0], '3' => ['label' => 'Closed', 'count' => $counts['closed'] ?? 0]];
                @endphp
                @foreach($filters as $value => $filter)
                    <button wire:click="$set('status', '{{ $value }}')" class="filter-pill {{ $status === $value ? 'filter-pill-active' : '' }}">
                        @lang($filter['label'])
                        <span class="text-2xs px-1.5 py-0.5 rounded-full {{ $status === $value ? 'bg-primary-light/30' : 'bg-primary-light/20' }}">{{ $filter['count'] }}</span>
                    </button>
                @endforeach
            </div>
        </div>
    </x-client.card>

    {{-- Tickets List --}}
    <div class="space-y-2 md:space-y-3">
        {{-- Loading Skeleton --}}
        <div wire:loading.delay wire:target="search, status" class="space-y-2 md:space-y-3">
            @for($i = 0; $i < 5; $i++)
                <x-client.skeleton type="ticket-item" :delay="$i * 75" />
            @endfor
        </div>

        {{-- Actual Content --}}
        <div wire:loading.remove wire:target="search, status" class="space-y-2 md:space-y-3">
        @forelse($tickets as $index => $ticket)
            @php
                $statusConfig = [0 => ['label' => 'Open', 'type' => 'secondary', 'icon' => 'ph-envelope-open'], 1 => ['label' => 'Answered', 'type' => 'success', 'icon' => 'ph-check-circle'], 2 => ['label' => 'Replied', 'type' => 'warning', 'icon' => 'ph-arrow-bend-up-left'], 3 => ['label' => 'Closed', 'type' => 'secondary', 'icon' => 'ph-lock'], 4 => ['label' => 'On Hold', 'type' => 'info', 'icon' => 'ph-pause']];
                $config = $statusConfig[$ticket->status] ?? $statusConfig[0];
                $priorityConfig = [1 => ['label' => 'Low', 'type' => 'secondary'], 2 => ['label' => 'Medium', 'type' => 'info'], 3 => ['label' => 'High', 'type' => 'danger'], 4 => ['label' => 'Critical', 'type' => 'danger']];
                $priority = $priorityConfig[$ticket->priority] ?? $priorityConfig[2];
            @endphp
            <a href="{{ route('client.tickets.show', $ticket->ticket) }}" wire:navigate class="group block animate-in" style="animation-delay: {{ $index * 50 }}ms;">
                <x-client.card class="card-hover" padding="sm">
                    <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
                        <div class="flex items-start gap-3 md:gap-4">
                            <div class="flex h-9 w-9 md:h-10 md:w-10 items-center justify-center rounded-xl shrink-0 bg-warning-light">
                                <i class="ph {{ $config['icon'] }} text-base md:text-lg text-warning-color"></i>
                            </div>
                            <div class="min-w-0 flex-1">
                                <div class="flex flex-wrap items-center gap-1.5 md:gap-2">
                                    <span class="text-xs md:text-sm text-dynamic-secondary">#{{ $ticket->ticket }}</span>
                                    <x-client.badge :type="$priority['type']" size="xs">{{ __($priority['label']) }}</x-client.badge>
                                </div>
                                <h3 class="mt-0.5 md:mt-1 truncate font-medium text-sm md:text-base text-dynamic">{{ $ticket->subject }}</h3>
                                <p class="mt-0.5 md:mt-1 text-xs md:text-sm text-dynamic-secondary">@lang('Last reply'): {{ $ticket->last_reply?->diffForHumans() ?? $ticket->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                        <div class="flex items-center gap-2 md:gap-3 ml-12 sm:ml-0">
                            <x-client.badge :type="$config['type']" size="sm" :icon="$config['icon']">{{ __($config['label']) }}</x-client.badge>
                            <i class="ph ph-arrow-right group-hover:translate-x-1 transition-transform text-dynamic-muted"></i>
                        </div>
                    </div>
                </x-client.card>
            </a>
        @empty
            <x-client.card class="animate-in">
                <x-client.empty-state icon="ph-chat-circle-dots" illustration="tickets" title="No tickets found" description="You haven't opened any support tickets yet." actionText="Open Ticket" actionHref="{{ route('client.tickets.create') }}" />
            </x-client.card>
        @endforelse
        </div>
    </div>

    {{-- Pagination --}}
    @if($tickets->hasPages())
        <div class="mt-4 md:mt-6 animate-in">{{ $tickets->links('vendor.livewire.novahost') }}</div>
    @endif
</div>
