@php
    use App\Models\SupportTicket;

    $statusType = match($ticket->status) {
        SupportTicket::STATUS_OPEN => 'secondary',
        SupportTicket::STATUS_ANSWERED => 'success',
        SupportTicket::STATUS_CUSTOMER_REPLY => 'warning',
        SupportTicket::STATUS_CLOSED => 'secondary',
        SupportTicket::STATUS_ON_HOLD => 'info',
        default => 'secondary',
    };
    $statusLabel = match($ticket->status) {
        SupportTicket::STATUS_OPEN => 'Open',
        SupportTicket::STATUS_ANSWERED => 'Answered',
        SupportTicket::STATUS_CUSTOMER_REPLY => 'Replied',
        SupportTicket::STATUS_CLOSED => 'Closed',
        SupportTicket::STATUS_ON_HOLD => 'On Hold',
        default => 'Open',
    };
    $statusIcon = match($ticket->status) {
        SupportTicket::STATUS_OPEN => 'ph-envelope-open',
        SupportTicket::STATUS_ANSWERED => 'ph-check-circle',
        SupportTicket::STATUS_CUSTOMER_REPLY => 'ph-arrow-bend-up-left',
        SupportTicket::STATUS_CLOSED => 'ph-lock',
        SupportTicket::STATUS_ON_HOLD => 'ph-pause',
        default => 'ph-envelope-open',
    };
    $priorityType = match($ticket->priority) {
        SupportTicket::PRIORITY_LOW => 'secondary',
        SupportTicket::PRIORITY_MEDIUM => 'info',
        SupportTicket::PRIORITY_HIGH => 'danger',
        SupportTicket::PRIORITY_CRITICAL => 'danger',
        default => 'secondary',
    };
    $priorityLabel = match($ticket->priority) {
        SupportTicket::PRIORITY_LOW => 'Low',
        SupportTicket::PRIORITY_MEDIUM => 'Medium',
        SupportTicket::PRIORITY_HIGH => 'High',
        SupportTicket::PRIORITY_CRITICAL => 'Critical',
        default => 'Medium',
    };
@endphp

<div class="space-y-4 md:space-y-6">
    {{-- Breadcrumb --}}
    <nav class="flex items-center gap-2 text-xs md:text-sm animate-in text-dynamic-secondary">
        <a href="{{ route('client.tickets') }}" wire:navigate class="transition-colors text-primary-color hover:underline">@lang('Tickets')</a>
        <i class="ph ph-caret-right text-xs"></i>
        <span class="text-dynamic">#{{ $ticket->ticket }}</span>
    </nav>

    {{-- Header Card --}}
    <x-client.card class="animate-in">
        <div class="flex flex-col gap-3 md:gap-4 lg:flex-row lg:items-start lg:justify-between">
            <div class="min-w-0">
                <div class="flex flex-wrap items-center gap-2 md:gap-3">
                    <h1 class="text-base md:text-xl font-semibold text-dynamic">{{ $ticket->subject }}</h1>
                    <x-client.badge :type="$statusType" size="sm" :icon="$statusIcon">{{ __($statusLabel) }}</x-client.badge>
                </div>
                <div class="mt-1.5 md:mt-2 flex flex-wrap items-center gap-1.5 md:gap-2 text-xs md:text-sm text-dynamic-secondary">
                    <span>@lang('Ticket') #{{ $ticket->ticket }}</span>
                    <span>·</span>
                    <span class="inline-flex items-center gap-1">@lang('Priority'): <x-client.badge :type="$priorityType" size="xs">{{ __($priorityLabel) }}</x-client.badge></span>
                    <span class="hidden sm:inline">·</span>
                    <span class="w-full sm:w-auto">@lang('Created') {{ $ticket->created_at->format('M d, Y H:i') }}</span>
                </div>
            </div>
            @if($ticket->status !== SupportTicket::STATUS_CLOSED)
                <x-client.button wire:click="closeTicket" wire:confirm="{{ __('Are you sure you want to close this ticket?') }}" variant="secondary" icon="ph-lock" wireLoading="closeTicket" class="shrink-0">@lang('Close Ticket')</x-client.button>
            @endif
        </div>
    </x-client.card>

    {{-- Messages --}}
    <div class="space-y-3 md:space-y-4">
        @foreach($messages as $index => $message)
            @php $isAdmin = $message->admin_id > 0; @endphp
            <div class="flex gap-2 md:gap-4 {{ $isAdmin ? '' : 'flex-row-reverse' }} animate-in" style="animation-delay: {{ $index * 50 }}ms;">
                <div class="shrink-0">
                    <div class="flex h-8 w-8 md:h-10 md:w-10 items-center justify-center rounded-xl {{ $isAdmin ? 'bg-primary-light' : 'bg-success-light' }}">
                        <i class="ph {{ $isAdmin ? 'ph-headset' : 'ph-user' }} text-sm md:text-lg {{ $isAdmin ? 'text-primary-color' : 'text-success-color' }}"></i>
                    </div>
                </div>
                <div class="max-w-[85%] md:max-w-2xl flex-1 {{ $isAdmin ? '' : 'text-right' }}">
                    <div class="mb-1 flex flex-wrap items-center gap-1.5 md:gap-2 {{ $isAdmin ? '' : 'justify-end' }}">
                        <span class="font-medium text-xs md:text-sm text-dynamic">{{ $isAdmin ? ($message->admin->name ?? 'Support') : $ticket->name }}</span>
                        <span class="text-xs md:text-sm text-dynamic-secondary">{{ $message->created_at->format('M d, Y H:i') }}</span>
                    </div>
                    <div class="p-3 md:p-4 text-left rounded-2xl {{ $isAdmin ? 'admin-message-bubble' : 'card-dynamic' }} border-subtle" style="border-width: 1px;">
                        <div class="prose prose-sm max-w-none text-xs md:text-sm text-dynamic-secondary">{!! nl2br(e($message->message)) !!}</div>
                        @if($message->attachments->count() > 0)
                            <div class="mt-3 md:mt-4 flex flex-wrap gap-1.5 md:gap-2">
                                @foreach($message->attachments as $attachment)
                                    <a href="{{ route('client.tickets.attachment.download', $attachment->id) }}" class="inline-flex items-center gap-1.5 md:gap-2 px-2.5 md:px-3 py-1.5 md:py-2 text-xs md:text-sm rounded-lg transition-colors card-dynamic text-dynamic-secondary hover:bg-primary-light">
                                        <i class="ph ph-paperclip text-dynamic-muted"></i>
                                        <span class="truncate max-w-[120px] md:max-w-none">{{ $attachment->original_name ?? basename($attachment->attachment) }}</span>
                                    </a>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    {{-- Reply Form --}}
    @if($ticket->status != 3)
        <x-client.card class="animate-in">
            <h3 class="mb-3 md:mb-4 font-medium text-sm md:text-base text-dynamic">@lang('Reply to Ticket')</h3>
            <form wire:submit="sendReply" class="space-y-3 md:space-y-4">
                <div>
                    <x-client.input wire:model="reply" type="textarea" rows="4" placeholder="{{ __('Type your reply...') }}" />
                    @error('reply') <p class="mt-1 text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                </div>
                @if($attachmentsEnabled)
                    <div class="flex flex-wrap items-center gap-2 md:gap-4">
                        <label class="flex cursor-pointer items-center gap-1.5 md:gap-2 px-3 md:px-4 py-2 md:py-2.5 text-xs md:text-sm font-medium rounded-xl transition-colors bg-primary-light border-subtle text-dynamic-secondary" style="border-width: 1px;">
                            <i class="ph ph-paperclip text-dynamic-muted"></i>
                            @lang('Attach Files')
                            <input wire:model="attachments" type="file" multiple class="hidden" />
                        </label>
                        @if(count($attachments) > 0)<span class="text-xs md:text-sm text-dynamic-secondary">{{ count($attachments) }} @lang('file(s) selected')</span>@endif
                        <span class="text-xs w-full md:w-auto text-dynamic-muted">@lang('Max :size MB, up to :max files', ['size' => $maxAttachmentSize, 'max' => $maxAttachments])</span>
                    </div>
                    @if(count($attachments) > 0)
                        <div class="flex flex-wrap gap-1.5 md:gap-2">
                            @foreach($attachments as $index => $attachment)
                                <div class="flex items-center gap-1.5 md:gap-2 px-2.5 md:px-3 py-1.5 md:py-2 text-xs md:text-sm rounded-xl bg-primary-light border-subtle" style="border-width: 1px;">
                                    <span class="truncate max-w-[150px] text-dynamic">{{ $attachment->getClientOriginalName() }}</span>
                                    <button type="button" wire:click="removeAttachment({{ $index }})" class="transition-colors p-0.5 text-dynamic-muted hover:text-danger-color"><i class="ph ph-x"></i></button>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    @error('attachments') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                    @error('attachments.*') <p class="text-xs md:text-sm text-danger-color">{{ $message }}</p> @enderror
                @endif
                <div class="flex justify-end">
                    <x-client.button type="submit" icon="ph-paper-plane-tilt" wireLoading="sendReply">@lang('Send Reply')</x-client.button>
                </div>
            </form>
        </x-client.card>
    @else
        {{-- Closed Ticket Info --}}
        <x-client.card class="animate-in">
            <div class="flex items-start gap-3 md:gap-4">
                <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl shrink-0 bg-primary-light">
                    <i class="ph ph-lock text-lg md:text-xl text-dynamic-muted"></i>
                </div>
                <div class="flex-1 min-w-0">
                    <h4 class="font-medium text-sm md:text-base text-dynamic">@lang('Ticket Closed')</h4>
                    <p class="mt-0.5 md:mt-1 text-xs md:text-sm text-dynamic-secondary">@lang('This ticket has been closed.')</p>
                    <div class="mt-3 md:mt-4 flex flex-col sm:flex-row gap-2 md:gap-3">
                        <x-client.button wire:click="reopenTicket" variant="secondary" icon="ph-arrow-counter-clockwise" wireLoading="reopenTicket">@lang('Reopen Ticket')</x-client.button>
                        <x-client.button href="{{ route('client.tickets.create') }}" icon="ph-plus">@lang('Open New Ticket')</x-client.button>
                    </div>
                </div>
            </div>
        </x-client.card>

        {{-- Satisfaction Rating --}}
        @if($canRate)
            <x-client.card class="animate-in">
                <div class="text-center max-w-md mx-auto">
                    <div class="flex h-12 w-12 md:h-14 md:w-14 mx-auto items-center justify-center rounded-xl bg-warning-light">
                        <i class="ph ph-star text-xl md:text-2xl text-warning-color"></i>
                    </div>
                    <h3 class="mt-3 md:mt-4 text-base md:text-lg font-semibold text-dynamic">@lang('How was your experience?')</h3>
                    <p class="mt-1 md:mt-2 text-xs md:text-sm text-dynamic-secondary">@lang('Your feedback helps us improve our support.')</p>
                    <div class="mt-4 md:mt-6 flex justify-center gap-1.5 md:gap-2">
                        @for($i = 1; $i <= 5; $i++)
                            <button wire:click="$set('satisfactionRating', {{ $i }})" class="p-1.5 md:p-2 rounded-xl transition-all transform hover:scale-110 {{ $satisfactionRating >= $i ? 'bg-warning' : 'bg-primary-light' }}">
                                <i class="ph ph-star{{ $satisfactionRating >= $i ? '-fill' : '' }} text-xl md:text-2xl {{ $satisfactionRating >= $i ? 'text-white' : 'text-dynamic-muted' }}"></i>
                            </button>
                        @endfor
                    </div>
                    @if($satisfactionRating)
                        <div class="mt-3 md:mt-4 space-y-3 md:space-y-4">
                            <x-client.input wire:model="satisfactionFeedback" type="textarea" rows="3" placeholder="{{ __('Tell us more about your experience (optional)...') }}" />
                            <x-client.button wire:click="submitRating" icon="ph-paper-plane-tilt" wireLoading="submitRating" fullWidth>@lang('Submit Feedback')</x-client.button>
                        </div>
                    @endif
                </div>
            </x-client.card>
        @elseif($ticket->satisfaction_rating)
            <x-client.card class="animate-in">
                <div class="text-center py-2">
                    <div class="flex justify-center gap-0.5 md:gap-1">
                        @for($i = 1; $i <= 5; $i++)
                            <i class="ph ph-star{{ $ticket->satisfaction_rating >= $i ? '-fill' : '' }} text-lg md:text-xl {{ $ticket->satisfaction_rating >= $i ? 'text-warning-color' : 'text-dynamic-muted' }}"></i>
                        @endfor
                    </div>
                    <p class="mt-1.5 md:mt-2 text-xs md:text-sm text-dynamic-secondary">@lang('Thank you for your feedback!')</p>
                </div>
            </x-client.card>
        @endif
    @endif
</div>
