@php
    $depositEnabled = isFeatureEnabled('deposits');
@endphp

<div class="space-y-4 md:space-y-6">
    {{-- Page Header --}}
    <div class="flex flex-col gap-3 md:gap-4 sm:flex-row sm:items-center sm:justify-between animate-fade-in">
        <div class="flex items-center gap-3 md:gap-4">
            <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-lg md:rounded-xl shrink-0 bg-primary-light">
                <i class="ph-duotone ph-arrows-left-right text-lg md:text-xl text-primary-color"></i>
            </div>
            <div>
                <h1 class="text-lg md:text-xl font-bold tracking-tight text-dynamic">@lang('Transactions')</h1>
                <p class="mt-0.5 text-xs md:text-sm text-dynamic-secondary">@lang('View your transaction history')</p>
            </div>
        </div>
        @if($depositEnabled)
            <x-client.button href="{{ route('client.deposits.add') }}" icon="ph-plus" class="hover-lift">@lang('Add Funds')</x-client.button>
        @endif
    </div>

    {{-- Balance Card --}}
    <div class="card-dynamic bg-gradient-primary rounded-xl md:rounded-2xl p-5 md:p-8 text-white relative overflow-hidden animate-slide-up border-none shadow-premium">
        <div class="absolute -right-10 -top-10 h-32 w-32 rounded-full bg-white/10 blur-3xl opacity-50"></div>
        <div class="relative flex items-center justify-between">
            <div>
                <p class="text-xs md:text-sm font-bold uppercase tracking-widest opacity-80">@lang('Current Balance')</p>
                <p class="mt-1 md:mt-2 text-3xl md:text-4xl font-black tracking-tight drop-shadow-sm">{{ showAmount($balance) }}</p>
            </div>
            <div class="flex h-12 w-12 md:h-14 md:w-14 items-center justify-center rounded-xl bg-white/20 backdrop-blur-md border border-white/20 shrink-0">
                <i class="ph-duotone ph-wallet text-2xl md:text-3xl"></i>
            </div>
        </div>
    </div>

    {{-- Filters --}}
    <div class="flex flex-col gap-3 md:gap-4 sm:flex-row sm:items-center sm:justify-between animate-slide-up stagger-1">
        {{-- Search --}}
        <div class="relative w-full sm:max-w-xs">
            <x-client.input wire:model.live.debounce.300ms="search" type="text" placeholder="{{ __('Search transactions...') }}" prefixIcon="ph-magnifying-glass" />
        </div>

        {{-- Type Filter --}}
        @php
            $filters = [
                '' => ['label' => 'All', 'count' => $counts['all']],
                '+' => ['label' => 'Credit', 'count' => $counts['credit']],
                '-' => ['label' => 'Debit', 'count' => $counts['debit']],
            ];
        @endphp
        <div class="flex flex-wrap gap-2 md:gap-3">
            @foreach($filters as $value => $filter)
                <button wire:click="$set('type', '{{ $value }}')" class="filter-pill {{ $type === $value ? 'filter-pill-active' : '' }}">
                    @lang($filter['label'])
                    <span class="text-2xs px-1.5 py-0.5 rounded-full {{ $type === $value ? 'bg-primary-light/30' : 'bg-primary-light/20' }}">{{ $filter['count'] }}</span>
                </button>
            @endforeach
        </div>
    </div>

    {{-- Mobile: Card View --}}
    <div class="md:hidden space-y-2 animate-slide-up stagger-2">
        {{-- Loading Skeleton --}}
        <div wire:loading.delay wire:target="search, type" class="space-y-2">
            @for($i = 0; $i < 5; $i++)
                <x-client.skeleton type="transaction-row" :delay="$i * 75" />
            @endfor
        </div>

        <div wire:loading.remove wire:target="search, type">
            @forelse($transactions as $transaction)
                <x-client.card padding="sm">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center gap-3">
                            <div class="flex h-10 w-10 items-center justify-center rounded-xl shrink-0 bg-{{ $transaction->trx_type === '+' ? 'success' : 'danger' }}-light">
                                <i class="ph-duotone {{ $transaction->trx_type === '+' ? 'ph-arrow-down' : 'ph-arrow-up' }} text-base text-{{ $transaction->trx_type === '+' ? 'success' : 'danger' }}-color"></i>
                            </div>
                            <div class="min-w-0">
                                <p class="text-sm font-bold truncate text-dynamic">{{ Str::limit($transaction->details, 25) }}</p>
                                <p class="text-[11px] text-dynamic-muted mt-0.5 tracking-tight">{{ $transaction->created_at->format('M d, Y') }}</p>
                            </div>
                        </div>
                        <div class="text-right shrink-0">
                            <p class="text-sm font-medium" style="color: var(--{{ $transaction->trx_type === '+' ? 'success' : 'danger' }});">
                                {{ $transaction->trx_type }}{{ showAmount($transaction->amount) }}
                            </p>
                            <p class="text-xs" style="color: var(--text-muted);">{{ showAmount($transaction->post_balance) }}</p>
                        </div>
                    </div>
                </x-client.card>
            @empty
                <x-client.empty-state icon="ph-arrows-left-right" title="{{ __('No transactions found') }}" description="{{ __('Your transaction history will appear here.') }}" />
            @endforelse
        </div>
    </div>

    {{-- Desktop: List View --}}
    <div class="hidden md:block animate-slide-up stagger-2">
        <x-client.card padding="none">
            {{-- Loading Skeleton --}}
            <div wire:loading.delay wire:target="search, type">
                @for($i = 0; $i < 5; $i++)
                    <x-client.skeleton type="transaction-row" :delay="$i * 75" />
                @endfor
            </div>

            <div wire:loading.remove wire:target="search, type" class="divide-y divide-subtle">
                @forelse($transactions as $transaction)
                    <div class="flex items-center justify-between px-5 md:px-8 py-4 md:py-5 transition-all hover:bg-primary-light group">
                        <div class="flex items-center gap-3 md:gap-4">
                            <div class="flex h-10 w-10 md:h-12 md:w-12 items-center justify-center rounded-xl shrink-0 bg-{{ $transaction->trx_type === '+' ? 'success' : 'danger' }}-light transition-transform group-hover:scale-110">
                                <i class="ph-duotone {{ $transaction->trx_type === '+' ? 'ph-arrow-down' : 'ph-arrow-up' }} text-lg md:text-xl text-{{ $transaction->trx_type === '+' ? 'success' : 'danger' }}-color"></i>
                            </div>
                            <div>
                                <p class="text-sm md:text-base font-bold text-dynamic group-hover:text-primary-color transition-colors">{{ $transaction->details }}</p>
                                <p class="text-xs md:text-sm text-dynamic-muted mt-0.5">
                                    <span class="font-mono text-[10px] uppercase opacity-70 tracking-widest">{{ $transaction->trx }}</span> 
                                    <span class="mx-1.5 opacity-30">|</span> 
                                    {{ $transaction->created_at->format('M d, Y H:i') }}
                                </p>
                            </div>
                        </div>
                        <div class="text-right">
                            <p class="text-sm md:text-base font-black text-{{ $transaction->trx_type === '+' ? 'success' : 'danger' }}-color">
                                {{ $transaction->trx_type }}{{ showAmount($transaction->amount) }}
                            </p>
                            <p class="text-xs md:text-sm text-dynamic-muted mt-0.5 italic">@lang('Post Balance'): {{ showAmount($transaction->post_balance) }}</p>
                        </div>
                    </div>
                @empty
                    <div class="p-8 md:p-12">
                        <x-client.empty-state icon="ph-arrows-left-right" title="{{ __('No transactions found') }}" description="{{ __('Your transaction history will appear here.') }}" />
                    </div>
                @endforelse
            </div>
        </x-client.card>
    </div>

    {{-- Pagination --}}
    @if($transactions->hasPages())
        <div class="mt-4 md:mt-6">
            {{ $transactions->links('vendor.livewire.novahost') }}
        </div>
    @endif
</div>
