@php
    $domainTableContent = getContent('domain_table.content', true);
@endphp

<div class="relative py-16 bg-surface-offwhite dark:bg-slate-950 overflow-hidden transition-colors duration-300"
     x-data="tldPricingListOnly()"
     x-init="">
     
     {{-- Background elements --}}
     <div class="absolute inset-0 pointer-events-none">
         <div class="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-primary-500/5 dark:bg-primary-600/10 rounded-full blur-[120px]"></div>
     </div>
 
     <div class="relative z-10 max-w-6xl mx-auto px-4 lg:px-8">
         {{-- Header Section --}}
         <div class="text-center max-w-2xl mx-auto mb-10">
             <h2 class="text-2xl md:text-3xl font-bold text-slate-900 dark:text-white mb-4 tracking-tight">
                 {{ __(@$domainTableContent->data_values->heading ?? 'Complete TLD Pricing List') }}
             </h2>
             @if(@$domainTableContent->data_values->subheading)
                 <p class="text-sm text-slate-500 dark:text-slate-400 leading-relaxed">
                     {{ __(@$domainTableContent->data_values->subheading) }}
                 </p>
             @endif
         </div>
 
         {{-- PRICING TABLE --}}
         <div class="relative bg-white dark:bg-slate-900/40 border border-slate-200 dark:border-white/10 rounded-xl overflow-hidden shadow-sm dark:shadow-xl transition-all duration-300">
             <div class="overflow-x-auto">
                 <table class="w-full text-left border-collapse">
                     <thead>
                         <tr class="border-b border-slate-200 dark:border-white/10 bg-slate-50 dark:bg-white/[0.03]">
                             <th class="px-5 py-3 text-[10px] font-bold uppercase tracking-wider text-slate-400 dark:text-slate-500">TLD Extension</th>
                             <th class="px-5 py-3 text-[10px] font-bold uppercase tracking-wider text-slate-400 dark:text-slate-500 text-center">Registration</th>
                             <th class="px-5 py-3 text-[10px] font-bold uppercase tracking-wider text-slate-400 dark:text-slate-500 text-center">Transfer</th>
                             <th class="px-5 py-3 text-[10px] font-bold uppercase tracking-wider text-slate-400 dark:text-slate-500 text-center">Renewal</th>
                             <th class="px-5 py-3 text-[10px] font-bold uppercase tracking-wider text-slate-400 dark:text-slate-500 text-right">ID Protection</th>
                         </tr>
                     </thead>
                     <tbody class="divide-y divide-slate-100 dark:divide-white/5">
                         <template x-for="(tld, index) in results" :key="`tld-static-${index}-${tld.id}`">
                             <tr class="group/tr hover:bg-slate-50 dark:hover:bg-white/[0.02] transition-colors">
                                 <td class="px-5 py-3.5">
                                     <span class="text-base font-bold text-slate-900 dark:text-white group-hover/tr:text-primary-600 dark:group-hover/tr:text-primary-400 transition-colors" x-text="tld.extension"></span>
                                 </td>
                                 <td class="px-5 py-3.5 text-center">
                                     <span class="text-sm font-bold text-slate-900 dark:text-white" x-text="tld.formatted_pricing.registration"></span>
                                 </td>
                                 <td class="px-5 py-3.5 text-center">
                                     <span class="text-sm font-bold text-primary-600 dark:text-primary-400" x-text="tld.formatted_pricing.transfer"></span>
                                 </td>
                                 <td class="px-5 py-3.5 text-center">
                                     <span class="text-sm text-slate-500 dark:text-slate-400" x-text="tld.formatted_pricing.renewal"></span>
                                 </td>
                                 <td class="px-5 py-3.5 text-right">
                                     <template x-if="tld.formatted_pricing.id_protection">
                                         <span class="text-xs font-semibold text-green-600 dark:text-green-400 bg-green-50 dark:bg-green-500/10 px-2.5 py-1 rounded-md" x-text="tld.formatted_pricing.id_protection"></span>
                                     </template>
                                     <template x-if="!tld.formatted_pricing.id_protection">
                                         <span class="text-[10px] font-bold uppercase tracking-wider text-slate-400 dark:text-slate-600">Included</span>
                                     </template>
                                 </td>
                             </tr>
                         </template>
                     </tbody>
                 </table>
             </div>
 
             <div class="px-5 py-4 border-t border-slate-200 dark:border-white/10 bg-slate-50 dark:bg-white/[0.02]">
                 <div class="flex items-center justify-between">
                     <span class="text-xs font-medium text-slate-400 dark:text-slate-500" x-text="results.length + ' extensions available'"></span>
                     <div x-show="hasMore">
                         <button @click="loadMore()" :disabled="loadingMore" class="text-sm font-semibold text-primary-600 dark:text-primary-400 hover:text-primary-700 dark:hover:text-primary-300 transition-colors flex items-center gap-1.5">
                             <span>Explore more TLDs</span>
                             <i class="ph ph-caret-down text-xs"></i>
                         </button>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 </div>
    </div>
</div>

<script nonce="{{ csp_nonce() }}">
function tldPricingListOnly() {
    return {
        results: [],
        cursor: null,
        loadingMore: false,
        hasMore: true,
        
        async init() {
            await this.fetchResults();
        },
        
        async loadMore() {
            if (!this.hasMore || this.loadingMore) return;
            this.loadingMore = true;
            await this.fetchResults();
            this.loadingMore = false;
        },
        
        async fetchResults() {
            try {
                const csrfToken = '{{ csrf_token() }}';
                const response = await fetch('/api/domains/search', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json', 'X-CSRF-TOKEN': csrfToken, 'Accept': 'application/json' },
                    body: JSON.stringify({ cursor: this.cursor, limit: 45 })
                });
                
                const data = await response.json();
                if (data.success) {
                    this.results = [...this.results, ...data.data];
                    this.cursor = data.meta.next_cursor;
                    this.hasMore = data.meta.has_more;
                }
            } catch (error) { console.error('Pricing list error:', error); }
        }
    };
}
</script>
