<div class="fixed bottom-4 right-4 sm:bottom-6 sm:right-6 z-[9999]"
     x-data="{
        isOpen: @entangle('isOpen'),
        hasUnread: @entangle('hasUnread'),
        chatView: @entangle('view'),
        pollInterval: @entangle('pollInterval'),
        ready: false,
        sending: false,
        optimisticMsg: null,

        scrollToBottom() {
            this.$nextTick(() => {
                const el = this.$refs.chatContainer;
                if (el) el.scrollTo({ top: el.scrollHeight, behavior: 'smooth' });
            });
        },

        startPolling() {
            if (this._pt) clearInterval(this._pt);
            this._pt = setInterval(() => $wire.checkNewMessages(), this.pollInterval * 1000);
        },

        async send() {
            const msg = $wire.get('message');
            if (!msg || !msg.trim()) return;

            // Optimistic: show message instantly
            this.optimisticMsg = msg.trim();
            this.sending = true;
            this.scrollToBottom();

            await $wire.sendReply();

            this.optimisticMsg = null;
            this.sending = false;
            this.scrollToBottom();
        }
     }"
     x-init="
        setTimeout(() => ready = true, 2000);
        $watch('isOpen', v => { if (v) setTimeout(() => scrollToBottom(), 150); });
        $watch('pollInterval', () => startPolling());
        startPolling();

        // Sound management — lightweight
        let _beep = null;
        $watch('hasUnread', v => {
            const a = document.getElementById('_chatSfx');
            if (v && ready && a) {
                a.play().catch(() => {});
                if (!_beep) _beep = setInterval(() => {
                    if (this.hasUnread && a) { a.currentTime = 0; a.play().catch(() => {}); }
                    else { clearInterval(_beep); _beep = null; }
                }, 6000);
            } else {
                if (_beep) { clearInterval(_beep); _beep = null; }
            }
        });
     "
     @scroll-chat-bottom.window="scrollToBottom()"
     style="font-family: 'Inter', system-ui, -apple-system, sans-serif; --chat-color: {{ gs('ticket_livechat_color') ?? '#CC2628' }}; --primary: {{ gs('ticket_livechat_color') ?? '#CC2628' }};">

    {{-- ═══ FAB ═══ --}}
    <div class="relative w-[52px] h-[52px] sm:w-[60px] sm:h-[60px]">
        <button x-show="isOpen" @click="$wire.toggleChat()"
                x-transition:enter="transition ease-[cubic-bezier(.34,1.56,.64,1)] duration-500"
                x-transition:enter-start="opacity-0 scale-0 rotate-180"
                x-transition:enter-end="opacity-100 scale-100 rotate-0"
                x-transition:leave="transition ease-in duration-150"
                x-transition:leave-end="opacity-0 scale-0"
                class="absolute inset-0 w-full h-full rounded-[18px] shadow-[0_8px_30px_rgba(0,0,0,0.2)] flex items-center justify-center text-white active:scale-90 transition-transform z-20"
                style="background: var(--chat-color);"
                aria-label="Close chat"
                x-cloak>
            <i class="ph-bold ph-x text-[18px] sm:text-xl" aria-hidden="true"></i>
        </button>

        <button x-show="!isOpen" @click="$wire.toggleChat()"
                x-transition:enter="transition ease-[cubic-bezier(.34,1.56,.64,1)] duration-500"
                x-transition:enter-start="opacity-0 scale-0"
                x-transition:enter-end="opacity-100 scale-100"
                x-transition:leave="transition ease-in duration-150"
                x-transition:leave-end="opacity-0 scale-0"
                class="absolute inset-0 w-full h-full rounded-[18px] shadow-[0_8px_30px_rgba(0,0,0,0.25)] flex items-center justify-center hover:scale-105 active:scale-95 transition-all duration-200 z-10"
                style="background: var(--chat-color);"
                aria-label="Open live chat">
            <i class="ph-fill ph-chat-centered-dots text-[22px] sm:text-2xl text-white" aria-hidden="true"></i>

            <div x-show="hasUnread" x-transition.scale.origin.center x-cloak
                 class="absolute -top-1 -right-1 w-[18px] h-[18px] bg-red-500 rounded-full flex items-center justify-center shadow-lg shadow-red-500/40 border-2 border-white dark:border-neutral-900"
                 aria-hidden="true">
                <span class="w-1.5 h-1.5 bg-white rounded-full animate-ping absolute"></span>
                <span class="w-1.5 h-1.5 bg-white rounded-full relative"></span>
            </div>
        </button>

        <div class="absolute inset-0 rounded-[18px] blur-xl scale-110 -z-10 animate-pulse pointer-events-none"
             style="background: color-mix(in srgb, var(--chat-color), transparent 75%);"
             x-show="hasUnread" x-cloak></div>
    </div>

    {{-- ═══ CHAT WINDOW ═══ --}}
    <div x-show="isOpen"
         x-transition:enter="transition ease-[cubic-bezier(.22,1,.36,1)] duration-400"
         x-transition:enter-start="opacity-0 translate-y-6 scale-[0.97]"
         x-transition:enter-end="opacity-100 translate-y-0 scale-100"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-end="opacity-0 translate-y-4 scale-[0.98]"
         class="absolute bottom-[4rem] sm:bottom-[4.5rem] right-0
                w-[calc(100vw-1.5rem)] sm:w-[400px]
                h-[calc(100dvh-6rem)] sm:h-[640px] max-h-[88dvh]
                flex flex-col overflow-hidden
                rounded-2xl sm:rounded-3xl
                bg-white dark:bg-[#0f0f11]
                border border-black/[0.06] dark:border-white/[0.06]
                shadow-[0_24px_80px_-12px_rgba(0,0,0,0.25)] dark:shadow-[0_24px_80px_-12px_rgba(0,0,0,0.6)]
                ring-1 ring-black/[0.03] dark:ring-white/[0.03]
                will-change-transform"
         x-cloak>

        {{-- HEADER --}}
        <div class="relative px-5 sm:px-6 pt-5 sm:pt-6 pb-5 flex flex-col gap-4 overflow-hidden flex-shrink-0"
             wire:key="chat-header">
            <div class="absolute inset-0" style="background: linear-gradient(135deg, var(--chat-color), color-mix(in srgb, var(--chat-color), black 20%));"></div>
            <div class="absolute inset-0 opacity-[0.025]" style="background-image: url('data:image/svg+xml,%3Csvg viewBox=%270 0 256 256%27 xmlns=%27http://www.w3.org/2000/svg%27%3E%3Cfilter id=%27n%27%3E%3CfeTurbulence type=%27fractalNoise%27 baseFrequency=%270.9%27 numOctaves=%274%27/%3E%3C/filter%3E%3Crect width=%27100%25%27 height=%27100%25%27 filter=%27url(%23n)%27/%3E%3C/svg%3E');"></div>
            <div class="absolute -top-12 -right-12 w-36 h-36 bg-white/[0.07] rounded-full blur-2xl pointer-events-none"></div>

            <div class="flex items-center justify-between relative z-10">
                @if($view !== 'home')
                    <button wire:click="backToHome"
                            class="w-9 h-9 bg-white/[0.1] hover:bg-white/[0.18] backdrop-blur-sm rounded-xl text-white/90 transition-all active:scale-90 flex items-center justify-center border border-white/[0.08]"
                            aria-label="Back to chat home">
                        <i class="ph-bold ph-arrow-left text-[15px]" aria-hidden="true"></i>
                    </button>
                @else
                    <div class="w-9 h-9 rounded-xl bg-white/[0.12] backdrop-blur-md flex items-center justify-center border border-white/[0.08]">
                        <i class="ph-bold ph-lightning text-white/90 text-[15px]"></i>
                    </div>
                @endif

                <div class="flex -space-x-2 items-center" wire:key="admin-avatars">
                    @forelse($this->admins as $admin)
                        <div wire:key="adm-{{ $admin->id }}"
                             class="w-8 h-8 rounded-full border-[1.5px] border-white/30 shadow-sm flex items-center justify-center text-[10px] font-bold uppercase bg-white/[0.15] backdrop-blur-sm text-white">
                            {{ $admin->initials }}
                        </div>
                    @empty
                        <div class="w-8 h-8 rounded-full bg-white/[0.12] border-[1.5px] border-white/20 flex items-center justify-center" wire:key="no-adm">
                            <i class="ph ph-user text-white/70 text-sm"></i>
                        </div>
                    @endforelse
                </div>
            </div>

            <div class="relative z-10 space-y-1.5">
                <h3 class="font-semibold text-[15px] sm:text-base text-white tracking-tight leading-none">
                    @if($this->activeTicket?->assignedAdmin)
                        {{ $this->activeTicket->assignedAdmin->name }}
                    @else
                        {{ gs('ticket_livechat_title') ?? 'Support' }}
                    @endif
                </h3>
                <div class="flex items-center gap-1.5">
                    @if($this->isAdminOnline)
                        <span class="relative flex h-2 w-2"><span class="animate-ping absolute h-full w-full rounded-full bg-emerald-300 opacity-75"></span><span class="relative rounded-full h-2 w-2 bg-emerald-400"></span></span>
                        <span class="text-[11px] font-medium text-white/60">Online — replies instantly</span>
                    @else
                        <span class="w-2 h-2 rounded-full bg-amber-400/80"></span>
                        <span class="text-[11px] font-medium text-white/50">Away — we'll reply soon</span>
                    @endif
                </div>
            </div>
        </div>

        {{-- CONTENT --}}
        <div class="flex-1 overflow-y-auto bg-slate-50/50 dark:bg-[#0f0f11] px-4 sm:px-5 py-5 livechat-scroll"
             x-ref="chatContainer">

            @if($view === 'home')
                <div class="space-y-5" wire:key="view-home">
                    <div class="px-0.5">
                        <p class="font-semibold text-base text-slate-900 dark:text-white tracking-tight">
                            @auth Hi {{ auth()->user()->firstname }} 👋 @else Hey there 👋 @endauth
                        </p>
                        <p class="text-slate-500 dark:text-slate-400 text-[13px] mt-0.5">How can we help you today?</p>
                    </div>

                    <div class="space-y-2">
                        <button wire:click="startNewTicket"
                                class="w-full group text-left bg-white dark:bg-white/[0.03] p-4 rounded-2xl border border-slate-200/80 dark:border-white/[0.06] hover:border-primary-500/30 hover:shadow-lg hover:shadow-primary-500/[0.04] transition-all duration-200">
                            <div class="flex items-center gap-3.5">
                                <div class="w-10 h-10 rounded-xl bg-primary-50 dark:bg-primary-500/10 text-primary-500 flex items-center justify-center group-hover:bg-primary-500 group-hover:text-white transition-all duration-200 flex-shrink-0">
                                    <i class="ph-bold ph-chat-text text-lg"></i>
                                </div>
                                <div class="min-w-0">
                                    <p class="text-[14px] font-semibold text-slate-800 dark:text-white leading-none">New Conversation</p>
                                    <p class="text-[11px] text-slate-400 dark:text-slate-500 mt-1">Usually replies in ~5 min</p>
                                </div>
                                <i class="ph-bold ph-arrow-right text-slate-300 dark:text-slate-600 group-hover:text-primary-500 group-hover:translate-x-0.5 transition-all ml-auto"></i>
                            </div>
                        </button>

                        <a href="{{ route('kb.index') }}" wire:navigate
                           class="flex items-center gap-3.5 p-4 rounded-2xl bg-white dark:bg-white/[0.03] border border-slate-200/80 dark:border-white/[0.06] hover:border-primary-500/20 transition-all duration-200 group">
                            <div class="w-10 h-10 rounded-xl bg-slate-100 dark:bg-white/[0.04] text-slate-500 dark:text-slate-400 flex items-center justify-center flex-shrink-0">
                                <i class="ph-bold ph-books text-lg"></i>
                            </div>
                            <div class="min-w-0">
                                <p class="text-[14px] font-semibold text-slate-800 dark:text-white leading-none">Help Center</p>
                                <p class="text-[11px] text-slate-400 dark:text-slate-500 mt-1">Browse articles & guides</p>
                            </div>
                            <i class="ph-bold ph-arrow-right text-slate-300 dark:text-slate-600 group-hover:text-primary-500 group-hover:translate-x-0.5 transition-all ml-auto"></i>
                        </a>
                    </div>

                    @if($this->tickets->count() > 0)
                        <div class="pt-1">
                            <p class="text-[10px] font-semibold text-slate-400 dark:text-slate-500 uppercase tracking-[0.12em] px-0.5 mb-2.5">Recent</p>
                            <div class="space-y-1.5">
                                @foreach($this->tickets->take(3) as $ticket)
                                    @php
                                        $isUnread = ($ticket->status == \App\Constants\Status::TICKET_ANSWERED && !in_array($ticket->id, $viewedTickets));
                                        $isClosed = $ticket->status == \App\Constants\Status::TICKET_CLOSED;
                                    @endphp
                                    <button wire:click="openTicket({{ $ticket->id }})" wire:key="tk-{{ $ticket->id }}"
                                            class="w-full text-left flex items-center gap-3 px-3.5 py-3 rounded-xl bg-white dark:bg-white/[0.02] border border-slate-100 dark:border-white/[0.04] hover:border-primary-500/20 transition-all duration-200 group relative">
                                        @if($isUnread)
                                            <span class="absolute -top-0.5 -right-0.5 w-2.5 h-2.5 bg-primary-500 rounded-full border-2 border-slate-50 dark:border-[#0f0f11] shadow-sm shadow-primary-500/40"></span>
                                        @endif
                                        <div class="w-1.5 h-1.5 rounded-full flex-shrink-0 {{ $isUnread ? 'bg-primary-500' : ($isClosed ? 'bg-slate-300 dark:bg-slate-600' : 'bg-emerald-500') }}"></div>
                                        <div class="flex-1 min-w-0">
                                            <p class="text-[13px] font-medium text-slate-800 dark:text-slate-200 truncate leading-none">{{ $ticket->subject }}</p>
                                            <p class="text-[10px] text-slate-400 dark:text-slate-500 mt-1">{{ $ticket->last_reply ? diffForHumans($ticket->last_reply) : diffForHumans($ticket->created_at) }}</p>
                                        </div>
                                        @if($isUnread)
                                            <span class="text-[8px] font-bold text-primary-500 bg-primary-500/10 px-1.5 py-0.5 rounded-md uppercase tracking-wide">New</span>
                                        @endif
                                        <i class="ph ph-caret-right text-slate-300 dark:text-slate-600 text-xs group-hover:text-primary-500 transition-colors"></i>
                                    </button>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>

            @elseif($view === 'login')
                <div class="flex flex-col items-center justify-center text-center py-10 sm:py-14 space-y-5" wire:key="view-login">
                    <div class="w-16 h-16 bg-slate-100 dark:bg-white/[0.04] rounded-2xl flex items-center justify-center">
                        <i class="ph-bold ph-lock-simple text-3xl text-slate-300 dark:text-slate-600"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-lg text-slate-900 dark:text-white tracking-tight">Sign in required</h3>
                        <p class="text-slate-500 dark:text-slate-400 text-[13px] mt-1">Log in to chat with our team.</p>
                    </div>
                    <a href="{{ route('user.login') }}" wire:navigate
                       class="px-6 py-2.5 rounded-xl bg-primary-600 text-white text-[13px] font-semibold shadow-md shadow-primary-500/20 hover:bg-primary-700 active:scale-[0.97] transition-all">
                        Sign In
                    </a>
                </div>

            @elseif($view === 'new_ticket')
                <div class="space-y-5" wire:key="view-new">
                    <div>
                        <h3 class="font-semibold text-base text-slate-900 dark:text-white tracking-tight">New conversation</h3>
                        <p class="text-slate-500 dark:text-slate-400 text-[12px] mt-0.5">Describe your issue for faster support.</p>
                    </div>
                    <div class="space-y-3">
                        <div>
                            <label class="text-[10px] font-semibold text-slate-400 dark:text-slate-500 uppercase tracking-[0.1em] mb-1 block">Category</label>
                            <div class="relative">
                                <select wire:model="category_id" class="livechat-input pr-9 appearance-none">
                                    @foreach($this->categories as $category)
                                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                                    @endforeach
                                </select>
                                <i class="ph-bold ph-caret-down text-slate-400 dark:text-slate-500 absolute right-3 top-1/2 -translate-y-1/2 pointer-events-none text-xs"></i>
                            </div>
                        </div>
                        @if(!auth()->check())
                            <input type="text" wire:model="name" placeholder="Your name" class="livechat-input">
                            <input type="email" wire:model="email" placeholder="Email" class="livechat-input">
                        @endif
                        <input type="text" wire:model="subject" placeholder="Subject" class="livechat-input">
                        <textarea wire:model="message" rows="3" placeholder="How can we help?" class="livechat-input resize-none"></textarea>
                        @error('subject') <p class="text-red-500 text-[11px] px-0.5">{{ $message }}</p> @enderror
                        @error('message') <p class="text-red-500 text-[11px] px-0.5">{{ $message }}</p> @enderror

                        <button wire:click="createTicket" wire:loading.attr="disabled"
                                class="w-full py-3 rounded-xl bg-primary-600 text-white text-[13px] font-semibold shadow-md shadow-primary-500/20 hover:bg-primary-700 active:scale-[0.97] transition-all disabled:opacity-50">
                            <span wire:loading.remove wire:target="createTicket">Send Message</span>
                            <span wire:loading wire:target="createTicket" class="inline-flex items-center gap-1.5">
                                <svg class="animate-spin h-3.5 w-3.5" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4" fill="none"/><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"/></svg>
                                Sending…
                            </span>
                        </button>
                    </div>
                </div>

            @elseif($view === 'chat' && $this->activeTicket)
                <div class="space-y-4 pb-1" wire:key="view-chat-{{ $activeTicketId }}">
                    {{-- Ticket meta --}}
                    <div class="flex items-center justify-between bg-white dark:bg-white/[0.03] rounded-xl px-3.5 py-2.5 border border-slate-100 dark:border-white/[0.05]">
                        <div class="flex items-center gap-2 min-w-0">
                            <span class="text-[9px] font-bold text-primary-600 dark:text-primary-400 bg-primary-500/10 px-2 py-0.5 rounded-md tracking-wide flex-shrink-0">#{{ $this->activeTicket->ticket }}</span>
                            <span class="text-[12px] font-medium text-slate-500 dark:text-slate-400 truncate">{{ $this->activeTicket->subject }}</span>
                        </div>
                        @auth
                            <a href="{{ route('client.tickets.show', $this->activeTicket->ticket) }}" wire:navigate
                               class="text-[9px] font-bold text-primary-500 hover:text-primary-600 uppercase tracking-wider flex-shrink-0 ml-2">Open ↗</a>
                        @endauth
                    </div>

                    {{-- Messages --}}
                    @foreach($this->groupedMessages as $gi => $group)
                        <div class="flex flex-col {{ $group['sender'] === 'admin' ? 'items-start' : 'items-end' }} space-y-0.5" wire:key="g-{{ $gi }}">
                            @if($group['sender'] === 'admin' && $group['admin'])
                                <span class="text-[9px] font-semibold text-slate-400 dark:text-slate-500 uppercase tracking-[0.08em] px-0.5 mb-1">{{ $group['admin']->name ?? 'Support' }}</span>
                            @endif

                            @foreach($group['messages'] as $mi => $msg)
                                <div wire:key="m-{{ $msg->id }}"
                                     class="max-w-[82%] px-3.5 py-2.5 text-[13px] leading-[1.55]
                                    {{ $msg->admin_id
                                        ? 'bg-white dark:bg-white/[0.05] text-slate-700 dark:text-slate-300 border border-slate-100 dark:border-white/[0.06]'
                                        : 'bg-primary-600 text-white' }}
                                    {{ $loop->first && $msg->admin_id  ? 'rounded-2xl rounded-tl-[6px]' : '' }}
                                    {{ $loop->first && !$msg->admin_id ? 'rounded-2xl rounded-tr-[6px]' : '' }}
                                    {{ !$loop->first ? 'rounded-2xl' : '' }}">
                                    {!! nl2br(e($msg->message)) !!}

                                    @if($msg->attachments?->count())
                                        <div class="mt-2 pt-2 border-t {{ $msg->admin_id ? 'border-slate-100 dark:border-white/[0.06]' : 'border-white/20' }} space-y-1">
                                            @foreach($msg->attachments as $att)
                                                <a href="{{ route('client.tickets.attachment.download', $att->id) }}" target="_blank"
                                                   class="flex items-center gap-1.5 text-[11px] font-medium {{ $msg->admin_id ? 'text-primary-500' : 'text-white/80 hover:text-white' }} transition-colors">
                                                    <i class="ph ph-file-arrow-down text-sm"></i>{{ $att->original_name ?? 'File' }}
                                                </a>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            @endforeach

                            <span class="text-[9px] text-slate-400 dark:text-slate-500 px-0.5 mt-0.5 font-medium">
                                {{ $group['messages'][count($group['messages'])-1]->created_at->diffForHumans() }}
                            </span>
                        </div>
                    @endforeach

                    {{-- Optimistic message (instant) --}}
                    <template x-if="optimisticMsg">
                        <div class="flex flex-col items-end space-y-0.5">
                            <div class="max-w-[82%] px-3.5 py-2.5 text-[13px] leading-[1.55] bg-primary-600 text-white rounded-2xl rounded-tr-[6px] opacity-70">
                                <span x-text="optimisticMsg"></span>
                            </div>
                            <span class="text-[9px] text-slate-400 px-0.5 font-medium">Sending…</span>
                        </div>
                    </template>

                    {{-- Typing indicator --}}
                    @if($this->isAdminTyping)
                        <div class="flex items-start" wire:key="typing">
                            <div class="bg-white dark:bg-white/[0.05] border border-slate-100 dark:border-white/[0.06] px-4 py-3 rounded-2xl rounded-tl-[6px]">
                                <div class="flex gap-1">
                                    <span class="w-[5px] h-[5px] bg-slate-400 dark:bg-slate-500 rounded-full animate-bounce"></span>
                                    <span class="w-[5px] h-[5px] bg-slate-400 dark:bg-slate-500 rounded-full animate-bounce [animation-delay:0.15s]"></span>
                                    <span class="w-[5px] h-[5px] bg-slate-400 dark:bg-slate-500 rounded-full animate-bounce [animation-delay:0.3s]"></span>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            @endif
        </div>

        {{-- FOOTER --}}
        <div class="bg-white dark:bg-[#0f0f11] px-4 sm:px-5 pb-4 sm:pb-5 pt-0 flex-shrink-0" wire:key="chat-footer">
            @if($view === 'chat')
                <div class="space-y-2.5 mb-3">
                    @if(count($attachments) > 0)
                        <div class="flex flex-wrap gap-1.5 px-1">
                            @foreach($attachments as $i => $file)
                                <span class="inline-flex items-center gap-1.5 bg-slate-100 dark:bg-white/[0.04] px-2.5 py-1 rounded-lg text-[11px] font-medium text-slate-600 dark:text-slate-300 border border-slate-200 dark:border-white/[0.06]">
                                    <i class="ph ph-file text-xs"></i>
                                    <span class="max-w-[80px] truncate">{{ $file->getClientOriginalName() }}</span>
                                    <button wire:click="removeAttachment({{ $i }})" class="text-slate-400 hover:text-red-500 transition-colors" aria-label="Remove file"><i class="ph-bold ph-x text-[9px]" aria-hidden="true"></i></button>
                                </span>
                            @endforeach
                        </div>
                    @endif

                    <div class="flex items-end gap-1.5 bg-slate-50 dark:bg-white/[0.03] p-1 rounded-xl border border-slate-200 dark:border-white/[0.06] focus-within:border-primary-500/40 focus-within:ring-2 focus-within:ring-primary-500/10 transition-all duration-200"
                         x-data="{ rows: 1 }" @input="rows = Math.min(4, $event.target.value.split('\n').length)">

                        <label class="w-8 h-8 rounded-lg text-slate-400 dark:text-slate-500 hover:text-primary-500 hover:bg-primary-500/5 flex items-center justify-center cursor-pointer transition-all flex-shrink-0">
                            <i class="ph ph-paperclip text-[15px]"></i>
                            <input type="file" wire:model="attachments" multiple class="hidden" accept=".jpg,.jpeg,.png,.gif,.pdf,.doc,.docx,.txt,.zip">
                        </label>

                        <textarea wire:model.blur="message"
                                  x-on:keydown.enter.prevent="if(!$event.shiftKey) send()"
                                  placeholder="Type a message…"
                                  :rows="rows"
                                  class="flex-1 bg-transparent border-none focus:ring-0 text-[13px] py-1.5 text-slate-700 dark:text-slate-200 placeholder-slate-400 dark:placeholder-slate-500 resize-none leading-snug"></textarea>

                        <button @click="send()" :disabled="sending"
                                class="w-8 h-8 rounded-lg bg-primary-600 text-white flex items-center justify-center active:scale-90 shadow-sm shadow-primary-500/20 hover:bg-primary-700 disabled:opacity-40 transition-all flex-shrink-0"
                                aria-label="Send message">
                            <template x-if="!sending"><i class="ph-bold ph-arrow-up text-sm"></i></template>
                            <template x-if="sending"><svg class="animate-spin h-3 w-3" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4" fill="none"/><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4z"/></svg></template>
                        </button>
                    </div>

                    <div class="flex justify-between items-center px-1">
                        <button wire:click="endChat" wire:confirm="End this conversation?"
                                class="text-[10px] font-semibold text-slate-400 dark:text-slate-500 hover:text-red-500 transition-colors uppercase tracking-wider">End chat</button>
                        <span class="text-[10px] text-slate-300 dark:text-slate-600">#{{ $this->activeTicket->ticket }}</span>
                    </div>
                </div>
            @endif

            <div class="text-center border-t border-slate-100 dark:border-white/[0.04] pt-3">
                <a href="https://salieno.com" target="_blank" class="inline-block group">
                    <p class="text-[9px] font-semibold text-slate-300 dark:text-slate-600 tracking-[0.15em] uppercase group-hover:text-slate-500 dark:group-hover:text-slate-400 transition-colors">⚡ Salieno</p>
                </a>
            </div>
        </div>
    </div>

    <audio id="_chatSfx" preload="auto"><source src="{{ asset('assets/audio/notification.mp3') }}" type="audio/mpeg"></audio>

    <script data-navigate-once>
        // Unlock audio on first interaction
        const _u = () => { const a=document.getElementById('_chatSfx'); if(a) a.play().then(()=>{a.pause();a.currentTime=0}).catch(()=>{}); document.removeEventListener('click',_u); document.removeEventListener('touchstart',_u); };
        document.addEventListener('click',_u);
        document.addEventListener('touchstart',_u);
        window.addEventListener('play-chat-sound', () => { const a=document.getElementById('_chatSfx'); if(a){a.currentTime=0;a.play().catch(()=>{})} });
    </script>
</div>
