<div class="grid lg:grid-cols-3 gap-8">
    {{-- Main Configuration Panel --}}
    <div class="lg:col-span-2 space-y-6">
        {{-- Billing Cycle Selection --}}
        <div class="bg-white rounded-2xl border border-slate-100 shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-slate-100 bg-slate-50">
                <h3 class="text-lg font-semibold text-slate-800 flex items-center gap-2">
                    <i class="ph ph-calendar-check text-primary-600"></i>
                    {{ __('Select Billing Cycle') }}
                </h3>
            </div>
            <div class="p-6">
                <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($billingCycles as $key => $cycle)
                        <label class="relative cursor-pointer group">
                            <input type="radio" wire:model.live="selectedCycle" value="{{ $key }}" class="peer sr-only">
                            <div class="p-4 rounded-xl border-2 transition-all duration-200
                                {{ $selectedCycle === $key
                                    ? 'border-primary-500 bg-primary-50 ring-2 ring-primary-500/20'
                                    : 'border-slate-200 hover:border-primary-200 bg-white' }}">
                                <div class="flex items-center justify-between mb-2">
                                    <span class="font-semibold text-slate-800">{{ $cycle['label'] }}</span>
                                    @if($selectedCycle === $key)
                                        <i class="ph ph-check-circle-fill text-primary-600"></i>
                                    @endif
                                </div>
                                <div class="text-2xl font-bold text-slate-900">{{ formatCurrency($cycle['price']) }}</div>
                                @if($cycle['setup_fee'] > 0)
                                    <div class="text-xs text-slate-500 mt-1">+ {{ formatCurrency($cycle['setup_fee']) }} {{ __('setup') }}</div>
                                @endif
                                @if($cycle['months'] > 1)
                                    <div class="text-xs text-accent-600 font-medium mt-1">
                                        {{ formatCurrency($cycle['monthly_equivalent']) }}/{{ __('mo') }}
                                    </div>
                                @endif
                            </div>
                        </label>
                    @endforeach
                </div>
            </div>
        </div>

        {{-- Domain Configuration (if product requires domain) --}}
        @if($product->domain_register && count($domainSetups) > 0)
        <div class="bg-white rounded-2xl border border-slate-100 shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-slate-100 bg-slate-50">
                <h3 class="text-lg font-semibold text-slate-800 flex items-center gap-2">
                    <i class="ph ph-globe text-primary-600"></i>
                    {{ __('Domain Configuration') }}
                </h3>
            </div>
            <div class="p-6 space-y-6">
                {{-- Domain Options --}}
                <div class="grid sm:grid-cols-2 gap-4">
                    <label class="relative cursor-pointer">
                        <input type="radio" wire:model.live="domainOption" value="register" class="peer sr-only">
                        <div class="p-4 rounded-xl border-2 transition-all {{ $domainOption === 'register' ? 'border-primary-500 bg-primary-50' : 'border-slate-200 hover:border-primary-200' }}">
                            <div class="flex items-center gap-3">
                                <i class="ph ph-plus-circle text-xl {{ $domainOption === 'register' ? 'text-primary-600' : 'text-slate-400' }}"></i>
                                <span class="font-medium text-slate-800">{{ __('Register New Domain') }}</span>
                            </div>
                        </div>
                    </label>
                    <label class="relative cursor-pointer">
                        <input type="radio" wire:model.live="domainOption" value="existing" class="peer sr-only">
                        <div class="p-4 rounded-xl border-2 transition-all {{ $domainOption === 'existing' ? 'border-primary-500 bg-primary-50' : 'border-slate-200 hover:border-primary-200' }}">
                            <div class="flex items-center gap-3">
                                <i class="ph ph-link text-xl {{ $domainOption === 'existing' ? 'text-primary-600' : 'text-slate-400' }}"></i>
                                <span class="font-medium text-slate-800">{{ __('Use Existing Domain') }}</span>
                            </div>
                        </div>
                    </label>
                </div>

                {{-- Register New Domain --}}
                @if($domainOption === 'register')
                <div class="space-y-4">
                    <div class="flex gap-2">
                        <div class="flex-1">
                            <input type="text" wire:model="domainName" placeholder="{{ __('Enter domain name') }}"
                                class="w-full px-4 py-3 rounded-xl border border-slate-200 focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition">
                        </div>
                        <select wire:model.live="domainExtension" class="px-4 py-3 rounded-xl border border-slate-200 focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition">
                            @foreach($domainSetups as $setup)
                                <option value=".{{ $setup['extension'] ?? 'com' }}">.{{ $setup['extension'] ?? 'com' }}</option>
                            @endforeach
                        </select>
                        <button wire:click="checkDomain" wire:loading.attr="disabled"
                            class="px-6 py-3 rounded-xl bg-primary-600 text-white font-medium hover:bg-primary-700 transition disabled:opacity-50">
                            <span wire:loading.remove wire:target="checkDomain">{{ __('Check') }}</span>
                            <span wire:loading wire:target="checkDomain"><i class="ph ph-spinner animate-spin"></i></span>
                        </button>
                    </div>
                    @if($domainCheckMessage)
                        <div class="flex items-center gap-2 text-sm {{ $domainAvailable ? 'text-green-600' : 'text-red-600' }}">
                            <i class="ph {{ $domainAvailable ? 'ph-check-circle' : 'ph-x-circle' }}"></i>
                            {{ $domainCheckMessage }}
                        </div>
                    @endif
                </div>
                @endif

                {{-- Use Existing Domain --}}
                @if($domainOption === 'existing')
                <div>
                    <input type="text" wire:model="existingDomain" placeholder="{{ __('Enter your existing domain (e.g., example.com)') }}"
                        class="w-full px-4 py-3 rounded-xl border border-slate-200 focus:border-primary-500 focus:ring-2 focus:ring-primary-500/20 transition">
                    <p class="text-sm text-slate-500 mt-2">{{ __('You will need to update your domain\'s nameservers after purchase.') }}</p>
                </div>
                @endif
            </div>
        </div>
        @endif

        {{-- Configurable Options --}}
        @if($product->configurableGroups && $product->configurableGroups->count() > 0)
        <div class="bg-white rounded-2xl border border-slate-100 shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-slate-100 bg-slate-50">
                <h3 class="text-lg font-semibold text-slate-800 flex items-center gap-2">
                    <i class="ph ph-sliders text-primary-600"></i>
                    {{ __('Configuration Options') }}
                </h3>
            </div>
            <div class="p-6 space-y-6">
                @foreach($product->configurableGroups as $group)
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-2">{{ $group->name }}</label>
                        @foreach($group->options as $option)
                            <div class="space-y-2">
                                @foreach($option->subOptions as $subOption)
                                    <label class="flex items-center gap-3 p-3 rounded-lg border border-slate-200 hover:border-primary-200 cursor-pointer transition">
                                        <input type="radio" name="config_{{ $option->id }}"
                                            wire:model="configOptions.{{ $option->id }}"
                                            value="{{ $subOption->id }}"
                                            class="text-primary-600 focus:ring-primary-500">
                                        <span class="flex-1 text-slate-700">{{ $subOption->name }}</span>
                                        @if($subOption->pricing)
                                            <span class="text-sm font-medium text-slate-500">
                                                +{{ formatCurrency($subOption->pricing->monthly ?? 0) }}/{{ __('mo') }}
                                            </span>
                                        @endif
                                    </label>
                                @endforeach
                            </div>
                        @endforeach
                    </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>

    {{-- Order Summary Sidebar --}}
    <div class="lg:col-span-1">
        <div class="sticky top-24 space-y-6">
            {{-- Order Summary Card --}}
            <div class="bg-white rounded-2xl border border-slate-100 shadow-sm overflow-hidden">
                <div class="px-6 py-4 border-b border-slate-100 bg-gradient-to-r from-primary-600 to-primary-500">
                    <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                        <i class="ph ph-shopping-cart"></i>
                        {{ __('Order Summary') }}
                    </h3>
                </div>
                <div class="p-6 space-y-4">
                    {{-- Product Info --}}
                    <div class="flex items-start gap-4 pb-4 border-b border-slate-100">
                        <div class="w-12 h-12 rounded-xl bg-primary-50 flex items-center justify-center shrink-0">
                            <i class="ph ph-hard-drives text-xl text-primary-600"></i>
                        </div>
                        <div class="flex-1 min-w-0">
                            <h4 class="font-semibold text-slate-800 truncate">{{ $product->name }}</h4>
                            <p class="text-sm text-slate-500">{{ $category->name }}</p>
                        </div>
                    </div>

                    {{-- Billing Cycle --}}
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-slate-600">{{ __('Billing Cycle') }}</span>
                        <span class="font-medium text-slate-800">{{ $this->currentPrice['label'] ?? 'Monthly' }}</span>
                    </div>

                    {{-- Product Price --}}
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-slate-600">{{ __('Product Price') }}</span>
                        <span class="font-medium text-slate-800">{{ formatCurrency($this->currentPrice['price'] ?? 0) }}</span>
                    </div>

                    {{-- Setup Fee --}}
                    @if(($this->currentPrice['setup_fee'] ?? 0) > 0)
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-slate-600">{{ __('Setup Fee') }}</span>
                        <span class="font-medium text-slate-800">{{ formatCurrency($this->currentPrice['setup_fee']) }}</span>
                    </div>
                    @endif

                    {{-- Domain Price --}}
                    @if($this->domainPrice > 0)
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-slate-600">{{ __('Domain Registration') }}</span>
                        <span class="font-medium text-slate-800">{{ formatCurrency($this->domainPrice) }}</span>
                    </div>
                    @endif

                    {{-- Total --}}
                    <div class="pt-4 border-t border-slate-100">
                        <div class="flex items-center justify-between">
                            <span class="text-lg font-semibold text-slate-800">{{ __('Total Due Today') }}</span>
                            <span class="text-2xl font-bold text-primary-600">{{ formatCurrency($this->orderTotal) }}</span>
                        </div>
                    </div>

                    {{-- Add to Cart Button --}}
                    <button wire:click="addToCart" wire:loading.attr="disabled"
                        class="w-full py-4 px-6 rounded-xl bg-gradient-to-r from-primary-600 to-primary-500 text-white font-semibold text-base hover:from-primary-700 hover:to-primary-600 transition-all shadow-lg shadow-primary-500/25 disabled:opacity-50 flex items-center justify-center gap-2">
                        <span wire:loading.remove wire:target="addToCart">
                            <i class="ph ph-shopping-cart-simple"></i>
                            {{ __('Add to Cart') }}
                        </span>
                        <span wire:loading wire:target="addToCart">
                            <i class="ph ph-spinner animate-spin"></i>
                            {{ __('Processing...') }}
                        </span>
                    </button>
                </div>
            </div>

            {{-- Trust Badges --}}
            <div class="bg-slate-50 rounded-2xl p-5 space-y-4">
                <div class="flex items-center gap-3 text-sm text-slate-600">
                    <i class="ph ph-shield-check text-accent-500 text-lg"></i>
                    <span>{{ __('Secure SSL Checkout') }}</span>
                </div>
                <div class="flex items-center gap-3 text-sm text-slate-600">
                    <i class="ph ph-arrows-clockwise text-accent-500 text-lg"></i>
                    <span>{{ __('30-Day Money Back Guarantee') }}</span>
                </div>
                <div class="flex items-center gap-3 text-sm text-slate-600">
                    <i class="ph ph-headset text-accent-500 text-lg"></i>
                    <span>{{ __('24/7 Expert Support') }}</span>
                </div>
            </div>

            {{-- Need Help --}}
            <div class="text-center">
                <p class="text-sm text-slate-500 mb-2">{{ __('Need help choosing?') }}</p>
                <a href="{{ route('contact') }}" class="inline-flex items-center gap-2 text-sm font-medium text-primary-600 hover:text-primary-700 transition">
                    <i class="ph ph-chat-circle-dots"></i>
                    {{ __('Contact our sales team') }}
                </a>
            </div>
        </div>
    </div>
</div>

