<div class="w-full">
    {{-- Glassmorphic Card --}}
    {{-- Salieno-Spec Liquid Chassis --}}
    <div class="bg-slate-900/50 backdrop-blur-3xl border border-white/5 rounded-3xl shadow-2xl shadow-black/50 overflow-hidden">
        
        {{-- Progress Bar --}}
        <div class="h-1 bg-slate-100 dark:bg-slate-800 flex">
            @for ($i = 1; $i <= 5; $i++)
                <div class="h-full transition-all duration-500 ease-in-out {{ $step >= $i ? 'bg-primary-500 w-1/5' : 'w-0' }}"></div>
            @endfor
        </div>

        <div class="p-6 sm:p-10">
            @if ($step == 1)
                {{-- Step 1: Welcome & Readiness --}}
                <div x-data="{ confirmingReset: false }" class="text-center animate-in fade-in slide-in-from-bottom-4 duration-700">
                    <div class="w-20 h-20 bg-primary-500/10 rounded-2xl flex items-center justify-center mx-auto mb-8">
                        <i class="ph-fill ph-rocket-launch text-4xl text-primary-500"></i>
                    </div>
                    
                    <h2 class="text-3xl font-black text-white mb-4 tracking-tighter font-display leading-tight">Ready to launch?</h2>
                    <p class="text-slate-400 text-lg mb-10 max-w-lg mx-auto leading-relaxed">
                        Welcome to the Salieno Advanced Auto-Installer. We'll get your digital empire up and running in just a few minutes.
                    </p>

                    <div class="grid grid-cols-2 gap-4 mb-10">
                        <div class="p-5 rounded-2xl bg-white/5 border border-white/10 flex flex-col items-center group transition-all hover:bg-white/10">
                            <span class="text-2xl mb-1 {{ $requirementsMet ? 'text-green-500' : 'text-amber-500' }}">
                                <i class="ph-bold {{ $requirementsMet ? 'ph-check-circle' : 'ph-warning-circle' }}"></i>
                            </span>
                            <span class="text-[10px] font-black uppercase tracking-[0.2em] text-slate-400">Environment</span>
                            <span class="text-sm font-bold text-white">{{ $requirementsMet ? 'Compatible' : 'Requires Fixes' }}</span>
                        </div>
                        <div class="p-5 rounded-2xl bg-white/5 border border-white/10 flex flex-col items-center group transition-all hover:bg-white/10">
                            <span class="text-2xl mb-1 text-primary-500"><i class="ph-bold ph-shield-check"></i></span>
                            <span class="text-[10px] font-black uppercase tracking-[0.2em] text-slate-400">Security</span>
                            <span class="text-sm font-bold text-white">Military Grade</span>
                        </div>
                    </div>

                    <div class="flex flex-col items-center gap-4">
                        <button wire:click="nextStep" class="group w-full sm:w-64 h-14 inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] text-lg px-8 py-3.5">
                            <span>Get Started</span>
                            <svg class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" /></svg>
                        </button>
                        <div class="flex items-center gap-6">
                            <p class="text-xs font-bold text-slate-400 uppercase tracking-widest">Takes ~3 minutes</p>
                            <button @click="confirmingReset = true" class="text-xs font-bold text-primary-500/50 hover:text-primary-500 uppercase tracking-widest transition-colors">
                                Reset Progress
                            </button>
                        </div>
                    </div>

                    {{-- Premium Confirmation Modal --}}
                    <div x-show="confirmingReset" 
                         x-cloak
                         class="fixed inset-0 z-50 flex items-center justify-center p-4 bg-slate-950/80 backdrop-blur-sm"
                         x-transition:enter="transition ease-out duration-300"
                         x-transition:enter-start="opacity-0"
                         x-transition:enter-end="opacity-100"
                         x-transition:leave="transition ease-in duration-200"
                         x-transition:leave-start="opacity-100"
                         x-transition:leave-end="opacity-0">
                        
                        <div @click.away="confirmingReset = false" 
                             class="bg-slate-900 border border-white/10 rounded-3xl p-8 max-w-sm w-full shadow-2xl animate-in zoom-in-95 duration-200">
                            <div class="w-16 h-16 bg-red-500/10 rounded-2xl flex items-center justify-center mx-auto mb-6">
                                <i class="ph-bold ph-warning text-3xl text-red-500"></i>
                            </div>
                            <h3 class="text-xl font-black text-white mb-2 font-display">Reset Installation?</h3>
                            <p class="text-slate-400 text-sm mb-8">This will clear all your progress and configurations. This action cannot be undone.</p>
                            
                            <div class="flex flex-col gap-3">
                                <button wire:click="resetSession" class="group w-full inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-red-500 hover:bg-red-600 text-white shadow-lg shadow-red-500/25 hover:shadow-red-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] px-7 py-2.5 text-sm">
                                    Yes, Reset Everything
                                </button>
                                <button @click="confirmingReset = false" class="w-full inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-white/5 hover:bg-white/10 text-white border border-white/10 hover:border-white/20 backdrop-blur-sm transition-[border-color,background-color,box-shadow,transform] duration-300 px-7 py-2.5 text-sm">
                                    Cancel
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

            @elseif ($step == 2)
                {{-- Step 2: Requirements & Permissions --}}
                <div class="animate-in fade-in slide-in-from-right-4 duration-500">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 bg-primary-500/10 rounded-xl flex items-center justify-center">
                            <i class="ph-bold ph-list-checks text-2xl text-primary-500"></i>
                        </div>
                        <div>
                            <h2 class="text-2xl font-black text-white tracking-tight font-display">System Guard</h2>
                            <p class="text-sm text-slate-400 font-medium tracking-tight">Verifying PHP environment and folder permissions</p>
                        </div>
                    </div>

                    <div class="space-y-8">
                        {{-- PHP Extensions --}}
                        <div>
                            <h3 class="text-xs font-black uppercase tracking-[0.2em] text-slate-400 mb-4 flex items-center gap-2">
                                <span>PHP Extensions</span>
                                <div class="h-px flex-1 bg-slate-800"></div>
                            </h3>
                            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-3">
                                @foreach($requirements as $key => $req)
                                    <div class="p-3 rounded-xl border {{ $req['passed'] ? 'bg-green-500/5 border-green-500/20' : 'bg-red-500/5 border-red-500/20' }} flex items-center justify-between">
                                        <span class="text-sm font-bold {{ $req['passed'] ? 'text-slate-300' : 'text-red-500' }}">{{ $req['name'] }}</span>
                                        <i class="ph-bold {{ $req['passed'] ? 'ph-check-circle text-green-500' : 'ph-x-circle text-red-500' }}"></i>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                        {{-- Permissions --}}
                        <div>
                            <h3 class="text-xs font-black uppercase tracking-[0.2em] text-slate-400 mb-4 flex items-center gap-2">
                                <span>Write Permissions</span>
                                <div class="h-px flex-1 bg-slate-800"></div>
                            </h3>
                            <div class="space-y-2">
                                @foreach($permissions as $path => $isWritable)
                                    <div class="p-3 rounded-xl border {{ $isWritable ? 'bg-slate-800/30 border-slate-800' : 'bg-amber-500/5 border-amber-500/20' }} flex items-center justify-between">
                                        <code class="text-xs font-bold text-slate-400">{{ $path == '.' ? '/' : $path }}</code>
                                        <div class="flex items-center gap-2">
                                            <span class="text-[10px] font-black uppercase tracking-tighter {{ $isWritable ? 'text-slate-400' : 'text-amber-600' }}">
                                                {{ $isWritable ? 'Writable' : 'Locked' }}
                                            </span>
                                            <i class="ph-bold {{ $isWritable ? 'ph-check text-green-500' : 'ph-lock-simple text-amber-500' }}"></i>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>

                    <div class="mt-10 flex items-center justify-between pt-8 border-t border-slate-800">
                        <button wire:click="prevStep" class="inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-white/5 hover:bg-white/10 text-white border border-white/10 hover:border-white/20 backdrop-blur-sm transition-[border-color,background-color,box-shadow,transform] duration-300 px-7 py-2.5 text-sm">
                            <i class="ph-bold ph-caret-left"></i>
                            <span>Back</span>
                        </button>
                        <button wire:click="nextStep" class="group inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] px-8 py-2.5 text-sm {{ !$requirementsMet ? 'opacity-50 cursor-not-allowed' : '' }}">
                            <span>Continue</span>
                            <svg class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" /></svg>
                        </button>
                    </div>
                </div>
            @elseif ($step == 3)
                {{-- Step 3: Database Shield --}}
                <div class="animate-in fade-in slide-in-from-right-4 duration-500">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 bg-primary-500/10 rounded-xl flex items-center justify-center">
                            <i class="ph-bold ph-database text-2xl text-primary-500"></i>
                        </div>
                        <div>
                            <h2 class="text-2xl font-black text-white tracking-tight font-display">Database Shield</h2>
                            <p class="text-sm text-slate-400 font-medium tracking-tight">Securely connect your storage engine</p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                        <div class="col-span-full sm:col-span-1">
                            <label class="block text-xs font-black uppercase tracking-widest text-slate-400 mb-2">Host</label>
                            <input type="text" wire:model="db_host" autocomplete="off" id="db_host" class="w-full h-12 px-4 rounded-xl bg-white/5 border-white/10 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 transition-all outline-none">
                        </div>
                        <div class="col-span-full sm:col-span-1">
                            <label class="block text-xs font-black uppercase tracking-widest text-slate-400 mb-2">Port</label>
                            <input type="text" wire:model="db_port" autocomplete="off" id="db_port" class="w-full h-12 px-4 rounded-xl bg-white/5 border-white/10 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 transition-all outline-none">
                        </div>
                        <div class="col-span-full">
                            <label class="block text-xs font-black uppercase tracking-widest text-slate-400 mb-2">Database Name</label>
                            <input type="text" wire:model="db_database" id="db_database" autocomplete="off" placeholder="e.g. salieno_db" class="w-full h-12 px-4 rounded-xl bg-white/5 border-white/10 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 transition-all outline-none">
                        </div>
                        <div class="col-span-full sm:col-span-1">
                            <label class="block text-xs font-black uppercase tracking-widest text-slate-400 mb-2">Username</label>
                            <input type="text" wire:model="db_username" id="db_username" autocomplete="off" class="w-full h-12 px-4 rounded-xl bg-white/5 border-white/10 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 transition-all outline-none">
                        </div>
                        <div class="col-span-full sm:col-span-1">
                            <label class="block text-xs font-black uppercase tracking-widest text-slate-400 mb-2">Password</label>
                            <input type="password" wire:model="db_password" id="db_password" autocomplete="new-password" class="w-full h-12 px-4 rounded-xl bg-white/5 border-white/10 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 transition-all outline-none">
                        </div>
                    </div>

                    @error('db_connection')
                        <div class="mt-4 p-4 rounded-xl bg-red-500/5 border border-red-500/20 text-red-500 text-sm font-medium flex gap-2">
                            <i class="ph-bold ph-warning-circle text-lg flex-shrink-0"></i>
                            <span>{{ $message }}</span>
                        </div>
                    @enderror

                    <div class="mt-10 flex items-center justify-between pt-8 border-t border-slate-800">
                        <button wire:click="prevStep" class="inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-white/5 hover:bg-white/10 text-white border border-white/10 hover:border-white/20 backdrop-blur-sm transition-[border-color,background-color,box-shadow,transform] duration-300 px-7 py-2.5 text-sm">
                            <i class="ph-bold ph-caret-left"></i>
                            <span>Back</span>
                        </button>
                        <div class="flex gap-4">
                            <button wire:click="testDatabase" class="inline-flex items-center justify-center gap-2 font-bold rounded-xl border backdrop-blur-sm transition-[border-color,background-color,box-shadow,transform] duration-300 px-7 py-2.5 text-sm {{ $dbConnected ? 'border-green-500/30 text-green-500 bg-green-500/5' : 'border-primary-500/30 text-primary-500 bg-white/5 hover:bg-white/10' }}">
                                <i class="ph-bold {{ $dbConnected ? 'ph-check-circle' : 'ph-lightning' }}"></i>
                                <span>{{ $dbConnected ? 'Connected' : 'Test Connection' }}</span>
                            </button>
                            <button wire:click="nextStep" class="group inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] px-8 py-2.5 text-sm {{ !$dbConnected ? 'opacity-50 cursor-not-allowed' : '' }}">
                                <span>{{ $dbConnected ? 'Continue' : 'Validate Connection' }}</span>
                                <svg class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" /></svg>
                            </button>
                        </div>
                    </div>
                </div>

            @elseif ($step == 4)
                {{-- Step 4: Environment Forge --}}
                <div class="animate-in fade-in slide-in-from-right-4 duration-500">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 bg-primary-500/10 rounded-xl flex items-center justify-center">
                            <i class="ph-bold ph-gear-six text-2xl text-primary-500"></i>
                        </div>
                        <div>
                            <h2 class="text-2xl font-black text-white tracking-tighter font-display leading-tight">App Genesis</h2>
                            <p class="text-sm text-slate-400 font-medium tracking-tight">Identity and behavior synchronization</p>
                        </div>
                    </div>

                    <div class="space-y-6">
                        <div>
                            <label class="block text-xs font-black uppercase tracking-widest text-slate-400 mb-2">App Name</label>
                            <input type="text" wire:model="site_title" name="salieno_identity_{{ rand(1000,9999) }}" autocomplete="one-time-code" data-lpignore="true" data-1p-ignore class="w-full h-12 px-4 rounded-xl bg-white/5 border-white/10 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 transition-all outline-none">
                        </div>
                        <div>
                            <label class="block text-xs font-black uppercase tracking-widest text-slate-400 mb-2">App URL</label>
                            <input type="text" wire:model="site_endpoint" name="salieno_gateway_{{ rand(1000,9999) }}" autocomplete="one-time-code" data-lpignore="true" data-1p-ignore class="w-full h-12 px-4 rounded-xl bg-white/5 border-white/10 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 transition-all outline-none">
                        </div>
                        <div class="p-4 rounded-2xl bg-slate-800/50 border border-slate-800 flex items-center justify-between">
                            <div>
                                <span class="block text-sm font-bold text-white">Debug Mode</span>
                                <span class="text-xs text-slate-400 font-medium">Enabled detailed error reporting (Dev only)</span>
                            </div>
                            <button wire:click="$toggle('app_debug')" class="w-12 h-6 rounded-full transition-colors relative {{ $app_debug ? 'bg-primary-500' : 'bg-white/10' }}">
                                <div class="absolute top-1 left-1 w-4 h-4 bg-white rounded-full transition-all {{ $app_debug ? 'translate-x-6' : '' }}"></div>
                            </button>
                        </div>
                    </div>

                    <div class="mt-10 flex items-center justify-between pt-8 border-t border-slate-800">
                        <button wire:click="prevStep" class="inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-white/5 hover:bg-white/10 text-white border border-white/10 hover:border-white/20 backdrop-blur-sm transition-[border-color,background-color,box-shadow,transform] duration-300 px-7 py-2.5 text-sm">
                            <i class="ph-bold ph-caret-left"></i>
                            <span>Back</span>
                        </button>
                        <button wire:click="nextStep" class="group inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] px-8 py-2.5 text-sm">
                            <span>Continue</span>
                            <svg class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" /></svg>
                        </button>
                    </div>
                </div>

            @elseif ($step == 5)
                {{-- Step 5: Admin Genesis --}}
                <div class="animate-in fade-in slide-in-from-right-4 duration-500">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 bg-primary-500/10 rounded-xl flex items-center justify-center">
                            <i class="ph-bold ph-user-focus text-2xl text-primary-500"></i>
                        </div>
                        <div>
                            <h2 class="text-2xl font-black text-white tracking-tighter font-display leading-tight">Sovereign Domain</h2>
                            <p class="text-sm text-slate-400 font-medium tracking-tight">Forging the primary administrator identity</p>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                        <div class="col-span-full">
                            <label class="block text-xs font-black uppercase tracking-widest text-slate-400 mb-2">Display Name</label>
                            <input type="text" wire:model="admin_name" name="salieno_persona_{{ rand(1000,9999) }}" autocomplete="one-time-code" data-lpignore="true" data-1p-ignore placeholder="Super Admin" class="w-full h-12 px-4 rounded-xl bg-white/5 border-white/10 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 transition-all outline-none">
                        </div>
                        <div class="col-span-full sm:col-span-1">
                            <label class="block text-xs font-black uppercase tracking-widest text-slate-400 mb-2">Email Address</label>
                            <input type="text" wire:model="admin_email" name="salieno_comms_{{ rand(1000,9999) }}" autocomplete="one-time-code" data-lpignore="true" data-1p-ignore class="w-full h-12 px-4 rounded-xl bg-white/5 border-white/10 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 transition-all outline-none">
                        </div>
                        <div class="col-span-full sm:col-span-1">
                            <label class="block text-xs font-black uppercase tracking-widest text-slate-400 mb-2">Username</label>
                            <input type="text" wire:model="admin_username" name="salieno_alias_{{ rand(1000,9999) }}" autocomplete="one-time-code" data-lpignore="true" data-1p-ignore placeholder="admin" class="w-full h-12 px-4 rounded-xl bg-white/5 border-white/10 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 transition-all outline-none">
                        </div>
                        <div class="col-span-full">
                            <label class="block text-xs font-black uppercase tracking-widest text-slate-400 mb-2">Password</label>
                            <input type="password" wire:model="admin_password" name="salieno_cipher_{{ rand(1000,9999) }}" autocomplete="new-password" data-lpignore="true" data-1p-ignore class="w-full h-12 px-4 rounded-xl bg-white/5 border-white/10 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 transition-all outline-none">
                        </div>
                    </div>

                    @error('install_error')
                        <div class="mt-4 p-4 rounded-xl bg-red-500/5 border border-red-500/20 text-red-500 text-sm font-medium flex gap-2">
                            <i class="ph-bold ph-warning-circle text-lg flex-shrink-0"></i>
                            <span>{{ $message }}</span>
                        </div>
                    @enderror

                    <div class="mt-10 flex items-center justify-between pt-8 border-t border-slate-800">
                        <button wire:click="prevStep" class="inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-white/5 hover:bg-white/10 text-white border border-white/10 hover:border-white/20 backdrop-blur-sm transition-[border-color,background-color,box-shadow,transform] duration-300 px-7 py-2.5 text-sm">
                            <i class="ph-bold ph-caret-left"></i>
                            <span>Back</span>
                        </button>
                        <button wire:click="nextStep" class="group inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] px-8 py-2.5 text-sm">
                            <span>Review Configuration</span>
                            <svg class="w-4 h-4 group-hover:translate-x-1 transition-transform" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path stroke-linecap="round" stroke-linejoin="round" d="M17 8l4 4m0 0l-4 4m4-4H3" /></svg>
                        </button>
                    </div>
                </div>

            @elseif ($step == 6)
                {{-- Step 6: Confirmation Summary --}}
                <div class="animate-in fade-in slide-in-from-right-4 duration-500">
                    <div class="flex items-center gap-4 mb-8">
                        <div class="w-12 h-12 bg-primary-500/10 rounded-xl flex items-center justify-center">
                            <i class="ph-bold ph-file-search text-2xl text-primary-500"></i>
                        </div>
                        <div>
                            <h2 class="text-2xl font-black text-white tracking-tighter font-display leading-tight">Deployment Ready</h2>
                            <p class="text-sm text-slate-400 font-medium tracking-tight">Please review your installation manifest</p>
                        </div>
                    </div>

                    <div class="space-y-4">
                        <div class="p-5 rounded-2xl bg-slate-800/30 border border-slate-800 relative group">
                            <button wire:click="goToStep(3)" class="absolute top-4 right-4 text-[10px] font-black uppercase tracking-widest text-primary-500 opacity-0 group-hover:opacity-100 transition-opacity flex items-center gap-1">
                                <i class="ph-bold ph-pencil-simple"></i>
                                <span>Edit</span>
                            </button>
                            <h3 class="text-[10px] font-black uppercase tracking-widest text-slate-400 mb-3">Database Engine</h3>
                            <div class="grid grid-cols-2 gap-y-2 text-sm">
                                <span class="text-slate-400">Host:</span> <span class="font-bold text-slate-200">{{ $db_host }}:{{ $db_port }}</span>
                                <span class="text-slate-400">Database:</span> <span class="font-bold text-slate-200">{{ $db_database }}</span>
                                <span class="text-slate-400">User:</span> <span class="font-bold text-slate-200">{{ $db_username }}</span>
                            </div>
                        </div>

                        <div class="p-5 rounded-2xl bg-slate-50 dark:bg-slate-800/30 border border-slate-100 dark:border-slate-800 relative group">
                            <button wire:click="goToStep(4)" class="absolute top-4 right-4 text-[10px] font-black uppercase tracking-widest text-primary-500 opacity-0 group-hover:opacity-100 transition-opacity flex items-center gap-1">
                                <i class="ph-bold ph-pencil-simple"></i>
                                <span>Edit</span>
                            </button>
                            <h3 class="text-[10px] font-black uppercase tracking-widest text-slate-400 mb-3">Application Forge</h3>
                            <div class="grid grid-cols-2 gap-y-2 text-sm">
                                <span class="text-slate-400">Name:</span> <span class="font-bold text-slate-200">{{ $site_title }}</span>
                                <span class="text-slate-400">URL:</span> <span class="font-bold text-slate-200">{{ $site_endpoint }}</span>
                                <span class="text-slate-400">Debug:</span> <span class="font-bold {{ $app_debug ? 'text-amber-500' : 'text-slate-200' }}">{{ $app_debug ? 'Enabled' : 'Disabled' }}</span>
                            </div>
                        </div>

                        <div class="p-5 rounded-2xl bg-slate-50 dark:bg-slate-800/30 border border-slate-100 dark:border-slate-800 relative group">
                            <button wire:click="goToStep(5)" class="absolute top-4 right-4 text-[10px] font-black uppercase tracking-widest text-primary-500 opacity-0 group-hover:opacity-100 transition-opacity flex items-center gap-1">
                                <i class="ph-bold ph-pencil-simple"></i>
                                <span>Edit</span>
                            </button>
                            <h3 class="text-[10px] font-black uppercase tracking-widest text-slate-400 mb-3">Super Admin Genesis</h3>
                            <div class="grid grid-cols-2 gap-y-2 text-sm">
                                <span class="text-slate-400">Identity:</span> <span class="font-bold text-slate-200">{{ $admin_name }}</span>
                                <span class="text-slate-400">Email:</span> <span class="font-bold text-slate-200">{{ $admin_email }}</span>
                                <span class="text-slate-400">Username:</span> <span class="font-bold text-slate-200">{{ $admin_username }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="mt-10 flex items-center justify-between pt-8 border-t border-slate-800">
                        <button wire:click="prevStep" class="inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-white/5 hover:bg-white/10 text-white border border-white/10 hover:border-white/20 backdrop-blur-sm transition-[border-color,background-color,box-shadow,transform] duration-300 px-7 py-2.5 text-sm">
                            <i class="ph-bold ph-caret-left"></i>
                            <span>Back</span>
                        </button>
                        <button wire:click="startInstallation" class="group inline-flex items-center justify-center gap-2 font-bold rounded-xl bg-primary-500 hover:bg-primary-600 text-white shadow-lg shadow-primary-500/25 hover:shadow-primary-500/40 transition-[background-color,color,transform] duration-300 hover:scale-[1.02] active:scale-[0.98] px-8 py-2.5 text-sm">
                            <span>Deploy System</span>
                            <i class="ph-bold ph-rocket-launch"></i>
                        </button>
                    </div>
                </div>

            @elseif ($step == 7 || $installing)
                {{-- Step 7: Installation Progress --}}
                <div class="text-center animate-in fade-in zoom-in-95 duration-700" 
                     wire:init="runDeployment"
                     x-on:deployment-complete.window="setTimeout(() => window.location.href = $event.detail.url, 1500)">
                    
                    <div class="relative w-32 h-32 mx-auto mb-10">
                        <div class="absolute inset-0 rounded-full border-4 border-slate-800"></div>
                        <svg class="absolute inset-0 w-32 h-32 -rotate-90">
                            <circle cx="64" cy="64" r="60" fill="none" class="stroke-primary-500 transition-all duration-1000 ease-out" stroke-width="8" stroke-dasharray="377" stroke-dashoffset="{{ 377 - (377 * $installationProgress / 100) }}"></circle>
                        </svg>
                        <div class="absolute inset-0 flex flex-col items-center justify-center">
                            <span class="text-3xl font-black text-white font-display">{{ $installationProgress }}%</span>
                        </div>
                    </div>

                    <h2 class="text-2xl font-black text-white mb-2 font-display tracking-tight leading-tight">The Singularity is Near</h2>
                    <p class="text-slate-400 font-medium mb-12 flex items-center justify-center gap-2">
                        <i class="ph-bold ph-circle-notch animate-spin text-primary-500"></i>
                        <span>{{ $installationPhase }}</span>
                    </p>

                    <div class="max-w-md mx-auto space-y-4">
                        <div class="h-1.5 w-full bg-slate-800 rounded-full overflow-hidden">
                            <div class="h-full bg-primary-500 transition-all duration-700 ease-in-out" style="width: {{ $installationProgress }}%"></div>
                        </div>
                        <p class="text-[10px] font-bold text-slate-400 uppercase tracking-[0.2em]">Executing Phased Deployment Sequence</p>
                    </div>

                    @if($installationError)
                        <div class="mt-10 p-6 rounded-2xl bg-red-500/5 border border-red-500/20 text-red-500 text-sm font-medium animate-in slide-in-from-top-4">
                            <div class="flex items-center justify-center gap-2 mb-2">
                                <i class="ph-bold ph-warning-octagon text-2xl"></i>
                                <span class="text-lg font-black">Deployment Terminated</span>
                            </div>
                            <p class="mb-6">{{ $installationError }}</p>
                            <button wire:click="$set('step', 1)" class="h-10 px-6 rounded-lg bg-red-600 text-white font-bold text-xs uppercase tracking-widest hover:bg-red-700 transition-colors">
                                Return to Diagnostics
                            </button>
                        </div>
                    @endif
                </div>
            @endif
        </div>
    </div>
</div>
