{{--
    Global Lazy Loading Placeholder — Shimmer Skeleton
    ==================================================
    This view is rendered while a lazy-loaded Livewire component is being fetched.
    It works in: Admin (dark), Client Area (dark/light), Frontend (dark/light).

    Usage in components:
      <livewire:some-component lazy />
      — OR with a custom per-component placeholder —
      public function placeholder() {
          return view('livewire.custom-placeholder');
      }
--}}

<div class="w-full animate-pulse" aria-busy="true" aria-label="Loading content…">
    {{-- Card-shaped skeleton that adapts to dark/light via Tailwind --}}
    <div class="rounded-xl border
                border-slate-200 dark:border-white/[0.06]
                bg-white dark:bg-white/[0.03]
                p-5 sm:p-6 space-y-4">

        {{-- Header row: icon + title bar --}}
        <div class="flex items-center gap-3">
            <div class="h-10 w-10 shrink-0 rounded-lg
                        bg-slate-100 dark:bg-white/[0.06]"></div>
            <div class="flex-1 space-y-2">
                <div class="h-4 w-2/5 rounded-md
                            bg-slate-100 dark:bg-white/[0.06]"></div>
                <div class="h-3 w-1/4 rounded-md
                            bg-slate-50 dark:bg-white/[0.04]"></div>
            </div>
        </div>

        {{-- Content rows --}}
        <div class="space-y-3 pt-2">
            <div class="h-3 w-full rounded-md
                        bg-slate-100 dark:bg-white/[0.06]"></div>
            <div class="h-3 w-5/6 rounded-md
                        bg-slate-50 dark:bg-white/[0.04]"></div>
            <div class="h-3 w-4/6 rounded-md
                        bg-slate-100 dark:bg-white/[0.06]"></div>
        </div>

        {{-- Footer row: two small action bars --}}
        <div class="flex items-center gap-3 pt-2">
            <div class="h-8 w-24 rounded-lg
                        bg-slate-100 dark:bg-white/[0.06]"></div>
            <div class="h-8 w-20 rounded-lg
                        bg-slate-50 dark:bg-white/[0.04]"></div>
        </div>
    </div>
</div>
